/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.evaluatetablecontent;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryEvalTableContent
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryEvalTableContent.class;
    public boolean isAddRowsResult = false;
    public boolean isClearResultList = true;
    public boolean isUseVars = false;
    public boolean iscustomSQL = false;
    public String customSQL = null;
    private DatabaseMeta connection = null;
    public String tablename = null;
    public String schemaname = null;
    private static final String selectCount = "SELECT count(*) FROM ";
    public static final String[] successConditionsDesc = new String[]{BaseMessages.getString(PKG, (String)"JobEntryEvalTableContent.SuccessWhenRowCountEqual.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryEvalTableContent.SuccessWhenRowCountDifferent.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryEvalTableContent.SuccessWhenRowCountSmallerThan.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryEvalTableContent.SuccessWhenRowCountSmallerOrEqualThan.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryEvalTableContent.SuccessWhenRowCountGreaterThan.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryEvalTableContent.SuccessWhenRowCountGreaterOrEqual.Label", (String[])new String[0])};
    public static final String[] successConditionsCode = new String[]{"rows_count_equal", "rows_count_different", "rows_count_smaller", "rows_count_smaller_equal", "rows_count_greater", "rows_count_greater_equal"};
    public static final int SUCCESS_CONDITION_ROWS_COUNT_EQUAL = 0;
    public static final int SUCCESS_CONDITION_ROWS_COUNT_DIFFERENT = 1;
    public static final int SUCCESS_CONDITION_ROWS_COUNT_SMALLER = 2;
    public static final int SUCCESS_CONDITION_ROWS_COUNT_SMALLER_EQUAL = 3;
    public static final int SUCCESS_CONDITION_ROWS_COUNT_GREATER = 4;
    public static final int SUCCESS_CONDITION_ROWS_COUNT_GREATER_EQUAL = 5;
    public String limit = "0";
    public int successCondition = 4;

    public JobEntryEvalTableContent(String n) {
        super(n, "");
    }

    public JobEntryEvalTableContent() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryEvalTableContent je = (JobEntryEvalTableContent)super.clone();
        return je;
    }

    public int getSuccessCobdition() {
        return this.successCondition;
    }

    public static int getSuccessConditionByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < successConditionsDesc.length; ++i) {
            if (!successConditionsDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return JobEntryEvalTableContent.getSuccessConditionByCode(tt);
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(200);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"connection", this.connection == null ? null : this.connection.getName()));
        retval.append("      ").append(XMLHandler.addTagValue((String)"schemaname", (String)this.schemaname));
        retval.append("      ").append(XMLHandler.addTagValue((String)"tablename", (String)this.tablename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"success_condition", (String)JobEntryEvalTableContent.getSuccessConditionCode(this.successCondition)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"limit", (String)this.limit));
        retval.append("      ").append(XMLHandler.addTagValue((String)"is_custom_sql", (boolean)this.iscustomSQL));
        retval.append("      ").append(XMLHandler.addTagValue((String)"is_usevars", (boolean)this.isUseVars));
        retval.append("      ").append(XMLHandler.addTagValue((String)"custom_sql", (String)this.customSQL));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_rows_result", (boolean)this.isAddRowsResult));
        retval.append("      ").append(XMLHandler.addTagValue((String)"clear_result_rows", (boolean)this.isClearResultList));
        return retval.toString();
    }

    private static String getSuccessConditionCode(int i) {
        if (i < 0 || i >= successConditionsCode.length) {
            return successConditionsCode[0];
        }
        return successConditionsCode[i];
    }

    private static int getSucessConditionByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < successConditionsCode.length; ++i) {
            if (!successConditionsCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static String getSuccessConditionDesc(int i) {
        if (i < 0 || i >= successConditionsDesc.length) {
            return successConditionsDesc[0];
        }
        return successConditionsDesc[i];
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            String dbname = XMLHandler.getTagValue((Node)entrynode, (String)"connection");
            this.connection = DatabaseMeta.findDatabase(databases, (String)dbname);
            this.schemaname = XMLHandler.getTagValue((Node)entrynode, (String)"schemaname");
            this.tablename = XMLHandler.getTagValue((Node)entrynode, (String)"tablename");
            this.successCondition = JobEntryEvalTableContent.getSucessConditionByCode(Const.NVL((String)XMLHandler.getTagValue((Node)entrynode, (String)"success_condition"), (String)""));
            this.limit = Const.NVL((String)XMLHandler.getTagValue((Node)entrynode, (String)"limit"), (String)"0");
            this.iscustomSQL = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"is_custom_sql"));
            this.isUseVars = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"is_usevars"));
            this.customSQL = XMLHandler.getTagValue((Node)entrynode, (String)"custom_sql");
            this.isAddRowsResult = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_rows_result"));
            this.isClearResultList = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"clear_result_rows"));
        }
        catch (KettleException e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobEntryEvalTableContent.UnableLoadXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.connection = rep.loadDatabaseMetaFromJobEntryAttribute(id_jobentry, "connection", "id_database", databases);
            this.schemaname = rep.getJobEntryAttributeString(id_jobentry, "schemaname");
            this.tablename = rep.getJobEntryAttributeString(id_jobentry, "tablename");
            this.successCondition = JobEntryEvalTableContent.getSuccessConditionByCode(Const.NVL((String)rep.getJobEntryAttributeString(id_jobentry, "success_condition"), (String)""));
            this.limit = rep.getJobEntryAttributeString(id_jobentry, "limit");
            this.iscustomSQL = rep.getJobEntryAttributeBoolean(id_jobentry, "is_custom_sql");
            this.isUseVars = rep.getJobEntryAttributeBoolean(id_jobentry, "is_usevars");
            this.isAddRowsResult = rep.getJobEntryAttributeBoolean(id_jobentry, "add_rows_result");
            this.isClearResultList = rep.getJobEntryAttributeBoolean(id_jobentry, "clear_result_rows");
            this.customSQL = rep.getJobEntryAttributeString(id_jobentry, "custom_sql");
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryEvalTableContent.UnableLoadRep", (String[])new String[]{"" + id_jobentry}), (Throwable)dbe);
        }
    }

    private static int getSuccessConditionByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < successConditionsCode.length; ++i) {
            if (!successConditionsCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveDatabaseMetaJobEntryAttribute(id_job, this.getObjectId(), "connection", "id_database", this.connection);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "schemaname", this.schemaname);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "tablename", this.tablename);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "success_condition", JobEntryEvalTableContent.getSuccessConditionCode(this.successCondition));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "limit", this.limit);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "custom_sql", this.customSQL);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "is_custom_sql", this.iscustomSQL);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "is_usevars", this.isUseVars);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "add_rows_result", this.isAddRowsResult);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "clear_result_rows", this.isClearResultList);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryEvalTableContent.UnableSaveRep", (String[])new String[]{"" + id_job}), (Throwable)dbe);
        }
    }

    public void setDatabase(DatabaseMeta database) {
        this.connection = database;
    }

    public DatabaseMeta getDatabase() {
        return this.connection;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public boolean isUnconditional() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Result execute(Result previousResult, int nr) {
        result = previousResult;
        result.setResult(false);
        oldBehavior = "Y".equalsIgnoreCase(this.getVariable("KETTLE_COMPATIBILITY_SET_ERROR_ON_SPECIFIC_JOB_ENTRIES", "N"));
        countSQLStatement = null;
        rowsCount = 0L;
        errCount = 0L;
        successOK = false;
        nrRowsLimit = Const.toInt((String)this.environmentSubstitute(this.limit), (int)0);
        if (this.log.isDetailed()) {
            this.logDetailed(BaseMessages.getString(JobEntryEvalTableContent.PKG, (String)"JobEntryEvalTableContent.Log.nrRowsLimit", (String[])new String[]{"" + nrRowsLimit}));
        }
        if (this.connection != null) {
            db = new Database((LoggingObjectInterface)this, this.connection);
            db.shareVariablesWith((VariableSpace)this);
            try {
                db.connect(this.parentJob.getTransactionId(), null);
                if (this.iscustomSQL) {
                    realCustomSQL = this.customSQL;
                    if (this.isUseVars) {
                        realCustomSQL = this.environmentSubstitute(realCustomSQL);
                    }
                    if (this.log.isDebug()) {
                        this.logDebug(BaseMessages.getString(JobEntryEvalTableContent.PKG, (String)"JobEntryEvalTableContent.Log.EnteredCustomSQL", (String[])new String[]{realCustomSQL}));
                    }
                    if (!Const.isEmpty((String)realCustomSQL)) {
                        countSQLStatement = realCustomSQL;
                    } else {
                        ++errCount;
                        this.logError(BaseMessages.getString(JobEntryEvalTableContent.PKG, (String)"JobEntryEvalTableContent.Error.NoCustomSQL", (String[])new String[0]));
                    }
                } else {
                    realTablename = this.environmentSubstitute(this.tablename);
                    realSchemaname = this.environmentSubstitute(this.schemaname);
                    if (!Const.isEmpty((String)realTablename)) {
                        countSQLStatement = !Const.isEmpty((String)realSchemaname) ? "SELECT count(*) FROM " + db.getDatabaseMeta().getQuotedSchemaTableCombination(realSchemaname, realTablename) : "SELECT count(*) FROM " + db.getDatabaseMeta().quoteField(realTablename);
                    } else {
                        ++errCount;
                        this.logError(BaseMessages.getString(JobEntryEvalTableContent.PKG, (String)"JobEntryEvalTableContent.Error.NoTableName", (String[])new String[0]));
                    }
                }
                if (countSQLStatement == null) ** GOTO lbl93
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(JobEntryEvalTableContent.PKG, (String)"JobEntryEvalTableContent.Log.RunSQLStatement", (String[])new String[]{countSQLStatement}));
                }
                if (this.iscustomSQL) {
                    if (this.isClearResultList) {
                        result.getRows().clear();
                    }
                    if ((ar = db.getRows(countSQLStatement, 0)) != null) {
                        rowsCount = ar.size();
                        rowMeta = db.getQueryFields(countSQLStatement, false);
                        rows = new ArrayList<RowMetaAndData>();
                        for (i = 0; i < ar.size(); ++i) {
                            rows.add(new RowMetaAndData(rowMeta, (Object[])ar.get(i)));
                        }
                        if (this.isAddRowsResult && this.iscustomSQL && rows != null) {
                            result.getRows().addAll(rows);
                        }
                    } else if (this.log.isDebug()) {
                        this.logDebug(BaseMessages.getString(JobEntryEvalTableContent.PKG, (String)"JobEntryEvalTableContent.Log.customSQLreturnedNothing", (String[])new String[]{countSQLStatement}));
                    }
                } else {
                    row = db.getOneRow(countSQLStatement);
                    if (row != null) {
                        rowsCount = row.getInteger(0);
                    }
                }
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(JobEntryEvalTableContent.PKG, (String)"JobEntryEvalTableContent.Log.NrRowsReturned", (String[])new String[]{"" + rowsCount}));
                }
                switch (this.successCondition) {
                    case 0: {
                        successOK = rowsCount == (long)nrRowsLimit;
                        break;
                    }
                    case 1: {
                        successOK = rowsCount != (long)nrRowsLimit;
                        break;
                    }
                    case 2: {
                        successOK = rowsCount < (long)nrRowsLimit;
                        break;
                    }
                    case 3: {
                        successOK = rowsCount <= (long)nrRowsLimit;
                        break;
                    }
                    case 4: {
                        successOK = rowsCount > (long)nrRowsLimit;
                        break;
                    }
                    case 5: {
                        successOK = rowsCount >= (long)nrRowsLimit;
                        break;
                    }
                }
                if (successOK || !oldBehavior) ** GOTO lbl93
                ++errCount;
            }
            catch (KettleException dbe) {
                ++errCount;
                this.logError(BaseMessages.getString(JobEntryEvalTableContent.PKG, (String)"JobEntryEvalTableContent.Error.RunningEntry", (String[])new String[]{dbe.getMessage()}));
            }
            finally {
                if (db != null) {
                    db.disconnect();
                }
            }
        } else {
            ++errCount;
            this.logError(BaseMessages.getString(JobEntryEvalTableContent.PKG, (String)"JobEntryEvalTableContent.NoDbConnection", (String[])new String[0]));
        }
lbl93:
        // 5 sources

        result.setResult(successOK);
        result.setNrLinesRead(rowsCount);
        result.setNrErrors(errCount);
        return result;
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        return new DatabaseMeta[]{this.connection};
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (this.connection != null) {
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(this.connection.getHostname(), ResourceEntry.ResourceType.SERVER));
            reference.getEntries().add(new ResourceEntry(this.connection.getDatabaseName(), ResourceEntry.ResourceType.DATABASENAME));
            references.add(reference);
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        JobEntryValidatorUtils.andValidator().validate(this, "WaitForSQL", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
    }
}

