/*
 * Decompiled with CFR 0.152.
 */
package de.his.utils;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;

public class Pair<K, V>
implements Serializable,
Map.Entry<K, V> {
    private static final long serialVersionUID = -8005006032570760958L;
    private K key = null;
    private V value = null;
    public static final Comparator COMPARE_BY_KEY = new PairByKeyComparator();

    public Pair() {
    }

    public Pair(K key, V value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    public void setKey(K key) {
        this.key = key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public V setValue(V value) {
        V temp = this.value;
        this.value = value;
        return temp;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Pair)) {
            return false;
        }
        Pair other = (Pair)obj;
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return "Pair [key=" + this.key + ", value=" + this.value + "]";
    }

    static class PairByKeyComparator<K extends Comparable<K>, V>
    implements Comparator<Pair<K, V>>,
    Serializable {
        private static final long serialVersionUID = -7006883537267525554L;

        PairByKeyComparator() {
        }

        @Override
        public int compare(Pair<K, V> o1, Pair<K, V> o2) {
            return ((Comparable)o1.getKey()).compareTo(o2.getKey());
        }
    }
}

