/*
 * Decompiled with CFR 0.152.
 */
package de.his.security.auth.plugin;

import de.his.security.auth.AuthenticationManagerConfig;
import de.his.security.auth.plugin.AuthenticationPlugin;
import de.his.tools.ParseSQL;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class RequestAttributeAuth
implements AuthenticationPlugin {
    private static Logger logger = Logger.getLogger(RequestAttributeAuth.class);

    @Override
    public boolean init(AuthenticationManagerConfig authConfig, Element confElement) {
        logger.debug((Object)("AuthPlugin: " + this.getClass()));
        return true;
    }

    @Override
    public Properties authTest(Element confElement, Properties authProp, HttpServletRequest request, Properties userProp) {
        if (request == null) {
            return userProp;
        }
        this.dumpAttributes(confElement, request);
        boolean found = this.copyAttributes(confElement, request, userProp);
        if (found) {
            userProp.put("authenticated", "y");
        }
        return userProp;
    }

    private void dumpAttributes(Element confElement, HttpServletRequest request) {
        String debug = confElement.getChildText("debug");
        if (debug != null && debug.equals("y")) {
            Enumeration headers = request.getAttributeNames();
            while (headers.hasMoreElements()) {
                String header = (String)headers.nextElement();
                logger.debug((Object)(header + ": " + request.getAttribute(header)));
            }
        }
    }

    private boolean copyAttributes(Element confElement, HttpServletRequest request, Properties userProp) {
        String headerStr = confElement.getChildText("attribute");
        String[] headerNames = ParseSQL.getDBColNames(headerStr);
        String[] headerAliases = ParseSQL.getDBColNameAliases(headerStr);
        boolean found = false;
        for (int i = 0; i < headerNames.length; ++i) {
            Object value = request.getAttribute(headerNames[i]);
            if (value == null) continue;
            userProp.put(headerAliases[i], value);
            found = true;
        }
        return found;
    }
}

