/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.config.DbFormsConfig;
import org.dbforms.config.DbFormsConfigRegistry;
import org.dbforms.config.MultipleValidationException;
import org.dbforms.config.Table;
import org.dbforms.event.DatabaseEvent;
import org.dbforms.event.EventEngine;
import org.dbforms.event.WebEvent;
import org.dbforms.util.MessageResources;
import org.dbforms.util.MultipartRequest;
import org.dbforms.util.ParseUtil;
import org.dbforms.util.SqlUtil;
import org.dbforms.util.Util;

public class Controller
extends HttpServlet {
    private static Log logCat = LogFactory.getLog((String)(class$org$dbforms$servlets$Controller == null ? (class$org$dbforms$servlets$Controller = Controller.class$("org.dbforms.servlets.Controller")) : class$org$dbforms$servlets$Controller).getName());
    private int maxUploadSize = 102400;
    static /* synthetic */ Class class$org$dbforms$servlets$Controller;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.process(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.process(request, response);
    }

    public void init() throws ServletException {
        String maxUploadSizeStr = this.getServletConfig().getInitParameter("maxUploadSize");
        if (maxUploadSizeStr != null) {
            try {
                this.maxUploadSize = Integer.parseInt(maxUploadSizeStr);
            }
            catch (NumberFormatException nfe) {
                logCat.error((Object)"maxUploadSize not a valid number => using default.");
            }
        }
    }

    private Connection getConnection(DbFormsConfig config, HttpServletRequest request, int tableId, Hashtable connectionsTable) throws SQLException {
        String connectionName = null;
        Connection con = null;
        if (tableId != -1) {
            connectionName = ParseUtil.getParameter(request, "invname_" + tableId);
        }
        if ((con = (Connection)connectionsTable.get(connectionName = Util.isNull(connectionName) ? "default" : connectionName)) == null) {
            con = config.getConnection(connectionName);
            connectionsTable.put(connectionName, con);
        }
        return con;
    }

    private void cleanUpConnectionAfterException(Connection con) {
        try {
            if (con != null && !con.getAutoCommit()) {
                con.rollback();
                con.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            SqlUtil.logSqlException(e);
        }
    }

    private void closeConnections(Hashtable connectionsTable) {
        Enumeration cons = connectionsTable.keys();
        while (cons.hasMoreElements()) {
            String dbConnectionName = (String)cons.nextElement();
            Connection con = (Connection)connectionsTable.get(dbConnectionName);
            try {
                if (con != null && !con.getAutoCommit()) {
                    con.commit();
                    con.setAutoCommit(true);
                }
            }
            catch (SQLException e) {
                SqlUtil.logSqlException(e);
            }
            SqlUtil.closeConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block22: {
            String followUp2;
            WebEvent e;
            block23: {
                HttpSession session = request.getSession(true);
                logCat.debug((Object)("session timeout: " + session.getMaxInactiveInterval()));
                DbFormsConfig config = null;
                try {
                    config = DbFormsConfigRegistry.instance().lookup();
                }
                catch (Exception e2) {
                    logCat.error((Object)e2);
                    throw new ServletException((Throwable)e2);
                }
                Hashtable connections = new Hashtable();
                String contentType = request.getContentType();
                this.processLocale(request);
                if (contentType != null && contentType.startsWith("multipart")) {
                    try {
                        MultipartRequest multipartRequest = new MultipartRequest(request, this.maxUploadSize);
                        request.setAttribute("multipartRequest", (Object)multipartRequest);
                    }
                    catch (IOException ioe) {
                        logCat.error((Object)"::process - check if uploaded file(s) exceeded allowed size", (Throwable)ioe);
                        this.sendErrorMessage("Check if uploaded file(s) exceeded allowed size.", response);
                        return;
                    }
                }
                Connection con = null;
                e = null;
                Vector<SQLException> errors = new Vector<SQLException>();
                try {
                    request.setAttribute("errors", errors);
                    EventEngine engine = new EventEngine(request, config);
                    e = engine.generatePrimaryEvent();
                    if (e != null) {
                        request.setAttribute("webEvent", (Object)e);
                    }
                    try {
                        con = this.getConnection(config, request, e == null || e.getTable() == null ? -1 : e.getTable().getId(), connections);
                        if (e instanceof DatabaseEvent) {
                            try {
                                String formValidatorName = request.getParameter("formValidatorName_" + e.getTable().getId());
                                if (formValidatorName != null) {
                                    ((DatabaseEvent)e).doValidation(formValidatorName, this.getServletContext());
                                }
                                ((DatabaseEvent)e).processEvent(con);
                            }
                            catch (SQLException sqle) {
                                logCat.error((Object)"::process - SQLException:", (Throwable)sqle);
                                errors.addElement(sqle);
                                this.cleanUpConnectionAfterException(con);
                            }
                            catch (MultipleValidationException mve) {
                                this.processMultipleValidationException(con, errors, mve);
                            }
                        }
                        if (engine.getInvolvedTables() != null) {
                            this.processInvolvedTables(config, request, connections, e, errors, engine);
                        }
                    }
                    catch (SQLException exc) {
                        throw new ServletException((Throwable)exc);
                    }
                    Object var13_17 = null;
                    this.closeConnections(connections);
                    if (e == null) break block22;
                    followUp2 = null;
                    if (errors.size() == 0) break block23;
                    followUp2 = e.getFollowUpOnError();
                }
                catch (Throwable throwable) {
                    Object var13_18 = null;
                    this.closeConnections(connections);
                    if (e != null) {
                        String followUp2 = null;
                        if (errors.size() != 0) {
                            followUp2 = e.getFollowUpOnError();
                        }
                        if (Util.isNull(followUp2)) {
                            followUp2 = e.getFollowUp();
                        }
                        logCat.info((Object)("*** e = " + e + "*** e.getFollowUp() = " + e.getFollowUp()));
                        if (!Util.isNull(followUp2)) {
                            request.getRequestDispatcher(followUp2).forward((ServletRequest)request, (ServletResponse)response);
                        }
                    }
                    throw throwable;
                }
            }
            if (Util.isNull(followUp2)) {
                followUp2 = e.getFollowUp();
            }
            logCat.info((Object)("*** e = " + e + "*** e.getFollowUp() = " + e.getFollowUp()));
            if (!Util.isNull(followUp2)) {
                request.getRequestDispatcher(followUp2).forward((ServletRequest)request, (ServletResponse)response);
            }
        }
    }

    private void processInvolvedTables(DbFormsConfig config, HttpServletRequest request, Hashtable connections, WebEvent e, Vector errors, EventEngine engine) throws SQLException {
        Enumeration tableEnum = engine.getInvolvedTables().elements();
        while (tableEnum.hasMoreElements()) {
            Table t = (Table)tableEnum.nextElement();
            Enumeration eventEnum = engine.generateSecundaryEvents(t, e);
            while (eventEnum.hasMoreElements()) {
                DatabaseEvent dbE = (DatabaseEvent)eventEnum.nextElement();
                if (t.getId() != dbE.getTable().getId()) continue;
                Connection con = this.getConnection(config, request, dbE.getTable().getId(), connections);
                String formValidatorName = request.getParameter("formValidatorName_" + dbE.getTable().getId());
                try {
                    if (formValidatorName != null) {
                        dbE.doValidation(formValidatorName, this.getServletContext());
                    }
                    dbE.processEvent(con);
                }
                catch (SQLException sqle2) {
                    SqlUtil.logSqlException(sqle2, "::process - exception while process secundary events");
                    errors.addElement(sqle2);
                    this.cleanUpConnectionAfterException(con);
                }
                catch (MultipleValidationException mve) {
                    this.processMultipleValidationException(con, errors, mve);
                }
            }
        }
    }

    private void processLocale(HttpServletRequest request) {
        String lang = ParseUtil.getParameter(request, "lang");
        String country = ParseUtil.getParameter(request, "country", "");
        Locale locale = null;
        if (!Util.isNull(lang)) {
            locale = new Locale(lang, country);
        } else if (MessageResources.getLocale(request) == null) {
            MessageResources.setLocale(request, request.getLocale());
        }
        if (locale != null) {
            MessageResources.setLocale(request, locale);
        }
    }

    private void processMultipleValidationException(Connection con, Vector errors, MultipleValidationException mve) {
        Vector v = null;
        logCat.error((Object)"::processMultipleValidationException - exception", (Throwable)mve);
        v = mve.getMessages();
        if (v != null) {
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                errors.addElement(e.nextElement());
            }
        }
        this.cleanUpConnectionAfterException(con);
    }

    private void sendErrorMessage(String message, HttpServletResponse response) {
        try {
            PrintWriter out = response.getWriter();
            response.setContentType("text/html");
            out.println("<html><body><h1>ERROR:</h1><p>");
            out.println(message);
            out.println("</p></body></html>");
        }
        catch (IOException ioe) {
            logCat.error((Object)"::sendErrorMessage - senderror message crashed", (Throwable)ioe);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

