/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters.html;

import com.atlassian.clover.registry.entities.BaseClassInfo;
import com.atlassian.clover.registry.metrics.ClassMetrics;
import com.atlassian.clover.util.Formatting;

public abstract class ClassInfoStatsCalculator {
    public abstract String getName();

    public abstract String getFormattedValue(BaseClassInfo var1);

    public abstract int getScaledValue(BaseClassInfo var1);

    public abstract boolean ignore(BaseClassInfo var1);

    public static class PcCoveredElementsCalculator
    extends ClassInfoStatsCalculator {
        public boolean ignore(BaseClassInfo classInfo) {
            return this.getScaledValue(classInfo) == 0 || this.getScaledValue(classInfo) < 0;
        }

        public float getValue(BaseClassInfo classInfo) {
            return classInfo.getMetrics().getPcUncoveredElements();
        }

        public String getFormattedValue(BaseClassInfo classInfo) {
            return Formatting.getPercentStr(classInfo.getMetrics().getPcCoveredElements());
        }

        public int getScaledValue(BaseClassInfo classInfo) {
            return (int)(this.getValue(classInfo) * 100.0f);
        }

        public String getName() {
            return "Coverage";
        }
    }

    public static class AvgMethodComplexityCalculator
    extends ClassInfoStatsCalculator {
        public boolean ignore(BaseClassInfo classInfo) {
            return classInfo.getMetrics().getNumElements() <= 0;
        }

        public float getValue(BaseClassInfo classInfo) {
            float value = ((ClassMetrics)classInfo.getMetrics()).getAvgMethodComplexity();
            return value > 0.0f ? value : 0.0f;
        }

        public String getFormattedValue(BaseClassInfo classInfo) {
            return Formatting.format3d(this.getValue(classInfo));
        }

        public int getScaledValue(BaseClassInfo classInfo) {
            return (int)(this.getValue(classInfo) * 100.0f);
        }

        public String getName() {
            return "Average Method Complexity";
        }
    }

    public static class UncoveredElementsCalculator
    extends ClassInfoStatsCalculator {
        public boolean ignore(BaseClassInfo classInfo) {
            return this.getValue(classInfo) <= 0.0f;
        }

        public float getValue(BaseClassInfo classInfo) {
            return classInfo.getMetrics().getNumUncoveredElements();
        }

        public String getFormattedValue(BaseClassInfo classInfo) {
            return Formatting.formatInt((int)this.getValue(classInfo));
        }

        public int getScaledValue(BaseClassInfo classInfo) {
            return (int)this.getValue(classInfo);
        }

        public String getName() {
            return "# Elements Untested";
        }
    }

    public static class ElementCountCalculator
    extends ClassInfoStatsCalculator {
        public float getValue(BaseClassInfo classInfo) {
            return classInfo.getMetrics().getNumElements();
        }

        public String getFormattedValue(BaseClassInfo classInfo) {
            return Formatting.formatInt((int)this.getValue(classInfo));
        }

        public int getScaledValue(BaseClassInfo classInfo) {
            return (int)this.getValue(classInfo);
        }

        public String getName() {
            return "# Elements";
        }

        public boolean ignore(BaseClassInfo classInfo) {
            return this.getValue(classInfo) <= 0.0f;
        }
    }
}

