/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.recorder;

import clover.org.apache.commons.lang.mutable.MutableLong;
import com.atlassian.clover.CoverageDataSpec;
import com.atlassian.clover.recorder.BaseCoverageRecording;
import com.atlassian.clover.recorder.GlobalCoverageRecordingTranscript;
import com.atlassian.clover.util.CoverageUtils;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;

public class FileBasedCoverageRecordingTranscript
extends BaseCoverageRecording
implements GlobalCoverageRecordingTranscript {
    protected int[] hitCounts;
    protected long coverageSum;

    public FileBasedCoverageRecordingTranscript(BaseCoverageRecording.Header header, File fileOnDisk) {
        super(header, fileOnDisk);
    }

    public long getCoverageSum() {
        return this.coverageSum;
    }

    public void read(DataInputStream in, CoverageDataSpec spec) throws IOException {
        MutableLong sum = new MutableLong(0L);
        this.hitCounts = CoverageUtils.readCoverageAndSumCoverage(in, sum);
        this.coverageSum = sum.longValue();
    }

    public int get(int slotIndex) {
        return this.hitCounts[slotIndex];
    }

    public int getCount() {
        return this.hitCounts.length;
    }

    public int addTo(int[] coverage) {
        int max = Math.min(this.hitCounts.length, coverage.length);
        for (int i = 0; i < max; ++i) {
            int n = i;
            coverage[n] = coverage[n] + this.hitCounts[i];
        }
        return max;
    }

    public String toString() {
        return "FileBasedCoverageRecordingTranscript[header=" + this.header + ", coverageSum=" + this.coverageSum + ", hitCounts.length=" + (this.hitCounts == null ? null : Integer.valueOf(this.hitCounts.length)) + ']';
    }
}

