/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.java;

import com.atlassian.clover.instr.java.Emitter;
import com.atlassian.clover.instr.java.InstrumentationState;
import com.atlassian.clover.registry.FixedSourceRegion;
import com.atlassian.clover.registry.entities.FullMethodInfo;
import com.atlassian.clover.registry.entities.MethodSignature;
import com.atlassian.clover.spi.lang.LanguageConstruct;
import org.jetbrains.annotations.NotNull;

public class LambdaExpressionEntryEmitter
extends Emitter {
    private final MethodSignature lambdaSignature;
    private final String classCast;
    FullMethodInfo method;
    private int bodyStartLine;
    private int bodyStartColumn;

    public LambdaExpressionEntryEmitter(@NotNull MethodSignature lambdaSignature, @NotNull String classCast, int startLine, int startColumn, int bodyStartLine, int bodyStartColumn) {
        super(startLine, startColumn);
        this.lambdaSignature = lambdaSignature;
        this.classCast = classCast;
        this.bodyStartLine = bodyStartLine;
        this.bodyStartColumn = bodyStartColumn;
    }

    protected void init(@NotNull InstrumentationState state) {
        if (state.isInstrEnabled()) {
            this.method = (FullMethodInfo)state.getSession().enterMethod(this.getElementContext(), new FixedSourceRegion(this.getLine(), this.getColumn()), this.lambdaSignature, false, null, true, 1, LanguageConstruct.Builtin.METHOD);
            boolean classInstrStrategy = state.getCfg().isClassInstrStrategy();
            if (classInstrStrategy) {
                String recorderBase = state.getRecorderPrefix().substring(0, state.getRecorderPrefix().lastIndexOf(46));
                StringBuilder instr = new StringBuilder();
                instr.append(recorderBase);
                instr.append(".");
                instr.append("lambdaInc");
                instr.append("(");
                instr.append(Integer.toString(this.method.getDataIndex()));
                instr.append(",");
                instr.append(this.classCast);
                this.setInstr(instr.toString());
            }
        }
    }

    public int getBodyStartLine() {
        return this.bodyStartLine;
    }

    public int getBodyStartColumn() {
        return this.bodyStartColumn;
    }
}

