/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.util;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import de.laures.cewolf.CewolfException;
import de.laures.cewolf.ChartImage;
import de.laures.cewolf.ChartRenderingException;
import de.laures.cewolf.ConfigurationException;
import de.laures.cewolf.WebConstants;
import de.laures.cewolf.util.ImageHelper;
import de.laures.cewolf.util.RenderedImage;
import de.laures.cewolf.util.RenderingException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.Legend;
import org.jfree.chart.StandardLegend;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.StandardEntityCollection;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class Renderer
implements WebConstants {
    private static final Log log = LogFactory.getLog((Class)(class$de$laures$cewolf$util$Renderer == null ? (class$de$laures$cewolf$util$Renderer = Renderer.class$("de.laures.cewolf.util.Renderer")) : class$de$laures$cewolf$util$Renderer));
    static /* synthetic */ Class class$de$laures$cewolf$util$Renderer;

    private Renderer() {
    }

    public static RenderedImage render(ChartImage cd, Object chart) throws CewolfException {
        log.debug((Object)("rendering " + cd));
        switch (cd.getType()) {
            case 0: {
                return Renderer.renderChart(cd, chart);
            }
            case 1: {
                return Renderer.renderLegend(cd, chart);
            }
        }
        throw new ConfigurationException(cd.getType() + " is not a supported image type");
    }

    private static RenderedImage renderChart(ChartImage cd, Object chart) throws CewolfException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ChartRenderingInfo info = new ChartRenderingInfo((EntityCollection)new StandardEntityCollection());
            String mimeType = cd.getMimeType();
            if ("image/png".equals(mimeType)) {
                Renderer.handlePNG(baos, (JFreeChart)chart, cd.getWidth(), cd.getHeight(), info);
            } else if ("image/svg+xml".equals(mimeType)) {
                Renderer.handleSVG(baos, (JFreeChart)chart, cd.getWidth(), cd.getHeight());
            } else {
                throw new RenderingException("Mime type " + mimeType + " is unsupported.");
            }
            baos.close();
            return new RenderedImage(baos.toByteArray(), mimeType, info);
        }
        catch (IOException ioe) {
            throw new ChartRenderingException(ioe.getMessage());
        }
    }

    private static synchronized void handlePNG(ByteArrayOutputStream baos, JFreeChart chart, int width, int height, ChartRenderingInfo info) throws IOException {
        ChartUtilities.writeChartAsPNG((OutputStream)baos, (JFreeChart)chart, (int)width, (int)height, (ChartRenderingInfo)info);
    }

    private static synchronized void handleSVG(ByteArrayOutputStream baos, JFreeChart chart, int width, int height) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baos, "UTF-8");
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        Document document = domImpl.createDocument("cewolf-svg", "svg", null);
        SVGGeneratorContext ctx = SVGGeneratorContext.createDefault((Document)document);
        ctx.setComment("Generated by Cewolf using JFreeChart and Apache Batik SVG Generator");
        SVGGraphics2D svgGenerator = new SVGGraphics2D(ctx, false);
        svgGenerator.setSVGCanvasSize(new Dimension(width, height));
        chart.draw((Graphics2D)svgGenerator, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, width, height), null);
        svgGenerator.stream((Writer)writer, false);
        writer.close();
    }

    private static RenderedImage renderLegend(ChartImage cd, Object chart) throws CewolfException {
        try {
            int width = cd.getWidth();
            int height = cd.getHeight();
            Legend legend = ((JFreeChart)chart).getLegend();
            boolean haslegend = true;
            if (null == legend) {
                haslegend = false;
                ((JFreeChart)chart).setLegend((Legend)new StandardLegend());
                legend = ((JFreeChart)chart).getLegend();
            }
            legend.setAnchor(3);
            BufferedImage bimage = ImageHelper.createImage(width, height);
            Graphics2D g = bimage.createGraphics();
            g.setColor(Color.white);
            g.fillRect(0, 0, width, height);
            legend.draw(g, (Rectangle2D)new Rectangle(width, height), new ChartRenderingInfo());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
            JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(bimage);
            param.setQuality(1.0f, true);
            encoder.encode(bimage, param);
            out.close();
            if (!haslegend) {
                ((JFreeChart)chart).setLegend(null);
            }
            return new RenderedImage(out.toByteArray(), "image/jpeg", new ChartRenderingInfo((EntityCollection)new StandardEntityCollection()));
        }
        catch (IOException ioex) {
            throw new ChartRenderingException(ioex.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

