/*
 * Decompiled with CFR 0.152.
 */
package de.superx.stat;

import com.google.common.base.CharMatcher;
import com.google.common.io.ByteSource;
import com.google.common.io.Files;
import de.destatis.core.generator.AbstractDescriptor;
import de.destatis.core.generator.DataProvider;
import de.destatis.core.generator.Descriptor;
import de.destatis.core.generator.FieldDescriptor;
import de.destatis.core.generator.StructureDescriptor;
import de.destatis.core.generator.SurveyDataDocumentGenerator;
import de.destatis.core.generator.SurveyDataDocumentGeneratorException;
import de.destatis.core.inspector.InspectionProblem;
import de.destatis.core.inspector.InspectionReport;
import de.destatis.core.inspector.Inspector;
import de.destatis.core.inspector.ProblemPosition;
import de.destatis.core.resource.DatmlSdfSource;
import de.destatis.core.resource.NoResourceFoundException;
import de.destatis.core.resource.ResourceConfig;
import de.destatis.core.resource.ResourceException;
import de.destatis.core.resource.SurveyResource;
import de.destatis.core.resource.SurveyResourceProvider;
import de.statspez.pleditor.generator.runtime.plausi.PlausiFactory;
import de.statspez.pleditor.generator.runtime.plausi.PlausiInterface;
import de.statspez.pleditor.generator.runtime.plausi.PlausiKontext;
import de.statspez.pleditor.generator.runtime.plausi.ReferenzDateiInterface;
import de.statspez.pleditor.generator.runtime.plausi.SatzInterface;
import de.statspez.pleditor.generator.runtime.refdat.ReferenzDateiVerwalter;
import de.statspez.pleditor.generator.runtime.refdat.ReferenzDateiZugriffInterface;
import de.statspez.sdf.generator.meta.generated.MetaErhebungsbeschreibung;
import de.statspez.sdf.generator.meta.generated.MetaSDFMerkmal;
import de.superx.stat.ExaminationStatistics1990;
import de.superx.stat.ExaminationStatistics2016;
import de.superx.stat.GuestListenerStatistics;
import de.superx.stat.StatisticsBase;
import de.superx.stat.StudentAndExaminationStatistics1990;
import de.superx.stat.StudentAndExaminationStatistics2016;
import de.superx.stat.StudentStatistics1990;
import de.superx.stat.StudentStatistics2016;
import de.superx.stat.pl.SuperxPlausiFehler;
import de.superx.stat.pl.SuperxReferenzDateiZugriff;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang.text.StrBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.jdbc.support.rowset.SqlRowSetMetaData;
import org.xml.sax.InputSource;

public class StatisticExport
implements DataProvider,
SurveyResourceProvider {
    private static Logger logger = LoggerFactory.getLogger(StatisticExport.class);
    private static PlausiFactory factory = new PlausiFactory();
    private static List<String> statSql = Arrays.asList("select ef001, ef002, ef003, ef004, ef005, ef006, ef007, ef008u1, ef008u2, ef009, ef010u1, ef010u2, ef011u1, ef011u2, ef012, ef013, ef014, ef015, ef016, ef017, ef018, ef019, ef020, ef021, ef022, ef023, ef024, ef025, ef026, ef027, ef028, ef029, ef030, ef031, ef032, ef033, ef034, ef035, ef036, ef037, ef038, ef039, ef040, ef041, ef042, ef043, ef044, ef045, ef046, ef047, ef048, ef049, ef050, ef051, ef052, ef053, ef054, ef055, ef056, ef057, ef058, ef059, ef060, ef061, ef062, ef063, ef064, ef065u1, ef065u2, ef066, ef067, ef068, ef069, ef070, ef071, ef072, ef073, ef074, ef075, ef076, ef077, ef078, ef079, ef080, ef081, ef082, ef083, ef084, ef085, ef086, ef087, ef088, ef089, ef090, ef091, ef092, ef093, ef094, ef095, ef096, ef097, ef098, ef099, ef100, ef101, ef102, ef103, ef104, ef105, ef106, ef107, ef108, ef109, ef110, ef111u1, ef111u2, ef112, ef113, ef114, ef115, ef116, ef117, ef118, ef119, ef120, ef121, ef122, ef123, ef124, ef125, ef126, ef127, ef128, ef129, ef130, ef131, ef132, ef133, ef134, ef135, ef136, ef137, ef138, ef139, ef140, ef141, ef142, ef143, ef144, ef145, ef146, ef147, ef148, ef149, ef150, ef151, ef152 from sos_stat", "SELECT ef001 , ef002 , ef003 , ef004 , ef005 , ef006 , ef007 , ef008u1 , ef008u2 , ef008u3 , ef009 , ef010 , ef011 , ef012u1 , ef012u2 , ef013u1 , ef013u2 , ef014 , ef015 , ef016 , ef017 , ef018 , ef019 , ef020 , ef021 , ef022 , ef023 , ef024 , ef025 , ef026 , ef027 , ef028 , ef029 , ef030 , ef031 , ef032 , ef033 , ef034u1 , ef034u2 , ef035 , ef036 , ef037 , ef038 , ef039 , ef040 , ef041 , ef042 , ef043 , ef044 , ef045 , ef046 , ef047 , ef048 , ef049 , ef050u1 , ef050u2 , ef051 , ef052 , ef053 , ef054 , ef055 , ef056 , ef057 , ef058 , ef059 , ef060 , ef061 , ef062 , ef063 , ef064 , ef065 , ef066 , ef067 , ef068 , ef069 , ef070 , ef071 , ef072 , ef073 , ef074 , ef075 , ef076 , ef077 , ef078 , ef079 , ef080 , ef081 , ef082 , ef083 , ef084 , ef085 , ef086 , ef087 , ef088 , ef089 , ef090 , ef091 , ef092 , ef093 , ef094 , ef095 , ef096 , ef097 , ef098 , ef099 , ef100 , ef101 , ef102 , ef103 , ef104 , ef105 , ef106 , ef107 , ef108 , ef109 , ef110 , ef111 , ef112 , ef113 , ef114 , ef115 , ef116 , ef117 , ef118 , ef119u1 , ef119u2 , ef120 , ef121 , ef122 , ef123 , ef124 , ef125 , ef126 , ef127 , ef128 , ef129 , ef130 , ef131 , ef132 , ef133 , ef134 , ef135 , ef136 , ef137 , ef138 , ef139 , ef140 , ef141 , ef142 , ef143 , ef144 , ef145 , ef146 , ef147 , ef148 , ef149 , ef150 , ef151 , ef152 , ef153 , ef154 , ef155 , ef156 , ef157 , ef158 , ef159 , ef160 , ef161 , ef162 , ef163 , ef164 , ef165 , ef166 , ef167 , ef168 , ef169 , ef170 , ef171 , ef172 , ef173 , ef174 , ef175 , ef176 , ef177 , ef178 , ef179 , ef180 , ef181 , ef182 , ef183 , ef184 , ef185 , ef186 , ef187 , ef188 , ef189 , ef190 , ef191 , ef192 , ef193 , ef194 , ef195 , ef196 , ef197 , ef198 , ef199 FROM sos_astat", "SELECT ef001, ef002, ef003, ef004, ef005, ef006u1, ef006u2, ef007, ef008, ef009, ef010, ef011, ef012 FROM sos_astat_guest");
    private static int MAX_PLAUSI_COUNT = 1000;
    JdbcTemplate jt;
    DataSource dataSource;
    SqlRowSet rs;
    Map<String, String> currentRow;
    int currentIndex = -1;
    int endIndex = -1;
    int startIndex = -1;
    String[] columnNames;
    SurveyDataDocumentGenerator generator;
    Properties metaData = new Properties();
    String configDir;
    String sdf;
    String resourceId;
    String sql;
    short sdfValidationMode = 0;
    short sdfMetaValidationMode = (short)10;
    MetaErhebungsbeschreibung meta;
    Map<String, MetaSDFMerkmal> merkmale;
    StatisticsBase.DistributionType distributionType;

    public StatisticExport(StatisticsBase.DistributionType distributionType, String configDir, String sdf, String properties, String staticSqlNumber, String sqlFilterClause) {
        this.distributionType = distributionType;
        try {
            this.sql = statSql.get(Integer.parseInt(staticSqlNumber));
        }
        catch (NumberFormatException e) {
            this.sql = statSql.get(0);
        }
        catch (IndexOutOfBoundsException e) {
            this.sql = statSql.get(0);
        }
        if (sqlFilterClause != null) {
            this.sql = this.sql + " where " + sqlFilterClause;
        }
        this.sql = distributionType == StatisticsBase.DistributionType.GUEST_LISTENERS ? this.sql + " order by ef004" : this.sql + " order by ef006";
        this.configDir = configDir;
        this.sdf = sdf;
        this.resourceId = "1" + sdf;
        try {
            this.metaData.load(new FileInputStream(configDir + File.separator + "conf" + File.separator + properties + ".properties"));
        }
        catch (Exception e) {
            logger.error("Problem reading survey.properties", (Throwable)e);
        }
        ResourceConfig resourceConfig = new ResourceConfig();
        resourceConfig.setSdfMetaDir(configDir + File.separator + "sdfmeta");
        resourceConfig.setSurveyDir(configDir + File.separator + "sdf");
        this.generator = new SurveyDataDocumentGenerator(resourceConfig);
        this.generator.setSurveyResourceProvider((SurveyResourceProvider)this);
        this.generator.setSDFValidationMode(this.sdfValidationMode);
        this.generator.setSDFMetaValidationMode(this.sdfMetaValidationMode);
    }

    public void generate(OutputStream out) {
        try {
            this.generator.generate((DataProvider)this, out, "2.0");
        }
        catch (SurveyDataDocumentGeneratorException e) {
            logger.error("Couldn't generate DatML/Raw", (Throwable)e);
        }
    }

    public StringBuffer generateFixedSizeRecord(StatisticsBase record) {
        StrBuilder result = new StrBuilder();
        for (String columnName : this.columnNames) {
            String merkmalName = record.translateFieldNameToOrig(columnName);
            MetaSDFMerkmal m = this.merkmale.get(merkmalName);
            if (m == null) continue;
            logger.debug("Merkmal: {}, L\u00e4nge: {}", (Object)columnName, (Object)m.getLaenge());
            String value = record.getString(m.getName());
            result.appendFixedWidthPadLeft((Object)value, (int)m.getLaenge(), ' ');
        }
        return result.toStringBuffer();
    }

    private StringBuffer generateCsvRecord(StatisticsBase record, String sep) {
        StrBuilder result = new StrBuilder();
        for (int i = 0; i < this.columnNames.length; ++i) {
            String merkmalName = record.translateFieldNameToOrig(this.columnNames[i]);
            result.append(record.getString(merkmalName));
            result.append(sep);
        }
        return result.toStringBuffer();
    }

    public void getFixedSizeData(OutputStream out) {
        try {
            this.getSurveyResource(null, null, null);
        }
        catch (NoResourceFoundException e) {
            logger.error("Couldn't get survey resource", (Throwable)e);
            return;
        }
        this.doQuery();
        StatisticsBase record = this.next();
        while (record != null) {
            StringBuffer line = this.generateFixedSizeRecord(record);
            try {
                out.write(line.toString().getBytes());
                out.write(10);
            }
            catch (IOException e) {
                logger.warn("Couldn't write f\u00edxed size data", (Throwable)e);
                break;
            }
            record = this.next();
        }
    }

    public void getCsvData(OutputStream out) {
        this.doQuery();
        StatisticsBase record = this.next();
        while (record != null) {
            StringBuffer line = this.generateCsvRecord(record, ";");
            try {
                out.write(line.toString().getBytes());
                out.write(10);
            }
            catch (IOException e) {
                logger.warn("Couldn't write f\u00edxed size data", (Throwable)e);
                break;
            }
            record = this.next();
        }
    }

    public void getOutput(String mimeType, OutputStream out) {
        switch (mimeType) {
            case "text/xml": {
                this.generate(out);
                break;
            }
            case "text/csv": {
                this.getCsvData(out);
                break;
            }
            case "text/plain": {
                this.getFixedSizeData(out);
                break;
            }
            default: {
                throw new RuntimeException("Unknown mime-type: " + mimeType);
            }
        }
    }

    public InspectionReport getInspectionReport(InputStream inputStream, int inspectionLevel) {
        Inspector inspector = new Inspector();
        inspector.setSurveyResourceProvider((SurveyResourceProvider)this);
        inspector.setInspectionLevel(inspectionLevel);
        InputSource inputSource = null;
        InspectionReport report = null;
        try {
            inputSource = new InputSource(inputStream);
            report = inspector.inspect(inputSource);
        }
        catch (Exception e) {
            logger.error("Problem reading DatML/RAW", (Throwable)e);
        }
        return report;
    }

    public OutputStream getDatMlRaw() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.generate((OutputStream)out);
        return out;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        this.jt = new JdbcTemplate(dataSource);
        this.doQuery();
    }

    public void setSdfValidationMode(short sdfValidationMode) {
        this.generator.setSDFValidationMode(sdfValidationMode);
        this.sdfValidationMode = sdfValidationMode;
    }

    public void setSdfMetaValidationMode(short sdfMetaValidationMode) {
        this.generator.setSDFMetaValidationMode(sdfMetaValidationMode);
        this.sdfMetaValidationMode = sdfMetaValidationMode;
    }

    public static void main(String[] args) {
        Object report2;
        Object object;
        FileSystemXmlApplicationContext ctx = new FileSystemXmlApplicationContext("test/spring/testApplicationContextPg.xml");
        StatisticExport stex = new StatisticExport(StatisticsBase.DistributionType.COMPLETE2016, "test/spring", "02060810019999000002", "survey", null, null);
        stex.setDataSource((DataSource)ctx.getBean("dataSource"));
        try {
            FileOutputStream out = new FileOutputStream(stex.getConfigDir() + File.separator + "daten_02060810019999000002.xml");
            object = null;
            try {
                stex.generate(out);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (out != null) {
                    if (object != null) {
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((OutputStream)out).close();
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Couldn't generate DatML/RAW", (Throwable)e);
        }
        logger.debug("Successfully created DatML/RAW.");
        try {
            FileInputStream in = new FileInputStream(stex.getConfigDir() + File.separator + "daten_02060810019999000002.xml");
            object = null;
            try {
                report2 = stex.getInspectionReport(in, 4);
                List problems = report2.getProblemList();
                Integer numProblems = report2.getNumOfProblems();
                Integer numDecls = report2.getNumOfDeclarations();
                Integer numMsgs = report2.getNumOfMessages();
                logger.warn("Probleme: {}, Nachrichten: {}, Deklarationen: {}, Probleme im Report: {}", new Object[]{numProblems, numMsgs, numDecls, "" + problems.size()});
                for (InspectionProblem problem : problems) {
                    ProblemPosition problemPosition = problem.getPosition();
                }
            }
            catch (Throwable report2) {
                object = report2;
                throw report2;
            }
            finally {
                if (in != null) {
                    if (object != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (Throwable report2) {
                            ((Throwable)object).addSuppressed(report2);
                        }
                    } else {
                        ((InputStream)in).close();
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Couldn't inspect DatML/RAW", (Throwable)e);
        }
        List<StatisticsBase> ses = stex.getData();
        logger.debug("Anzahl Datens\u00e4tze: {}", (Object)ses.size());
        try {
            FileOutputStream out = new FileOutputStream(stex.getConfigDir() + File.separator + "daten_02060810019999000002.txt");
            report2 = null;
            try {
                stex.getFixedSizeData(out);
            }
            catch (Throwable problems) {
                report2 = problems;
                throw problems;
            }
            finally {
                if (out != null) {
                    if (report2 != null) {
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (Throwable problems) {
                            ((Throwable)report2).addSuppressed(problems);
                        }
                    } else {
                        ((OutputStream)out).close();
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Couldn't generate fixed size data", (Throwable)e);
        }
        stex.jt.execute("delete from sos_stat_plausi");
        for (StatisticsBase se : ses) {
            List<SuperxPlausiFehler> errors = stex.plausi(se);
            stex.savePlausiToDb(errors);
        }
    }

    public void doQuery() {
        this.currentIndex = -1;
        this.currentRow = null;
        this.rs = this.jt.queryForRowSet(this.sql);
        SqlRowSetMetaData srsmt = this.rs.getMetaData();
        this.columnNames = srsmt.getColumnNames();
        while (this.currentIndex < this.startIndex - 1 && this.getNextRow()) {
            logger.debug("Skipping " + this.currentIndex);
        }
    }

    public StatisticsBase next() {
        if (this.getNextRow()) {
            StatisticsBase s = StatisticExport.getStatisticsRecord(this.distributionType);
            s.setData(this.currentRow);
            return s;
        }
        return null;
    }

    public void doPlausi() {
        List<SuperxPlausiFehler> errors;
        List<StatisticsBase> ses = this.getData();
        logger.debug("Anzahl Datens\u00e4tze: {}", (Object)ses.size());
        this.jt.execute("delete from sos_stat_plausi");
        ArrayList<SuperxPlausiFehler> allErrors = new ArrayList<SuperxPlausiFehler>();
        Iterator<StatisticsBase> sei = ses.iterator();
        for (int count = 0; sei.hasNext() && count < MAX_PLAUSI_COUNT; count += errors.size()) {
            errors = this.plausi(sei.next());
            allErrors.addAll(errors);
        }
        this.savePlausiToDb(allErrors);
    }

    public void savePlausiToDb(final List<SuperxPlausiFehler> errors) {
        this.jt.batchUpdate("insert into sos_stat_plausi (matrikelnr,fehlerid,fehlertext,korrekturhinweis,einzelfelder) values (?,?,?,?,?)", new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                String fehlertextLang = ((SuperxPlausiFehler)errors.get(i)).getFehlertextLang();
                String fehlertext = fehlertextLang.isEmpty() ? ((SuperxPlausiFehler)errors.get(i)).getFehlertextKurz() : fehlertextLang;
                ps.setString(1, ((SuperxPlausiFehler)errors.get(i)).getMatrikelNummer());
                ps.setString(2, ((SuperxPlausiFehler)errors.get(i)).getFehlerId());
                ps.setString(3, fehlertext);
                ps.setString(4, ((SuperxPlausiFehler)errors.get(i)).getFehlerKorrekturhinweis());
                ps.setString(5, ((SuperxPlausiFehler)errors.get(i)).getEfList());
            }

            public int getBatchSize() {
                return errors.size();
            }
        });
    }

    public void readPlausiFromDb(final OutputStream out) {
        this.jt.query("select matrikelnr,fehlerid,fehlertext,korrekturhinweis,einzelfelder from sos_stat_plausi", new RowCallbackHandler(){

            public void processRow(ResultSet rsPar) throws SQLException {
                StringBuilder stb = new StringBuilder();
                for (int i = 1; i <= 5; ++i) {
                    stb.append(rsPar.getString(i)).append(" ");
                }
                stb.append('\n');
                try {
                    out.write(stb.toString().getBytes());
                }
                catch (IOException e) {
                    logger.error("Couldn't write to output stream", (Throwable)e);
                }
            }
        });
    }

    public void setEndIndex(int index) {
        this.endIndex = index;
    }

    public void setStartIndex(int index) {
        this.startIndex = index;
    }

    public List<StatisticsBase> getData(int maxRows) {
        this.doQuery();
        ArrayList<StatisticsBase> ses = new ArrayList<StatisticsBase>();
        for (int rows = 0; this.getNextRow() && (maxRows == -1 || rows < maxRows); ++rows) {
            StatisticsBase s = StatisticExport.getStatisticsRecord(this.distributionType);
            s.setData(this.currentRow);
            ses.add(s);
        }
        return ses;
    }

    public List<StatisticsBase> getData() {
        return this.getData(-1);
    }

    public List<SuperxPlausiFehler> plausi(SatzInterface record) {
        String[] refDats;
        ArrayList<SuperxPlausiFehler> plausiErrors = new ArrayList<SuperxPlausiFehler>();
        PlausiInterface plausi = factory.createPlausi("ERHEBUNG_STUDENTEN_PRUEFUNGEN");
        ReferenzDateiVerwalter dateiVerwalter = new ReferenzDateiVerwalter();
        PlausiKontext ctx = new PlausiKontext();
        SuperxReferenzDateiZugriff csvRefVerw = new SuperxReferenzDateiZugriff(this.getConfigDir() + File.separator + "astat" + File.separator + "csv");
        dateiVerwalter.registriereReferenzdateiZugriff((ReferenzDateiZugriffInterface)csvRefVerw);
        for (String refDat : refDats = csvRefVerw.getReferenzdateien()) {
            logger.debug("Referenzdatei: " + refDat);
        }
        ctx.setReferenzDateien((ReferenzDateiInterface)dateiVerwalter);
        ctx.setMerkmalsPruefungWertAbfrageStrategie(2);
        try {
            ctx.setPlausiAblauf("Ablauf_Studenten_Pruefungen");
            plausi.gesamtPlausi(record, ctx);
        }
        catch (Exception e) {
            logger.error("Validation with astat plausis failed.", (Throwable)e);
        }
        int res = ctx.getPlausiErgebnis();
        String plausiErgebnis = "Ergebnis der AStat Validierung: " + (res == 0 ? "Keine Fehler" : (res == 1 ? "Muss-Fehler oder fehlende Merkmale" : (res == 2 ? "Kann-Fehler" : (res == 3 ? "Automatische Korrektur oder L\u00e4ngen Fehler" : (res == 4 ? "Fehler Wertebereich" : "Unbekanntes Ergebnis")))));
        logger.debug(plausiErgebnis);
        for (int i = 0; i < ctx.getAnzahlFehler(); ++i) {
            SuperxPlausiFehler sxPlFehler = new SuperxPlausiFehler(ctx.getFehler(i));
            sxPlFehler.setMatrikelNummer(((StatisticsBase)record).getString("EF6"));
            plausiErrors.add(sxPlFehler);
        }
        return plausiErrors;
    }

    public void close() {
    }

    public DataProvider getDataProvider(StructureDescriptor structure) {
        String path = AbstractDescriptor.getCustomNamesPathString((Descriptor)structure);
        if (path.equals("Nachricht[1]")) {
            return null;
        }
        logger.debug("getDataProvider: {}", (Object)path);
        if (structure.getType() == 2) {
            logger.debug("RECORD {}", (Object)structure.getIndex());
            int index = structure.getIndex();
            if (this.startIndex != -1) {
                index += this.startIndex;
            }
            if (this.rs.isLast() || this.endIndex != -1 && index > this.endIndex) {
                return null;
            }
        }
        return this;
    }

    public String getFieldValue(FieldDescriptor field) {
        String path = AbstractDescriptor.getCustomNamesPathString((Descriptor)field);
        logger.debug("getFieldValue: {}", (Object)path);
        if (field.getType() == 2) {
            logger.debug("Type: Metadata Value: {}", (Object)this.metaData.getProperty(path));
            return this.metaData.getProperty(path);
        }
        int endPos = path.lastIndexOf(46);
        String parentPath = "";
        if (endPos > 0) {
            parentPath = path.substring(0, endPos);
        }
        String fieldName = path.substring(endPos + 1);
        fieldName = StatisticExport.translateFieldName(fieldName);
        return this.getFromRow(parentPath, fieldName);
    }

    public SurveyResource getSurveyResource(String statId, String reportingPeriod, String collector) throws NoResourceFoundException {
        logger.debug("statId: {}", (Object)statId);
        logger.debug("reportingPeriod: {}", (Object)reportingPeriod);
        logger.debug("collector: {}", (Object)collector);
        ByteSource bs = Files.asByteSource((File)new File(this.configDir + File.separator + "sdf" + File.separator + this.sdf + ".xml"));
        DatmlSdfSource res = null;
        try {
            res = new DatmlSdfSource(this.resourceId, bs.read());
            this.meta = res.getErhebungsbeschreibung();
            Iterator it = this.meta.getMerkmale();
            this.merkmale = new HashMap<String, MetaSDFMerkmal>();
            while (it.hasNext()) {
                MetaSDFMerkmal m = (MetaSDFMerkmal)it.next();
                logger.debug("Merkmal: {}", (Object)m.getName());
                this.merkmale.put(m.getName(), m);
            }
        }
        catch (IOException e) {
            logger.error("Problem reading sdf", (Throwable)e);
        }
        catch (ResourceException e) {
            logger.error("Problem getting MetaErhebungsBeschreibung", (Throwable)e);
        }
        return res;
    }

    private String getFromRow(String path, String fieldName) {
        int endPos = path.lastIndexOf(46);
        String satz = path.substring(endPos + 1);
        int index = Integer.parseInt(CharMatcher.DIGIT.retainFrom((CharSequence)satz));
        if (this.startIndex != -1) {
            index += this.startIndex;
        }
        if (index > this.currentIndex && !this.getNextRow()) {
            logger.debug("End of data reached at line {}", (Object)index);
            return null;
        }
        logger.debug("Getting data line {} field {}", (Object)index, (Object)fieldName);
        return this.currentRow.get(fieldName);
    }

    private boolean getNextRow() {
        if (this.rs == null || this.rs.isLast() || this.endIndex != -1 && this.currentIndex == this.endIndex) {
            logger.debug("END OF DATA for index " + this.currentIndex);
            return false;
        }
        HashMap<String, String> row = new HashMap<String, String>();
        if (this.rs.next()) {
            for (String columnName : this.columnNames) {
                String value = this.rs.getString(columnName);
                if (value != null) {
                    value = value.trim();
                }
                row.put(columnName.trim(), value);
            }
            this.currentRow = row;
            ++this.currentIndex;
            logger.debug("DATA LINE #" + this.currentIndex);
            return true;
        }
        return false;
    }

    private String getConfigDir() {
        return this.configDir;
    }

    public static String translateFieldName(String origFieldName) {
        String numPart;
        String fieldNameOrig = origFieldName.toLowerCase();
        if (fieldNameOrig.equals("berichtseinheitid")) {
            return "ef004";
        }
        String fieldName = "ef";
        String lenNumPart = numPart = fieldNameOrig.substring(2);
        if (numPart.contains("u")) {
            lenNumPart = numPart.substring(0, numPart.indexOf(117));
        }
        for (int len = lenNumPart.length(); len < 3; ++len) {
            fieldName = fieldName + "0";
        }
        return fieldName + numPart;
    }

    private static StatisticsBase getStatisticsRecord(StatisticsBase.DistributionType distributiontype) {
        StatisticsBase statisticsBase = null;
        switch (distributiontype) {
            case COMPLETE1990: {
                statisticsBase = new StudentAndExaminationStatistics1990();
                break;
            }
            case COMPLETE2016: {
                statisticsBase = new StudentAndExaminationStatistics2016();
                break;
            }
            case STUDENTS1990: {
                statisticsBase = new StudentStatistics1990();
                break;
            }
            case STUDENTS2016: {
                statisticsBase = new StudentStatistics2016();
                break;
            }
            case EXAMINATIONS1990: {
                statisticsBase = new ExaminationStatistics1990();
                break;
            }
            case EXAMINATIONS2016: {
                statisticsBase = new ExaminationStatistics2016();
                break;
            }
            case GUEST_LISTENERS: {
                statisticsBase = new GuestListenerStatistics();
            }
        }
        return statisticsBase;
    }

    public static enum ExportFormat {
        XML("text/xml", "text/xml", "xml"),
        CSV("text/csv", "text/comma-separated-values", "csv"),
        TXT("text/plain", "text/plain", "txt"),
        ZIP("application/zip", "application/zip", "zip"),
        UNKNOWN("", "", "");

        private String mime;
        private String content;
        private String extension;

        private ExportFormat(String mime, String content, String extension) {
            this.mime = mime;
            this.content = content;
            this.extension = extension;
        }

        public String getMimeType() {
            return this.mime;
        }

        public String getContentType() {
            return this.content;
        }

        public String getExtension() {
            return this.extension;
        }

        public static ExportFormat getForMimeType(String mimeType) {
            if (CSV.getMimeType().equals(mimeType)) {
                return CSV;
            }
            if (XML.getMimeType().equals(mimeType)) {
                return XML;
            }
            if (TXT.getMimeType().equals(mimeType)) {
                return TXT;
            }
            if (ZIP.getMimeType().equals(mimeType)) {
                return ZIP;
            }
            return UNKNOWN;
        }
    }
}

