/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.memtext.db.NichtAngemeldetException;
import de.memtext.tree.KeyParentEqualException;
import de.memtext.tree.NoMainEntryException;
import de.memtext.util.ServletHelper;
import de.memtext.util.StringUtils;
import de.superx.common.DBServletException;
import de.superx.common.InvalidDataTypeException;
import de.superx.common.InvalidKeyException;
import de.superx.common.SichtException;
import de.superx.common.SxUser;
import de.superx.common.UngueltigeEingabeException;
import de.superx.servlet.AbstractSuperXServlet;
import de.superx.servlet.ServletUtils;
import de.superx.servlet.SuperXManager;
import de.superx.servlet.SuperXServletHelper;
import de.superx.servlet.SxPools;
import de.superx.util.SqlStringUtils;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadException;
import org.dom4j.DocumentException;
import org.xml.sax.SAXException;

public class SuperXUpload
extends AbstractSuperXServlet {
    private static final long serialVersionUID = 2L;
    private static final String ADMIN_ONLY = SuperXManager.htmlPageHead("Upload") + "<center><h3>Hier ist ein Login nur f\u00fcr Administratoren m&ouml;glich.</h3>(Cookies m&uuml;ssen aktiviert sein)<FORM ACTION=\"SuperXUpload\" METHOD=\"post\"><p><p>Kennung: <br /><INPUT TYPE=\"Text\" NAME=\"kennung\" VALUE=\"superx\"></p><p><p>Passwort: <br /><INPUT TYPE=\"Password\" NAME=\"passwort\" value=\"\"></p><p>MandantenID<br><input type=\"text\" name=\"MandantenID\" value=\"default\"></p><br><INPUT TYPE=\"Submit\" NAME=\"Abschicken\" VALUE=\"Anmelden\"></FORM></center></body></html>";
    private static String pageBeginning = SuperXManager.htmlPageHead("Upload") + "<center><h1>SuperX Upload</h1>";
    private static String pageEnd = "</body></html>";
    private static String pathstart = "";
    private Map mandantenFilter = new HashMap();
    private static String tempdir;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        pathstart = this.getServletConfig().getServletContext().getRealPath("/");
        Enumeration en = config.getInitParameterNames();
        while (en.hasMoreElements()) {
            String mandantenID = (String)en.nextElement();
            String mandantenFilterString = config.getInitParameter(mandantenID);
            this.mandantenFilter.put(mandantenID, mandantenFilterString);
            new File(pathstart + File.separator + mandantenID + "custom").mkdirs();
        }
        tempdir = System.getProperty("java.io.tmpdir");
        if (!tempdir.endsWith("/") && !tempdir.endsWith("\\")) {
            tempdir = tempdir + System.getProperty("file.separator");
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.checkAnmeldungImRequest(request);
        if (this.isAllowed(request, response)) {
            if (FileUpload.isMultipartContent((HttpServletRequest)request)) {
                Uploader u = new Uploader(request, response);
                u.run(true);
            } else {
                this.sendFormPage(request, response);
            }
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AbstractSuperXServlet.setEncoding(request);
        response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
        if (this.isAllowed(request, response)) {
            this.sendFormPage(request, response);
        }
    }

    private boolean isAllowed(HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean result = true;
        SxUser user = (SxUser)request.getSession().getAttribute("user");
        if (user == null || !user.isAdmin()) {
            result = false;
            ServletUtils.sendBackHtml(response, ADMIN_ONLY);
        } else {
            String mandantenID = ServletUtils.getMandantenID(request);
            if (mandantenID == null || this.mandantenFilter.get(mandantenID) == null) {
                ServletUtils.sendBackHtml(response, pageBeginning + "<h2><font color=\"red\"> Die Funktion ist f&uuml;r Ihre MandantenID: " + mandantenID + " nicht aktiviert.</font></h2></body></html>");
                result = false;
            }
        }
        return result;
    }

    private void sendFormPage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String pfad = ServletHelper.getParameter(request, "pfad");
        String mandantenID = ServletUtils.getMandantenID(request);
        if (pfad == null) {
            pfad = "";
        }
        String t = pageBeginning + "<p align=\"center\"> <b>Ihre MandantenID:</b><font color=\"darkgreen\">" + mandantenID + "</font></p><p align=\"center\">Dateien werden auf dem Webserver gespielt ins Verzeichnis <b>superx/" + mandantenID + "/custom/</b><br>Zur Verlinkung von Grafiken kann z.B. ../" + mandantenID + "/custom/" + mandantenID + "/logo.gif genutzt werden</p><p align=\"center\"><b>Erlaubte Dateien:</b><font color=\"darkgreen\"> " + this.mandantenFilter.get(mandantenID) + "</font><br><br> <b>Jeder Upload wird einschlie\u00dflich Dateiname,Username,Zeitpunkt und IP-Nummer protokolliert!</b><br><br>Sie k&ouml;nnen ein bis vier Dateien gleichzeitig hochladen.<br>Ggfs. bereits vorhandene Dateien werden &uuml;berschrieben.</p><form action=\"../servlet/SuperXUpload\" enctype=\"multipart/form-data\" method=\"POST\"> \n<p align=\"center\"><br><input type=\"file\" size=\"60\" name=\"datei1\" ><br>\n<input type=\"file\" size=\"60\"  name=\"datei2\" ><br>\n<input type=\"file\" size=\"60\"  name=\"datei3\" ><br>\n<input type=\"file\" size=\"60\" name=\"datei4\" ><br><br>\n<input type=\"submit\" value=\"Upload\"> \n</p></form> \n</body> \n</html>";
        ServletUtils.sendBackHtml(response, t);
    }

    public String getServletInfo() {
        return "SuperXUpload";
    }

    private class Uploader
    extends SuperXServletHelper {
        private String subpath;
        private StringBuffer result;
        private Connection conn;
        private PreparedStatement pst;
        private List filterList;

        Uploader(HttpServletRequest request, HttpServletResponse response) throws IOException {
            super(request, response);
            this.subpath = "";
            this.result = new StringBuffer();
            this.filterList = new LinkedList();
            String filters = (String)SuperXUpload.this.mandantenFilter.get(this.getMandantenID());
            if (filters != null) {
                StringTokenizer st = new StringTokenizer(filters, ",");
                while (st.hasMoreTokens()) {
                    String afilter = st.nextToken();
                    this.filterList.add(afilter);
                }
            }
            this.result.append(pageBeginning);
            try {
                this.conn = SxPools.getConnection(this.getMandantenID());
                String client_ip = "'" + request.getRemoteAddr() + "'";
                String client_dns = "'" + request.getRemoteHost() + "'";
                String now = "";
                now = SxPools.get(this.getMandantenID()).getSqlDialect().equals("Postgres") ? ", now()" : ", current";
                this.pst = this.conn.prepareStatement("insert into protokoll (proto_fkt_id, userinfo_id, ip_adresse, client_name, zeitpunkt,kommentar) values (?, ?," + client_ip + "," + client_dns + now + ",?)");
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }

        @Override
        protected void perform() throws SQLException, DBServletException, TransformerException, KeyParentEqualException, NichtAngemeldetException, IOException, ParseException, ParserConfigurationException, FactoryConfigurationError, SAXException, DocumentException, IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, CloneNotSupportedException, TemplateException, InvalidKeyException, SichtException, IOException, ServletException, UngueltigeEingabeException, NoMainEntryException, InvalidDataTypeException {
            DiskFileUpload fu = new DiskFileUpload();
            try {
                List files = fu.parseRequest(this.request);
                String mandantenID = this.getMandantenID();
                this.subpath = File.separator + mandantenID + File.separator + "custom";
                for (FileItem item : files) {
                    if (item.isFormField() || item.getSize() == 0L) continue;
                    if (this.isFileAllowed(item.getName())) {
                        this.uploadFile(item);
                        continue;
                    }
                    this.log(item, new UngueltigeEingabeException("Hochladen von " + item.getName() + " nicht erlaubt!"));
                }
            }
            catch (FileUploadException e) {
                this.result.append("<p><font color=\"red\"> Hochladen nicht erfolgreich: " + (Object)((Object)e) + "</font></p>");
            }
            this.result.append("<p align=\"center\"><a  href=\"../servlet/SuperXUpload\">zur Upload-Seite</a></p></body> \n</html>");
            this.pst.close();
            this.conn.close();
            this.sendBackHtml(this.result.toString());
        }

        private void uploadFile(FileItem item) throws SQLException {
            File dir = new File(pathstart + this.subpath);
            try {
                if (!dir.exists()) {
                    throw new IOException("Zielverzeichnis " + dir + " existiert nicht");
                }
                File targetFile = new File(pathstart + this.subpath + File.separator + item.getName());
                if (targetFile.exists()) {
                    targetFile.delete();
                }
                item.write(targetFile);
                this.log(item, null);
            }
            catch (Exception e) {
                this.log(item, e);
            }
        }

        private void log(FileItem item, Exception e) throws SQLException {
            SxUser user = (SxUser)this.request.getSession().getAttribute("user");
            this.pst.setInt(2, (Integer)user.getId());
            String msg = "";
            this.result.append("<p>");
            String s = item.getName() + " nach superx" + this.subpath;
            if (e == null) {
                msg = "Hochladen von " + s + " erfolgreich";
                this.result.append("<font color=\"darkgreen\">" + msg + "</font>");
                this.pst.setInt(1, 11);
            } else if (e instanceof UngueltigeEingabeException) {
                msg = "Hochladen von " + s + " nicht erlaubt!";
                this.result.append("<font color=\"red\">" + msg + "</font>");
                this.pst.setInt(1, 12);
            } else {
                msg = "Hochladen von " + s + " nicht erfolgreich:" + e;
                this.pst.setInt(1, 13);
                this.result.append("<font color=\"red\">" + msg + "</font>");
            }
            this.pst.setString(3, msg);
            this.pst.execute();
            this.result.append("</p>");
        }

        private boolean isFileAllowed(String name) {
            boolean result = false;
            for (String afilter : this.filterList) {
                if (afilter.indexOf("*") == -1) {
                    if (!name.equals(afilter)) continue;
                    result = true;
                    continue;
                }
                afilter = StringUtils.replace(afilter, ".", "\\.").toLowerCase();
                Pattern p = Pattern.compile(afilter = StringUtils.replace(afilter, "*", ".*"));
                Matcher m = p.matcher(name.toLowerCase());
                if (!m.matches()) continue;
                result = true;
            }
            return result;
        }
    }
}

