/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.memtext.baseobjects.NamedObjectI;
import de.memtext.db.PropsReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDriver;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;

public class ExternalPool
extends GenericObjectPool
implements NamedObjectI {
    private String name;
    private boolean isOK = false;
    private String exceptionMsg = "";

    public ExternalPool(String mandantenID, String name, String driver, String url, String username, String passwort, int minidle, int maxidle, int maxactive, String testsql) {
        this.setName(name);
        try {
            Class.forName(driver);
            if (minidle != 0) {
                this.setMinIdle(minidle);
            }
            if (maxidle != 0) {
                this.setMaxIdle(maxidle);
            }
            if (maxactive != 0) {
                this.setMaxActive(maxactive);
            }
            Properties props = new Properties();
            props.put("user", username);
            passwort = PropsReader.check(mandantenID, passwort);
            props.put("password", passwort);
            boolean i = false;
            DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(url, props);
            PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, (ObjectPool)this, null, testsql, false, true);
            PoolingDriver pdriver = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:");
            pdriver.registerPool(this.getName(), (ObjectPool)this);
            Connection c = this.getConnection();
            c.close();
            this.isOK = true;
        }
        catch (Exception e) {
            this.exceptionMsg = "Externe Datenverbindung Mandant:" + name.replace('-', ':') + " konnte nicht aufgebaut werden: " + e.toString();
            System.out.println(this.exceptionMsg);
            e.printStackTrace();
            Logger.getLogger("superx_" + mandantenID).log(Level.WARNING, this.exceptionMsg);
        }
    }

    public Connection getConnection() throws SQLException {
        return DriverManager.getConnection("jdbc:apache:commons:dbcp:" + this.getName());
    }

    public void invalidate(Connection con) throws SQLException {
        PoolingDriver driver = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:" + this.getName());
        driver.invalidateConnection(con);
    }

    public String getExceptionMsg() {
        return this.exceptionMsg;
    }

    public boolean isOK() {
        return this.isOK;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }
}

