/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import de.memtext.baseobjects.coll.IdObjectSet;
import de.memtext.util.NumberUtils;
import de.memtext.util.XMLUtils;
import de.superx.bin.fm.EtlStarter;
import de.superx.common.RepositoryItem;
import de.superx.common.RepositoryItemCollection;
import de.superx.common.SelectableItem;
import de.superx.common.SelectableItemNode;
import de.superx.common.StandaloneSicht;
import de.superx.common.SxResultRow;
import de.superx.common.SxResultSet;
import de.superx.util.SqlStringUtils;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.ParseException;
import freemarker.log.Logger;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.SimpleDate;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleNumber;
import freemarker.template.SimpleScalar;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateSequenceModel;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TemplateProcessor {
    private Configuration cfg;
    public SxResultSet rawFmTemplates;
    protected HashMap repositoryMap = new HashMap();
    protected String mandantenID = "default";
    protected Connection con = null;
    public static final String REPOSITORY_SELECT = "select trim(both from id) as id,caption,content,gueltig_seit,gueltig_bis,comment,sort1,sort2,sort3 from sx_repository where aktiv=1";

    public TemplateProcessor(String mandantenID, Connection con) {
        this(mandantenID);
        this.con = con;
    }

    public TemplateProcessor(String mandantenID) {
        this.mandantenID = mandantenID;
        Configuration myCfg = new Configuration(Configuration.VERSION_2_3_21);
        myCfg.setTemplateLoader((TemplateLoader)new StringTemplateLoader());
        try {
            myCfg.setSetting("number_format", "###########.####");
            myCfg.setSharedVariable("etl", (TemplateModel)new EtlStarter(mandantenID));
        }
        catch (TemplateException e) {
            System.out.println("FreeMarker warning: " + (Object)((Object)e));
            e.printStackTrace();
        }
        this.cfg = myCfg;
    }

    public void setRepositoryMap(HashMap repository) {
        this.repositoryMap = repository;
    }

    public void add(String id, String ts) {
        ((StringTemplateLoader)this.cfg.getTemplateLoader()).putTemplate(id, ts);
    }

    protected synchronized Template buildTemplateObject(String templateName, String template) throws IOException {
        Template t = null;
        templateName = this.cleanName(templateName);
        templateName = templateName + "-rnd:" + NumberUtils.getRandomInt(1000000000);
        template = template.replaceAll("\\p{javaSpaceChar}", " ");
        ((StringTemplateLoader)this.cfg.getTemplateLoader()).putTemplate(templateName, template);
        try {
            t = this.cfg.getTemplate(templateName);
            this.cfg.removeTemplateFromCache(templateName);
        }
        catch (ParseException e) {
            throw new RuntimeException("FreeMarker-Parsing fehlgeschlagen - " + e.getMessage() + "DETAILS: Die Zeilennummer bezieht sich auf folgende Vorlage\n(Masken select_stmt nach SuperX-Verarbeitung mit generateSql)\n" + template);
        }
        return t;
    }

    public String process(String templateName, String fmSql, HashMap hmap, String sqldialect) throws TemplateException, IOException, SQLException {
        StringBuffer b = new StringBuffer();
        fmSql = b.toString() + fmSql;
        templateName = this.cleanName(templateName);
        hmap.put("SQLdialect", sqldialect);
        hmap.putAll(this.repositoryMap);
        if (fmSql.indexOf("<sqlvars>") > -1) {
            this.addSqlVars(hmap, fmSql, sqldialect);
            fmSql = this.removeSqlVars(fmSql);
        }
        StringWriter out = new StringWriter();
        Template t = this.buildTemplateObject(templateName, fmSql);
        t.process((Object)hmap, (Writer)out);
        ((Writer)out).close();
        return ((Object)out).toString();
    }

    private synchronized void addSqlVars(HashMap hmap, String fmSql, String sqldialect) throws SQLException, TemplateException, IOException {
        int i = fmSql.indexOf("<sqlvars>");
        int i2 = fmSql.indexOf("</sqlvars>");
        String sqlvarsxml = fmSql.substring(i, i2 + 10);
        Document doc = null;
        try {
            doc = XMLUtils.buildDocumentFromStringWithException(sqlvarsxml, false);
        }
        catch (SAXException e) {
            String msg = "Sqlvars konnten nicht zu XML-Dokument verarbeitet werden, Syntax checken ";
            System.out.println(msg);
            System.out.println(sqlvarsxml);
            e.printStackTrace();
            throw new SQLException(msg + "vergl. catalina.out ");
        }
        NodeList list = doc.getElementsByTagName("sqlvar");
        for (i = 0; i < list.getLength(); ++i) {
            FMListe liste;
            SxResultSet roh;
            Node n = list.item(i);
            String varname = XMLUtils.getAttribValue(n, "name");
            String sql = n.getTextContent();
            SqlVarType type = SqlVarType.none;
            if (XMLUtils.hasAttrib(n, "type")) {
                type = SqlVarType.valueOf(XMLUtils.getAttribValue(n, "type").toLowerCase());
            }
            String name_intern = "";
            if (type == SqlVarType.sichtsequence) {
                roh = this.readFromDb(sql);
                liste = new FMListe();
                for (SxResultRow zeile : roh) {
                    String gewuenschterStand = "today";
                    liste.add(this.addSqlVarSicht(hmap, "nur_ein_dummy", (String)zeile.get(0), gewuenschterStand));
                }
                hmap.put(varname, liste);
                continue;
            }
            if (type == SqlVarType.hashlist) {
                List<TemplateHashModel> results = this.selectFromDb(sql);
                hmap.put(varname, results);
                continue;
            }
            if (type == SqlVarType.sicht) {
                name_intern = XMLUtils.getAttribValue(n, "name_intern");
                String gewuenschterStand = "today";
                if (XMLUtils.hasAttrib(n, "stand")) {
                    gewuenschterStand = XMLUtils.getAttribValue(n, "stand");
                }
                this.addSqlVarSicht(hmap, varname, name_intern, gewuenschterStand);
                continue;
            }
            if (type == SqlVarType.list) {
                roh = this.readFromDb(sql);
                ArrayList<String> results = new ArrayList<String>();
                for (SxResultRow zeile : roh) {
                    results.add(zeile.get(0).toString());
                }
                hmap.put(varname, results);
                continue;
            }
            if (type == SqlVarType.string) {
                String resultstring = this.process("sqlvar " + varname + NumberUtils.getRandomInt(99999999), sql, hmap, sqldialect);
                hmap.put(varname, resultstring);
                continue;
            }
            if (SqlStringUtils.tableExists(this.con, "sx_repository", this.mandantenID)) {
                sql = "<#include \"SuperX_general\"/><#include \"SQL_lingua_franca\"/>" + sql;
            }
            sql = this.process("sqlvar " + varname + NumberUtils.getRandomInt(99999999), sql, hmap, sqldialect);
            roh = this.readFromDb(sql);
            liste = new FMListe();
            boolean isSelectableItem = false;
            Object entry = "";
            int rowcount = roh.size();
            for (SxResultRow zeile : roh) {
                if (type == SqlVarType.hash || type == SqlVarType.hashsequence) {
                    SxHash h = new SxHash();
                    for (int j = 0; j < zeile.size(); ++j) {
                        String key = roh.getColumnName(j).toLowerCase();
                        Object value = zeile.get(j);
                        h.put(key, value);
                    }
                    if (rowcount == 1) {
                        entry = h;
                    }
                    liste.add(h);
                    continue;
                }
                entry = zeile.get(0);
                if (entry == null) {
                    entry = "";
                }
                String nam = "";
                if (zeile.size() > 1) {
                    nam = SqlStringUtils.getValueAsString(zeile.get(1));
                    isSelectableItem = true;
                }
                SelectableItem item = new SelectableItem(entry, nam);
                if (zeile.size() > 2) {
                    item.setStrukturInfo(zeile.get(2));
                }
                if (zeile.size() > 3) {
                    item.setStrukturInfo(zeile.get(3));
                }
                liste.add(new SelectableItemNode(item));
            }
            if (type == SqlVarType.hashsequence || type == SqlVarType.hash && rowcount > 1 || isSelectableItem) {
                hmap.put(varname, liste);
                liste = null;
                continue;
            }
            hmap.put(varname, entry);
            entry = null;
        }
    }

    protected List<TemplateHashModel> selectFromDb(String sql) throws SQLException {
        ArrayList<TemplateHashModel> result = new ArrayList<TemplateHashModel>();
        try (Statement st = this.con.createStatement();
             ResultSet res = st.executeQuery(sql);){
            ResultSetMetaData meta = res.getMetaData();
            int colCount = meta.getColumnCount();
            ArrayList<String> colLabels = new ArrayList<String>(colCount);
            for (int i = 0; i < colCount; ++i) {
                colLabels.add(meta.getColumnLabel(i + 1));
            }
            while (res.next()) {
                HashMap<String, String> row = new HashMap<String, String>();
                for (String colLabel : colLabels) {
                    row.put(colLabel, res.getString(colLabel));
                }
                result.add((TemplateHashModel)new SimpleHash(row));
            }
        }
        return result;
    }

    protected StandaloneSicht addSqlVarSicht(HashMap hmap, String varname, String name_intern, String gewuenschterStand) throws SQLException {
        throw new IllegalStateException("sqlvar mit type Sicht wird hier nicht unterst\u00fctzt");
    }

    protected SxResultSet readFromDb(String sql) throws SQLException {
        return new SxResultSet();
    }

    private String removeSqlVars(String fmSql) {
        int i = fmSql.indexOf("<sqlvars>");
        int i2 = fmSql.indexOf("</sqlvars>");
        return fmSql.substring(0, i) + fmSql.substring(i2 + 10, fmSql.length());
    }

    protected String cleanName(String templateName) {
        if (templateName.indexOf("/") > -1) {
            templateName = templateName.replace('/', ' ');
        }
        if (templateName.indexOf("\\") > -1) {
            templateName = templateName.replace('\\', ' ');
        }
        return templateName;
    }

    public void setTemplates(SxResultSet rawFmTemplates) {
        this.rawFmTemplates = rawFmTemplates;
        if (rawFmTemplates == null) {
            throw new RuntimeException("Keine FreeMarker Templates geliefert");
        }
        for (SxResultRow row : rawFmTemplates) {
            String name = (String)row.get(0);
            String content = SqlStringUtils.getValueAsString(row.get(1));
            this.add(name, content);
            this.cfg.addAutoInclude(name);
        }
    }

    public static void repositoryToMap(SxResultSet rs, HashMap map) {
        IdObjectSet riColls = new IdObjectSet();
        for (SxResultRow row : rs) {
            Object id = row.get(0);
            String name = (String)row.get(1);
            RepositoryItem ri = new RepositoryItem();
            ri.setId(id);
            ri.setName(name);
            ri.setContent(SqlStringUtils.getValueAsString(row.get(2)));
            ri.setValidSince((java.util.Date)row.get(3));
            ri.setValidTill((java.util.Date)row.get(4));
            ri.setComment(SqlStringUtils.getValueAsString(row.get(5)));
            RepositoryItemCollection riColl = null;
            if (riColls.containsItemWithId(id)) {
                riColl = (RepositoryItemCollection)riColls.getById(id);
            } else {
                riColl = new RepositoryItemCollection(id);
                riColls.add(riColl);
            }
            riColl.add(ri);
        }
        for (RepositoryItemCollection rcoll : riColls) {
            map.put(rcoll.getId(), rcoll);
        }
    }

    static {
        try {
            Logger.selectLoggerLibrary((int)0);
        }
        catch (Exception e) {
            System.out.println("FreeMarker warning: " + e);
        }
    }

    class SxHash
    implements TemplateHashModel {
        private HashMap map = new HashMap();

        SxHash() {
        }

        public void put(String key, Object value) {
            this.map.put(key, value);
        }

        public boolean containsKey(Object key) {
            return this.map.containsKey(key);
        }

        public TemplateModel get(String key) throws TemplateModelException {
            if (!this.map.containsKey(key)) {
                throw new IllegalArgumentException("Kein attribut " + key + " bekannt");
            }
            Object val = this.map.get(key);
            if (val == null) {
                val = "";
            }
            SimpleScalar result = null;
            if (val instanceof String) {
                result = new SimpleScalar(val.toString());
            } else if (val instanceof Date) {
                result = new SimpleDate((Date)val);
            } else if (val instanceof Number) {
                result = new SimpleNumber((Number)val);
            } else if (val instanceof Clob) {
                result = new SimpleScalar(SqlStringUtils.getValueAsString(val));
            }
            return result;
        }

        public boolean isEmpty() throws TemplateModelException {
            return this.map.isEmpty();
        }
    }

    class FMListe
    implements TemplateMethodModelEx,
    TemplateSequenceModel {
        private static final long serialVersionUID = 1L;
        private LinkedList liste = new LinkedList();

        FMListe() {
        }

        public void add(Object o) {
            this.liste.add(o);
        }

        public Object exec(List l) throws TemplateModelException {
            Object result = null;
            if (l == null) {
                throw new IllegalArgumentException("keine Argumente \u00fcbergeben");
            }
            String key = "";
            if (l.get(0).toString().equalsIgnoreCase("get")) {
                if (l.size() < 3) {
                    throw new TemplateModelException("Syntax: get,id-column Schl\u00fcssel - mindestens 3 Elemente n\u00f6tig");
                }
                String idcolumn = l.get(1).toString();
                key = l.get(2).toString();
                for (Object o : this.liste) {
                    if (!(o instanceof SxHash)) continue;
                    SxHash h = (SxHash)o;
                    if (!h.containsKey(idcolumn)) {
                        throw new IllegalArgumentException("idcolumn " + idcolumn + " nicht gefunden");
                    }
                    if (!h.get(idcolumn).toString().equals(key)) continue;
                    result = h;
                }
            } else if (l.get(0).toString().equalsIgnoreCase("getById")) {
                if (l.size() < 2) {
                    throw new TemplateModelException("Syntax: getbyId,Schl\u00fcssel - mindestens 2 Elemente n\u00f6tig");
                }
                for (Object o : this.liste) {
                    SelectableItem s;
                    if (!(o instanceof SelectableItem) || !(s = (SelectableItem)o).getId().toString().equals(key)) continue;
                    result = s;
                }
            } else {
                throw new IllegalArgumentException("nur getItem,Schl\u00fcssel implementiert");
            }
            if (result == null) {
                throw new IllegalArgumentException("Element " + key + " nicht gefunden in Freemarker hash");
            }
            return result;
        }

        public TemplateModel get(int i) throws TemplateModelException {
            Object o = this.liste.get(i);
            SxHash result = null;
            result = o instanceof SxHash ? (SxHash)o : new DefaultObjectWrapper().wrap(o);
            return result;
        }

        public int size() throws TemplateModelException {
            return this.liste.size();
        }
    }

    static enum SqlVarType {
        list,
        hashlist,
        hash,
        hashsequence,
        sicht,
        sichtsequence,
        string,
        none;

    }
}

