/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import de.memtext.util.DateUtils;
import de.memtext.util.GetOpts;
import de.memtext.util.StringUtils;
import de.memtext.util.XMLUtils;
import de.superx.bin.SxConnection;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.postgresql.PGConnection;
import org.postgresql.copy.CopyManager;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FileToTableUploader {
    private String logfile;
    private String dbpropfile;
    private String mode = "stop";
    private String inFormat;
    private String targetTable;
    private String srcFile;
    private boolean header = false;
    private String delim;
    private String encoding;
    private String inserts = "";
    private boolean continueAfterError;
    private boolean removeTrailingDelim = true;
    private boolean isPostgres;
    private boolean useBatch = true;
    private static int maxCols = 1000;
    private String[] insert_cols = new String[maxCols];
    private int[] insert_types = new int[maxCols];
    private int numberOfColumns;
    public long numberOfRows;
    private Connection uploadConnection;
    private DatabaseMetaData dbmd;
    private PreparedStatement pst;
    private static String usage = "-------------------------------------\nGebrauch: java de.superx.bin.FileToTableUploader \n-dbproperties:<Pfad zu db.properties> \n-table:<Tabellenname> \n-unl:<Dateipfad Quelldatei>(optional, default ist Tabellenname.unl) \n-delim:<delimiter>(optional, default ist ^) \n-header:<true|false>(optional, mit Feld\u00fcberschriften, default ist false)\n-mode:<stop|exclude-row>(optional, default is stop) #Bei Fehlerhaften Daten kann das Hochladen gestoppt werden, oder der Datensatz wird \u00fcbersprungen\n-inserts:<false|simple|batch>(optional, default is false) #Bei -inserts:simple und batch werden Die Rohdaten in Insert-sql-Statements \u00fcbersetzt (nur f\u00fcr Debugging-Zwecke, sehr langsam. Der Modus exclude-field ist dar\u00fcberhinaus nicht anwendbar)\n-encoding:<utf8,ISO-8859-1, default ist System.file.encoding>\n---------------------------------------------------";

    public Connection getUploadConnection() {
        return this.uploadConnection;
    }

    public void setUploadConnection(Connection uploadConnection) {
        this.uploadConnection = uploadConnection;
    }

    public boolean isRemoveTrailingDelim() {
        return this.removeTrailingDelim;
    }

    public void setRemoveTrailingDelim(boolean removeTrailingDelim) {
        this.removeTrailingDelim = removeTrailingDelim;
    }

    public void setHeader(boolean header) {
        this.header = header;
    }

    public String getDbpropfile() {
        return this.dbpropfile;
    }

    public void setDbpropfile(String dbpropfile) {
        this.dbpropfile = dbpropfile;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        if (!(mode.equals("stop") || mode.equals("exclude-field") || mode.equals("transaction"))) {
            mode = "exclude-row";
        }
        this.mode = mode;
    }

    public String getInFormat() {
        return this.inFormat;
    }

    public void setInFormat(String inFormat) {
        this.inFormat = inFormat;
    }

    public String getTargetTable() {
        return this.targetTable;
    }

    public void setTargetTable(String targetTable) {
        this.targetTable = targetTable;
    }

    public String getSrcFile() {
        return this.srcFile;
    }

    public void setSrcFile(String srcFile) {
        this.srcFile = srcFile;
    }

    public String getDelim() {
        return this.delim;
    }

    public void setDelim(String delim) {
        if (delim.equals("tab")) {
            delim = "\t";
        }
        if (delim.equals("")) {
            delim = "^";
        }
        this.delim = delim;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        if (encoding == null || encoding.equals("")) {
            encoding = "UTF-8";
        }
        this.encoding = encoding;
    }

    public String getInserts() {
        return this.inserts;
    }

    public void setInserts(String inserts) {
        if (inserts.equalsIgnoreCase("batch")) {
            this.useBatch = true;
        }
        if (inserts.equalsIgnoreCase("simple")) {
            this.useBatch = false;
        }
        this.inserts = inserts;
    }

    public boolean isContinueAfterError() {
        return this.continueAfterError;
    }

    public void setContinueAfterError(boolean continueAfterError) {
        this.continueAfterError = continueAfterError;
    }

    public String uploadFile() throws Exception {
        String protokoll = "";
        protokoll = this.inFormat.equalsIgnoreCase("xml") ? this.uploadXML() : this.uploadCSV();
        if (protokoll.indexOf("Exception") > -1) {
            throw new Exception(protokoll);
        }
        return protokoll;
    }

    private String uploadXML() throws Exception {
        String errmsg = "";
        Document mydomres = null;
        this.numberOfRows = 0L;
        try {
            DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dfactory.newDocumentBuilder();
            FileInputStream in = new FileInputStream(this.srcFile);
            InputSource is = new InputSource(in);
            mydomres = builder.newDocument();
            mydomres = builder.parse(is);
        }
        catch (SAXException e1) {
            errmsg = "XML-Strom nicht wohlgeformt: " + e1.toString();
            return errmsg;
        }
        catch (ParserConfigurationException e2) {
            errmsg = "XML-Strom nicht wohlgeformt: " + e2.toString();
            return errmsg;
        }
        NodeList rowlist = mydomres.getElementsByTagName("row");
        this.initializeColumnSchema();
        String insertHead = this.createPreparedStatementHead();
        this.pst = this.uploadConnection.prepareStatement(insertHead);
        if (this.useBatch) {
            this.pst.clearBatch();
        }
        int anz_rows = rowlist.getLength();
        for (int zeilennr = 0; zeilennr < anz_rows; ++zeilennr) {
            Node rownode = rowlist.item(zeilennr);
            for (int col = 0; col < this.numberOfColumns; ++col) {
                Iterator it = XMLUtils.getChildNodeIterator(rownode);
                while (it.hasNext()) {
                    Node fldNode = (Node)it.next();
                    if (!XMLUtils.getAttribValue(fldNode, "name").equalsIgnoreCase(this.insert_cols[col])) continue;
                    String feld_wert = "";
                    try {
                        feld_wert = XMLUtils.getTheValue(fldNode).trim();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    errmsg = this.feld_wert_to_pst(zeilennr, col, errmsg, feld_wert);
                }
            }
            if (!errmsg.equals("") && this.mode.equals("stop")) break;
            if (this.useBatch) {
                this.pst.addBatch();
            } else {
                this.pst.executeUpdate();
            }
            ++this.numberOfRows;
        }
        if (this.useBatch) {
            this.pst.executeBatch();
        }
        return errmsg;
    }

    private String uploadCSV() throws Exception {
        Object outFile = null;
        String protokoll = "";
        if (this.isPostgres && !this.inserts.equalsIgnoreCase("simple") && !this.inserts.equalsIgnoreCase("batch")) {
            if (this.removeTrailingDelim) {
                this.srcFile = this.removeTrailingDelim(this.srcFile);
            }
            protokoll = this.uploadCSVinPostgres(this.srcFile, this.removeTrailingDelim);
        } else {
            protokoll = this.uploadCSVwithAnsiSQL(this.srcFile);
        }
        return protokoll;
    }

    private String removeTrailingDelim(String srcFile) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        String line;
        String returnSrcFile = srcFile + ".tmp";
        BufferedReader in2 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(srcFile), this.encoding));
        File outFile = new File(srcFile + ".tmp");
        FileOutputStream out = new FileOutputStream(outFile, false);
        PrintStream out2 = new PrintStream((OutputStream)out, true, this.encoding);
        while ((line = in2.readLine()) != null) {
            if (line.endsWith(this.delim)) {
                line = line.substring(0, line.length() - this.delim.length());
            }
            out2.println(line);
            out2.flush();
        }
        return returnSrcFile;
    }

    private String uploadCSVinPostgres(String srcFile, boolean deleteSrcFile) {
        String copySql = "COPY " + this.targetTable + " FROM STDIN WITH DELIMITER '" + this.delim + "' NULL '' ENCODING '" + this.encoding + "'";
        copySql = copySql + (this.header ? " HEADER" : "");
        String msg = "";
        try {
            File outFile;
            CopyManager cpm = ((PGConnection)this.uploadConnection).getCopyAPI();
            long anz = 0L;
            msg = "";
            FileReader in3 = new FileReader(srcFile);
            BufferedReader in4 = new BufferedReader(in3);
            this.numberOfRows = cpm.copyIn(copySql, (Reader)in4);
            if (deleteSrcFile && (outFile = new File(srcFile)) != null) {
                outFile.delete();
            }
        }
        catch (Exception e) {
            msg = e.toString();
        }
        return msg;
    }

    private String uploadCSVwithAnsiSQL(String srcFile) throws SQLException, FileNotFoundException, IOException {
        String text;
        this.numberOfRows = 0L;
        String msg = "";
        int zeilennr = 1;
        boolean fehlerSaetze = false;
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(srcFile), this.encoding));
        this.initializeColumnSchema();
        String insertHead = this.createPreparedStatementHead();
        this.pst = this.uploadConnection.prepareStatement(insertHead);
        if (this.useBatch) {
            this.pst.clearBatch();
        }
        while ((text = in.readLine()) != null) {
            String prepare;
            if (text.endsWith("\\")) {
                text = text.substring(0, text.length() - 1);
                String text2 = in.readLine();
                if (text2 != null) {
                    text = text + "\n" + text2;
                    while (text2.endsWith("\\")) {
                        text = text.substring(0, text.length() - 1);
                        text2 = in.readLine();
                        if (text2 == null) continue;
                        text = text + "\n" + text2;
                    }
                }
            }
            if (!(prepare = this.createPreparedInsertStatement(zeilennr, insertHead, text)).equals("") && this.mode.equals("stop")) {
                msg = prepare;
                break;
            }
            if (this.useBatch) {
                this.pst.addBatch();
            } else {
                this.pst.executeUpdate();
            }
            ++this.numberOfRows;
        }
        if (this.useBatch) {
            this.pst.executeBatch();
        }
        return msg;
    }

    private String createPreparedInsertStatement(int line, String insertHead, String text) throws SQLException {
        int p;
        int i = 0;
        int k = 0;
        String errmsg = "";
        do {
            if (!text.endsWith(this.delim)) {
                text = text + this.delim;
            }
            if ((p = text.indexOf(this.delim, i)) > 0 && text.substring(p - 1, p).equals("\\")) {
                p = text.indexOf(this.delim, p + 1);
            }
            if (p <= -1) continue;
            String feld_wert = p == -1 ? text.substring(i) : text.substring(i, p);
            if (feld_wert != null && feld_wert.indexOf("\\\\n") > 0) {
                feld_wert = StringUtils.replace(feld_wert, "\\\\n", "\\n");
            }
            if (feld_wert != null && feld_wert.indexOf("\\" + this.delim) > 0) {
                feld_wert = StringUtils.replace(feld_wert, "\\", "");
            }
            if (feld_wert != null && feld_wert.indexOf("\\\\") > 0) {
                feld_wert = StringUtils.replace(feld_wert, "\\\\", "\\");
            }
            errmsg = this.feld_wert_to_pst(line, k, errmsg, feld_wert);
            ++k;
            i = p + 1;
        } while (p > -1);
        return errmsg;
    }

    private String feld_wert_to_pst(int line, int col, String errmsg, String feld_wert) throws SQLException {
        if (col >= this.numberOfColumns) {
            errmsg = errmsg + "Anzahl Spalten in Datei ist " + col + ", aber es sollten nur " + (this.numberOfColumns - 1) + " Spalten sein. Bitte pr\u00fcfen Sie das Trennzeichen";
        } else if (feld_wert.equals("")) {
            try {
                this.pst.setNull(col + 1, this.insert_types[col]);
            }
            catch (SQLException e1) {
                errmsg = errmsg + e1.toString();
            }
        } else {
            switch (this.insert_types[col]) {
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    try {
                        int myInt = Integer.parseInt(feld_wert.trim());
                        this.pst.setInt(col + 1, myInt);
                    }
                    catch (NumberFormatException e1) {
                        errmsg = errmsg + e1.toString();
                        this.setFieldToNull(col, this.insert_types, this.pst);
                    }
                    catch (SQLException e1) {
                        errmsg = errmsg + this.conversionException(line, col, feld_wert, e1.toString());
                        this.setFieldToNull(col, this.insert_types, this.pst);
                    }
                    break;
                }
                case 6: {
                    try {
                        float myFloat = Float.parseFloat(feld_wert.trim());
                        this.pst.setFloat(col + 1, myFloat);
                    }
                    catch (NumberFormatException e1) {
                        errmsg = errmsg + this.conversionException(line, col, feld_wert, e1.toString());
                        this.setFieldToNull(col, this.insert_types, this.pst);
                    }
                    catch (SQLException e1) {
                        errmsg = errmsg + this.conversionException(line, col, feld_wert, e1.toString());
                        this.setFieldToNull(col, this.insert_types, this.pst);
                    }
                    break;
                }
                case 2: 
                case 3: 
                case 7: 
                case 8: {
                    try {
                        double myDouble = Double.parseDouble(feld_wert.trim());
                        this.pst.setDouble(col + 1, myDouble);
                    }
                    catch (NumberFormatException e1) {
                        errmsg = errmsg + this.conversionException(line, col, feld_wert, e1.toString());
                        this.setFieldToNull(col, this.insert_types, this.pst);
                    }
                    catch (SQLException e1) {
                        errmsg = errmsg + this.conversionException(line, col, feld_wert, e1.toString());
                        this.setFieldToNull(col, this.insert_types, this.pst);
                    }
                    break;
                }
                default: {
                    if (feld_wert.equals(" ")) {
                        feld_wert = "";
                    }
                    try {
                        this.pst.setString(col + 1, feld_wert);
                    }
                    catch (SQLException e1) {
                        errmsg = errmsg + this.conversionException(line, col, feld_wert, e1.toString());
                        this.setFieldToNull(col, this.insert_types, this.pst);
                    }
                    break;
                }
                case -1: {
                    ByteArrayInputStream by = new ByteArrayInputStream(feld_wert.getBytes());
                    this.pst.setAsciiStream(col + 1, (InputStream)by, feld_wert.length());
                    break;
                }
                case 91: {
                    try {
                        Date datum = DateUtils.parse(feld_wert.trim());
                        feld_wert = DateUtils.formatUS(datum);
                        this.pst.setDate(col + 1, Date.valueOf(feld_wert));
                    }
                    catch (SQLException e1) {
                        errmsg = errmsg + this.conversionException(line, col, feld_wert, e1.toString());
                        this.setFieldToNull(col, this.insert_types, this.pst);
                    }
                    catch (ParseException e1) {
                        errmsg = errmsg + this.conversionException(line, col, feld_wert, e1.toString());
                        this.setFieldToNull(col, this.insert_types, this.pst);
                    }
                    catch (IllegalArgumentException e1) {
                        errmsg = errmsg + this.conversionException(line, col, feld_wert, e1.toString());
                        this.setFieldToNull(col, this.insert_types, this.pst);
                    }
                    break;
                }
                case 92: {
                    try {
                        this.pst.setTime(col + 1, Time.valueOf(feld_wert.trim()));
                    }
                    catch (SQLException e1) {
                        errmsg = errmsg + this.conversionException(line, col, feld_wert, e1.toString());
                        this.setFieldToNull(col, this.insert_types, this.pst);
                    }
                    catch (IllegalArgumentException e1) {
                        errmsg = errmsg + this.conversionException(line, col, feld_wert, e1.toString());
                        this.setFieldToNull(col, this.insert_types, this.pst);
                    }
                    break;
                }
                case 93: {
                    try {
                        java.util.Date datum = DateUtils.dateTimeParse(feld_wert.trim());
                        feld_wert = DateUtils.dateTimeFormatUS(datum);
                        this.pst.setTimestamp(col + 1, Timestamp.valueOf(feld_wert + ".0"));
                    }
                    catch (SQLException e1) {
                        errmsg = errmsg + this.conversionException(line, col, feld_wert, e1.toString());
                        this.setFieldToNull(col, this.insert_types, this.pst);
                    }
                    catch (ParseException e1) {
                        errmsg = errmsg + this.conversionException(line, col, feld_wert, e1.toString());
                        this.setFieldToNull(col, this.insert_types, this.pst);
                    }
                    catch (IllegalArgumentException e1) {
                        errmsg = errmsg + this.conversionException(line, col, feld_wert, e1.toString());
                        this.setFieldToNull(col, this.insert_types, this.pst);
                    }
                    break;
                }
                case -7: {
                    try {
                        boolean wf = Boolean.getBoolean(feld_wert.trim());
                        this.pst.setBoolean(col + 1, wf);
                        break;
                    }
                    catch (SQLException e1) {
                        errmsg = errmsg + this.conversionException(line, col, feld_wert, e1.toString());
                        this.setFieldToNull(col, this.insert_types, this.pst);
                    }
                }
            }
        }
        return errmsg;
    }

    private void setFieldToNull(int k, int[] insert_types, PreparedStatement pst) {
        if (this.mode.equals("exclude-field")) {
            try {
                pst.setNull(k + 1, insert_types[k]);
            }
            catch (SQLException e3) {
                System.err.println("Invalid Field " + (k + 1) + " could not be set to null");
            }
        }
    }

    private String conversionException(int line, int col, String field_value, String error) {
        String err_msg = "";
        err_msg = "Error in  line " + line + " in Column " + (col + 1) + " " + this.insert_cols[col] + " value " + field_value + ": " + error.toString() + "; ";
        return err_msg;
    }

    private void initializeColumnSchema() throws SQLException {
        int i = 0;
        ResultSet rs = null;
        ResultSetMetaData rsmd = null;
        String tabelle = this.targetTable;
        if (!this.dbmd.storesLowerCaseIdentifiers()) {
            tabelle = tabelle.toUpperCase();
        }
        rs = this.dbmd.getColumns(this.uploadConnection.getCatalog(), null, tabelle, null);
        rsmd = rs.getMetaData();
        while (rs.next()) {
            this.insert_cols[i] = rs.getObject("COLUMN_NAME").toString();
            this.insert_types[i] = rs.getInt("DATA_TYPE");
            ++i;
        }
        this.numberOfColumns = i;
        if (!this.dbmd.supportsBatchUpdates()) {
            this.useBatch = false;
        }
    }

    private String createPreparedStatementHead() throws SQLException {
        String sql = null;
        String insert_head = "insert into " + this.targetTable + "(";
        String insert_val = "";
        for (int i = 0; i < this.numberOfColumns; ++i) {
            insert_head = insert_head + this.insert_cols[i] + ", ";
            insert_val = insert_val + "?, ";
        }
        insert_head = insert_head.substring(0, insert_head.length() - 2);
        insert_val = insert_val.substring(0, insert_val.length() - 2);
        insert_head = insert_head + ") values( ";
        sql = insert_head + insert_val + ");";
        return sql;
    }

    public Connection getConnection(Connection myConnection, String propfile) throws Exception {
        if (myConnection == null) {
            SxConnection mySxConnection = null;
            mySxConnection = new SxConnection();
            mySxConnection.setPropfile(propfile);
            myConnection = mySxConnection.getConnection();
            String db_driver = mySxConnection.m_DriverClass;
            if (db_driver.equals("org.postgresql.Driver")) {
                this.isPostgres = true;
            }
        }
        this.dbmd = myConnection.getMetaData();
        return myConnection;
    }

    public static void main(String[] args) {
        try {
            GetOpts.setOpts(args);
            String isdrin = GetOpts.isAllRequiredOptionsPresent("-dbproperties,-table,-unl");
            if (isdrin != null) {
                System.err.println("Folgende Optionen fehlen: " + isdrin);
                System.err.println(usage);
                System.exit(1);
            }
            FileToTableUploader myUploader = new FileToTableUploader();
            if (GetOpts.isPresent("-dbproperties")) {
                myUploader.setDbpropfile(GetOpts.getValue("-dbproperties"));
            }
            if (GetOpts.isPresent("-informat")) {
                myUploader.setInFormat(GetOpts.getValue("-informat"));
            }
            if (GetOpts.isPresent("-table")) {
                myUploader.setTargetTable(GetOpts.getValue("-table"));
            }
            if (GetOpts.isPresent("-unl")) {
                myUploader.setSrcFile(GetOpts.getValue("-unl"));
            } else {
                myUploader.setSrcFile(myUploader.getTargetTable() + ".unl");
            }
            if (GetOpts.isPresent("-header")) {
                myUploader.setHeader(GetOpts.getValue("-header").equalsIgnoreCase("true"));
            }
            if (GetOpts.isPresent("-delim")) {
                myUploader.setDelim(GetOpts.getValue("-delim"));
            }
            if (GetOpts.isPresent("-encoding")) {
                String encodingParam = GetOpts.getValue("-encoding");
                if (encodingParam != null && !encodingParam.equals("")) {
                    myUploader.setEncoding(encodingParam);
                }
            } else {
                myUploader.setEncoding(System.getProperty("file.encoding"));
            }
            if (GetOpts.isPresent("-mode")) {
                myUploader.setMode(GetOpts.getValue("-mode").toLowerCase());
            }
            if (GetOpts.isPresent("-inserts")) {
                myUploader.setInserts(GetOpts.getValue("-inserts"));
            }
            long jetzt = new java.util.Date().getTime();
            myUploader.setUploadConnection(myUploader.getConnection(null, myUploader.getDbpropfile()));
            String protokoll = myUploader.uploadFile();
            long erstrecht = new java.util.Date().getTime();
            System.out.println(myUploader.numberOfRows + " lines loaded");
            System.out.println("File " + myUploader.getSrcFile() + " uploaded");
            if (protokoll.equals("")) {
                protokoll = " in " + (erstrecht - jetzt) / 1000L + " Sec.";
            }
            System.out.println(protokoll);
        }
        catch (Exception ex) {
            System.err.println("Upload fehlgeschlagen: " + ex);
            System.exit(1);
        }
    }
}

