/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.memtext.util.DateUtils;
import de.memtext.util.XMLUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.nio.charset.Charset;
import java.util.logging.Logger;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;

public class AbstractWebserviceClient {
    int pause = 0;
    boolean isDeleteTmpXmlFileWanted = true;

    public AbstractWebserviceClient() {
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                if (this.getRequestorType() == Authenticator.RequestorType.PROXY) {
                    String prot = this.getRequestingProtocol().toLowerCase();
                    String host = System.getProperty(prot + ".proxyHost", "");
                    String port = System.getProperty(prot + ".proxyPort", "");
                    String user = System.getProperty(prot + ".proxyUser", "");
                    String password = System.getProperty(prot + ".proxyPassword", "");
                    if (this.getRequestingHost().toLowerCase().equals(host.toLowerCase()) && Integer.parseInt(port) == this.getRequestingPort()) {
                        return new PasswordAuthentication(user, password.toCharArray());
                    }
                }
                return null;
            }
        });
    }

    protected StringBuffer readSOAP(String soapxml, String url) throws Exception {
        int attempt = 1;
        boolean allDone = false;
        StringWriter sw = null;
        Exception exception = null;
        while (!allDone && attempt < 4) {
            try {
                sw = new StringWriter();
                if (this.pause > 0) {
                    Thread.sleep(this.pause * 1000);
                }
                SOAPConnectionFactory soapConnectionFactory = SOAPConnectionFactory.newInstance();
                SOAPConnection soapConnection = soapConnectionFactory.createConnection();
                SOAPMessage sr = this.getSoapMessageFromString(soapxml);
                sr.getMimeHeaders().addHeader("SOAPAction", "http://sap.com/xi/WebService/soap1.1");
                SOAPMessage soapResponse = soapConnection.call(sr, (Object)url);
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                transformer.transform(new DOMSource((Node)soapResponse.getSOAPPart()), new StreamResult(sw));
                soapConnection.close();
                System.gc();
                allDone = true;
            }
            catch (Exception e) {
                exception = e;
                System.out.println(DateUtils.getNowString() + " Aufruf fehlgeschlagen (s. WebserviceLog) - versuche erneut");
                StringWriter swException = new StringWriter();
                PrintWriter pw = new PrintWriter(swException);
                e.printStackTrace(pw);
                Logger.getLogger("wc").severe(" Problem bei Aufruf von " + url + "\n" + soapxml + "\n" + swException.toString());
                ++attempt;
            }
        }
        if (!allDone) {
            throw exception;
        }
        StringBuffer result = new StringBuffer(sw.toString());
        return result;
    }

    protected File createSoapFile(String soapxml, String url) throws Exception {
        int attempt = 1;
        boolean allDone = false;
        Exception exception = null;
        File tmpF = File.createTempFile("soapdata", ".xml");
        while (!allDone && attempt < 4) {
            try {
                if (tmpF.exists()) {
                    tmpF.delete();
                }
                if (this.pause > 0) {
                    Thread.sleep(this.pause * 1000);
                }
                SOAPConnectionFactory soapConnectionFactory = SOAPConnectionFactory.newInstance();
                SOAPConnection soapConnection = soapConnectionFactory.createConnection();
                SOAPMessage sr = this.getSoapMessageFromString(soapxml);
                sr.getMimeHeaders().addHeader("SOAPAction", "http://sap.com/xi/WebService/soap1.1");
                SOAPMessage soapResponse = soapConnection.call(sr, (Object)url);
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                transformer.transform(new DOMSource((Node)soapResponse.getSOAPPart()), new StreamResult(tmpF));
                soapConnection.close();
                System.gc();
                allDone = true;
            }
            catch (Exception e) {
                exception = e;
                System.out.println("\n" + DateUtils.getNowString() + " Aufruf fehlgeschlagen (s. WebserviceLog) - versuche erneut");
                StringWriter swException = new StringWriter();
                PrintWriter pw = new PrintWriter(swException);
                e.printStackTrace(pw);
                Logger.getLogger("wc").severe(" Problem bei Aufruf von " + url + "\n" + soapxml + "\n" + swException.toString());
                ++attempt;
            }
        }
        if (!allDone) {
            throw exception;
        }
        return tmpF;
    }

    private SOAPMessage getSoapMessageFromString(String xml) throws SOAPException, IOException {
        MessageFactory factory = MessageFactory.newInstance();
        SOAPMessage message = factory.createMessage(new MimeHeaders(), (InputStream)new ByteArrayInputStream(xml.getBytes(Charset.forName("UTF-8"))));
        return message;
    }

    static String purge(String data) {
        data = XMLUtils.removeTroublesomeCharacters(data);
        data = data.replaceAll("\u20ac", "EUR");
        data = data.replaceAll("\u2013", "-");
        data = data.replaceAll("\u2026", "...");
        data = data.replace('^', ' ');
        data = data.replaceAll("<EX_JEST>(?s).*</EX_JEST>", "");
        data = data.replaceAll("<EX_JEST></EX_JEST>", "");
        data = data.replaceAll("<EX_JEST/>", "");
        return data;
    }

    String adaptURL(String url) {
        String result = url;
        if (System.getProperty("WS_HOST") != null) {
            result = url.replaceAll("WS_HOST", System.getProperty("WS_HOST"));
        }
        return result;
    }

    private StringBuffer readFile(File f) throws IOException {
        String line;
        FileReader fr = new FileReader(f);
        BufferedReader bfr = new BufferedReader(fr);
        StringBuffer result = new StringBuffer();
        while ((line = bfr.readLine()) != null) {
            result.append(line + "\n");
        }
        bfr.close();
        fr.close();
        return result;
    }
}

