/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.db;

import de.memtext.db.DBAccess;
import de.memtext.util.StringUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;

public class DBComparison {
    private DBComparison() {
    }

    public static void main(String[] a) {
        try {
            Class.forName("org.hsqldb.jdbcDriver");
            Connection con = DriverManager.getConnection("jdbc:hsqldb:hsql://localhost:9000", "sa", "");
            DBAccess.addConnection("ssc", con);
            Connection con2 = DriverManager.getConnection("jdbc:hsqldb:hsql://localhost:9500", "sa", "");
            DBAccess.addConnection("ssc-test", con2);
            DBComparison.compare("ssc", "ssc-test");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void compare(String db1, String db2) {
        System.out.println("Start comparing...");
        StringBuffer fineTables = new StringBuffer("The following tables are fine: ");
        List tableList = DBAccess.get(db1).getTableList();
        boolean isOk = false;
        for (String table : tableList) {
            if (DBAccess.get(db2).hasTable(table)) {
                isOk = true;
                if (DBAccess.get(db1).getColumnCount(table) != DBAccess.get(db2).getColumnCount(table)) {
                    System.out.println("Table " + table + " has a different number of columns");
                    isOk = false;
                    continue;
                }
                List colList = DBAccess.get(db1).getColumnNames(table);
                for (String colname : colList) {
                    if (!DBAccess.get(db2).hasColumn(table, colname)) {
                        System.out.println("Table " + table + " in " + db2 + " doesn't have column:" + colname);
                        isOk = false;
                        continue;
                    }
                    if (DBAccess.get(db1).getColumnType(table, colname) == DBAccess.get(db2).getColumnType(table, colname)) continue;
                    System.out.println("Table " + table + " column:" + colname + " are of different types");
                    isOk = false;
                }
                if (!isOk) continue;
                fineTables.append(table + ",");
                continue;
            }
            System.out.println(db2 + " doesn't contain table:" + table);
        }
        StringUtils.deleteLastChar(fineTables);
        System.out.println(fineTables);
        System.out.println("..done");
    }
}

