/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.access.method;

import java.lang.reflect.Method;
import java.util.Collection;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.CodeSignature;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.method.MethodSecurityMetadataSource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMethodSecurityMetadataSource
implements MethodSecurityMetadataSource {
    protected final Log logger = LogFactory.getLog(this.getClass());

    @Override
    public final Collection<ConfigAttribute> getAttributes(Object object) {
        if (object instanceof MethodInvocation) {
            MethodInvocation mi = (MethodInvocation)object;
            Object target = mi.getThis();
            Class<?> targetClass = null;
            if (target != null) {
                targetClass = target instanceof Class ? (Class<?>)target : target.getClass();
            }
            return this.getAttributes(mi.getMethod(), targetClass);
        }
        if (object instanceof JoinPoint) {
            JoinPoint jp = (JoinPoint)object;
            Class targetClass = jp.getTarget() != null ? jp.getTarget().getClass() : jp.getSignature().getDeclaringType();
            String targetMethodName = jp.getStaticPart().getSignature().getName();
            Class[] types = ((CodeSignature)jp.getStaticPart().getSignature()).getParameterTypes();
            Class declaringType = ((CodeSignature)jp.getStaticPart().getSignature()).getDeclaringType();
            Method method = ClassUtils.getMethodIfAvailable((Class)declaringType, (String)targetMethodName, (Class[])types);
            Assert.notNull((Object)method, (String)("Could not obtain target method from JoinPoint: '" + jp + "'"));
            return this.getAttributes(method, targetClass);
        }
        throw new IllegalArgumentException("Object must be a non-null MethodInvocation or JoinPoint");
    }

    @Override
    public final boolean supports(Class<?> clazz) {
        return MethodInvocation.class.isAssignableFrom(clazz) || JoinPoint.class.isAssignableFrom(clazz);
    }
}

