/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.trace;

import de.werum.sis.trace.Logger;

public class ConsoleLogger
extends Logger {
    private static ConsoleLogger myLog = null;

    private ConsoleLogger(boolean debug, int errorThreshold) {
        super(debug, errorThreshold);
    }

    private ConsoleLogger(boolean debug, int errorThreshold, String user) {
        super(debug, errorThreshold, user);
    }

    public void print(int errorLevel, String sMsg) {
        if (this.debug && errorLevel <= this.errorThreshold) {
            this.print(sMsg);
        }
    }

    public void print(String sMsg) {
        if (this.debug) {
            this.now();
            StringBuffer sB = new StringBuffer(this.m_iEbene * 2);
            for (int i = 0; i < this.m_iEbene; ++i) {
                sB.append("  ");
            }
            System.out.println(this.m_sbZeit.toString() + sB.toString() + sMsg);
            Object var2_2 = null;
        }
    }

    public void enter(String klasse, String methode) {
        if (this.debug) {
            this.m_listFuncs.add(klasse + ", " + methode);
            this.print("-> " + this.m_iEbene + ": " + this.m_listFuncs.get(this.m_iEbene).toString());
            ++this.m_iEbene;
        }
    }

    public void enter(int errorLevel, String klasse, String methode) {
        if (this.debug && errorLevel <= this.errorThreshold) {
            this.enter(klasse, methode);
        }
    }

    public void leave() {
        if (this.debug) {
            --this.m_iEbene;
            this.print("<- " + this.m_iEbene + ": " + this.m_listFuncs.remove(this.m_iEbene).toString());
        }
    }

    public void leave(int errorLevel) {
        if (this.debug && errorLevel <= this.errorThreshold) {
            this.leave();
        }
    }

    public static ConsoleLogger getInstance() {
        if (myLog == null) {
            int errorThreshold = 0;
            boolean debug = false;
            try {
                errorThreshold = Integer.parseInt(System.getProperty("SIS_TRACE_LEVEL"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (errorThreshold > 0) {
                debug = true;
            }
            myLog = new ConsoleLogger(debug, errorThreshold);
        }
        return myLog;
    }

    public static ConsoleLogger getInstance(boolean debug, int errorThreshold) {
        if (myLog == null) {
            myLog = new ConsoleLogger(debug, errorThreshold);
        }
        return myLog;
    }

    public static ConsoleLogger getInstance(String user) {
        if (myLog == null) {
            int errorThreshold = 0;
            boolean debug = false;
            try {
                errorThreshold = Integer.parseInt(System.getProperty("SIS_TRACE_LEVEL"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (errorThreshold > 0) {
                debug = true;
            }
            myLog = new ConsoleLogger(debug, errorThreshold, user);
        }
        return myLog;
    }
}

