/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.meta.parser;

import de.werum.sis.meta.MetaElementInterface;
import de.werum.sis.meta.parser.ParserContextInterface;
import de.werum.sis.meta.parser.ResolverInterface;
import de.werum.sis.meta.parser.SuperParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class SubParser {
    private SuperParser mySuperParser = null;
    private ResolverInterface myResolver = null;
    private boolean parseAllowed = true;
    private boolean parserEnabled = false;

    public SubParser(SuperParser superParser, ResolverInterface resolver) {
        this.mySuperParser = superParser;
        this.myResolver = resolver;
    }

    public abstract boolean canHandleOpenTag(String var1, String var2);

    public abstract boolean canHandleClosedTag(String var1, String var2);

    public abstract void startElement(String var1, String var2, String var3, Attributes var4) throws SAXException;

    public abstract void endElement(String var1, String var2, String var3) throws SAXException;

    public abstract MetaElementInterface object();

    public ParserContextInterface getParserKontext() {
        ParserContextInterface parserKontext = null;
        if (this.mySuperParser != null) {
            parserKontext = this.mySuperParser.getParserKontext();
        }
        return parserKontext;
    }

    public String getKontextPath() {
        String kontext = "";
        if (this.mySuperParser != null) {
            kontext = this.mySuperParser.getKontextPath();
        }
        return kontext;
    }

    public void notifyObjectStarted(SubParser aParser) {
    }

    public boolean isAllowed() {
        return this.parseAllowed;
    }

    public void allow() {
        this.parseAllowed = true;
    }

    public void disallow() {
        this.parseAllowed = false;
    }

    protected final SuperParser superParser() {
        return this.mySuperParser;
    }

    protected final ResolverInterface resolver() {
        return this.myResolver;
    }

    protected void enable() {
        this.parserEnabled = true;
    }

    protected void disable() {
        this.parserEnabled = false;
    }

    protected void disableAndNotify() {
        this.parserEnabled = false;
        this.superParser().notifyObjectAvailable(this);
    }

    protected boolean isEnabled() {
        return this.parserEnabled;
    }

    protected void notifyObjectStarted() {
        this.superParser().notifyObjectStarted(this);
    }

    protected void notifyObjectAvailable() {
        this.superParser().notifyObjectAvailable(this);
    }
}

