/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.sdf.generator.parser;

import de.statspez.sdf.generator.meta.MetaCustomSDFTemplateAusfuehrung;
import de.statspez.sdf.generator.meta.SDFTags;
import de.statspez.sdf.generator.meta.generated.MetaSDFDokumenterzeuger;
import de.statspez.sdf.generator.meta.generated.MetaSDFTemplateArgument;
import de.statspez.sdf.generator.parser.ArgumentParser;
import de.statspez.sdf.generator.parser.LocalReference;
import de.statspez.sdf.generator.parser.SDFParserContext;
import de.werum.sis.common.AbstractMessage;
import de.werum.sis.meta.MetaElementInterface;
import de.werum.sis.meta.parser.MetaParseException;
import de.werum.sis.meta.parser.ParserChain;
import de.werum.sis.meta.parser.Reference;
import de.werum.sis.meta.parser.ResolverInterface;
import de.werum.sis.meta.parser.SubParser;
import de.werum.sis.meta.parser.SuperParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ExecuteParser
extends SubParser
implements SuperParser {
    private ParserChain parserChain = new ParserChain();
    private ArgumentParser argumentParser;
    private MetaCustomSDFTemplateAusfuehrung ausfuehrung;
    private MetaSDFDokumenterzeuger dokumenterzeuger;

    public ExecuteParser(SuperParser superParser, ResolverInterface resolver) {
        super(superParser, resolver);
        this.argumentParser = new ArgumentParser(this, resolver);
        this.parserChain.addParser((SubParser)this.argumentParser);
        this.ausfuehrung = null;
        this.dokumenterzeuger = null;
    }

    public void setDokumenterzeuger(MetaSDFDokumenterzeuger dokumenterzeuger) {
        this.dokumenterzeuger = dokumenterzeuger;
        this.argumentParser.setDokumenterzeuger(dokumenterzeuger);
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("execute".equalsIgnoreCase(localName)) {
            String executable = atts.getValue("executable");
            if (executable == null) {
                throw new MetaParseException("Executable von execute nicht definiert!");
            }
            executable = SDFTags.dekodiereXMLName(executable);
            this.ausfuehrung.setProgrammName(executable);
            this.argumentParser.setExecutableId(executable);
            this.resolver().registerForResolve((Reference)new LocalReference(this.ausfuehrung, "EXECUTABLE", executable, this.dokumenterzeuger));
        }
    }

    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("execute".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("execute".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
            this.ausfuehrung = new MetaCustomSDFTemplateAusfuehrung();
            this.enable();
        } else if (!this.parserChain.startElement(namespaceURI, localName, qName, atts)) {
            throw MetaParseException.unknownTagException((String)localName);
        }
        this.handleAttributes(namespaceURI, localName, qName, atts);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("execute".equalsIgnoreCase(localName)) {
            this.disableAndNotify();
        } else if (!this.parserChain.endElement(namespaceURI, localName, qName)) {
            throw MetaParseException.unknownClosingTagException((String)localName);
        }
    }

    public MetaElementInterface object() {
        return this.ausfuehrung;
    }

    public StringBuffer charData() {
        return this.superParser().charData();
    }

    public void notifyObjectAvailable(SubParser aParser) {
        this.ausfuehrung.addToArgumente((MetaSDFTemplateArgument)aParser.object());
    }

    public String parentElement() {
        return this.superParser().parentElement();
    }

    public void error(AbstractMessage errorMessage) {
        this.superParser().error(errorMessage);
    }
}

