/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.service.olap;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import mondrian.rolap.RolapConnection;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.olap4j.AllocationPolicy;
import org.olap4j.Axis;
import org.olap4j.CellSet;
import org.olap4j.CellSetAxis;
import org.olap4j.OlapConnection;
import org.olap4j.OlapException;
import org.olap4j.OlapStatement;
import org.olap4j.Position;
import org.olap4j.Scenario;
import org.olap4j.impl.IdentifierParser;
import org.olap4j.mdx.IdentifierNode;
import org.olap4j.mdx.ParseTreeWriter;
import org.olap4j.mdx.SelectNode;
import org.olap4j.mdx.parser.impl.DefaultMdxParserImpl;
import org.olap4j.metadata.Cube;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.Member;
import org.olap4j.query.LimitFunction;
import org.olap4j.query.Query;
import org.olap4j.query.QueryAxis;
import org.olap4j.query.QueryDimension;
import org.olap4j.query.Selection;
import org.olap4j.query.SortOrder;
import org.saiku.olap.dto.SaikuCube;
import org.saiku.olap.dto.SaikuDimensionSelection;
import org.saiku.olap.dto.SaikuMember;
import org.saiku.olap.dto.SaikuQuery;
import org.saiku.olap.dto.SaikuSelection;
import org.saiku.olap.dto.SaikuTag;
import org.saiku.olap.dto.SaikuTuple;
import org.saiku.olap.dto.SaikuTupleDimension;
import org.saiku.olap.dto.resultset.CellDataSet;
import org.saiku.olap.query.IQuery;
import org.saiku.olap.query.MdxQuery;
import org.saiku.olap.query.OlapQuery;
import org.saiku.olap.query.QueryDeserializer;
import org.saiku.olap.util.ObjectUtil;
import org.saiku.olap.util.OlapResultSetUtil;
import org.saiku.olap.util.SaikuUniqueNameComparator;
import org.saiku.olap.util.exception.SaikuOlapException;
import org.saiku.olap.util.formatter.CellSetFormatter;
import org.saiku.olap.util.formatter.FlattenedCellSetFormatter;
import org.saiku.olap.util.formatter.HierarchicalCellSetFormatter;
import org.saiku.olap.util.formatter.ICellSetFormatter;
import org.saiku.service.olap.OlapDiscoverService;
import org.saiku.service.util.KeyValue;
import org.saiku.service.util.exception.SaikuServiceException;
import org.saiku.service.util.export.CsvExporter;
import org.saiku.service.util.export.ExcelExporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OlapQueryService
implements Serializable {
    private static final long serialVersionUID = -7615296596528274904L;
    private static final Logger log = LoggerFactory.getLogger(OlapQueryService.class);
    private OlapDiscoverService olapDiscoverService;
    private Map<String, IQuery> queries = new HashMap<String, IQuery>();
    private static final AtomicLong ID_GENERATOR = new AtomicLong();

    public void setOlapDiscoverService(OlapDiscoverService os) {
        this.olapDiscoverService = os;
    }

    public SaikuQuery createNewOlapQuery(String queryName, SaikuCube cube) {
        try {
            Cube cub = this.olapDiscoverService.getNativeCube(cube);
            OlapConnection con = this.olapDiscoverService.getNativeConnection(cube.getConnectionName());
            if (cub != null) {
                OlapQuery query = new OlapQuery(new Query(queryName, cub), con, cube);
                this.putIQuery(queryName, query);
                return ObjectUtil.convert(query);
            }
        }
        catch (Exception e) {
            log.error("Cannot create new query for cube :" + cube, (Throwable)e);
        }
        return null;
    }

    public SaikuQuery createNewOlapQuery(String name, String xml) {
        try {
            QueryDeserializer qd = new QueryDeserializer();
            SaikuCube scube = qd.getFakeCube(xml);
            OlapConnection con = this.olapDiscoverService.getNativeConnection(scube.getConnectionName());
            IQuery query = qd.unparse(xml, con);
            if (name == null) {
                name = UUID.randomUUID().toString();
                this.putIQuery(name, query);
            } else {
                this.putIQuery(name, query);
            }
            return ObjectUtil.convert(query);
        }
        catch (Exception e) {
            throw new SaikuServiceException("Error creating query from xml", e);
        }
    }

    public void closeQuery(String queryName) {
        try {
            IQuery q = this.getIQuery(queryName);
            q.cancel();
            this.removeIQuery(queryName);
        }
        catch (Exception e) {
            throw new SaikuServiceException("Error closing query: " + queryName, e);
        }
    }

    public List<String> getQueries() {
        ArrayList<String> queryList = new ArrayList<String>();
        queryList.addAll(this.getIQueryMap().keySet());
        return queryList;
    }

    public SaikuQuery getQuery(String queryName) {
        IQuery q = this.getIQuery(queryName);
        return ObjectUtil.convert(q);
    }

    public void deleteQuery(String queryName) {
        this.removeIQuery(queryName);
    }

    public void cancel(String queryName) {
        try {
            IQuery q = this.getIQuery(queryName);
            q.cancel();
        }
        catch (Exception e) {
            throw new SaikuServiceException("Error cancelling query: " + queryName, e);
        }
    }

    public CellDataSet execute(String queryName) {
        return this.execute(queryName, new HierarchicalCellSetFormatter());
    }

    public CellDataSet execute(String queryName, String formatter) {
        String string = formatter = formatter == null ? "" : formatter.toLowerCase();
        if (formatter.equals("flat")) {
            return this.execute(queryName, new CellSetFormatter());
        }
        if (formatter.equals("hierarchical")) {
            return this.execute(queryName, new HierarchicalCellSetFormatter());
        }
        if (formatter.equals("flattened")) {
            return this.execute(queryName, new FlattenedCellSetFormatter());
        }
        return this.execute(queryName, new FlattenedCellSetFormatter());
    }

    public CellDataSet execute(String queryName, ICellSetFormatter formatter) {
        String runId = "runId:" + ID_GENERATOR.getAndIncrement();
        try {
            IQuery query = this.getIQuery(queryName);
            OlapConnection con = this.olapDiscoverService.getNativeConnection(query.getSaikuCube().getConnectionName());
            Long start = new Date().getTime();
            if (query.getScenario() != null) {
                log.info(runId + "\tQuery: " + query.getName() + " Setting scenario:" + query.getScenario().getId());
                con.setScenario(query.getScenario());
            }
            if (query.getTag() != null) {
                query = this.applyTag(query, con, query.getTag());
            }
            String mdx = query.getMdx();
            log.info(runId + "\tType:" + (Object)((Object)query.getType()) + ":\n" + mdx);
            CellSet cellSet = query.execute();
            Long exec = new Date().getTime();
            if (query.getScenario() != null) {
                log.info("Query (" + queryName + ") removing scenario:" + query.getScenario().getId());
                con.setScenario(null);
            }
            CellDataSet result = OlapResultSetUtil.cellSet2Matrix(cellSet, formatter);
            Long format = new Date().getTime();
            log.info(runId + "\tSize: " + result.getWidth() + "/" + result.getHeight() + "\tExecute:\t" + (exec - start) + "ms\tFormat:\t" + (format - exec) + "ms\t Total: " + (format - start) + "ms");
            result.setRuntime(new Double(format - start).intValue());
            this.getIQuery(queryName).storeCellset(cellSet);
            return result;
        }
        catch (Exception e) {
            if (log.isInfoEnabled()) {
                String error = ExceptionUtils.getRootCauseMessage((Throwable)e);
                log.info(runId + "\tException: " + error);
            }
            throw new SaikuServiceException(runId + "\tCan't execute query: " + queryName, e);
        }
        catch (Error e) {
            if (log.isInfoEnabled()) {
                String error = ExceptionUtils.getRootCauseMessage((Throwable)e);
                log.info(runId + "\tError: " + error);
            }
            throw new SaikuServiceException(runId + "\tCan't execute query: " + queryName, e);
        }
    }

    public SaikuQuery simulateTag(String queryName, SaikuTag tag) {
        try {
            IQuery query = this.getIQuery(queryName);
            OlapConnection con = this.olapDiscoverService.getNativeConnection(query.getSaikuCube().getConnectionName());
            return ObjectUtil.convert(this.applyTag(query, con, tag));
        }
        catch (Exception e) {
            throw new SaikuServiceException("Can't apply tag: " + tag + " to query " + queryName, e);
        }
    }

    private IQuery applyTag(IQuery query, OlapConnection con, SaikuTag t) throws Exception {
        String xml = query.toXml();
        QueryDeserializer qd = new QueryDeserializer();
        query = qd.unparse(xml, con);
        ArrayList<SaikuTupleDimension> doneDimension = new ArrayList<SaikuTupleDimension>();
        HashMap<String, QueryDimension> dimensionMap = new HashMap<String, QueryDimension>();
        if (t.getSaikuTupleDimensions() != null) {
            for (SaikuTupleDimension st : t.getSaikuTupleDimensions()) {
                if (doneDimension.contains(st)) continue;
                QueryDimension dim = query.getDimension(st.getName());
                dimensionMap.put(st.getUniqueName(), dim);
                dim.clearExclusions();
                dim.clearInclusions();
                query.moveDimension(dim, null);
                doneDimension.add(st);
            }
            if (t.getSaikuTupleDimensions().size() > 0) {
                SaikuTupleDimension rootDim = t.getSaikuTupleDimensions().get(0);
                QueryDimension dim = query.getDimension(rootDim.getName());
                query.moveDimension(dim, (Axis)Axis.COLUMNS);
                for (SaikuTuple tuple : t.getSaikuTuples()) {
                    SaikuMember m = tuple.getSaikuMember(rootDim.getUniqueName());
                    List<SaikuMember> others = tuple.getOtherSaikuMembers(rootDim.getUniqueName());
                    Selection sel = dim.createSelection(IdentifierParser.parseIdentifier((String)m.getUniqueName()));
                    for (SaikuMember context : others) {
                        QueryDimension otherDim = (QueryDimension)dimensionMap.get(context.getDimensionUniqueName());
                        query.moveDimension(otherDim, (Axis)Axis.COLUMNS);
                        Selection ctxSel = otherDim.createSelection(IdentifierParser.parseIdentifier((String)context.getUniqueName()));
                        sel.addContext(ctxSel);
                    }
                    dim.getInclusions().add(sel);
                }
            }
        }
        if (t.getSaikuDimensionSelections() != null) {
            for (SaikuDimensionSelection dimsel : t.getSaikuDimensionSelections()) {
                if (dimsel.getName().equals("Measures")) continue;
                QueryDimension filterDim = query.getDimension(dimsel.getName());
                query.moveDimension(filterDim, (Axis)Axis.FILTER);
                filterDim.clearInclusions();
                for (SaikuSelection ss : dimsel.getSelections()) {
                    if (ss.getType() != SaikuSelection.Type.MEMBER) continue;
                    Selection sel = filterDim.createSelection(IdentifierParser.parseIdentifier((String)ss.getUniqueName()));
                    if (filterDim.getInclusions().contains(sel)) continue;
                    filterDim.getInclusions().add(sel);
                }
            }
        }
        return query;
    }

    public void setMdx(String queryName, String mdx) {
        IQuery q = this.getIQuery(queryName);
        q.setMdx(mdx);
    }

    public CellDataSet executeMdx(String queryName, String mdx) {
        this.qm2mdx(queryName);
        this.setMdx(queryName, mdx);
        return this.execute(queryName, new HierarchicalCellSetFormatter());
    }

    public CellDataSet executeMdx(String queryName, String mdx, ICellSetFormatter formatter) {
        this.qm2mdx(queryName);
        this.setMdx(queryName, mdx);
        return this.execute(queryName, formatter);
    }

    public List<SaikuMember> getResultMetadataMembers(String queryName, boolean preferResult, String dimensionName, String hierarchyName, String levelName) {
        IQuery query = this.getIQuery(queryName);
        CellSet cs = query.getCellset();
        List<Object> members = new ArrayList();
        HashSet<Level> levels = new HashSet<Level>();
        if (cs != null && preferResult) {
            block0: for (CellSetAxis axis : cs.getAxes()) {
                int posIndex = 0;
                for (Hierarchy h : axis.getAxisMetaData().getHierarchies()) {
                    if (h.getUniqueName().equals(hierarchyName)) {
                        log.debug("Found hierarchy in the result: " + hierarchyName);
                        if (h.getLevels().size() == 1) continue block0;
                        HashSet<Member> mset = new HashSet<Member>();
                        for (Position pos : axis.getPositions()) {
                            Member m = (Member)pos.getMembers().get(posIndex);
                            if (!m.getLevel().getLevelType().equals((Object)Level.Type.ALL)) {
                                levels.add(m.getLevel());
                            }
                            if (!m.getLevel().getUniqueName().equals(levelName)) continue;
                            mset.add(m);
                        }
                        members = ObjectUtil.convertMembers(mset);
                        Collections.sort(members, new SaikuUniqueNameComparator());
                        continue block0;
                    }
                    ++posIndex;
                }
            }
            log.debug("Found members in the result: " + members.size());
        }
        if (cs == null || !preferResult || members.size() == 0 || levels.size() == 1) {
            members = this.olapDiscoverService.getLevelMembers(query.getSaikuCube(), dimensionName, hierarchyName, levelName);
        }
        return members;
    }

    public ResultSet explain(String queryName) {
        OlapStatement stmt = null;
        try {
            ResultSet rs;
            OlapConnection con = this.olapDiscoverService.getNativeConnection(this.getQuery(queryName).getCube().getConnectionName());
            if (!con.isWrapperFor(RolapConnection.class)) {
                throw new IllegalArgumentException("Cannot only get explain plan for Mondrian connections");
            }
            stmt = con.createStatement();
            String mdx = this.getMDXQuery(queryName);
            mdx = "EXPLAIN PLAN FOR \n" + mdx;
            ResultSet resultSet = rs = stmt.executeQuery(mdx);
            return resultSet;
        }
        catch (Exception e) {
            throw new SaikuServiceException("Error EXPLAIN: " + queryName, e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public ResultSet drillthrough(String queryName, int maxrows, String returns) {
        OlapStatement stmt = null;
        try {
            ResultSet rs;
            OlapConnection con = this.olapDiscoverService.getNativeConnection(this.getQuery(queryName).getCube().getConnectionName());
            stmt = con.createStatement();
            String mdx = this.getMDXQuery(queryName);
            mdx = maxrows > 0 ? "DRILLTHROUGH MAXROWS " + maxrows + " " + mdx : "DRILLTHROUGH " + mdx;
            if (StringUtils.isNotBlank((String)returns)) {
                mdx = mdx + "\r\n RETURN " + returns;
            }
            ResultSet resultSet = rs = stmt.executeQuery(mdx);
            return resultSet;
        }
        catch (SQLException e) {
            throw new SaikuServiceException("Error DRILLTHROUGH: " + queryName, e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public ResultSet drillthrough(String queryName, List<Integer> cellPosition, Integer maxrows, String returns) {
        OlapStatement stmt = null;
        try {
            ResultSet rs;
            IQuery query = this.getIQuery(queryName);
            CellSet cs = query.getCellset();
            SaikuCube cube = this.getQuery(queryName).getCube();
            OlapConnection con = this.olapDiscoverService.getNativeConnection(cube.getConnectionName());
            stmt = con.createStatement();
            String select = null;
            StringBuffer buf = new StringBuffer();
            buf.append("SELECT (");
            for (int i = 0; i < cellPosition.size(); ++i) {
                List members = ((Position)((CellSetAxis)cs.getAxes().get(i)).getPositions().get(cellPosition.get(i))).getMembers();
                for (int k = 0; k < members.size(); ++k) {
                    Member m = (Member)members.get(k);
                    if (k > 0 || i > 0) {
                        buf.append(", ");
                    }
                    buf.append(m.getUniqueName());
                }
            }
            buf.append(") ON COLUMNS \r\n");
            buf.append("FROM " + cube.getCubeName() + "\r\n");
            SelectNode sn = new DefaultMdxParserImpl().parseSelect(this.getMDXQuery(queryName));
            StringWriter writer = new StringWriter();
            sn.getFilterAxis().unparse(new ParseTreeWriter(new PrintWriter(writer)));
            if (StringUtils.isNotBlank((String)((Object)writer).toString())) {
                buf.append("WHERE " + ((Object)writer).toString());
            }
            select = buf.toString();
            select = maxrows > 0 ? "DRILLTHROUGH MAXROWS " + maxrows + " " + select + "\r\n" : "DRILLTHROUGH " + select + "\r\n";
            if (StringUtils.isNotBlank((String)returns)) {
                select = select + "\r\n RETURN " + returns;
            }
            log.debug("Drill Through for query (" + queryName + ") : \r\n" + select);
            ResultSet resultSet = rs = stmt.executeQuery(select);
            return resultSet;
        }
        catch (Exception e) {
            throw new SaikuServiceException("Error DRILLTHROUGH: " + queryName, e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public byte[] exportDrillthroughCsv(String queryName, int maxrows) {
        OlapStatement stmt = null;
        try {
            OlapConnection con = this.olapDiscoverService.getNativeConnection(this.getQuery(queryName).getCube().getConnectionName());
            stmt = con.createStatement();
            String mdx = this.getMDXQuery(queryName);
            mdx = maxrows > 0 ? "DRILLTHROUGH MAXROWS " + maxrows + " " + mdx : "DRILLTHROUGH " + mdx;
            ResultSet rs = stmt.executeQuery(mdx);
            byte[] byArray = CsvExporter.exportCsv(rs);
            return byArray;
        }
        catch (SQLException e) {
            throw new SaikuServiceException("Error DRILLTHROUGH: " + queryName, e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public byte[] exportResultSetCsv(ResultSet rs) {
        return CsvExporter.exportCsv(rs);
    }

    public byte[] exportResultSetCsv(ResultSet rs, String delimiter, String enclosing, boolean printHeader, List<KeyValue<String, String>> additionalColumns) {
        return CsvExporter.exportCsv(rs, delimiter, enclosing, printHeader, additionalColumns);
    }

    public void setCellValue(String queryName, List<Integer> position, String value, String allocationPolicy) {
        try {
            IQuery query = this.getIQuery(queryName);
            OlapConnection con = this.olapDiscoverService.getNativeConnection(query.getSaikuCube().getConnectionName());
            if (query.getScenario() == null) {
                Scenario s = con.createScenario();
                query.setScenario(s);
                con.setScenario(s);
                System.out.println("Created scenario:" + s + " : cell:" + position + " value" + value);
            } else {
                Scenario s = query.getScenario();
                con.setScenario(s);
                System.out.println("Using scenario:" + s + " : cell:" + position + " value" + value);
            }
            CellSet cs1 = query.execute();
            query.storeCellset(cs1);
            Number v = null;
            try {
                v = Integer.parseInt(value);
            }
            catch (Exception e) {
                v = Double.parseDouble(value);
            }
            if (v == null) {
                throw new SaikuServiceException("Error setting value of query " + queryName + " to:" + v);
            }
            allocationPolicy = AllocationPolicy.EQUAL_ALLOCATION.toString();
            AllocationPolicy ap = AllocationPolicy.valueOf((String)allocationPolicy);
            CellSet cs = query.getCellset();
            cs.getCell(position).setValue((Object)v, ap, new Object[0]);
            con.setScenario(null);
        }
        catch (Exception e) {
            throw new SaikuServiceException("Error setting value: " + queryName, e);
        }
    }

    public IQuery swapAxes(String queryName) {
        IQuery query = this.getIQuery(queryName);
        if (IQuery.QueryType.QM.equals((Object)query.getType())) {
            query.swapAxes();
        }
        return query;
    }

    public boolean includeChildren(String queryName, String dimensionName, String uniqueMemberName) {
        IQuery query = this.getIQuery(queryName);
        List memberList = IdentifierNode.parseIdentifier((String)uniqueMemberName).getSegmentList();
        QueryDimension dimension = query.getDimension(dimensionName);
        try {
            Selection sel = dimension.createSelection(Selection.Operator.CHILDREN, memberList);
            dimension.getInclusions().add(sel);
            return true;
        }
        catch (OlapException e) {
            throw new SaikuServiceException("Cannot include children query (" + queryName + ") dimension (" + dimensionName + ") member (" + uniqueMemberName + ")", e);
        }
    }

    public boolean removeChildren(String queryName, String dimensionName, String uniqueMemberName) {
        IQuery query = this.getIQuery(queryName);
        List memberList = IdentifierNode.parseIdentifier((String)uniqueMemberName).getSegmentList();
        QueryDimension dimension = query.getDimension(dimensionName);
        try {
            Selection sel = dimension.createSelection(Selection.Operator.CHILDREN, memberList);
            if (dimension.getInclusions().contains(sel)) {
                dimension.getInclusions().remove(sel);
            }
            return true;
        }
        catch (OlapException e) {
            throw new SaikuServiceException("Cannot remove children query (" + queryName + ") dimension (" + dimensionName + ") member (" + uniqueMemberName + ")", e);
        }
    }

    public boolean removeAllChildren(String queryName, String dimensionName) {
        IQuery query = this.getIQuery(queryName);
        QueryDimension dimension = query.getDimension(dimensionName);
        ArrayList<Selection> children = new ArrayList<Selection>();
        try {
            for (Selection sel : dimension.getInclusions()) {
                if (!sel.getOperator().equals((Object)Selection.Operator.CHILDREN)) continue;
                children.add(sel);
            }
            dimension.getInclusions().removeAll(children);
            return true;
        }
        catch (Exception e) {
            throw new SaikuServiceException("Cannot remove all children  for query (" + queryName + ") dimension (" + dimensionName + ")", e);
        }
    }

    public boolean includeMember(String queryName, String dimensionName, String uniqueMemberName, String selectionType, int memberposition) {
        IQuery query = this.getIQuery(queryName);
        List memberList = IdentifierNode.parseIdentifier((String)uniqueMemberName).getSegmentList();
        QueryDimension dimension = query.getDimension(dimensionName);
        Selection.Operator selectionMode = Selection.Operator.valueOf((String)selectionType);
        try {
            this.removeAllChildren(queryName, dimensionName);
            Selection sel = dimension.createSelection(selectionMode, memberList);
            if (dimension.getInclusions().contains(sel)) {
                dimension.getInclusions().remove(sel);
            }
            if (memberposition < 0) {
                memberposition = dimension.getInclusions().size();
            }
            dimension.getInclusions().add(memberposition, sel);
            return true;
        }
        catch (OlapException e) {
            throw new SaikuServiceException("Cannot include member query (" + queryName + ") dimension (" + dimensionName + ") member (" + uniqueMemberName + ") operator (" + selectionType + ") position " + memberposition, e);
        }
    }

    public boolean removeMember(String queryName, String dimensionName, String uniqueMemberName, String selectionType) throws SaikuServiceException {
        IQuery query = this.getIQuery(queryName);
        this.removeAllChildren(queryName, dimensionName);
        List memberList = IdentifierNode.parseIdentifier((String)uniqueMemberName).getSegmentList();
        QueryDimension dimension = query.getDimension(dimensionName);
        Selection.Operator selectionMode = Selection.Operator.valueOf((String)selectionType);
        try {
            if (log.isDebugEnabled()) {
                log.debug("query: " + queryName + " remove:" + selectionMode.toString() + " " + memberList.size());
            }
            Selection selection = dimension.createSelection(selectionMode, memberList);
            dimension.getInclusions().remove(selection);
            return true;
        }
        catch (OlapException e) {
            throw new SaikuServiceException("Error removing member (" + uniqueMemberName + ") of dimension (" + dimensionName + ")", e);
        }
    }

    public boolean includeLevel(String queryName, String dimensionName, String uniqueHierarchyName, String uniqueLevelName) {
        IQuery query = this.getIQuery(queryName);
        this.removeAllChildren(queryName, dimensionName);
        QueryDimension dimension = query.getDimension(dimensionName);
        for (Hierarchy hierarchy : dimension.getDimension().getHierarchies()) {
            if (!hierarchy.getUniqueName().equals(uniqueHierarchyName)) continue;
            for (Level level : hierarchy.getLevels()) {
                if (!level.getUniqueName().equals(uniqueLevelName)) continue;
                Selection sel = dimension.createSelection(level);
                if (!dimension.getInclusions().contains(sel)) {
                    dimension.include(level);
                }
                return true;
            }
        }
        return false;
    }

    public boolean removeLevel(String queryName, String dimensionName, String uniqueHierarchyName, String uniqueLevelName) {
        IQuery query = this.getIQuery(queryName);
        this.removeAllChildren(queryName, dimensionName);
        QueryDimension dimension = query.getDimension(dimensionName);
        try {
            for (Hierarchy hierarchy : dimension.getDimension().getHierarchies()) {
                if (!hierarchy.getUniqueName().equals(uniqueHierarchyName)) continue;
                for (Level level : hierarchy.getLevels()) {
                    if (!level.getUniqueName().equals(uniqueLevelName)) continue;
                    Selection inclusion = dimension.createSelection(level);
                    dimension.getInclusions().remove(inclusion);
                    ArrayList<Selection> removals = new ArrayList<Selection>();
                    for (Selection sel : dimension.getInclusions()) {
                        if (!(sel.getRootElement() instanceof Member) || !((Member)sel.getRootElement()).getLevel().equals(level) || !dimension.getInclusions().contains(sel)) continue;
                        removals.add(sel);
                    }
                    dimension.getInclusions().removeAll(removals);
                }
            }
        }
        catch (Exception e) {
            throw new SaikuServiceException("Cannot remove level" + uniqueLevelName + "from dimension " + dimensionName, e);
        }
        return true;
    }

    public void moveDimension(String queryName, String axisName, String dimensionName, int position) {
        try {
            Axis.Standard newAxis;
            if (log.isDebugEnabled()) {
                log.debug("move query: " + queryName + " dimension " + dimensionName + " to axis " + axisName + "  position" + position);
            }
            IQuery query = this.getIQuery(queryName);
            QueryDimension dimension = query.getDimension(dimensionName);
            Axis.Standard standard = axisName != null ? ("UNUSED".equals(axisName) ? null : Axis.Standard.valueOf((String)axisName)) : (newAxis = null);
            if (position == -1) {
                query.moveDimension(dimension, (Axis)newAxis);
            } else {
                query.moveDimension(dimension, (Axis)newAxis, position);
            }
        }
        catch (Exception e) {
            throw new SaikuServiceException("Cannot move dimension:" + dimensionName + " to axis: " + axisName, e);
        }
    }

    public void removeDimension(String queryName, String axisName, String dimensionName) {
        IQuery query = this.getIQuery(queryName);
        this.moveDimension(queryName, "UNUSED", dimensionName, -1);
        query.getDimension(dimensionName).getExclusions().clear();
        query.getDimension(dimensionName).getInclusions().clear();
    }

    public List<SaikuDimensionSelection> getAxisSelection(String queryName, String axis) {
        IQuery query = this.getIQuery(queryName);
        ArrayList<SaikuDimensionSelection> dimsel = new ArrayList<SaikuDimensionSelection>();
        try {
            QueryAxis qaxis = query.getAxis(axis);
            if (qaxis != null) {
                for (QueryDimension dim : qaxis.getDimensions()) {
                    dimsel.add(ObjectUtil.convertDimensionSelection(dim));
                }
            }
        }
        catch (SaikuOlapException e) {
            throw new SaikuServiceException("Cannot get dimension selections", e);
        }
        return dimsel;
    }

    public SaikuDimensionSelection getAxisDimensionSelections(String queryName, String axis, String dimension) {
        IQuery query = this.getIQuery(queryName);
        try {
            QueryAxis qaxis = query.getAxis(axis);
            if (qaxis != null) {
                QueryDimension dim = query.getDimension(dimension);
                if (dim != null) {
                    return ObjectUtil.convertDimensionSelection(dim);
                }
                throw new SaikuOlapException("Cannot find dimension with name:" + dimension);
            }
            throw new SaikuOlapException("Cannot find axis with name:" + axis);
        }
        catch (SaikuOlapException e) {
            throw new SaikuServiceException("Cannot get dimension selections", e);
        }
    }

    public void clearQuery(String queryName) {
        IQuery query = this.getIQuery(queryName);
        query.clearAllQuerySelections();
    }

    public IQuery clearAxis(String queryName, String axisName) {
        try {
            IQuery query = this.getIQuery(queryName);
            query.clearAxis(axisName);
            return query;
        }
        catch (SaikuOlapException e) {
            throw new SaikuServiceException("Cannot clear for query: " + queryName + " axis: " + axisName, e);
        }
    }

    public void clearAxisSelections(String queryName, String axisName) {
        IQuery query = this.getIQuery(queryName);
        if (Axis.Standard.valueOf((String)axisName) != null) {
            QueryAxis qAxis = query.getAxis((Axis)Axis.Standard.valueOf((String)axisName));
            query.resetAxisSelections(qAxis);
        }
    }

    public void sortAxis(String queryName, String axisName, String sortLiteral, String sortOrder) {
        IQuery query = this.getIQuery(queryName);
        if (Axis.Standard.valueOf((String)axisName) != null) {
            QueryAxis qAxis = query.getAxis((Axis)Axis.Standard.valueOf((String)axisName));
            SortOrder so = SortOrder.valueOf((String)sortOrder);
            qAxis.sort(so, sortLiteral);
        }
    }

    public void clearSort(String queryName, String axisName) {
        IQuery query = this.getIQuery(queryName);
        if (Axis.Standard.valueOf((String)axisName) != null) {
            QueryAxis qAxis = query.getAxis((Axis)Axis.Standard.valueOf((String)axisName));
            qAxis.clearSort();
        }
    }

    public void limitAxis(String queryName, String axisName, String limitFunction, String n, String sortLiteral) {
        IQuery query = this.getIQuery(queryName);
        if (Axis.Standard.valueOf((String)axisName) != null) {
            QueryAxis qAxis = query.getAxis((Axis)Axis.Standard.valueOf((String)axisName));
            LimitFunction lf = LimitFunction.valueOf((String)limitFunction);
            BigDecimal bn = new BigDecimal(n);
            qAxis.limit(lf, bn, sortLiteral);
        }
    }

    public void clearLimit(String queryName, String axisName) {
        IQuery query = this.getIQuery(queryName);
        if (Axis.Standard.valueOf((String)axisName) != null) {
            QueryAxis qAxis = query.getAxis((Axis)Axis.Standard.valueOf((String)axisName));
            qAxis.clearLimitFunction();
        }
    }

    public void filterAxis(String queryName, String axisName, String filterCondition) {
        IQuery query = this.getIQuery(queryName);
        if (Axis.Standard.valueOf((String)axisName) != null) {
            QueryAxis qAxis = query.getAxis((Axis)Axis.Standard.valueOf((String)axisName));
            qAxis.filter(filterCondition);
        }
    }

    public void clearFilter(String queryName, String axisName) {
        IQuery query = this.getIQuery(queryName);
        if (Axis.Standard.valueOf((String)axisName) != null) {
            QueryAxis qAxis = query.getAxis((Axis)Axis.Standard.valueOf((String)axisName));
            qAxis.clearFilter();
        }
    }

    public void resetQuery(String queryName) {
        IQuery query = this.getIQuery(queryName);
        query.resetQuery();
    }

    public void setNonEmpty(String queryName, String axisName, boolean bool) {
        IQuery query = this.getIQuery(queryName);
        QueryAxis newAxis = query.getAxis((Axis)Axis.Standard.valueOf((String)axisName));
        newAxis.setNonEmpty(bool);
    }

    public Properties setProperties(String queryName, Properties props) {
        IQuery query = this.getIQuery(queryName);
        query.setProperties(props);
        return this.getProperties(queryName);
    }

    public Properties getProperties(String queryName) {
        IQuery query = this.getIQuery(queryName);
        Properties props = query.getProperties();
        return props;
    }

    public String getMDXQuery(String queryName) {
        return this.getIQuery(queryName).getMdx();
    }

    public String getQueryXml(String queryName) {
        IQuery query = this.getIQuery(queryName);
        return query.toXml();
    }

    public byte[] getExport(String queryName, String type) {
        return this.getExport(queryName, type, new FlattenedCellSetFormatter());
    }

    public byte[] getExport(String queryName, String type, String formatter) {
        String string = formatter = formatter == null ? "" : formatter.toLowerCase();
        if (formatter.equals("flat")) {
            return this.getExport(queryName, type, new CellSetFormatter());
        }
        if (formatter.equals("flattened")) {
            return this.getExport(queryName, type, new FlattenedCellSetFormatter());
        }
        if (formatter.equals("hierarchical")) {
            return this.getExport(queryName, type, new HierarchicalCellSetFormatter());
        }
        return this.getExport(queryName, type, new FlattenedCellSetFormatter());
    }

    public byte[] getExport(String queryName, String type, ICellSetFormatter formatter) {
        if (type != null) {
            IQuery query = this.getIQuery(queryName);
            CellSet rs = query.getCellset();
            ArrayList<SaikuDimensionSelection> filters = new ArrayList();
            if (query.getType().equals((Object)IQuery.QueryType.QM)) {
                filters = this.getAxisSelection(queryName, "FILTER");
            }
            if (type.toLowerCase().equals("xls")) {
                return ExcelExporter.exportExcel(rs, formatter, filters);
            }
            if (type.toLowerCase().equals("csv")) {
                return CsvExporter.exportCsv(rs, ",", "\"", formatter);
            }
        }
        return new byte[0];
    }

    public void qm2mdx(String queryName) {
        IQuery query = this.getIQuery(queryName);
        OlapConnection con = this.olapDiscoverService.getNativeConnection(query.getSaikuCube().getConnectionName());
        MdxQuery mdx = new MdxQuery(con, query.getSaikuCube(), query.getName(), this.getMDXQuery(queryName));
        this.putIQuery(queryName, mdx);
        query = null;
    }

    public SaikuTag createTag(String queryName, String tagName, List<List<Integer>> cellPositions) {
        try {
            IQuery query = this.getIQuery(queryName);
            SaikuCube cube = this.getQuery(queryName).getCube();
            CellSet cs = query.getCellset();
            ArrayList<SaikuTuple> tuples = new ArrayList<SaikuTuple>();
            ArrayList<SaikuTupleDimension> dimensions = new ArrayList<SaikuTupleDimension>();
            for (List<Integer> cellPosition : cellPositions) {
                ArrayList<Member> members = new ArrayList<Member>();
                for (int i = 0; i < cellPosition.size(); ++i) {
                    members.addAll(((Position)((CellSetAxis)cs.getAxes().get(i)).getPositions().get(cellPosition.get(i))).getMembers());
                }
                List<SaikuMember> sm = ObjectUtil.convertMembers(members);
                SaikuTuple tuple = new SaikuTuple(sm);
                tuples.add(tuple);
                if (dimensions.size() != 0) continue;
                for (Member m : members) {
                    SaikuTupleDimension sd = new SaikuTupleDimension(m.getDimension().getName(), m.getDimension().getUniqueName(), m.getDimension().getCaption());
                    if (dimensions.contains(sd)) continue;
                    dimensions.add(sd);
                }
            }
            List<SaikuDimensionSelection> filterSelections = this.getAxisSelection(queryName, "FILTER");
            SaikuTag t = new SaikuTag(tagName, dimensions, tuples, filterSelections);
            return t;
        }
        catch (Exception e) {
            throw new SaikuServiceException("Error addTag:" + tagName + " for query: " + queryName, e);
        }
    }

    public void setTag(String queryName, SaikuTag tag) {
        IQuery query = this.getIQuery(queryName);
        query.setTag(tag);
    }

    public void disableTag(String queryName) {
        IQuery query = this.getIQuery(queryName);
        query.removeTag();
    }

    private void putIQuery(String queryName, IQuery query) {
        this.queries.put(queryName, query);
    }

    private void removeIQuery(String queryName) {
        if (this.queries.containsKey(queryName)) {
            IQuery q = this.queries.remove(queryName);
            try {
                q.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Object var2_2 = null;
        }
    }

    private IQuery getIQuery(String queryName) {
        if (this.queries.containsKey(queryName)) {
            return this.queries.get(queryName);
        }
        throw new SaikuServiceException("No query found using name: " + queryName);
    }

    private Map<String, IQuery> getIQueryMap() {
        return this.queries;
    }
}

