/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime.test;

import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.interpreter.InterpreterContext;
import de.statspez.pleditor.generator.interpreter.PlausiClassificationFactory;
import de.statspez.pleditor.generator.interpreter.ProgramDescriptor;
import de.statspez.pleditor.generator.interpreter.ProgramInterpreter;
import de.statspez.pleditor.generator.interpreter.SimpleDataset;
import de.statspez.pleditor.generator.interpreter.TBFieldDescriptorFactory;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.generated.MetaStatspezObjekt;
import de.statspez.pleditor.generator.parser.Helper;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorImpl;
import de.statspez.pleditor.generator.runtime.InvalidValue;
import de.statspez.pleditor.generator.runtime.ValueFactory;
import de.statspez.pleditor.generator.runtime.plausi.PlausiFehler;
import de.statspez.pleditor.generator.runtime.plausi.PlausiInterface;
import de.statspez.pleditor.generator.runtime.plausi.PlausiKontext;
import de.statspez.pleditor.generator.runtime.test.PlausiTestCase;
import de.statspez.pleditor.generator.runtime.test.PlausiTestCaseResult;
import de.statspez.pleditor.generator.runtime.test.PlausiTestResult;
import de.statspez.pleditor.generator.runtime.test.TestFailure;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

public class FieldTestCase
extends PlausiTestCase {
    private String field = null;
    private String value = null;

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public void execute(PlausiInterface plausi, PlausiTestResult result) {
        PlausiTestCaseResult testCaseResult = new PlausiTestCaseResult(this);
        try {
            try {
                int i;
                String field;
                PlausiKontext context = new PlausiKontext();
                HashMap<String, String> values = new HashMap<String, String>();
                String fieldValue = this.getValue();
                if (fieldValue != null && fieldValue.length() > 0) {
                    values.put(this.getField(), fieldValue);
                }
                if ((field = this.getField()).indexOf("[") > 0) {
                    StringBuffer correctedField = new StringBuffer();
                    String[] fieldHierarchy = field.split("\\.");
                    i = 0;
                    while (i < fieldHierarchy.length) {
                        int indexOfBrace;
                        if (correctedField.length() > 0) {
                            correctedField.append('.');
                        }
                        if ((indexOfBrace = fieldHierarchy[i].indexOf(91)) > 0) {
                            correctedField.append(fieldHierarchy[i].substring(0, indexOfBrace));
                            String[] indicesString = fieldHierarchy[i].substring(fieldHierarchy[i].indexOf(91) + 1, fieldHierarchy[i].length() - 1).split("\\]\\[");
                            int j = 0;
                            while (j < indicesString.length) {
                                correctedField.append('[').append(Integer.parseInt(indicesString[j]) + 1).append(']');
                                ++j;
                            }
                        } else {
                            correctedField.append(fieldHierarchy[i]);
                        }
                        ++i;
                    }
                    field = correctedField.toString();
                }
                SimpleDataset dataset = new SimpleDataset(values);
                dataset.setIndicesPrefix("[");
                dataset.setIndicesSuffix("]");
                plausi.feldPlausi(field, dataset, context);
                PlausiFehler[] errors = new PlausiFehler[context.getAnzahlFehler()];
                i = 0;
                while (i < context.getAnzahlFehler()) {
                    errors[i] = context.getFehler(i);
                    ++i;
                }
                testCaseResult.handlePlausiResult(errors, "Java");
            }
            catch (Exception ex) {
                testCaseResult.addFailure(new TestFailure(this.getName(), "Java", 5, ex));
                result.addTestCaseResult(testCaseResult);
            }
        }
        finally {
            result.addTestCaseResult(testCaseResult);
        }
    }

    @Override
    public void interprete(MetaCustomPlausibilisierung plausi, PlausiTestResult result) {
        PlausiTestCaseResult testCaseResult = new PlausiTestCaseResult(this);
        try {
            try {
                MetaStatspezObjekt metaObject = this.getMetaObject(plausi);
                MetaProgram metaProgram = Helper.metaStructureFor(this.getElementMessage(metaObject), this.getProgramCode(metaObject));
                InterpreterContext context = new InterpreterContext();
                context.setClassificationFactory(new PlausiClassificationFactory(plausi));
                FeldDeskriptorImpl refField = null;
                context.declareVariable("feld");
                String fieldValue = this.getValue();
                if (fieldValue != null && fieldValue.length() > 0) {
                    context.setVariableValue("feld", ValueFactory.instance().valueFor(fieldValue));
                } else {
                    context.setVariableValue("feld", InvalidValue.instance());
                }
                String field = new String(this.getField());
                if (field.indexOf("[") > 0) {
                    StringBuffer correctedField = new StringBuffer();
                    String[] fieldHierarchy = field.split("\\.");
                    int i = 0;
                    while (i < fieldHierarchy.length) {
                        int indexOfBrace;
                        if (correctedField.length() > 0) {
                            correctedField.append('.');
                        }
                        if ((indexOfBrace = fieldHierarchy[i].indexOf(91)) > 0) {
                            correctedField.append(fieldHierarchy[i].substring(0, indexOfBrace));
                            String[] indicesString = fieldHierarchy[i].substring(fieldHierarchy[i].indexOf(91) + 1, fieldHierarchy[i].length() - 1).split("\\]\\[");
                            int j = 0;
                            while (j < indicesString.length) {
                                correctedField.append('#').append(indicesString[j]);
                                ++j;
                            }
                        } else {
                            correctedField.append(fieldHierarchy[i]);
                        }
                        ++i;
                    }
                    field = correctedField.toString();
                }
                TBFieldDescriptorFactory fieldDescriptorFactory = new TBFieldDescriptorFactory(plausi);
                refField = fieldDescriptorFactory.getFieldDescriptor(field);
                ProgramDescriptor programDescriptor = new ProgramDescriptor(metaProgram, null, metaObject);
                programDescriptor.setRefField(refField);
                ProgramInterpreter programInterpreter = new ProgramInterpreter();
                programInterpreter.execute(programDescriptor, null, context);
                testCaseResult.handlePlausiResult(context.getPlausiErrors(), "Interpreter");
            }
            catch (Exception ex) {
                testCaseResult.addFailure(new TestFailure(this.getName(), "Interpreter", 5, ex));
                result.addTestCaseResult(testCaseResult);
            }
        }
        finally {
            result.addTestCaseResult(testCaseResult);
        }
    }

    @Override
    public void performJavaScript(MetaCustomPlausibilisierung plausi, File javaScriptPlausiFile, PlausiTestResult result) {
        PlausiTestCaseResult testCaseResult = new PlausiTestCaseResult(this);
        try {
            try {
                ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
                ScriptEngine scriptEngine = scriptEngineManager.getEngineByName("JavaScript");
                InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("/de/statspez/pleditor/generator/codegen/js/runtime/plausilib.js"));
                try {
                    scriptEngine.eval(reader);
                }
                finally {
                    ((Reader)reader).close();
                }
                reader = new FileReader(javaScriptPlausiFile);
                try {
                    scriptEngine.eval(reader);
                }
                finally {
                    ((Reader)reader).close();
                }
                scriptEngine.eval("function getValue(field) {return '" + this.getValue() + "';}");
                MetaStatspezObjekt metaObject = this.getMetaObject(plausi);
                String statement = "prg_Merkmal_" + StringHelper.getEscapedName(metaObject.getName()) + "('" + this.getField() + "')";
                testCaseResult.handlePlausiResult(this.performJavaScriptPlausi(scriptEngine, statement), "JavaScript");
            }
            catch (Exception ex) {
                testCaseResult.addFailure(new TestFailure(this.getName(), "JavaScript", 5, ex));
                result.addTestCaseResult(testCaseResult);
            }
        }
        finally {
            result.addTestCaseResult(testCaseResult);
        }
    }
}

