/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.parser;

import de.statspez.pleditor.generator.common.AbstractMessage;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.generated.MetaDsbComps;
import de.statspez.pleditor.generator.meta.generated.MetaDsbFeld;
import de.statspez.pleditor.generator.meta.generated.MetaDsbObjekt;
import de.statspez.pleditor.generator.meta.generated.MetaEinzelfeld;
import de.statspez.pleditor.generator.parser.Dsb_Comment_Parser;
import de.statspez.pleditor.generator.parser.Dsb_FieldTypeParser;
import de.statspez.pleditor.generator.parser.Dsb_GroupTypeParser;
import de.statspez.pleditor.generator.parser.ILParseException;
import de.statspez.pleditor.generator.parser.ParserChain;
import de.statspez.pleditor.generator.parser.Resolver;
import de.statspez.pleditor.generator.parser.SubParser;
import de.statspez.pleditor.generator.parser.SuperParser;
import java.util.Iterator;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class Dsb_RecordHeaderTypeParser
extends SubParser
implements SuperParser {
    private MetaDsbObjekt currentDsb = null;
    private Vector selectors = null;
    private ParserChain parserChain = new ParserChain();
    private Dsb_FieldTypeParser feldParser;
    private Dsb_GroupTypeParser groupParser;
    private Dsb_Comment_Parser comParser = null;

    public Dsb_RecordHeaderTypeParser(SuperParser sParser, Resolver resolver) {
        super(sParser, resolver);
        this.feldParser = new Dsb_FieldTypeParser(this, resolver);
        this.parserChain.addParser(this.feldParser);
        this.groupParser = new Dsb_GroupTypeParser(this, resolver);
        this.parserChain.addParser(this.groupParser);
        this.comParser = new Dsb_Comment_Parser(this, resolver);
        this.parserChain.addParser(this.comParser);
    }

    @Override
    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("http://www.destatis.de/schema/datml-ssp/1.0".equalsIgnoreCase(namespaceURI) && "recordHeaderType".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    @Override
    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("recordHeaderType".equalsIgnoreCase(localName)) {
            this.enable();
        } else if ("recordSelectors".equalsIgnoreCase(localName)) {
            this.selectors = new Vector();
        } else if (!"recordSelector".equalsIgnoreCase(localName) && !"annotation".equalsIgnoreCase(localName)) {
            if ("groupType".equalsIgnoreCase(localName)) {
                this.feldParser.setCanEnabled(false);
                this.comParser.setCanEnabled(false);
            }
            if (!this.parserChain.startElement(namespaceURI, localName, qName, atts)) {
                throw ILParseException.unknownTagException(localName);
            }
        }
        this.handleAttributes(namespaceURI, localName, qName, atts);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("recordHeaderType".equalsIgnoreCase(localName)) {
            this.disableAndNotify();
        } else if (!this.parserChain.endElement(namespaceURI, localName, qName) && !this.handleTag(namespaceURI, localName, qName)) {
            throw ILParseException.unkownClosingTagException(localName);
        }
    }

    @Override
    public MetaElement object() {
        return this.currentDsb;
    }

    @Override
    public void notifyObjectAvailable(SubParser aParser) {
        if (aParser == this.feldParser) {
            MetaEinzelfeld aFeld = (MetaEinzelfeld)this.feldParser.object();
            this.currentDsb.getComps().addToCompList(aFeld);
        } else if (aParser == this.groupParser) {
            MetaDsbComps comps = (MetaDsbComps)this.groupParser.object();
            Iterator it = comps.getCompList();
            while (it != null && it.hasNext()) {
                this.currentDsb.getComps().addToCompList((MetaDsbFeld)it.next());
            }
            this.feldParser.setCanEnabled(true);
            this.comParser.setCanEnabled(true);
        } else if (aParser == this.comParser) {
            this.currentDsb.getComps().addToCompList((MetaDsbFeld)this.comParser.object());
        }
    }

    @Override
    public StringBuffer charData() {
        return this.superParser().charData();
    }

    @Override
    public String parentElement() {
        return this.superParser().parentElement();
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("recordHeaderType".equalsIgnoreCase(localName)) {
            String str = atts.getValue("name");
            str = atts.getValue("name-prefix");
            if (str != null && str.trim().length() > 0) {
                this.currentDsb.setPraefix(str.trim());
            }
            str = atts.getValue("class");
            str = atts.getValue("length");
            if (str != null) {
                int length;
                try {
                    length = Integer.parseInt(str.trim());
                }
                catch (NumberFormatException e) {
                    throw new ILParseException("Wert des Attributes length ist keine Zahl!");
                }
                this.currentDsb.setSatzlaenge(length);
            }
        } else if ("recordSelector".equalsIgnoreCase(localName)) {
            String str = atts.getValue("name");
            if (str == null) {
                throw new ILParseException("Fuer das Satzartauswahlfeld ist kein Name definiert!");
            }
            this.selectors.add(str.trim());
        }
    }

    private boolean handleTag(String namespaceURI, String localName, String qName) {
        boolean handled = true;
        String chars = this.superParser().charData().toString().trim();
        if ("annotation".equalsIgnoreCase(localName)) {
            if (chars != null && chars.length() > 0) {
                this.currentDsb.setKommentar(chars);
            }
        } else if (!"recordSelectors".equalsIgnoreCase(localName) && !"recordSelector".equalsIgnoreCase(localName)) {
            handled = false;
        }
        return handled;
    }

    public void setCurrentDsb(MetaDsbObjekt objekt) {
        this.currentDsb = objekt;
    }

    @Override
    public void error(AbstractMessage errorMessage) {
        this.superParser().error(errorMessage);
    }
}

