/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.compare2.pdf;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Table;
import com.lowagie.text.TextElementArray;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import de.statspez.pleditor.generator.compare2.pdf.PdfConfig;
import de.statspez.pleditor.generator.compare2.pdf.PdfContext;
import de.statspez.pleditor.generator.compare2.pdf.PdfFontFactory;
import java.awt.Color;
import java.awt.Font;
import java.util.List;
import java.util.StringTokenizer;

public class ITextUtil {
    public static Paragraph convertTableToParagraph(Table table) throws BadElementException {
        if (table.size() != 1 || table.getColumns() != 1) {
            throw new BadElementException("Tabelle darf nur aus einer Zelle bestehen.");
        }
        com.lowagie.text.Font font = null;
        Chunk[] chunks = (Chunk[])table.getChunks().get(0);
        if (chunks.length > 0) {
            font = chunks[0].getFont();
        }
        Paragraph result = new Paragraph("", font);
        int i = 0;
        while (i < chunks.length) {
            Chunk element = chunks[i];
            result.add((Object)element);
            ++i;
        }
        return result;
    }

    public static com.lowagie.text.Font awtToITextFont(Font awtFont, Color color) {
        assert (awtFont != null) : "Die zu konvertierende Schriftart darf nicht NULL sein.";
        assert (color != null) : "Die zu konvertierende Farbe darf nicht NULL sein.";
        return PdfFontFactory.getInstance().getFont(awtFont, color);
    }

    public static com.lowagie.text.Font awtToITextFont(Font awtFont) {
        assert (awtFont != null) : "Die zu konvertierende Schriftart darf nicht NULL sein.";
        return PdfFontFactory.getInstance().getFont(awtFont, Color.black);
    }

    public static String getStringContentFrom(Element element) {
        StringBuffer buf = new StringBuffer();
        if (element != null) {
            if (element instanceof List && element instanceof TextElementArray) {
                for (Object obj : (List)element) {
                    if (!(obj instanceof Element)) continue;
                    buf.append(ITextUtil.getStringContentFrom((Element)obj));
                }
                if (element instanceof Paragraph) {
                    buf.append("\n");
                } else {
                    buf.append(' ');
                }
            } else if (element instanceof Chunk) {
                buf.append(((Chunk)element).getContent());
            }
        }
        return buf.toString();
    }

    public static String getOutlineStringFrom(Element element) {
        StringBuffer buf = new StringBuffer();
        for (Chunk chunk : element.getChunks()) {
            buf.append(ITextUtil.getOutlineStringFrom(chunk.getContent()));
        }
        return buf.toString();
    }

    public static String getOutlineStringFrom(String string) {
        StringBuffer buf = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(string);
        while (tokenizer.hasMoreTokens()) {
            buf.append(String.valueOf(tokenizer.nextToken()) + " ");
        }
        return buf.toString();
    }

    public static float pixelToCm(float pixel) {
        return (float)((double)pixel * 0.33);
    }

    public static float pointToCm(float point) {
        return (float)((double)point * 0.7);
    }

    public static float totalWidth(int metaWidth) {
        return (float)metaWidth * 0.627f;
    }

    public static PdfPTable createFooter(PdfConfig pdfConfig, PdfContext genContext) {
        PdfPCell pdfPCell;
        PdfPTable table;
        String footline = pdfConfig.getFootline();
        if (footline == null) {
            table = new PdfPTable(new float[]{100.0f});
        } else {
            table = new PdfPTable(new float[]{90.0f, 10.0f});
            pdfPCell = new PdfPCell();
            pdfPCell.setBorder(0);
            pdfPCell.setHorizontalAlignment(0);
            pdfPCell.addElement((Element)new Phrase(footline, ITextUtil.awtToITextFont(pdfConfig.getFootlineFont(), null)));
            table.addCell(pdfPCell);
        }
        table.setWidthPercentage(100.0f);
        table.setSpacingBefore(0.0f);
        table.setSpacingAfter(0.0f);
        pdfPCell = new PdfPCell();
        pdfPCell.setBorder(0);
        pdfPCell.setVerticalAlignment(6);
        Paragraph paragraph = new Paragraph();
        paragraph.setLeading(1.0f, 1.0f);
        paragraph.add((Object)new Chunk(genContext.getPageNrFormated(), ITextUtil.awtToITextFont(pdfConfig.getFootlineFont())));
        paragraph.setAlignment(2);
        pdfPCell.addElement((Element)paragraph);
        table.addCell(pdfPCell);
        return table;
    }

    public static void passeSeitenraenderAn(Document document, PdfConfig pdfConfig, PdfContext genKontext, float leftMargin, float rightMargin, float topMargin, float bottomMargin) {
        float kopffussBreite = document.getPageSize().getWidth() - rightMargin - leftMargin;
        PdfPTable footTable = ITextUtil.createFooter(pdfConfig, genKontext);
        footTable.setTotalWidth(kopffussBreite);
        document.setMargins(leftMargin, rightMargin, topMargin, bottomMargin += footTable.getTotalHeight() + 10.0f);
    }
}

