/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.java;

import de.statspez.pleditor.generator.codegen.java.CodegenContext;
import de.statspez.pleditor.generator.codegen.java.Settings;
import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.support.CodegenUtil;
import de.statspez.pleditor.generator.codegen.support.PruefungIterator;
import de.statspez.pleditor.generator.codegen.support.Traverser;
import de.statspez.pleditor.generator.meta.MetaCustomMappingElement;
import de.statspez.pleditor.generator.meta.MetaCustomMerkmal;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaCustomPruefung;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.MetaCustomThemenbereich;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import de.statspez.pleditor.generator.runtime.FeatureVariable;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorExt;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorImpl;
import de.statspez.pleditor.generator.runtime.PlausiDescriptorExt;
import de.statspez.pleditor.generator.runtime.PlausiDescriptorSerializer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;

public class PlausiDescriptorGenerator {
    private CodegenContext context = null;
    private PlausiDescriptorExt descriptor = null;
    private Hashtable mappings = null;

    public synchronized void generate(CodegenContext aContext) throws IOException {
        this.context = aContext;
        this.descriptor = new PlausiDescriptorExt();
        String descriptorFilename = String.valueOf(this.context.getPlausiClassName()) + "_Descriptor.data";
        OutputStream out = this.context.createOutputStream(descriptorFilename);
        try {
            this.buildMappings();
            this.storeSpecificationCode();
            this.storeFieldDescriptors();
            PlausiDescriptorSerializer pds = new PlausiDescriptorSerializer();
            pds.serialize(this.descriptor, out);
        }
        finally {
            this.context.destroyOutputStream(descriptorFilename, out);
        }
    }

    private void buildMappings() {
        MetaCustomPlausibilisierung mcp = (MetaCustomPlausibilisierung)this.context.getPlausi();
        if (mcp.usedMappings() != null) {
            this.mappings = new Hashtable();
            Iterator it = mcp.usedMappings().getMappingliste();
            while (it.hasNext()) {
                MetaCustomMappingElement mappingElement = (MetaCustomMappingElement)it.next();
                this.mappings.put(mappingElement.getTBFeldListeAlsName(), mappingElement.getDsbFeldAlsName());
            }
        }
    }

    private void storeSpecificationCode() {
        PruefungIterator pruefungIt = new PruefungIterator(this.context.getPlausi());
        pruefungIt.eachPruefung(new PruefungIterator.CodeBlock(){

            @Override
            public void doForPruefung(MetaCustomPruefung pruefung, MetaCustomThemenbereich tb) {
                PlausiDescriptorGenerator.this.descriptor.setCodeFor(pruefung.getPruefschluessel(), pruefung.getPLSpezifikation());
            }
        });
        Iterator merkmalIt = this.context.getPlausi().getMerkmale();
        while (merkmalIt.hasNext()) {
            MetaCustomMerkmal aMerkmal = (MetaCustomMerkmal)merkmalIt.next();
            if (aMerkmal.getPLSpezifikation() != null) {
                this.descriptor.setCodeFor(aMerkmal.getName(), aMerkmal.getPLSpezifikation());
                continue;
            }
            this.descriptor.setCodeFor(aMerkmal.getName(), "nicht verfuegbar");
        }
    }

    private void storeFieldDescriptors() {
        MetaThemenbereich rootTb = ((MetaCustomPlausibilisierung)this.context.getPlausi()).rootThemenbereich();
        rootTb.accept(new TBFeldDeskriptorBuilder());
    }

    private class TBFeldDeskriptorBuilder
    extends Traverser {
        private Stack descriptorStack = new Stack();

        private TBFeldDeskriptorBuilder() {
        }

        @Override
        public void visitThemenbereich(MetaThemenbereich tb) {
            Iterator it = tb.getFelder();
            while (it.hasNext()) {
                ((MetaElement)it.next()).accept(this);
            }
        }

        @Override
        public void visitTBFeld(MetaTBFeld feld) {
            FeldDeskriptorImpl parentDescriptor = this.descriptorStack.empty() ? null : this.descriptorStack.peek();
            if (!(feld.getKlasse() instanceof MetaThemenbereich)) {
                int feldTyp = Settings.rtTypeForILType(((MetaMerkmal)feld.getKlasse()).getTyp());
                FeldDeskriptorExt typDeskriptor = new FeldDeskriptorExt(PlausiDescriptorGenerator.this.mappings, feld.getName(), parentDescriptor == null ? null : parentDescriptor.getFeldDeskriptor(), feldTyp, ((MetaMerkmal)feld.getKlasse()).getMaske());
                if (feld instanceof MetaCustomTBFeld) {
                    typDeskriptor.setDimension(((MetaCustomTBFeld)feld).dimensions());
                    typDeskriptor.setFeldBezeichnung(CodegenUtil.getDisplayName(PlausiDescriptorGenerator.this.context.getTextResource(), (MetaCustomTBFeld)feld));
                }
                FeatureVariable feldDeskriptor = new FeatureVariable(parentDescriptor, typDeskriptor, new int[0]);
                String id = feldDeskriptor.hierarchyAsString();
                PlausiDescriptorGenerator.this.descriptor.setFeldDeskriptor(id, feldDeskriptor);
                MetaProgram checkProgram = ((MetaCustomMerkmal)feld.getKlasse()).getMetaSpezifikation();
                if (checkProgram != null) {
                    PlausiDescriptorGenerator.this.descriptor.setCheckMethod(id, "prg_" + StringHelper.getEscapedName(checkProgram.name()));
                }
            } else {
                MetaThemenbereich refTb = (MetaThemenbereich)feld.getKlasse();
                FeldDeskriptorExt typDeskriptor = new FeldDeskriptorExt(PlausiDescriptorGenerator.this.mappings, feld.getName(), parentDescriptor == null ? null : parentDescriptor.getFeldDeskriptor(), 7);
                if (feld instanceof MetaCustomTBFeld) {
                    typDeskriptor.setDimension(((MetaCustomTBFeld)feld).dimensions());
                    typDeskriptor.setFeldBezeichnung(CodegenUtil.getDisplayName(PlausiDescriptorGenerator.this.context.getTextResource(), (MetaCustomTBFeld)feld));
                }
                FeatureVariable tbDeskriptor = new FeatureVariable(parentDescriptor, typDeskriptor, new int[0]);
                this.descriptorStack.push(tbDeskriptor);
                refTb.accept(this);
                this.descriptorStack.pop();
            }
        }
    }
}

