/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.analysis;

import de.statspez.pleditor.generator.codegen.pl.HierarchicalCodeConverter;
import de.statspez.pleditor.generator.codegen.support.Traverser;
import de.statspez.pleditor.generator.meta.InternalFunctions;
import de.statspez.pleditor.generator.meta.MetaArrayAccess;
import de.statspez.pleditor.generator.meta.MetaFieldAccess;
import de.statspez.pleditor.generator.meta.MetaFunctionCall;
import de.statspez.pleditor.generator.meta.MetaIdentifier;
import de.statspez.pleditor.generator.meta.MetaMaterialAccess;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.MetaProgramParameter;
import de.statspez.pleditor.generator.meta.MetaStructureAccess;
import de.statspez.pleditor.generator.meta.MetaVarDeclaration;
import de.statspez.pleditor.generator.meta.generated.MetaPLFunktion;
import de.statspez.pleditor.generator.meta.generated.MetaPLInitwert;
import de.statspez.pleditor.generator.meta.generated.MetaPLPruefung;
import de.statspez.pleditor.generator.meta.generated.MetaPLVariable;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import de.statspez.pleditor.generator.parser.Helper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class ReferencedFieldsResolver {
    public String[] getReferencedFields(MetaThemenbereich tb, MetaPLPruefung pruefung, String prefix, Map mappedNames) {
        ArrayList referencedFields = new ArrayList();
        pruefung.accept(new Resolver(tb, referencedFields, prefix, mappedNames));
        return referencedFields.toArray(new String[referencedFields.size()]);
    }

    private class Resolver
    extends Traverser {
        private MetaThemenbereich tb;
        private List referencedFields;
        private Stack structure;
        private Set variables;
        private String prefix;
        private Map mappedNames;

        public Resolver(MetaThemenbereich tb, List referencedFields, String prefix, Map mappedNames) {
            this.tb = tb;
            this.referencedFields = referencedFields;
            this.prefix = prefix;
            this.mappedNames = mappedNames;
            this.structure = new Stack();
            this.variables = new HashSet();
            Iterator iter = this.tb.getVariablen();
            while (iter.hasNext()) {
                this.variables.add(((MetaPLVariable)iter.next()).getName());
            }
            iter = this.tb.getInitialisierungswerte();
            while (iter.hasNext()) {
                this.variables.add(((MetaPLInitwert)iter.next()).getName());
            }
        }

        private void addField(String field) {
            if (!this.variables.contains(field)) {
                String name;
                String structuredFieldName = field;
                int i = this.structure.size() - 1;
                while (i >= 0) {
                    structuredFieldName = this.structure.get(i) + "." + structuredFieldName;
                    --i;
                }
                if (this.prefix != null) {
                    structuredFieldName = String.valueOf(this.prefix) + structuredFieldName;
                }
                if ((name = (String)this.mappedNames.get(structuredFieldName)) == null || name.length() == 0) {
                    name = structuredFieldName;
                }
                if (!this.referencedFields.contains(name)) {
                    this.referencedFields.add(name);
                }
            }
        }

        @Override
        public void visitProgram(MetaProgram aProgram) {
            if (aProgram.containsHierarchicalFunction()) {
                HierarchicalCodeConverter converter = new HierarchicalCodeConverter();
                String simpleProgramCode = converter.generate(aProgram);
                MetaProgram simpleProgram = Helper.metaStructureFor(simpleProgramCode);
                this.visitElements(aProgram.parameters());
                simpleProgram.statements().accept(this);
            } else {
                super.visitProgram(aProgram);
            }
        }

        @Override
        public void visitProgramParameter(MetaProgramParameter aParameter) {
            this.variables.add(aParameter.name().value());
        }

        @Override
        public void visitFieldAccess(MetaFieldAccess aFieldAccess) {
            this.addField(aFieldAccess.accessedField().value());
        }

        @Override
        public void visitArrayAccess(MetaArrayAccess anArrayAccess) {
            this.addField(anArrayAccess.accessedArray().value());
            super.visitArrayAccess(anArrayAccess);
        }

        @Override
        public void visitStructureAccess(MetaStructureAccess aStructureAccess) {
            final ArrayList structureElements = new ArrayList();
            aStructureAccess.structureAccess().accept(new Traverser(){

                @Override
                public void visitFieldAccess(MetaFieldAccess aFieldAccess) {
                    structureElements.add(aFieldAccess.accessedField().value());
                }

                @Override
                public void visitArrayAccess(MetaArrayAccess anArrayAccess) {
                    Resolver.this.visitElements(anArrayAccess.indices());
                    structureElements.add(anArrayAccess.accessedArray().value());
                }
            });
            Iterator iter = structureElements.iterator();
            while (iter.hasNext()) {
                this.structure.push(iter.next());
            }
            aStructureAccess.selectedElement().accept(this);
            int i = 0;
            while (i < structureElements.size()) {
                this.structure.pop();
                ++i;
            }
        }

        @Override
        public void visitFunctionCall(MetaFunctionCall aStatement) {
            String functionName;
            this.visitElements(aStatement.parameters());
            final ArrayList structureElements = new ArrayList();
            if (aStatement.function().adaptedObject() instanceof MetaIdentifier) {
                MetaIdentifier identifier = (MetaIdentifier)aStatement.function().adaptedObject();
                functionName = identifier.value();
            } else {
                MetaStructureAccess structureAccess = (MetaStructureAccess)aStatement.function().adaptedObject();
                MetaFieldAccess fieldAccess = (MetaFieldAccess)structureAccess.selectedElement();
                functionName = fieldAccess.accessedField().value();
                structureAccess.structureAccess().accept(new Traverser(){

                    @Override
                    public void visitFieldAccess(MetaFieldAccess aFieldAccess) {
                        structureElements.add(aFieldAccess.accessedField().value());
                    }

                    @Override
                    public void visitArrayAccess(MetaArrayAccess anArrayAccess) {
                        Resolver.this.visitElements(anArrayAccess.indices());
                        structureElements.add(anArrayAccess.accessedArray().value());
                    }
                });
            }
            if (!InternalFunctions.instance().isInternalFunction(functionName)) {
                MetaThemenbereich subTb = this.tb;
                Iterator iter = structureElements.iterator();
                while (iter.hasNext()) {
                    this.structure.push(iter.next());
                    Iterator felder = subTb.getFelder();
                    while (felder.hasNext()) {
                        MetaTBFeld feld = (MetaTBFeld)felder.next();
                        if (!(feld.getKlasse() instanceof MetaThemenbereich) || !feld.getName().equals(this.structure.peek())) continue;
                        subTb = (MetaThemenbereich)feld.getKlasse();
                    }
                }
                iter = subTb.getFunktionen();
                while (iter.hasNext()) {
                    MetaPLFunktion funktion = (MetaPLFunktion)iter.next();
                    if (!funktion.getName().equals(functionName)) continue;
                    String subPrefix = "";
                    int i = this.structure.size() - 1;
                    while (i >= 0) {
                        subPrefix = this.structure.get(i) + "." + subPrefix;
                        --i;
                    }
                    if (this.prefix != null) {
                        subPrefix = String.valueOf(this.prefix) + subPrefix;
                    }
                    funktion.accept(new Resolver(subTb, this.referencedFields, subPrefix, this.mappedNames));
                    break;
                }
                int i = 0;
                while (i < structureElements.size()) {
                    this.structure.pop();
                    ++i;
                }
            }
        }

        @Override
        public void visitVarDeclaration(MetaVarDeclaration aDeclaration) {
            Iterator iter = aDeclaration.identifiers();
            while (iter.hasNext()) {
                this.variables.add(((MetaIdentifier)iter.next()).value());
            }
        }

        @Override
        public void visitMaterialAccess(MetaMaterialAccess anAccess) {
            this.visitElements(anAccess.selectionConditions());
        }
    }
}

