/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.sql;

import java.util.List;
import mondrian.olap.Evaluator;
import mondrian.olap.MondrianDef;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.SqlConstraintUtils;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.SqlQuery;
import mondrian.rolap.sql.TupleConstraint;
import mondrian.spi.Dialect;
import mondrian.util.Pair;

public class MemberKeyConstraint
implements TupleConstraint {
    private final Pair<List<MondrianDef.Expression>, List<Comparable>> cacheKey;
    private final List<MondrianDef.Expression> columnList;
    private final List<Dialect.Datatype> datatypeList;
    private final List<Comparable> valueList;

    public MemberKeyConstraint(List<MondrianDef.Expression> columnList, List<Dialect.Datatype> datatypeList, List<Comparable> valueList) {
        this.columnList = columnList;
        this.datatypeList = datatypeList;
        this.valueList = valueList;
        this.cacheKey = Pair.of(columnList, valueList);
    }

    @Override
    public void addConstraint(SqlQuery sqlQuery, RolapCube baseCube, AggStar aggStar) {
        for (int i = 0; i < this.columnList.size(); ++i) {
            MondrianDef.Expression expression = this.columnList.get(i);
            Comparable value = this.valueList.get(i);
            Dialect.Datatype datatype = this.datatypeList.get(i);
            sqlQuery.addWhere(SqlConstraintUtils.constrainLevel2(sqlQuery, expression, datatype, value));
        }
    }

    @Override
    public void addLevelConstraint(SqlQuery sqlQuery, RolapCube baseCube, AggStar aggStar, RolapLevel level) {
    }

    @Override
    public MemberChildrenConstraint getMemberChildrenConstraint(RolapMember parent) {
        return null;
    }

    public String toString() {
        return "MemberKeyConstraint";
    }

    @Override
    public Object getCacheKey() {
        return this.cacheKey;
    }

    @Override
    public Evaluator getEvaluator() {
        return null;
    }
}

