/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.Collection;
import mondrian.rolap.RolapStar;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.AbstractColumnPredicate;
import mondrian.rolap.agg.MinusStarPredicate;
import mondrian.rolap.agg.ValueColumnPredicate;

public class RangeColumnPredicate
extends AbstractColumnPredicate {
    private final boolean lowerInclusive;
    private final ValueColumnPredicate lowerBound;
    private final boolean upperInclusive;
    private final ValueColumnPredicate upperBound;

    public RangeColumnPredicate(RolapStar.Column column, boolean lowerInclusive, ValueColumnPredicate lowerBound, boolean upperInclusive, ValueColumnPredicate upperBound) {
        super(column);
        assert (lowerBound == null || lowerBound.getConstrainedColumn() == column);
        assert (lowerBound != null || !lowerInclusive);
        assert (upperBound == null || upperBound.getConstrainedColumn() == column);
        assert (upperBound != null || !upperInclusive);
        this.lowerInclusive = lowerInclusive;
        this.lowerBound = lowerBound;
        this.upperInclusive = upperInclusive;
        this.upperBound = upperBound;
    }

    public int hashCode() {
        int h = this.lowerInclusive ? 2 : 1;
        h = 31 * h + this.lowerBound.hashCode();
        h = 31 * h + (this.upperInclusive ? 2 : 1);
        h = 31 * h + this.upperBound.hashCode();
        return h;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RangeColumnPredicate) {
            RangeColumnPredicate that = (RangeColumnPredicate)obj;
            return this.lowerInclusive == that.lowerInclusive && this.lowerBound.equals(that.lowerBound) && this.upperInclusive == that.upperInclusive && this.upperBound.equals(that.upperBound);
        }
        return false;
    }

    @Override
    public void values(Collection<Object> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean evaluate(Object value) {
        int c;
        if (this.lowerBound != null) {
            c = ((Comparable)this.lowerBound.getValue()).compareTo(value);
            if (this.lowerInclusive ? c > 0 : c >= 0) {
                return false;
            }
        }
        if (this.upperBound != null) {
            c = ((Comparable)this.upperBound.getValue()).compareTo(value);
            if (this.upperInclusive ? c < 0 : c <= 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void describe(StringBuilder buf) {
        buf.append("Range(");
        if (this.lowerBound == null) {
            buf.append("unbounded");
        } else {
            this.lowerBound.describe(buf);
            if (this.lowerInclusive) {
                buf.append(" inclusive");
            }
        }
        buf.append(" to ");
        if (this.upperBound == null) {
            buf.append("unbounded");
        } else {
            this.upperBound.describe(buf);
            if (this.upperInclusive) {
                buf.append(" inclusive");
            }
        }
        buf.append(")");
    }

    @Override
    public StarColumnPredicate.Overlap intersect(StarColumnPredicate predicate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean mightIntersect(StarPredicate other) {
        if (other instanceof ValueColumnPredicate) {
            return this.evaluate(((ValueColumnPredicate)other).getValue());
        }
        return true;
    }

    @Override
    public StarColumnPredicate minus(StarPredicate predicate) {
        assert (predicate != null);
        return new MinusStarPredicate(this, (StarColumnPredicate)predicate);
    }

    @Override
    public StarColumnPredicate cloneWithColumn(RolapStar.Column column) {
        return new RangeColumnPredicate(column, this.lowerInclusive, this.lowerBound, this.upperInclusive, this.upperBound);
    }

    public ValueColumnPredicate getLowerBound() {
        return this.lowerBound;
    }

    public boolean getLowerInclusive() {
        return this.lowerInclusive;
    }

    public ValueColumnPredicate getUpperBound() {
        return this.upperBound;
    }

    public boolean getUpperInclusive() {
        return this.upperInclusive;
    }
}

