/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import mondrian.olap.Connection;
import mondrian.rolap.RolapConnection;
import mondrian.rolap.RolapResultShepherd;
import mondrian.rolap.agg.AggregationManager;
import mondrian.server.MondrianServerRegistry;
import mondrian.server.RepositoryContentFinder;
import mondrian.server.Statement;
import mondrian.server.monitor.Monitor;
import mondrian.spi.CatalogLocator;
import mondrian.util.LockBox;
import org.olap4j.OlapConnection;

public abstract class MondrianServer {
    public static MondrianServer forConnection(Connection connection) {
        return ((RolapConnection)connection).getServer();
    }

    public static MondrianServer createWithRepository(RepositoryContentFinder contentFinder, CatalogLocator catalogLocator) {
        return MondrianServerRegistry.INSTANCE.createWithRepository(contentFinder, catalogLocator);
    }

    public static MondrianServer forId(String instanceId) {
        return MondrianServerRegistry.INSTANCE.serverForId(instanceId);
    }

    public static void dispose(String instanceId) {
        MondrianServer server = MondrianServer.forId(instanceId);
        if (server != null) {
            server.shutdown();
        }
    }

    public abstract int getId();

    public MondrianVersion getVersion() {
        return MondrianServerRegistry.INSTANCE.getOrLoadVersion();
    }

    public abstract List<String> getKeywords();

    public abstract RolapResultShepherd getResultShepherd();

    public abstract LockBox getLockBox();

    public abstract OlapConnection getConnection(String var1, String var2, String var3) throws SQLException, SecurityException;

    public abstract OlapConnection getConnection(String var1, String var2, String var3, Properties var4) throws SQLException, SecurityException;

    public abstract List<Map<String, Object>> getDatabases(RolapConnection var1);

    public abstract CatalogLocator getCatalogLocator();

    public abstract void shutdown();

    public abstract void addConnection(RolapConnection var1);

    public abstract void removeConnection(RolapConnection var1);

    public abstract RolapConnection getConnection(int var1);

    public abstract void addStatement(Statement var1);

    public abstract void removeStatement(Statement var1);

    public abstract Monitor getMonitor();

    public abstract AggregationManager getAggregationManager();

    public static interface MondrianVersion {
        public String getVersionString();

        public int getMajorVersion();

        public int getMinorVersion();

        public String getProductName();
    }
}

