/*
 * Decompiled with CFR 0.152.
 */
package com.bitmechanic.maxq.generator;

import com.bitmechanic.maxq.IScriptAdapter;
import com.bitmechanic.maxq.Utils;
import com.bitmechanic.maxq.generator.AbstractCodeGenerator;
import com.bitmechanic.maxq.generator.GeneratorFactory;
import com.bitmechanic.maxq.generator.IScriptGenerator;
import java.io.File;

public class JavaCodeGenerator
extends AbstractCodeGenerator {
    private String baseClasspath;

    public JavaCodeGenerator(IScriptAdapter adapter) {
        super(adapter);
        File basePath = new File(GeneratorFactory.generatorProperties.getProperty("generator.java.sourcepath", ""));
        this.baseClasspath = basePath.getAbsolutePath();
        System.out.println(this.baseClasspath);
    }

    public String[] getValidFileExtensions() {
        return new String[]{".java"};
    }

    private String generateTidyImport() {
        return "import org.w3c.tidy.*" + AbstractCodeGenerator.END_STATEMENT;
    }

    private String setTidyConfig() {
        StringBuffer result = new StringBuffer();
        result.append(this.createStatement("//setup Tidy configurations"));
        result.append(this.createStatement("Tidy tidy = new Tidy()"));
        result.append(this.createStatement("tidy.setConfigurationFromFile(\"" + AbstractCodeGenerator.jtidyConfigFile + "\")"));
        return result.toString();
    }

    public void doCreateList() {
        super.getScriptAdapter().append(this.createStatement("list = new ArrayList()"));
    }

    public void doCallUrl(String url, String method, String data, String contentLength, String list) {
        super.getScriptAdapter().append(this.createStatement(String.valueOf(method) + "(\"" + url + "\"" + data + contentLength + list + ")"));
    }

    public void doAssertResponse(String respCode) {
        StringBuffer result = new StringBuffer();
        result.append(this.createStatement("System.out.println(\"Response code: \" + getResponse().getStatusCode())"));
        result.append(this.createStatement("assertEquals(\"Assert number " + ++this.assertNumber + " failed\", " + respCode + ", getResponse().getStatusCode())"));
        super.getScriptAdapter().append(result.toString());
    }

    public void doAddParameterToList(String name, String value) {
        super.getScriptAdapter().append(this.createStatement("list.add(new NameValuePair(\"" + name + "\", \"" + value + "\")" + ")"));
    }

    public void doTestUrlMessage(String url) {
        super.getScriptAdapter().append(this.createStatement("System.out.println(\"Testing URL: \" +replaceURL(\"" + url + "\"))"));
    }

    public void doSetData(String data) {
        super.getScriptAdapter().append(this.createStatement("data = '" + data + "'"));
    }

    public void doTidyCode(String url) {
        StringBuffer buf = new StringBuffer();
        if (AbstractCodeGenerator.jtidyConfigFile != null) {
            buf.append(this.createStatement("//validate html text via Tidy"));
            buf.append(this.createStatement("tidy.parse(getResponse().getInputStream(), System.out)"));
            buf.append(this.createStatement("if (tidy.getParseWarnings() + tidy.getParseErrors() > 0) {"));
            buf.append(this.createStatement("    System.out.println(\"<<Tidy report>> URL=" + url.trim() + " WARNING=\"+tidy.getParseWarnings()+\", and ERROR=\"+tidy.getParseErrors())"));
            buf.append(this.createStatement("    System.out.println(\"+------------------------------------------------------------------------------+\")"));
            buf.append(this.createStatement("}"));
        }
        super.getScriptAdapter().append(buf.toString());
    }

    public void doResponseForStdOut(String url) {
        StringBuffer result = new StringBuffer();
        result.append(this.createStatement("System.out.println(\"+--------Begin HTTP response for :" + url + "--------+\")"));
        result.append(this.createStatement("rsp = new String(getResponse().getData())"));
        result.append(this.createStatement("System.out.println(rsp)"));
        result.append(this.createStatement("System.out.println(\"+--------End HTTP response for :" + url + "--------+\")"));
        result.append(this.createStatement("System.out.println(\"+--------MessageDigest :\"+getDigestStr(rsp)+\"+--------+\")"));
        super.getScriptAdapter().append(result.toString());
    }

    public void doResponseForFile() {
        StringBuffer result = new StringBuffer();
        result.append(this.createStatement("rsp = new String(getResponse().getData())"));
        result.append(this.createStatement("filename = getResponse().hashCode() + \".html\""));
        result.append(this.createStatement("System.out.println(\"+--------Save html output to :\"+filename+\"--------+\")"));
        result.append(this.createStatement("htmlFile = EditorPane.saveHTML(filename, rsp, \"tmp\")"));
        super.getScriptAdapter().append(result.toString());
    }

    public void doStartRecording() {
        if (!this.scriptContainsTestDeclaration()) {
            this.getScriptAdapter().insert(this.getTestDeclarationText(), 0);
        }
    }

    public void doStopRecording() {
        StringBuffer result = new StringBuffer();
        result.append("    }");
        result.append(String.valueOf(IScriptGenerator.EOL) + IScriptGenerator.EOL);
        result.append("/****************/" + IScriptGenerator.EOL + IScriptGenerator.EOL);
        result.append("}");
        super.getScriptAdapter().append(result.toString());
    }

    public void doSave(String path, String fileName) {
        if (path == null) {
            throw new IllegalArgumentException("path cannot be null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("file name cannot be null");
        }
        String name = fileName;
        if (fileName.indexOf(".") > -1) {
            name = fileName.substring(0, fileName.indexOf("."));
        }
        this.setTestName(name);
        this.setTestPath(path);
        this.updateTestName();
        this.updateTestPath();
    }

    private void updateTestPath() {
        String pkg = this.getPackage();
        System.out.println("package = " + pkg);
        if (this.getScript() != null) {
            int startpos = this.getScript().indexOf("package ");
            if (startpos > -1) {
                int end = this.getScript().indexOf(";", startpos += 8);
                this.getScriptAdapter().replace(this.getPackage(), startpos, end);
            } else if (!pkg.equals("")) {
                this.getScriptAdapter().insert("package " + pkg + ";" + IScriptGenerator.EOL + IScriptGenerator.EOL, 0);
            }
        }
    }

    public void doLoad(String script) {
        super.loadScriptAdapter(script);
        String testName = this.parseTestName();
        System.out.println("testNAme = " + testName);
        this.setTestName(testName);
        this.setDefaultTestName(testName);
        String testPath = this.parseTestPath();
        System.out.println("TestPath = " + testPath);
        this.setTestPath(this.parseTestPath());
    }

    public String parseTestName() {
        int startpos;
        String testName = "";
        if (this.getScript() != null && (startpos = this.getScript().indexOf("public class ")) > -1) {
            int end = this.getScript().indexOf(" extends", startpos += 13);
            testName = this.getScript().substring(startpos, end);
        }
        return testName;
    }

    private String parseTestPath() {
        String testPath = null;
        int pos = this.getPackageNameStartPos();
        if (pos > -1) {
            int end = this.getPackageNameEndPos();
            testPath = this.packageToPath(this.getScript().substring(pos, end).trim());
        }
        return testPath;
    }

    private int getPackageNameEndPos() {
        int pos = -1;
        if (this.getScript() != null) {
            pos = this.getScript().indexOf(";", this.getPackageNameStartPos());
        }
        return pos;
    }

    private int getPackageNameStartPos() {
        int pos = -1;
        if (this.getScript() != null && (pos = this.getScript().indexOf("package ")) > -1) {
            pos += 7;
        }
        return pos;
    }

    private String packageToPath(String s) {
        return String.valueOf(this.getTestPath()) + "\\" + s.replace('.', '\\');
    }

    private String getPackage() {
        String path = "";
        System.out.println("baseclasspath = " + this.baseClasspath);
        System.out.println("testpath = " + this.getTestPath());
        if (this.getTestPath() != null && this.getTestPath().toLowerCase().startsWith(this.baseClasspath.toLowerCase()) && this.getTestPath().length() != this.baseClasspath.length()) {
            path = this.getTestPath().substring(this.baseClasspath.length() + 1);
        }
        return path.replace('\\', '.');
    }

    private void updateTestName() {
        this.updateClassDefinition();
        this.updateConstructor();
        this.updateTestMethod();
    }

    private void updateTestMethod() {
        int startpos = -1;
        if (this.getScript() != null && (startpos = this.getScript().indexOf("public void test" + this.getDefaultTestName() + "() throws Exception {")) > -1) {
            this.getScriptAdapter().replace(this.getTestName(), startpos += 16, startpos + this.getDefaultTestName().length());
        }
    }

    private void updateClassDefinition() {
        int startpos = -1;
        if (this.getScript() != null && (startpos = this.getScript().indexOf("public class " + this.getDefaultTestName())) > -1) {
            startpos += 13;
            int end = -1;
            if (this.getScript() != null) {
                end = this.getScript().indexOf(" extends");
            }
            this.getScriptAdapter().replace(this.getTestName(), startpos, end);
        }
    }

    private void updateConstructor() {
        int startpos = -1;
        if (this.getScript() != null && (startpos = this.getScript().indexOf("public " + this.getDefaultTestName() + "(String name) {")) > -1) {
            this.getScriptAdapter().replace(this.getTestName(), startpos += 7, startpos + this.getDefaultTestName().length());
        }
    }

    private boolean scriptContainsTestDeclaration() {
        int pos = this.getScript().indexOf("// This class was generated by MaxQ (maxq.tigris.org)");
        return pos > -1;
    }

    protected String getTestDeclarationText() {
        StringBuffer result = new StringBuffer();
        result.append(this.getPackageDeclaration());
        result.append("// This class was generated by MaxQ (maxq.tigris.org)" + IScriptGenerator.EOL);
        result.append("// imports" + IScriptGenerator.EOL);
        result.append("import junit.textui.TestRunner" + AbstractCodeGenerator.END_STATEMENT);
        result.append("import com.bitmechanic.maxq.HttpTestCase" + AbstractCodeGenerator.END_STATEMENT);
        result.append("import java.io.*" + AbstractCodeGenerator.END_STATEMENT);
        result.append("import java.util.*" + AbstractCodeGenerator.END_STATEMENT);
        result.append("import org.apache.commons.httpclient.NameValuePair" + AbstractCodeGenerator.END_STATEMENT);
        if (AbstractCodeGenerator.jtidyConfigFile != null) {
            result.append(this.generateTidyImport());
        }
        if (AbstractCodeGenerator.isCpRspToStdout()) {
            result.append("import java.security.MessageDigest" + AbstractCodeGenerator.END_STATEMENT);
        }
        result.append(String.valueOf(IScriptGenerator.EOL) + "// definition of test class" + IScriptGenerator.EOL);
        result.append("public class " + this.getTestName() + " extends HttpTestCase {" + IScriptGenerator.EOL);
        result.append("    public " + this.getTestName() + "(String name) {" + IScriptGenerator.EOL);
        result.append("        super(name)" + AbstractCodeGenerator.END_STATEMENT);
        result.append("    }" + IScriptGenerator.EOL + IScriptGenerator.EOL);
        result.append("    public void setUp() {" + IScriptGenerator.EOL).append("        //add setup code here if needed " + IScriptGenerator.EOL).append("    }" + IScriptGenerator.EOL + IScriptGenerator.EOL);
        result.append("    public void tearDown() {" + IScriptGenerator.EOL).append("        //add teardown code here if needed " + IScriptGenerator.EOL).append("    }" + IScriptGenerator.EOL + IScriptGenerator.EOL);
        if (AbstractCodeGenerator.isCpRspToStdout()) {
            result.append("    protected String getDigestStr(String httpString) throws Exception {" + IScriptGenerator.EOL);
            result.append("        MessageDigest md = MessageDigest.getInstance(\"SHA\")" + AbstractCodeGenerator.END_STATEMENT);
            result.append("        md.update(httpString.getBytes())" + AbstractCodeGenerator.END_STATEMENT);
            result.append("        byte[] digest = md.digest()" + AbstractCodeGenerator.END_STATEMENT);
            result.append("        StringBuffer hexString = new StringBuffer()" + AbstractCodeGenerator.END_STATEMENT);
            result.append("        for (int i = 0; i < digest.length; i++) {" + IScriptGenerator.EOL);
            result.append("            byte b = digest[i]" + AbstractCodeGenerator.END_STATEMENT);
            result.append("            hexString.append(Integer.toHexString(0xFF & b))" + AbstractCodeGenerator.END_STATEMENT);
            result.append("            hexString.append(\" \")" + AbstractCodeGenerator.END_STATEMENT);
            result.append("        }" + IScriptGenerator.EOL + IScriptGenerator.EOL);
            result.append("        return hexString.toString()" + AbstractCodeGenerator.END_STATEMENT + IScriptGenerator.EOL);
            result.append("    }" + IScriptGenerator.EOL + IScriptGenerator.EOL);
        }
        result.append("    // Test method generated from the MaxQ Java generator" + IScriptGenerator.EOL);
        result.append("    public void test" + this.getTestName() + "() throws Exception {" + IScriptGenerator.EOL);
        result.append("        List list" + AbstractCodeGenerator.END_STATEMENT);
        result.append("        String rsp" + AbstractCodeGenerator.END_STATEMENT);
        result.append("        String filename" + AbstractCodeGenerator.END_STATEMENT);
        result.append("        File htmlFile " + AbstractCodeGenerator.END_STATEMENT);
        System.out.println("JTIDY:" + AbstractCodeGenerator.jtidyConfigFile);
        if (AbstractCodeGenerator.jtidyConfigFile != null) {
            result.append(this.setTidyConfig());
        }
        return result.toString();
    }

    private String getPackageDeclaration() {
        String pkgDeclaration = "";
        if (!this.getPackage().equals("")) {
            pkgDeclaration = "package " + this.getPackage() + AbstractCodeGenerator.END_STATEMENT;
        }
        return pkgDeclaration;
    }

    protected String createStatement(String text) {
        return Utils.lpad(8, String.valueOf(text) + AbstractCodeGenerator.END_STATEMENT);
    }
}

