/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.mavenplugins.sourceforge;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpRecoverableException;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.contrib.ssl.EasySSLProtocolSocketFactory;
import org.apache.commons.httpclient.cookie.CookiePolicy;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.cyberneko.html.parsers.DOMParser;
import org.w3c.dom.Document;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class WebBrowser {
    private static WebBrowser _instance = new WebBrowser();
    private HttpClient _client;
    private DOMParser _parser;

    public static WebBrowser getInstance() {
        return _instance;
    }

    public static String forceFinalSlash(String s) {
        if (!s.endsWith("/")) {
            return s + "/";
        }
        return s;
    }

    public static String removeFinalSlash(String s) {
        if (s.endsWith("/")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    private WebBrowser() {
        CookiePolicy.setDefaultPolicy((int)0);
        Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (SecureProtocolSocketFactory)new EasySSLProtocolSocketFactory(), 443));
        this._client = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        this._parser = new DOMParser();
        try {
            this._parser.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"lower");
        }
        catch (SAXNotRecognizedException e) {
            e.printStackTrace();
        }
        catch (SAXNotSupportedException e) {
            e.printStackTrace();
        }
    }

    public HttpClient getClient() {
        return this._client;
    }

    public void useProxy(String proxyHost, int proxyPort, String ntDomain, String userName, String password) {
        System.out.println("Using proxy " + proxyHost + ":" + proxyPort);
        this._client.getHostConfiguration().setProxy(proxyHost, proxyPort);
        if (userName != null) {
            if (ntDomain == null) {
                System.out.println("Login on the proxy with user name " + userName);
                this._client.getState().setProxyCredentials(null, proxyHost, (Credentials)new UsernamePasswordCredentials(userName, password));
            } else {
                try {
                    String host = InetAddress.getLocalHost().getHostName();
                    System.out.println("Login on the NT proxy with user name " + userName + ", host " + host + ", NT domain " + ntDomain);
                    this._client.getState().setProxyCredentials(null, proxyHost, (Credentials)new NTCredentials(userName, password, host, ntDomain));
                }
                catch (UnknownHostException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public HttpMethod executeMethod(HttpMethod method) throws URIException {
        int statusCode = -1;
        int attempt = 0;
        method.setRequestHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0b; Windows 98)");
        while (statusCode == -1 && attempt < 3) {
            try {
                statusCode = this._client.executeMethod(method);
            }
            catch (HttpRecoverableException e) {
                System.out.println("A recoverable exception occurred, retrying.  " + e.getMessage());
            }
            catch (IOException e) {
                System.out.println("Failed to download file.");
                e.printStackTrace();
                throw new RuntimeException("Failed to download file.");
            }
        }
        if (statusCode == -1) {
            System.out.println("Failed to recover from exception.");
            throw new RuntimeException("Error when reading " + method.getPath());
        }
        if (statusCode >= 400) {
            System.out.println("Page not found (error " + statusCode + ")");
            throw new RuntimeException("Error when reading " + method.getPath());
        }
        if (statusCode >= 300 && statusCode < 400) {
            Header locationHeader = method.getResponseHeader("location");
            if (locationHeader == null) {
                locationHeader = method.getResponseHeader("Location");
            }
            if (locationHeader != null) {
                String redirectLocation = locationHeader.getValue();
                method.releaseConnection();
                URI uri = new URI(redirectLocation);
                if (!uri.isAbsoluteURI()) {
                    uri = method.getURI();
                    if (!redirectLocation.startsWith("/")) {
                        redirectLocation = uri.getCurrentHierPath() + "/" + redirectLocation;
                    }
                    uri.setPath(redirectLocation);
                    redirectLocation = uri.getURI();
                }
                GetMethod redirectMethod = new GetMethod(redirectLocation);
                this.executeMethod((HttpMethod)redirectMethod);
                return redirectMethod;
            }
            System.out.println("Page not found");
            throw new RuntimeException("Error when reading " + method);
        }
        return method;
    }

    public String getResponse(HttpMethod method) throws URIException {
        HttpMethod lastMethod = this.executeMethod(method);
        String response = new String(lastMethod.getResponseBody());
        lastMethod.releaseConnection();
        return response;
    }

    public Document getDocument(HttpMethod method) throws Exception {
        String response = this.getResponse(method);
        XMLInputSource source = new XMLInputSource(null, null, null, (Reader)new StringReader(response), null);
        this._parser.parse(source);
        Document doc = this._parser.getDocument();
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFile(HttpMethod method, File destFile) throws Exception {
        HttpMethod lastMethod = this.executeMethod(method);
        BufferedInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new BufferedInputStream(lastMethod.getResponseBodyAsStream());
            out = new FileOutputStream(destFile);
            byte[] buffer = new byte[8192];
            int count = 0;
            do {
                out.write(buffer, 0, count);
            } while ((count = ((InputStream)in).read(buffer, 0, buffer.length)) != -1);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                ((InputStream)in).close();
            }
        }
    }
}

