/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.selectvalues;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleAttributeInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.lineage.FieldnameLineage;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInjectionMetaEntry;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInjectionInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.selectvalues.SelectMetadataChange;
import org.pentaho.di.trans.steps.selectvalues.SelectValues;
import org.pentaho.di.trans.steps.selectvalues.SelectValuesData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class SelectValuesMeta
extends BaseStepMeta
implements StepMetaInterface,
StepMetaInjectionInterface {
    private static Class<?> PKG = SelectValuesMeta.class;
    private String[] selectName;
    private String[] selectRename;
    private int[] selectLength;
    private int[] selectPrecision;
    private boolean selectingAndSortingUnspecifiedFields;
    private String[] deleteName;
    private SelectMetadataChange[] meta;

    public String[] getDeleteName() {
        return this.deleteName;
    }

    public void setDeleteName(String[] deleteName) {
        this.deleteName = deleteName;
    }

    public int[] getSelectLength() {
        return this.selectLength;
    }

    public void setSelectLength(int[] selectLength) {
        this.selectLength = selectLength;
    }

    public String[] getSelectName() {
        return this.selectName;
    }

    public void setSelectName(String[] selectName) {
        this.selectName = selectName;
    }

    public int[] getSelectPrecision() {
        return this.selectPrecision;
    }

    public void setSelectPrecision(int[] selectPrecision) {
        this.selectPrecision = selectPrecision;
    }

    public String[] getSelectRename() {
        return this.selectRename;
    }

    public void setSelectRename(String[] selectRename) {
        this.selectRename = selectRename;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int nrFields, int nrRemove, int nrMeta) {
        this.allocateSelect(nrFields);
        this.allocateRemove(nrRemove);
        this.allocateMeta(nrMeta);
    }

    private void allocateSelect(int nrFields) {
        this.selectName = new String[nrFields];
        this.selectRename = new String[nrFields];
        this.selectLength = new int[nrFields];
        this.selectPrecision = new int[nrFields];
    }

    private void allocateRemove(int nrRemove) {
        this.deleteName = new String[nrRemove];
    }

    private void allocateMeta(int nrMeta) {
        this.meta = new SelectMetadataChange[nrMeta];
    }

    @Override
    public Object clone() {
        int i;
        SelectValuesMeta retval = (SelectValuesMeta)super.clone();
        int nrfields = this.selectName.length;
        int nrremove = this.deleteName.length;
        int nrmeta = this.meta.length;
        retval.allocate(nrfields, nrremove, nrmeta);
        for (i = 0; i < nrfields; ++i) {
            retval.selectName[i] = this.selectName[i];
            retval.selectRename[i] = this.selectRename[i];
            retval.selectLength[i] = this.selectLength[i];
            retval.selectPrecision[i] = this.selectPrecision[i];
        }
        for (i = 0; i < nrremove; ++i) {
            retval.deleteName[i] = this.deleteName[i];
        }
        for (i = 0; i < nrmeta; ++i) {
            retval.getMeta()[i] = this.meta[i].clone();
        }
        return retval;
    }

    private void readData(Node step) throws KettleXMLException {
        try {
            Node line;
            int i;
            Node fields = XMLHandler.getSubNode((Node)step, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            int nrremove = XMLHandler.countNodes((Node)fields, (String)"remove");
            int nrmeta = XMLHandler.countNodes((Node)fields, (String)"meta");
            this.allocate(nrfields, nrremove, nrmeta);
            for (i = 0; i < nrfields; ++i) {
                line = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.selectName[i] = XMLHandler.getTagValue((Node)line, (String)"name");
                this.selectRename[i] = XMLHandler.getTagValue((Node)line, (String)"rename");
                this.selectLength[i] = Const.toInt((String)XMLHandler.getTagValue((Node)line, (String)"length"), (int)-2);
                this.selectPrecision[i] = Const.toInt((String)XMLHandler.getTagValue((Node)line, (String)"precision"), (int)-2);
            }
            this.selectingAndSortingUnspecifiedFields = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)fields, (String)"select_unspecified"));
            for (i = 0; i < nrremove; ++i) {
                line = XMLHandler.getSubNodeByNr((Node)fields, (String)"remove", (int)i);
                this.deleteName[i] = XMLHandler.getTagValue((Node)line, (String)"name");
            }
            for (i = 0; i < nrmeta; ++i) {
                Node metaNode = XMLHandler.getSubNodeByNr((Node)fields, (String)"meta", (int)i);
                this.meta[i] = new SelectMetadataChange(this);
                this.meta[i].loadXML(metaNode);
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"SelectValuesMeta.Exception.UnableToReadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.allocate(0, 0, 0);
    }

    public void getSelectFields(RowMetaInterface inputRowMeta, String name) throws KettleStepException {
        if (this.selectName != null && this.selectName.length > 0) {
            RowMeta row = new RowMeta();
            for (int i = 0; i < this.selectName.length; ++i) {
                ValueMetaInterface v = inputRowMeta.searchValueMeta(this.selectName[i]);
                if (v == null) continue;
                if (!(v = v.clone()).getName().equals(this.selectRename[i]) && this.selectRename[i] != null && this.selectRename[i].length() > 0) {
                    v.setName(this.selectRename[i]);
                    v.setOrigin(name);
                }
                if (this.selectLength[i] != -2) {
                    v.setLength(this.selectLength[i]);
                    v.setOrigin(name);
                }
                if (this.selectPrecision[i] != -2) {
                    v.setPrecision(this.selectPrecision[i]);
                    v.setOrigin(name);
                }
                row.addValueMeta(v);
            }
            if (this.selectingAndSortingUnspecifiedFields) {
                ArrayList<String> extra = new ArrayList<String>();
                for (int i = 0; i < inputRowMeta.size(); ++i) {
                    String fieldName = inputRowMeta.getValueMeta(i).getName();
                    if (Const.indexOfString((String)fieldName, (String[])this.selectName) >= 0) continue;
                    extra.add(fieldName);
                }
                Collections.sort(extra);
                for (String fieldName : extra) {
                    ValueMetaInterface extraValue = inputRowMeta.searchValueMeta(fieldName);
                    row.addValueMeta(extraValue);
                }
            }
            inputRowMeta.clear();
            inputRowMeta.addRowMeta((RowMetaInterface)row);
        }
    }

    public void getDeleteFields(RowMetaInterface inputRowMeta) throws KettleStepException {
        if (this.deleteName != null && this.deleteName.length > 0) {
            for (int i = 0; i < this.deleteName.length; ++i) {
                try {
                    inputRowMeta.removeValueMeta(this.deleteName[i]);
                    continue;
                }
                catch (KettleValueException e) {
                    throw new KettleStepException((Throwable)e);
                }
            }
        }
    }

    public void getMetadataFields(RowMetaInterface inputRowMeta, String name) throws KettlePluginException {
        if (this.meta != null && this.meta.length > 0) {
            for (int i = 0; i < this.meta.length; ++i) {
                SelectMetadataChange metaChange = this.meta[i];
                int idx = inputRowMeta.indexOfValue(metaChange.getName());
                if (idx < 0) continue;
                ValueMetaInterface v = inputRowMeta.getValueMeta(idx);
                if (!v.getName().equals(metaChange.getRename()) && !Const.isEmpty((String)metaChange.getRename())) {
                    v.setName(metaChange.getRename());
                    v.setOrigin(name);
                }
                if (metaChange.getType() != 0 && v.getType() != metaChange.getType()) {
                    v = ValueMetaFactory.cloneValueMeta((ValueMetaInterface)v, (int)metaChange.getType());
                    inputRowMeta.setValueMeta(idx, v);
                    v.setStorageType(0);
                }
                if (metaChange.getLength() != -2) {
                    v.setLength(metaChange.getLength());
                    v.setOrigin(name);
                }
                if (metaChange.getPrecision() != -2) {
                    v.setPrecision(metaChange.getPrecision());
                    v.setOrigin(name);
                }
                if (metaChange.getStorageType() >= 0) {
                    v.setStorageType(metaChange.getStorageType());
                    v.setOrigin(name);
                }
                if (!Const.isEmpty((String)metaChange.getConversionMask())) {
                    v.setConversionMask(metaChange.getConversionMask());
                    v.setOrigin(name);
                }
                v.setDateFormatLenient(metaChange.isDateFormatLenient());
                v.setDateFormatLocale(EnvUtil.createLocale((String)metaChange.getDateFormatLocale()));
                v.setDateFormatTimeZone(EnvUtil.createTimeZone((String)metaChange.getDateFormatTimeZone()));
                v.setLenientStringToNumber(metaChange.isLenientStringToNumber());
                if (!Const.isEmpty((String)metaChange.getEncoding())) {
                    v.setStringEncoding(metaChange.getEncoding());
                    v.setOrigin(name);
                }
                if (!Const.isEmpty((String)metaChange.getDecimalSymbol())) {
                    v.setDecimalSymbol(metaChange.getDecimalSymbol());
                    v.setOrigin(name);
                }
                if (!Const.isEmpty((String)metaChange.getGroupingSymbol())) {
                    v.setGroupingSymbol(metaChange.getGroupingSymbol());
                    v.setOrigin(name);
                }
                if (Const.isEmpty((String)metaChange.getCurrencySymbol())) continue;
                v.setCurrencySymbol(metaChange.getCurrencySymbol());
                v.setOrigin(name);
            }
        }
    }

    @Override
    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        try {
            RowMetaInterface rowMeta = inputRowMeta.clone();
            inputRowMeta.clear();
            inputRowMeta.addRowMeta(rowMeta);
            this.getSelectFields(inputRowMeta, name);
            this.getDeleteFields(inputRowMeta);
            this.getMetadataFields(inputRowMeta, name);
        }
        catch (Exception e) {
            throw new KettleStepException((Throwable)e);
        }
    }

    @Override
    public String getXML() {
        int i;
        StringBuffer retval = new StringBuffer(300);
        retval.append("    <fields>");
        for (i = 0; i < this.selectName.length; ++i) {
            retval.append("      <field>");
            retval.append("        ").append(XMLHandler.addTagValue((String)this.getXmlCode("FIELD_NAME"), (String)this.selectName[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)this.getXmlCode("FIELD_RENAME"), (String)this.selectRename[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)this.getXmlCode("FIELD_LENGTH"), (int)this.selectLength[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)this.getXmlCode("FIELD_PRECISION"), (int)this.selectPrecision[i]));
            retval.append("      </field>");
        }
        retval.append("        ").append(XMLHandler.addTagValue((String)this.getXmlCode("SELECT_UNSPECIFIED"), (boolean)this.selectingAndSortingUnspecifiedFields));
        for (i = 0; i < this.deleteName.length; ++i) {
            retval.append("      <remove>");
            retval.append("        ").append(XMLHandler.addTagValue((String)this.getXmlCode("REMOVE_NAME"), (String)this.deleteName[i]));
            retval.append("      </remove>");
        }
        for (i = 0; i < this.meta.length; ++i) {
            retval.append(this.meta[i].getXML());
        }
        retval.append("    </fields>");
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int i;
            int nrfields = rep.countNrStepAttributes(id_step, this.getRepCode("FIELD_NAME"));
            int nrremove = rep.countNrStepAttributes(id_step, this.getRepCode("REMOVE_NAME"));
            int nrmeta = rep.countNrStepAttributes(id_step, this.getRepCode("META_NAME"));
            this.allocate(nrfields, nrremove, nrmeta);
            for (i = 0; i < nrfields; ++i) {
                this.selectName[i] = rep.getStepAttributeString(id_step, i, this.getRepCode("FIELD_NAME"));
                this.selectRename[i] = rep.getStepAttributeString(id_step, i, this.getRepCode("FIELD_RENAME"));
                this.selectLength[i] = (int)rep.getStepAttributeInteger(id_step, i, this.getRepCode("FIELD_LENGTH"));
                this.selectPrecision[i] = (int)rep.getStepAttributeInteger(id_step, i, this.getRepCode("FIELD_PRECISION"));
            }
            this.selectingAndSortingUnspecifiedFields = rep.getStepAttributeBoolean(id_step, this.getRepCode("SELECT_UNSPECIFIED"));
            for (i = 0; i < nrremove; ++i) {
                this.deleteName[i] = rep.getStepAttributeString(id_step, i, this.getRepCode("REMOVE_NAME"));
            }
            for (i = 0; i < nrmeta; ++i) {
                this.meta[i] = new SelectMetadataChange(this);
                this.meta[i].setName(rep.getStepAttributeString(id_step, i, this.getRepCode("META_NAME")));
                this.meta[i].setRename(rep.getStepAttributeString(id_step, i, this.getRepCode("META_RENAME")));
                this.meta[i].setType((int)rep.getStepAttributeInteger(id_step, i, this.getRepCode("META_TYPE")));
                this.meta[i].setLength((int)rep.getStepAttributeInteger(id_step, i, this.getRepCode("META_LENGTH")));
                this.meta[i].setPrecision((int)rep.getStepAttributeInteger(id_step, i, this.getRepCode("META_PRECISION")));
                this.meta[i].setStorageType(ValueMeta.getStorageType((String)rep.getStepAttributeString(id_step, i, this.getRepCode("META_STORAGE_TYPE"))));
                this.meta[i].setConversionMask(rep.getStepAttributeString(id_step, i, this.getRepCode("META_CONVERSION_MASK")));
                this.meta[i].setDateFormatLenient(Boolean.parseBoolean(rep.getStepAttributeString(id_step, i, this.getRepCode("META_DATE_FORMAT_LENIENT"))));
                this.meta[i].setDateFormatLocale(rep.getStepAttributeString(id_step, i, this.getRepCode("META_DATE_FORMAT_LOCALE")));
                this.meta[i].setDateFormatTimeZone(rep.getStepAttributeString(id_step, i, this.getRepCode("META_DATE_FORMAT_TIMEZONE")));
                this.meta[i].setLenientStringToNumber(Boolean.parseBoolean(rep.getStepAttributeString(id_step, i, this.getRepCode("META_LENIENT_STRING_TO_NUMBER"))));
                this.meta[i].setDecimalSymbol(rep.getStepAttributeString(id_step, i, this.getRepCode("META_DECIMAL")));
                this.meta[i].setGroupingSymbol(rep.getStepAttributeString(id_step, i, this.getRepCode("META_GROUPING")));
                this.meta[i].setCurrencySymbol(rep.getStepAttributeString(id_step, i, this.getRepCode("META_CURRENCY")));
                this.meta[i].setEncoding(rep.getStepAttributeString(id_step, i, this.getRepCode("META_ENCODING")));
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SelectValuesMeta.Exception.UnexpectedErrorReadingStepInfoFromRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            int i;
            for (i = 0; i < this.selectName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("FIELD_NAME"), this.selectName[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("FIELD_RENAME"), this.selectRename[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("FIELD_LENGTH"), this.selectLength[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("FIELD_PRECISION"), this.selectPrecision[i]);
            }
            rep.saveStepAttribute(id_transformation, id_step, this.getRepCode("SELECT_UNSPECIFIED"), this.selectingAndSortingUnspecifiedFields);
            for (i = 0; i < this.deleteName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("REMOVE_NAME"), this.deleteName[i]);
            }
            for (i = 0; i < this.meta.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("META_NAME"), this.meta[i].getName());
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("META_RENAME"), this.meta[i].getRename());
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("META_TYPE"), this.meta[i].getType());
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("META_LENGTH"), this.meta[i].getLength());
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("META_PRECISION"), this.meta[i].getPrecision());
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("META_STORAGE_TYPE"), ValueMeta.getStorageTypeCode((int)this.meta[i].getStorageType()));
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("META_CONVERSION_MASK"), this.meta[i].getConversionMask());
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("META_DATE_FORMAT_LENIENT"), Boolean.toString(this.meta[i].isDateFormatLenient()));
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("META_DATE_FORMAT_LOCALE"), this.meta[i].getDateFormatLocale() == null ? null : this.meta[i].getDateFormatLocale().toString());
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("META_DATE_FORMAT_TIMEZONE"), this.meta[i].getDateFormatTimeZone() == null ? null : this.meta[i].getDateFormatTimeZone().toString());
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("META_LENIENT_STRING_TO_NUMBER"), Boolean.toString(this.meta[i].isLenientStringToNumber()));
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("META_DECIMAL"), this.meta[i].getDecimalSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("META_GROUPING"), this.meta[i].getGroupingSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("META_CURRENCY"), this.meta[i].getCurrencySymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, this.getRepCode("META_ENCODING"), this.meta[i].getEncoding());
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SelectValuesMeta.Exception.UnableToSaveStepInfoToRepository", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        boolean error_found;
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            int i;
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.StepReceivingFields", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            String error_message = "";
            error_found = false;
            for (i = 0; i < this.selectName.length; ++i) {
                int idx = prev.indexOfValue(this.selectName[i]);
                if (idx >= 0) continue;
                error_message = error_message + "\t\t" + this.selectName[i] + Const.CR;
                error_found = true;
            }
            if (error_found) {
                error_message = BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.SelectedFieldsNotFound", (String[])new String[0]) + Const.CR + Const.CR + error_message;
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.AllSelectedFieldsFound", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            if (this.selectName.length > 0) {
                for (i = 0; i < prev.size(); ++i) {
                    ValueMetaInterface pv = prev.getValueMeta(i);
                    int idx = Const.indexOfString((String)pv.getName(), (String[])this.selectName);
                    if (idx >= 0) continue;
                    error_message = error_message + "\t\t" + pv.getName() + " (" + pv.getTypeDesc() + ")" + Const.CR;
                    error_found = true;
                }
                if (error_found) {
                    error_message = BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.FieldsNotFound", (String[])new String[0]) + Const.CR + Const.CR + error_message;
                    cr = new CheckResult(2, error_message, (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                } else {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.AllSelectedFieldsFound2", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
            }
            error_message = "";
            error_found = false;
            for (i = 0; i < this.deleteName.length; ++i) {
                int idx = prev.indexOfValue(this.deleteName[i]);
                if (idx >= 0) continue;
                error_message = error_message + "\t\t" + this.deleteName[i] + Const.CR;
                error_found = true;
            }
            if (error_found) {
                error_message = BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.DeSelectedFieldsNotFound", (String[])new String[0]) + Const.CR + Const.CR + error_message;
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.AllDeSelectedFieldsFound", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            error_message = "";
            error_found = false;
            for (i = 0; i < this.meta.length; ++i) {
                int idx = prev.indexOfValue(this.meta[i].getName());
                if (idx >= 0) continue;
                error_message = error_message + "\t\t" + this.meta[i].getName() + Const.CR;
                error_found = true;
            }
            if (error_found) {
                error_message = BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.MetadataFieldsNotFound", (String[])new String[0]) + Const.CR + Const.CR + error_message;
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.AllMetadataFieldsFound", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.FieldsNotFound2", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.StepReceivingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.NoInputReceivedError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        int[] cnt = new int[this.selectName.length];
        error_found = false;
        String error_message = "";
        for (int i = 0; i < this.selectName.length; ++i) {
            cnt[i] = 0;
            for (int j = 0; j < this.selectName.length; ++j) {
                if (!this.selectName[i].equals(this.selectName[j])) continue;
                int n = i;
                cnt[n] = cnt[n] + 1;
            }
            if (cnt[i] <= 1) continue;
            if (!error_found) {
                error_message = BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.DuplicateFieldsSpecified", (String[])new String[0]) + Const.CR;
            } else {
                error_found = true;
            }
            error_message = error_message + BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.OccurentRow", (String[])new String[]{i + " : " + this.selectName[i] + "  (" + cnt[i]}) + Const.CR;
            error_found = true;
        }
        if (error_found) {
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new SelectValues(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new SelectValuesData();
    }

    public boolean isSelectingAndSortingUnspecifiedFields() {
        return this.selectingAndSortingUnspecifiedFields;
    }

    public void setSelectingAndSortingUnspecifiedFields(boolean selectingAndSortingUnspecifiedFields) {
        this.selectingAndSortingUnspecifiedFields = selectingAndSortingUnspecifiedFields;
    }

    public SelectMetadataChange[] getMeta() {
        return this.meta;
    }

    public void setMeta(SelectMetadataChange[] meta) {
        this.meta = meta;
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }

    public List<FieldnameLineage> getFieldnameLineage() {
        String output;
        String input;
        int i;
        ArrayList<FieldnameLineage> lineages = new ArrayList<FieldnameLineage>();
        for (i = 0; i < this.getSelectName().length; ++i) {
            input = this.getSelectName()[i];
            output = this.getSelectRename()[i];
            if (Const.isEmpty((String)output) || input.equalsIgnoreCase(output)) continue;
            lineages.add(new FieldnameLineage(input, output));
        }
        for (i = 0; i < this.getMeta().length; ++i) {
            input = this.getMeta()[i].getName();
            output = this.getMeta()[i].getRename();
            if (Const.isEmpty((String)output) || input.equalsIgnoreCase(output)) continue;
            int idx = Const.indexOfString((String)input, (String[])this.getSelectRename());
            if (idx < 0) {
                lineages.add(new FieldnameLineage(input, output));
                continue;
            }
            FieldnameLineage lineage = FieldnameLineage.findFieldnameLineageWithInput(lineages, input);
            lineage.setOutputFieldname(output);
        }
        return lineages;
    }

    @Override
    public StepMetaInjectionInterface getStepMetaInjectionInterface() {
        return this;
    }

    @Override
    public List<StepInjectionMetaEntry> getStepInjectionMetadataEntries() {
        return this.getStepInjectionMetadataEntries(PKG);
    }

    @Override
    public void injectStepMetadataEntries(List<StepInjectionMetaEntry> metadata) {
        for (StepInjectionMetaEntry entry : metadata) {
            String attributeValue;
            KettleAttributeInterface fieldAttr;
            StepInjectionMetaEntry fieldAttribute;
            int i;
            List<StepInjectionMetaEntry> fieldAttributes;
            int row;
            KettleAttributeInterface attr = this.findAttribute(entry.getKey());
            if (entry.getValueType() != 0) {
                if (entry.getKey().equals("SELECT_UNSPECIFIED")) {
                    this.selectingAndSortingUnspecifiedFields = (Boolean)entry.getValue();
                    continue;
                }
                throw new RuntimeException("Unhandled metadata injection of attribute: " + attr.toString() + " - " + attr.getDescription());
            }
            if (attr.getKey().equals("FIELDS")) {
                List<StepInjectionMetaEntry> selectFields = entry.getDetails();
                this.allocateSelect(selectFields.size());
                for (row = 0; row < selectFields.size(); ++row) {
                    StepInjectionMetaEntry selectField = selectFields.get(row);
                    fieldAttributes = selectField.getDetails();
                    for (i = 0; i < fieldAttributes.size(); ++i) {
                        fieldAttribute = fieldAttributes.get(i);
                        fieldAttr = this.findAttribute(fieldAttribute.getKey());
                        attributeValue = (String)fieldAttribute.getValue();
                        if (fieldAttr.getKey().equals("FIELD_NAME")) {
                            this.getSelectName()[row] = attributeValue;
                            continue;
                        }
                        if (fieldAttr.getKey().equals("FIELD_RENAME")) {
                            this.getSelectRename()[row] = attributeValue;
                            continue;
                        }
                        if (fieldAttr.getKey().equals("FIELD_LENGTH")) {
                            this.getSelectLength()[row] = attributeValue == null ? -1 : Integer.parseInt(attributeValue);
                            continue;
                        }
                        if (fieldAttr.getKey().equals("FIELD_PRECISION")) {
                            this.getSelectPrecision()[row] = attributeValue == null ? -1 : Integer.parseInt(attributeValue);
                            continue;
                        }
                        throw new RuntimeException("Unhandled metadata injection of attribute: " + fieldAttr.toString() + " - " + fieldAttr.getDescription());
                    }
                }
                continue;
            }
            if (attr.getKey().equals("REMOVES")) {
                List<StepInjectionMetaEntry> removeFields = entry.getDetails();
                this.allocateRemove(removeFields.size());
                for (row = 0; row < removeFields.size(); ++row) {
                    StepInjectionMetaEntry removeField = removeFields.get(row);
                    fieldAttributes = removeField.getDetails();
                    for (i = 0; i < fieldAttributes.size(); ++i) {
                        fieldAttribute = fieldAttributes.get(i);
                        fieldAttr = this.findAttribute(fieldAttribute.getKey());
                        attributeValue = (String)fieldAttribute.getValue();
                        if (!fieldAttr.getKey().equals("REMOVE_NAME")) {
                            throw new RuntimeException("Unhandled metadata injection of attribute: " + fieldAttr.toString() + " - " + fieldAttr.getDescription());
                        }
                        this.getDeleteName()[row] = attributeValue;
                    }
                }
                continue;
            }
            if (!attr.getKey().equals("METAS")) continue;
            List<StepInjectionMetaEntry> metaFields = entry.getDetails();
            this.allocateMeta(metaFields.size());
            for (row = 0; row < metaFields.size(); ++row) {
                StepInjectionMetaEntry metaField = metaFields.get(row);
                SelectMetadataChange metaChange = new SelectMetadataChange(this);
                List<StepInjectionMetaEntry> fieldAttributes2 = metaField.getDetails();
                for (int i2 = 0; i2 < fieldAttributes2.size(); ++i2) {
                    StepInjectionMetaEntry fieldAttribute2 = fieldAttributes2.get(i2);
                    KettleAttributeInterface fieldAttr2 = this.findAttribute(fieldAttribute2.getKey());
                    String attributeValue2 = (String)fieldAttribute2.getValue();
                    if (fieldAttr2.getKey().equals("META_NAME")) {
                        metaChange.setName(attributeValue2);
                        continue;
                    }
                    if (fieldAttr2.getKey().equals("META_RENAME")) {
                        metaChange.setRename(attributeValue2);
                        continue;
                    }
                    if (fieldAttr2.getKey().equals("META_TYPE")) {
                        metaChange.setType(ValueMeta.getType((String)attributeValue2));
                        continue;
                    }
                    if (fieldAttr2.getKey().equals("META_LENGTH")) {
                        metaChange.setLength(attributeValue2 == null ? -1 : Integer.parseInt(attributeValue2));
                        continue;
                    }
                    if (fieldAttr2.getKey().equals("META_PRECISION")) {
                        metaChange.setPrecision(attributeValue2 == null ? -1 : Integer.parseInt(attributeValue2));
                        continue;
                    }
                    if (fieldAttr2.getKey().equals("META_STORAGE_TYPE")) {
                        metaChange.setStorageType(ValueMeta.getStorageType((String)attributeValue2));
                        continue;
                    }
                    if (fieldAttr2.getKey().equals("META_CONVERSION_MASK")) {
                        metaChange.setConversionMask(attributeValue2);
                        continue;
                    }
                    if (fieldAttr2.getKey().equals("META_DATE_FORMAT_LENIENT")) {
                        metaChange.setDateFormatLenient(ValueMeta.convertStringToBoolean((String)attributeValue2) != null);
                        continue;
                    }
                    if (fieldAttr2.getKey().equals("META_DATE_FORMAT_LOCALE")) {
                        metaChange.setDateFormatLocale(attributeValue2);
                        continue;
                    }
                    if (fieldAttr2.getKey().equals("META_DATE_FORMAT_TIMEZONE")) {
                        metaChange.setDateFormatTimeZone(attributeValue2);
                        continue;
                    }
                    if (fieldAttr2.getKey().equals("META_LENIENT_STRING_TO_NUMBER")) {
                        metaChange.setLenientStringToNumber(ValueMeta.convertStringToBoolean((String)attributeValue2) != null);
                        continue;
                    }
                    if (fieldAttr2.getKey().equals("META_DECIMAL")) {
                        metaChange.setDecimalSymbol(attributeValue2);
                        continue;
                    }
                    if (fieldAttr2.getKey().equals("META_GROUPING")) {
                        metaChange.setGroupingSymbol(attributeValue2);
                        continue;
                    }
                    if (fieldAttr2.getKey().equals("META_CURRENCY")) {
                        metaChange.setCurrencySymbol(attributeValue2);
                        continue;
                    }
                    if (fieldAttr2.getKey().equals("META_ENCODING")) {
                        metaChange.setEncoding(attributeValue2);
                        continue;
                    }
                    throw new RuntimeException("Unhandled metadata injection of attribute: " + fieldAttr2.getKey() + " - " + fieldAttr2.getDescription());
                }
                this.meta[row] = metaChange;
            }
            break;
        }
    }

    @Override
    public List<StepInjectionMetaEntry> extractStepMetadataEntries() throws KettleException {
        return null;
    }
}

