/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.prioritizestreams;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.prioritizestreams.PrioritizeStreams;
import org.pentaho.di.trans.steps.prioritizestreams.PrioritizeStreamsData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class PrioritizeStreamsMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = PrioritizeStreamsMeta.class;
    private String[] stepName;

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    @Override
    public Object clone() {
        PrioritizeStreamsMeta retval = (PrioritizeStreamsMeta)super.clone();
        int nrfields = this.stepName.length;
        retval.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            retval.stepName[i] = this.stepName[i];
        }
        return retval;
    }

    public void allocate(int nrfields) {
        this.stepName = new String[nrfields];
    }

    public String[] getStepName() {
        return this.stepName;
    }

    public void setStepName(String[] stepName) {
        this.stepName = stepName;
    }

    @Override
    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            Node steps = XMLHandler.getSubNode((Node)stepnode, (String)"steps");
            int nrsteps = XMLHandler.countNodes((Node)steps, (String)"step");
            this.allocate(nrsteps);
            for (int i = 0; i < nrsteps; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)steps, (String)"step", (int)i);
                this.stepName[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("    <steps>" + Const.CR);
        for (int i = 0; i < this.stepName.length; ++i) {
            retval.append("      <step>" + Const.CR);
            retval.append("        " + XMLHandler.addTagValue((String)"name", (String)this.stepName[i]));
            retval.append("        </step>" + Const.CR);
        }
        retval.append("      </steps>" + Const.CR);
        return retval.toString();
    }

    @Override
    public void setDefault() {
        int nrsteps = 0;
        this.allocate(nrsteps);
        for (int i = 0; i < nrsteps; ++i) {
            this.stepName[i] = "step" + i;
        }
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int nrsteps = rep.countNrStepAttributes(id_step, "step_name");
            this.allocate(nrsteps);
            for (int i = 0; i < nrsteps; ++i) {
                this.stepName[i] = rep.getStepAttributeString(id_step, i, "step_name");
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            for (int i = 0; i < this.stepName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "step_name", this.stepName[i]);
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"PrioritizeStreamsMeta.CheckResult.NotReceivingFields", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else if (this.stepName.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"PrioritizeStreamsMeta.CheckResult.AllStepsFound", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"PrioritizeStreamsMeta.CheckResult.NoStepsEntered", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"PrioritizeStreamsMeta.CheckResult.StepRecevingData2", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"PrioritizeStreamsMeta.CheckResult.NoInputReceivedFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new PrioritizeStreams(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new PrioritizeStreamsData();
    }
}

