/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.excelinput.poi;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.pentaho.di.core.spreadsheet.KCell;
import org.pentaho.di.core.spreadsheet.KSheet;
import org.pentaho.di.trans.steps.excelinput.poi.PoiCell;

public class PoiSheet
implements KSheet {
    private Sheet sheet;

    public PoiSheet(Sheet sheet) {
        this.sheet = sheet;
    }

    public String getName() {
        return this.sheet.getSheetName();
    }

    public KCell[] getRow(int rownr) {
        if (rownr < this.sheet.getFirstRowNum()) {
            return new KCell[0];
        }
        if (rownr > this.sheet.getLastRowNum()) {
            throw new ArrayIndexOutOfBoundsException("Read beyond last row: " + rownr);
        }
        Row row = this.sheet.getRow(rownr);
        if (row == null) {
            return new KCell[0];
        }
        int cols = row.getLastCellNum();
        if (cols < 0) {
            return new KCell[0];
        }
        KCell[] xlsCells = new PoiCell[cols];
        for (int i = 0; i < cols; ++i) {
            Cell cell = row.getCell(i);
            if (cell == null) continue;
            xlsCells[i] = new PoiCell(cell);
        }
        return xlsCells;
    }

    public int getRows() {
        return this.sheet.getLastRowNum() + 1;
    }

    public KCell getCell(int colnr, int rownr) {
        Row row = this.sheet.getRow(rownr);
        if (row == null) {
            return null;
        }
        Cell cell = row.getCell(colnr);
        if (cell == null) {
            return null;
        }
        return new PoiCell(cell);
    }
}

