/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.accessinput;

import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.i18n.BaseMessages;

public class AccessInputField
implements Cloneable {
    private static Class<?> PKG = AccessInputField.class;
    public static final int TYPE_TRIM_NONE = 0;
    public static final int TYPE_TRIM_LEFT = 1;
    public static final int TYPE_TRIM_RIGHT = 2;
    public static final int TYPE_TRIM_BOTH = 3;
    public static final String[] trimTypeCode = new String[]{"none", "left", "right", "both"};
    public static final String[] trimTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"AccessInputField.TrimType.None", (String[])new String[0]), BaseMessages.getString(PKG, (String)"AccessInputField.TrimType.Left", (String[])new String[0]), BaseMessages.getString(PKG, (String)"AccessInputField.TrimType.Right", (String[])new String[0]), BaseMessages.getString(PKG, (String)"AccessInputField.TrimType.Both", (String[])new String[0])};
    private String name;
    private String Column;
    private int type;
    private int length;
    private String format;
    private int trimtype;
    private int precision;
    private String currencySymbol;
    private String decimalSymbol;
    private String groupSymbol;
    private boolean repeat;
    private String[] samples;

    public AccessInputField(String fieldname) {
        this.name = fieldname;
        this.Column = "";
        this.length = -1;
        this.type = 2;
        this.format = "";
        this.trimtype = 0;
        this.groupSymbol = "";
        this.decimalSymbol = "";
        this.currencySymbol = "";
        this.precision = -1;
        this.repeat = false;
    }

    public AccessInputField() {
        this(null);
    }

    public static final int getTrimTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < trimTypeCode.length; ++i) {
            if (!trimTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static final int getTrimTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < trimTypeDesc.length; ++i) {
            if (!trimTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static final String getTrimTypeCode(int i) {
        if (i < 0 || i >= trimTypeCode.length) {
            return trimTypeCode[0];
        }
        return trimTypeCode[i];
    }

    public static final String getTrimTypeDesc(int i) {
        if (i < 0 || i >= trimTypeDesc.length) {
            return trimTypeDesc[0];
        }
        return trimTypeDesc[i];
    }

    public Object clone() {
        try {
            AccessInputField retval = (AccessInputField)super.clone();
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getName() {
        return this.name;
    }

    public String getColumn() {
        return this.Column;
    }

    public void setColumn(String fieldcolumn) {
        this.Column = fieldcolumn;
    }

    public void setName(String fieldname) {
        this.name = fieldname;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeDesc() {
        return ValueMeta.getTypeDesc((int)this.type);
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setSamples(String[] samples) {
        this.samples = samples;
    }

    public String[] getSamples() {
        return this.samples;
    }

    public int getTrimType() {
        return this.trimtype;
    }

    public String getTrimTypeCode() {
        return AccessInputField.getTrimTypeCode(this.trimtype);
    }

    public String getTrimTypeDesc() {
        return AccessInputField.getTrimTypeDesc(this.trimtype);
    }

    public void setTrimType(int trimtype) {
        this.trimtype = trimtype;
    }

    public String getGroupSymbol() {
        return this.groupSymbol;
    }

    public void setGroupSymbol(String group_symbol) {
        this.groupSymbol = group_symbol;
    }

    public String getDecimalSymbol() {
        return this.decimalSymbol;
    }

    public void setDecimalSymbol(String decimal_symbol) {
        this.decimalSymbol = decimal_symbol;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setCurrencySymbol(String currency_symbol) {
        this.currencySymbol = currency_symbol;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public boolean isRepeated() {
        return this.repeat;
    }

    public void setRepeated(boolean repeat) {
        this.repeat = repeat;
    }

    public void flipRepeated() {
        this.repeat = !this.repeat;
    }
}

