/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pentaho.di.trans.step.StepIOMetaInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;

public class StepIOMeta
implements StepIOMetaInterface,
Cloneable {
    private boolean inputAcceptor;
    private boolean outputProducer;
    private boolean inputOptional;
    private boolean outputDynamic;
    private boolean inputDynamic;
    private List<StreamInterface> streams;
    private boolean sortedDataRequired;
    private String generalInfoDescription;
    private String generalTargetDescription;

    public StepIOMeta(boolean inputAcceptor, boolean outputProducer, boolean inputOptional, boolean sortedDataRequired, boolean inputDynamic, boolean outputDynamic) {
        this.inputAcceptor = inputAcceptor;
        this.outputProducer = outputProducer;
        this.inputOptional = inputOptional;
        this.sortedDataRequired = sortedDataRequired;
        this.streams = Collections.synchronizedList(new ArrayList());
        this.inputDynamic = inputDynamic;
        this.outputDynamic = outputDynamic;
    }

    protected StepIOMeta clone() throws CloneNotSupportedException {
        StepIOMeta ioMeta = (StepIOMeta)super.clone();
        ioMeta.streams = new ArrayList<StreamInterface>();
        ioMeta.streams.addAll(this.streams);
        return ioMeta;
    }

    @Override
    public boolean isInputAcceptor() {
        return this.inputAcceptor;
    }

    public void setInputAcceptor(boolean inputAcceptor) {
        this.inputAcceptor = inputAcceptor;
    }

    @Override
    public boolean isOutputProducer() {
        return this.outputProducer;
    }

    public void setOutputProducer(boolean outputProducer) {
        this.outputProducer = outputProducer;
    }

    @Override
    public boolean isInputOptional() {
        return this.inputOptional;
    }

    public void setInputOptional(boolean inputOptional) {
        this.inputOptional = inputOptional;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<StreamInterface> getInfoStreams() {
        ArrayList<StreamInterface> list = new ArrayList<StreamInterface>();
        List<StreamInterface> list2 = this.streams;
        synchronized (list2) {
            for (StreamInterface stream : this.streams) {
                if (!stream.getStreamType().equals((Object)StreamInterface.StreamType.INFO)) continue;
                list.add(stream);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<StreamInterface> getTargetStreams() {
        ArrayList<StreamInterface> list = new ArrayList<StreamInterface>();
        List<StreamInterface> list2 = this.streams;
        synchronized (list2) {
            for (StreamInterface stream : this.streams) {
                if (!stream.getStreamType().equals((Object)StreamInterface.StreamType.TARGET)) continue;
                list.add(stream);
            }
        }
        return list;
    }

    @Override
    public boolean isSortedDataRequired() {
        return this.sortedDataRequired;
    }

    public void setSortedDataRequired(boolean sortedDataRequired) {
        this.sortedDataRequired = sortedDataRequired;
    }

    @Override
    public void addStream(StreamInterface stream) {
        this.streams.add(stream);
    }

    @Override
    public String[] getInfoStepnames() {
        List<StreamInterface> infoStreams = this.getInfoStreams();
        String[] names = new String[infoStreams.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = infoStreams.get(i).getStepname();
        }
        return names;
    }

    @Override
    public String[] getTargetStepnames() {
        List<StreamInterface> targetStreams = this.getTargetStreams();
        String[] names = new String[targetStreams.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = targetStreams.get(i).getStepname();
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInfoSteps(StepMeta[] infoSteps) {
        ArrayList<StreamInterface> list = new ArrayList<StreamInterface>();
        List<StreamInterface> list2 = this.streams;
        synchronized (list2) {
            for (StreamInterface stream : this.streams) {
                if (!stream.getStreamType().equals((Object)StreamInterface.StreamType.INFO)) continue;
                list.add(stream);
            }
        }
        for (int i = 0; i < infoSteps.length; ++i) {
            if (i >= list.size()) {
                throw new RuntimeException("We expect all possible info streams to be pre-populated!");
            }
            this.streams.get(i).setStepMeta(infoSteps[i]);
        }
    }

    @Override
    public String getGeneralInfoDescription() {
        return this.generalInfoDescription;
    }

    @Override
    public void setGeneralInfoDescription(String generalInfoDescription) {
        this.generalInfoDescription = generalInfoDescription;
    }

    @Override
    public String getGeneralTargetDescription() {
        return this.generalTargetDescription;
    }

    @Override
    public void setGeneralTargetDescription(String generalTargetDescription) {
        this.generalTargetDescription = generalTargetDescription;
    }

    public void clearStreams() {
        this.streams.clear();
    }

    @Override
    public boolean isOutputDynamic() {
        return this.outputDynamic;
    }

    @Override
    public void setOutputDynamic(boolean outputDynamic) {
        this.outputDynamic = outputDynamic;
    }

    @Override
    public boolean isInputDynamic() {
        return this.inputDynamic;
    }

    @Override
    public void setInputDynamic(boolean inputDynamic) {
        this.inputDynamic = inputDynamic;
    }

    @Override
    public StreamInterface findTargetStream(StepMeta targetStep) {
        for (StreamInterface stream : this.getTargetStreams()) {
            if (!targetStep.equals(stream.getStepMeta())) continue;
            return stream;
        }
        return null;
    }

    @Override
    public StreamInterface findInfoStream(StepMeta infoStep) {
        for (StreamInterface stream : this.getInfoStreams()) {
            if (!infoStep.equals(stream.getStepMeta())) continue;
            return stream;
        }
        return null;
    }
}

