/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.partition.PartitionSchema;
import org.w3c.dom.Node;

public class SlaveStepCopyPartitionDistribution {
    public static final String XML_TAG = "slave-step-copy-partition-distribution";
    private Map<SlaveStepCopy, Integer> distribution = new Hashtable<SlaveStepCopy, Integer>();
    private List<PartitionSchema> originalPartitionSchemas;

    public SlaveStepCopyPartitionDistribution() {
    }

    public void addPartition(String slaveServerName, String partitionSchemaName, int stepCopyNr, int partitionNr) {
        this.distribution.put(new SlaveStepCopy(slaveServerName, partitionSchemaName, stepCopyNr), partitionNr);
    }

    public int addPartition(String slaveServerName, String partitionSchemaName, int stepCopyNr) {
        Integer partitionNr = this.distribution.get(new SlaveStepCopy(slaveServerName, partitionSchemaName, stepCopyNr));
        if (partitionNr == null) {
            int nr = 0;
            for (SlaveStepCopy slaveStepCopy : this.distribution.keySet()) {
                if (!slaveStepCopy.partitionSchemaName.equals(partitionSchemaName)) continue;
                ++nr;
            }
            partitionNr = nr;
            this.addPartition(slaveServerName, partitionSchemaName, stepCopyNr, nr);
        }
        return partitionNr;
    }

    private int getPartition(SlaveStepCopy slaveStepCopy) {
        Integer integer = this.distribution.get(slaveStepCopy);
        if (integer == null) {
            return -1;
        }
        return integer;
    }

    public int getPartition(String slaveServerName, String partitionSchemaName, int stepCopyNr) {
        return this.getPartition(new SlaveStepCopy(slaveServerName, partitionSchemaName, stepCopyNr));
    }

    public String getXML() {
        StringBuilder xml = new StringBuilder(200);
        xml.append(XMLHandler.openTag((String)XML_TAG)).append(Const.CR);
        ArrayList<SlaveStepCopy> list = new ArrayList<SlaveStepCopy>(this.distribution.keySet());
        Collections.sort(list);
        for (SlaveStepCopy copy : list) {
            int partition = this.getPartition(copy);
            xml.append("  ").append(XMLHandler.openTag((String)"entry"));
            xml.append("  ").append(XMLHandler.addTagValue((String)"slavename", (String)copy.slaveServerName, (boolean)false, (String[])new String[0]));
            xml.append("  ").append(XMLHandler.addTagValue((String)"partition_schema_name", (String)copy.partitionSchemaName, (boolean)false, (String[])new String[0]));
            xml.append("  ").append(XMLHandler.addTagValue((String)"stepcopy", (int)copy.stepCopyNr, (boolean)false));
            xml.append("  ").append(XMLHandler.addTagValue((String)"partition", (int)partition, (boolean)false));
            xml.append(XMLHandler.closeTag((String)"entry")).append(Const.CR);
        }
        if (this.originalPartitionSchemas != null) {
            xml.append("  ").append(XMLHandler.openTag((String)"original-partition-schemas"));
            for (PartitionSchema partitionSchema : this.originalPartitionSchemas) {
                xml.append(partitionSchema.getXML());
            }
            xml.append("  ").append(XMLHandler.closeTag((String)"original-partition-schemas"));
        }
        xml.append(XMLHandler.closeTag((String)XML_TAG)).append(Const.CR);
        return xml.toString();
    }

    public SlaveStepCopyPartitionDistribution(Node node) {
        this();
        int nrEntries = XMLHandler.countNodes((Node)node, (String)"entry");
        for (int i = 0; i < nrEntries; ++i) {
            Node entryNode = XMLHandler.getSubNodeByNr((Node)node, (String)"entry", (int)i);
            String slaveServerName = XMLHandler.getTagValue((Node)entryNode, (String)"slavename");
            String partitionSchemaName = XMLHandler.getTagValue((Node)entryNode, (String)"partition_schema_name");
            int stepCopyNr = Const.toInt((String)XMLHandler.getTagValue((Node)entryNode, (String)"stepcopy"), (int)-1);
            int partitionNr = Const.toInt((String)XMLHandler.getTagValue((Node)entryNode, (String)"partition"), (int)-1);
            this.addPartition(slaveServerName, partitionSchemaName, stepCopyNr, partitionNr);
        }
        Node originalPartitionSchemasNode = XMLHandler.getSubNode((Node)node, (String)"original-partition-schemas");
        if (originalPartitionSchemasNode != null) {
            this.originalPartitionSchemas = new ArrayList<PartitionSchema>();
            int nrSchemas = XMLHandler.countNodes((Node)originalPartitionSchemasNode, (String)"partitionschema");
            for (int i = 0; i < nrSchemas; ++i) {
                Node schemaNode = XMLHandler.getSubNodeByNr((Node)originalPartitionSchemasNode, (String)"partitionschema", (int)i);
                PartitionSchema originalPartitionSchema = new PartitionSchema(schemaNode);
                this.originalPartitionSchemas.add(originalPartitionSchema);
            }
        }
    }

    public Map<SlaveStepCopy, Integer> getDistribution() {
        return this.distribution;
    }

    public List<PartitionSchema> getOriginalPartitionSchemas() {
        return this.originalPartitionSchemas;
    }

    public void setOriginalPartitionSchemas(List<PartitionSchema> originalPartitionSchemas) {
        this.originalPartitionSchemas = originalPartitionSchemas;
    }

    public class SlaveStepCopy
    implements Comparable<SlaveStepCopy> {
        private String slaveServerName;
        private String partitionSchemaName;
        private int stepCopyNr;

        public SlaveStepCopy(String slaveServerName, String partitionSchemaName, int stepCopyNr) {
            this.slaveServerName = slaveServerName;
            this.partitionSchemaName = partitionSchemaName;
            this.stepCopyNr = stepCopyNr;
        }

        public String toString() {
            return this.slaveServerName + "/" + this.partitionSchemaName + "." + this.stepCopyNr;
        }

        public boolean equals(Object obj) {
            SlaveStepCopy copy = (SlaveStepCopy)obj;
            return this.slaveServerName.equals(copy.slaveServerName) && this.partitionSchemaName.equals(copy.partitionSchemaName) && this.stepCopyNr == copy.stepCopyNr;
        }

        public int hashCode() {
            try {
                return this.slaveServerName.hashCode() ^ this.partitionSchemaName.hashCode() ^ Integer.valueOf(this.stepCopyNr).hashCode();
            }
            catch (NullPointerException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public int compareTo(SlaveStepCopy o) {
            int cmp = this.slaveServerName.compareTo(o.slaveServerName);
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.partitionSchemaName.compareTo(o.partitionSchemaName);
            if (cmp != 0) {
                return cmp;
            }
            return this.stepCopyNr - o.stepCopyNr;
        }

        public String getSlaveServerName() {
            return this.slaveServerName;
        }

        public void setSlaveServerName(String slaveServerName) {
            this.slaveServerName = slaveServerName;
        }

        public String getPartitionSchemaName() {
            return this.partitionSchemaName;
        }

        public void setStepName(String partitionSchemaName) {
            this.partitionSchemaName = partitionSchemaName;
        }

        public int getStepCopyNr() {
            return this.stepCopyNr;
        }

        public void setStepCopyNr(int stepCopyNr) {
            this.stepCopyNr = stepCopyNr;
        }
    }
}

