/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.kdr.delegates;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.di.cluster.ClusterSchema;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.NotePadMeta;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogTableInterface;
import org.pentaho.di.core.logging.TransLogTable;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.partition.PartitionSchema;
import org.pentaho.di.repository.LongObjectId;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.repository.kdr.KettleDatabaseRepository;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryBaseDelegate;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryTransAttribute;
import org.pentaho.di.shared.SharedObjects;
import org.pentaho.di.trans.TransDependency;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepErrorMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.StepPartitioningMeta;
import org.pentaho.di.trans.steps.missing.MissingTrans;

public class KettleDatabaseRepositoryTransDelegate
extends KettleDatabaseRepositoryBaseDelegate {
    private static Class<?> PKG = TransMeta.class;
    private static final String TRANS_ATTRIBUTE_PREFIX_DELIMITER = "_";
    public static final String TRANS_ATTRIBUTE_PREFIX = "_ATTR__";

    public KettleDatabaseRepositoryTransDelegate(KettleDatabaseRepository repository) {
        super(repository);
    }

    public RowMetaAndData getTransformation(ObjectId id_transformation) throws KettleException {
        return this.repository.connectionDelegate.getOneRow(this.quoteTable("R_TRANSFORMATION"), this.quote("ID_TRANSFORMATION"), id_transformation);
    }

    public RowMetaAndData getTransHop(ObjectId id_trans_hop) throws KettleException {
        return this.repository.connectionDelegate.getOneRow(this.quoteTable("R_TRANS_HOP"), this.quote("ID_TRANS_HOP"), id_trans_hop);
    }

    public RowMetaAndData getTransDependency(ObjectId id_dependency) throws KettleException {
        return this.repository.connectionDelegate.getOneRow(this.quoteTable("R_DEPENDENCY"), this.quote("ID_DEPENDENCY"), id_dependency);
    }

    public boolean existsTransMeta(String name, RepositoryDirectoryInterface repositoryDirectory, RepositoryObjectType objectType) throws KettleException {
        try {
            return this.getTransformationID(name, repositoryDirectory.getObjectId()) != null;
        }
        catch (KettleException e) {
            throw new KettleException("Unable to verify if the transformation with name [" + name + "] in directory [" + repositoryDirectory + "] exists", (Throwable)e);
        }
    }

    public synchronized ObjectId getTransformationID(String name, ObjectId id_directory) throws KettleException {
        return this.repository.connectionDelegate.getIDWithValue(this.quoteTable("R_TRANSFORMATION"), this.quote("ID_TRANSFORMATION"), this.quote("NAME"), name, this.quote("ID_DIRECTORY"), id_directory);
    }

    public synchronized ObjectId getTransHopID(ObjectId id_transformation, ObjectId id_step_from, ObjectId id_step_to) throws KettleException {
        String[] lookupkey = new String[]{this.quote("ID_TRANSFORMATION"), this.quote("ID_STEP_FROM"), this.quote("ID_STEP_TO")};
        ObjectId[] key = new ObjectId[]{id_transformation, id_step_from, id_step_to};
        return this.repository.connectionDelegate.getIDWithValue(this.quoteTable("R_TRANS_HOP"), this.quote("ID_TRANS_HOP"), lookupkey, key);
    }

    public synchronized ObjectId getDependencyID(ObjectId id_transformation, ObjectId id_database, String tablename) throws KettleException {
        String[] lookupkey = new String[]{this.quote("ID_TRANSFORMATION"), this.quote("ID_DATABASE")};
        ObjectId[] key = new ObjectId[]{id_transformation, id_database};
        return this.repository.connectionDelegate.getIDWithValue(this.quoteTable("R_DEPENDENCY"), this.quote("ID_DEPENDENCY"), this.quote("TABLE_NAME"), tablename, lookupkey, key);
    }

    public void saveTransformation(TransMeta transMeta, String versionComment, ProgressMonitorListener monitor, boolean overwriteAssociated) throws KettleException {
        try {
            boolean isUsedByTransformation;
            StepMeta stepMeta;
            int i;
            if (monitor != null) {
                monitor.subTask(BaseMessages.getString(PKG, (String)"TransMeta.Monitor.LockingRepository", (String[])new String[0]));
            }
            this.repository.insertLogEntry("save transformation '" + transMeta.getName() + "'");
            this.repository.connectionDelegate.clearNextIDCounters();
            if (transMeta.getRepositoryDirectory().getObjectId() == null) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"TransMeta.Exception.PlsSelectAValidDirectoryBeforeSavingTheTransformation", (String[])new String[0]));
            }
            int nrWorks = 2 + transMeta.nrDatabases() + transMeta.nrNotes() + transMeta.nrSteps() + transMeta.nrTransHops();
            if (monitor != null) {
                monitor.beginTask(BaseMessages.getString(PKG, (String)"TransMeta.Monitor.SavingTransformationTask.Title", (String[])new String[0]) + transMeta.getPathAndName(), nrWorks);
            }
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"TransMeta.Log.SavingOfTransformationStarted", (String[])new String[0]));
            }
            if (monitor != null && monitor.isCanceled()) {
                throw new KettleDatabaseException();
            }
            if (monitor != null) {
                monitor.subTask(BaseMessages.getString(PKG, (String)"TransMeta.Monitor.HandlingOldVersionTransformationTask.Title", (String[])new String[0]));
            }
            if (transMeta.getObjectId() == null) {
                transMeta.setObjectId(this.repository.connectionDelegate.getNextTransformationID());
            } else {
                if (monitor != null) {
                    monitor.subTask(BaseMessages.getString(PKG, (String)"TransMeta.Monitor.DeletingOldVersionTransformationTask.Title", (String[])new String[0]));
                }
                if (this.log.isDebug()) {
                    this.log.logDebug(BaseMessages.getString(PKG, (String)"TransMeta.Log.DeletingOldVersionTransformation", (String[])new String[0]));
                }
                this.repository.deleteTransformation(transMeta.getObjectId());
                if (this.log.isDebug()) {
                    this.log.logDebug(BaseMessages.getString(PKG, (String)"TransMeta.Log.OldVersionOfTransformationRemoved", (String[])new String[0]));
                }
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"TransMeta.Log.SavingNotes", (String[])new String[0]));
            }
            for (i = 0; i < transMeta.nrNotes(); ++i) {
                if (monitor != null && monitor.isCanceled()) {
                    throw new KettleDatabaseException(BaseMessages.getString(PKG, (String)"TransMeta.Log.UserCancelledTransSave", (String[])new String[0]));
                }
                NotePadMeta ni = transMeta.getNote(i);
                this.repository.saveNotePadMeta(ni, transMeta.getObjectId());
                if (ni.getObjectId() != null) {
                    this.repository.insertTransNote(transMeta.getObjectId(), ni.getObjectId());
                }
                if (monitor == null) continue;
                monitor.worked(1);
            }
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"TransMeta.Log.SavingDatabaseConnections", (String[])new String[0]));
            }
            for (i = 0; i < transMeta.nrDatabases(); ++i) {
                if (monitor != null && monitor.isCanceled()) {
                    throw new KettleDatabaseException(BaseMessages.getString(PKG, (String)"TransMeta.Log.UserCancelledTransSave", (String[])new String[0]));
                }
                DatabaseMeta databaseMeta = transMeta.getDatabase(i);
                if (overwriteAssociated || databaseMeta.hasChanged() || databaseMeta.getObjectId() == null) {
                    this.repository.save((RepositoryElementInterface)databaseMeta, versionComment, monitor, overwriteAssociated);
                }
                if (monitor == null) continue;
                monitor.worked(1);
            }
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"TransMeta.Log.CheckingStepTypes", (String[])new String[0]));
            }
            this.repository.updateStepTypes();
            this.repository.updateDatabaseTypes();
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"TransMeta.Log.SavingSteps", (String[])new String[0]));
            }
            for (i = 0; i < transMeta.nrSteps(); ++i) {
                if (monitor != null && monitor.isCanceled()) {
                    throw new KettleDatabaseException(BaseMessages.getString(PKG, (String)"TransMeta.Log.UserCancelledTransSave", (String[])new String[0]));
                }
                stepMeta = transMeta.getStep(i);
                this.repository.stepDelegate.saveStepMeta(stepMeta, transMeta.getObjectId());
                if (monitor == null) continue;
                monitor.worked(1);
            }
            this.repository.connectionDelegate.closeStepAttributeInsertPreparedStatement();
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"TransMeta.Log.SavingHops", (String[])new String[0]));
            }
            for (i = 0; i < transMeta.nrTransHops(); ++i) {
                if (monitor != null && monitor.isCanceled()) {
                    throw new KettleDatabaseException(BaseMessages.getString(PKG, (String)"TransMeta.Log.UserCancelledTransSave", (String[])new String[0]));
                }
                TransHopMeta hi = transMeta.getTransHop(i);
                this.saveTransHopMeta(hi, transMeta.getObjectId());
                if (monitor == null) continue;
                monitor.worked(1);
            }
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"TransMeta.Log.SavingTransformationInfo", (String[])new String[0]));
            }
            this.insertTransformation(transMeta);
            this.saveTransParameters(transMeta);
            this.repository.connectionDelegate.closeTransAttributeInsertPreparedStatement();
            for (i = 0; i < transMeta.getPartitionSchemas().size(); ++i) {
                if (monitor != null && monitor.isCanceled()) {
                    throw new KettleDatabaseException(BaseMessages.getString(PKG, (String)"TransMeta.Log.UserCancelledTransSave", (String[])new String[0]));
                }
                PartitionSchema partitionSchema = transMeta.getPartitionSchemas().get(i);
                isUsedByTransformation = transMeta.isUsingPartitionSchema(partitionSchema);
                this.repository.save(partitionSchema, versionComment, null, transMeta.getObjectId(), isUsedByTransformation, overwriteAssociated);
            }
            for (i = 0; i < transMeta.getSlaveServers().size(); ++i) {
                if (monitor != null && monitor.isCanceled()) {
                    throw new KettleDatabaseException(BaseMessages.getString(PKG, (String)"TransMeta.Log.UserCancelledTransSave", (String[])new String[0]));
                }
                SlaveServer slaveServer = transMeta.getSlaveServers().get(i);
                isUsedByTransformation = transMeta.isUsingSlaveServer(slaveServer);
                this.repository.save(slaveServer, versionComment, null, transMeta.getObjectId(), isUsedByTransformation, overwriteAssociated);
            }
            for (i = 0; i < transMeta.getClusterSchemas().size(); ++i) {
                if (monitor != null && monitor.isCanceled()) {
                    throw new KettleDatabaseException(BaseMessages.getString(PKG, (String)"TransMeta.Log.UserCancelledTransSave", (String[])new String[0]));
                }
                ClusterSchema clusterSchema = transMeta.getClusterSchemas().get(i);
                isUsedByTransformation = transMeta.isUsingClusterSchema(clusterSchema);
                this.repository.save(clusterSchema, versionComment, null, transMeta.getObjectId(), isUsedByTransformation, overwriteAssociated);
            }
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"TransMeta.Log.SavingDependencies", (String[])new String[0]));
            }
            for (i = 0; i < transMeta.nrDependencies(); ++i) {
                if (monitor != null && monitor.isCanceled()) {
                    throw new KettleDatabaseException(BaseMessages.getString(PKG, (String)"TransMeta.Log.UserCancelledTransSave", (String[])new String[0]));
                }
                TransDependency td = transMeta.getDependency(i);
                this.saveTransDependency(td, transMeta.getObjectId());
            }
            this.saveTransAttributesMap(transMeta.getObjectId(), transMeta.getAttributesMap());
            for (i = 0; i < transMeta.nrSteps(); ++i) {
                stepMeta = transMeta.getStep(i);
                StepErrorMeta stepErrorMeta = stepMeta.getStepErrorMeta();
                if (stepErrorMeta == null) continue;
                this.repository.stepDelegate.saveStepErrorMeta(stepErrorMeta, transMeta.getObjectId(), stepMeta.getObjectId());
            }
            this.repository.connectionDelegate.closeStepAttributeInsertPreparedStatement();
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"TransMeta.Log.SavingFinished", (String[])new String[0]));
            }
            if (monitor != null) {
                monitor.subTask(BaseMessages.getString(PKG, (String)"TransMeta.Monitor.UnlockingRepository", (String[])new String[0]));
            }
            this.repository.unlockRepository();
            this.repository.commit();
            transMeta.clearChanged();
            if (monitor != null) {
                monitor.worked(1);
            }
            if (monitor != null) {
                monitor.done();
            }
        }
        catch (KettleDatabaseException dbe) {
            this.repository.rollback();
            this.log.logError(BaseMessages.getString(PKG, (String)"TransMeta.Log.ErrorSavingTransformationToRepository", (String[])new String[0]) + Const.CR + dbe.getMessage());
            throw new KettleException(BaseMessages.getString(PKG, (String)"TransMeta.Log.ErrorSavingTransformationToRepository", (String[])new String[0]), (Throwable)dbe);
        }
    }

    public void saveTransParameters(TransMeta transMeta) throws KettleException {
        String[] paramKeys = transMeta.listParameters();
        for (int idx = 0; idx < paramKeys.length; ++idx) {
            String desc = transMeta.getParameterDescription(paramKeys[idx]);
            String defaultValue = transMeta.getParameterDefault(paramKeys[idx]);
            this.insertTransParameter(transMeta.getObjectId(), idx, paramKeys[idx], defaultValue, desc);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TransMeta loadTransformation(TransMeta transMeta, String transname, RepositoryDirectoryInterface repdir, ProgressMonitorListener monitor, boolean setInternalVariables) throws KettleException {
        transMeta.setRepository(this.repository);
        transMeta.setMetaStore(this.repository.metaStore);
        KettleDatabaseRepository kettleDatabaseRepository = this.repository;
        synchronized (kettleDatabaseRepository) {
            try {
                int i;
                int i2;
                String pathAndName = repdir.isRoot() ? repdir + transname : repdir + "/" + transname;
                transMeta.setName(transname);
                transMeta.setRepositoryDirectory(repdir);
                if (this.log.isDetailed()) {
                    this.log.logDetailed(BaseMessages.getString(PKG, (String)"TransMeta.Log.LookingForTransformation", (String[])new String[]{transname, repdir.getPath()}));
                }
                if (monitor != null) {
                    monitor.subTask(BaseMessages.getString(PKG, (String)"TransMeta.Monitor.ReadingTransformationInfoTask.Title", (String[])new String[0]));
                }
                transMeta.setObjectId(this.getTransformationID(transname, repdir.getObjectId()));
                if (monitor != null) {
                    monitor.worked(1);
                }
                if (transMeta.getObjectId() == null) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"TransMeta.Exception.TransformationDoesNotExist", (String[])new String[0]) + transMeta.getName());
                }
                ObjectId[] noteids = this.repository.getTransNoteIDs(transMeta.getObjectId());
                ObjectId[] stepids = this.repository.getStepIDs(transMeta.getObjectId());
                ObjectId[] hopids = this.getTransHopIDs(transMeta.getObjectId());
                int nrWork = 3 + noteids.length + stepids.length + hopids.length;
                if (monitor != null) {
                    monitor.beginTask(BaseMessages.getString(PKG, (String)"TransMeta.Monitor.LoadingTransformationTask.Title", (String[])new String[0]) + pathAndName, nrWork);
                }
                if (this.log.isDetailed()) {
                    this.log.logDetailed(BaseMessages.getString(PKG, (String)"TransMeta.Log.LoadingTransformation", (String[])new String[]{transMeta.getName()}));
                }
                if (monitor != null) {
                    monitor.subTask(BaseMessages.getString(PKG, (String)"TransMeta.Monitor.ReadingTheAvailableSharedObjectsTask.Title", (String[])new String[0]));
                }
                try {
                    transMeta.setSharedObjects(this.readTransSharedObjects(transMeta));
                }
                catch (Exception e) {
                    this.log.logError(BaseMessages.getString(PKG, (String)"TransMeta.ErrorReadingSharedObjects.Message", (String[])new String[]{e.toString()}));
                    this.log.logError(Const.getStackTracker((Throwable)e));
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                if (monitor != null) {
                    monitor.subTask(BaseMessages.getString(PKG, (String)"TransMeta.Monitor.ReadingNoteTask.Title", (String[])new String[0]));
                }
                for (i2 = 0; i2 < noteids.length; ++i2) {
                    NotePadMeta ni = this.repository.notePadDelegate.loadNotePadMeta(noteids[i2]);
                    if (transMeta.indexOfNote(ni) < 0) {
                        transMeta.addNote(ni);
                    }
                    if (monitor == null) continue;
                    monitor.worked(1);
                }
                if (monitor != null) {
                    monitor.subTask(BaseMessages.getString(PKG, (String)"TransMeta.Monitor.ReadingStepsTask.Title", (String[])new String[0]));
                }
                this.repository.connectionDelegate.fillStepAttributesBuffer(transMeta.getObjectId());
                for (i2 = 0; i2 < stepids.length; ++i2) {
                    StepMeta stepMeta;
                    if (this.log.isDetailed()) {
                        this.log.logDetailed(BaseMessages.getString(PKG, (String)"TransMeta.Log.LoadingStepWithID", (String[])new String[0]) + stepids[i2]);
                    }
                    if (monitor != null) {
                        monitor.subTask(BaseMessages.getString(PKG, (String)"TransMeta.Monitor.ReadingStepTask.Title", (String[])new String[0]) + (i2 + 1) + "/" + stepids.length);
                    }
                    if ((stepMeta = this.repository.stepDelegate.loadStepMeta(stepids[i2], transMeta.getDatabases(), transMeta.getPartitionSchemas())).isMissing()) {
                        transMeta.addMissingTrans((MissingTrans)stepMeta.getStepMetaInterface());
                    }
                    transMeta.addOrReplaceStep(stepMeta);
                    if (monitor == null) continue;
                    monitor.worked(1);
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                this.repository.connectionDelegate.setStepAttributesBuffer(null);
                for (i2 = 0; i2 < transMeta.nrSteps(); ++i2) {
                    StepMetaInterface sii = transMeta.getStep(i2).getStepMetaInterface();
                    sii.searchInfoAndTargetSteps(transMeta.getSteps());
                }
                if (monitor != null) {
                    monitor.subTask(BaseMessages.getString(PKG, (String)"TransMeta.Monitor.LoadingTransformationDetailsTask.Title", (String[])new String[0]));
                }
                this.loadRepTrans(transMeta);
                if (monitor != null) {
                    monitor.worked(1);
                }
                if (monitor != null) {
                    monitor.subTask(BaseMessages.getString(PKG, (String)"TransMeta.Monitor.ReadingHopTask.Title", (String[])new String[0]));
                }
                for (i2 = 0; i2 < hopids.length; ++i2) {
                    TransHopMeta hi = this.loadTransHopMeta(hopids[i2], transMeta.getSteps());
                    if (hi != null) {
                        transMeta.addTransHop(hi);
                    }
                    if (monitor == null) continue;
                    monitor.worked(1);
                }
                for (i2 = 0; i2 < transMeta.nrSteps(); ++i2) {
                    StepPartitioningMeta stepPartitioningMeta = transMeta.getStep(i2).getStepPartitioningMeta();
                    if (stepPartitioningMeta == null) continue;
                    stepPartitioningMeta.setPartitionSchemaAfterLoading(transMeta.getPartitionSchemas());
                }
                for (i2 = 0; i2 < transMeta.nrSteps(); ++i2) {
                    transMeta.getStep(i2).setClusterSchemaAfterLoading(transMeta.getClusterSchemas());
                }
                if (monitor != null) {
                    monitor.subTask(BaseMessages.getString(PKG, (String)"TransMeta.Monitor.ReadingTheDependenciesTask.Title", (String[])new String[0]));
                }
                ObjectId[] depids = this.repository.getTransDependencyIDs(transMeta.getObjectId());
                for (i = 0; i < depids.length; ++i) {
                    TransDependency td = this.loadTransDependency(depids[i], transMeta.getDatabases());
                    transMeta.addDependency(td);
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                transMeta.setAttributesMap(this.loadTransAttributesMap(transMeta.getObjectId()));
                for (i = 0; i < transMeta.nrSteps(); ++i) {
                    StepMeta stepMeta = transMeta.getStep(i);
                    String sourceStep = this.repository.getStepAttributeString(stepMeta.getObjectId(), "step_error_handling_source_step");
                    if (sourceStep == null) continue;
                    StepErrorMeta stepErrorMeta = this.repository.stepDelegate.loadStepErrorMeta(transMeta, stepMeta, transMeta.getSteps());
                    stepErrorMeta.getSourceStep().setStepErrorMeta(stepErrorMeta);
                }
                KettleDatabaseRepositoryTransAttribute attributeInterface = new KettleDatabaseRepositoryTransAttribute(this.repository.connectionDelegate, transMeta.getObjectId());
                for (LogTableInterface logTable : transMeta.getLogTables()) {
                    logTable.loadFromRepository(attributeInterface);
                }
                if (monitor != null) {
                    monitor.subTask(BaseMessages.getString(PKG, (String)"TransMeta.Monitor.SortingStepsTask.Title", (String[])new String[0]));
                }
                transMeta.sortSteps();
                if (monitor != null) {
                    monitor.worked(1);
                }
                if (monitor != null) {
                    monitor.done();
                }
                if (this.log.isDetailed()) {
                    this.log.logDetailed(BaseMessages.getString(PKG, (String)"TransMeta.Log.LoadedTransformation2", (String[])new String[]{transname, String.valueOf(transMeta.getRepositoryDirectory() == null)}));
                    this.log.logDetailed(BaseMessages.getString(PKG, (String)"TransMeta.Log.LoadedTransformation", (String[])new String[]{transname, transMeta.getRepositoryDirectory().getPath()}));
                }
                this.repository.connectionDelegate.closeAttributeLookupPreparedStatements();
                TransMeta transMeta2 = transMeta;
                return transMeta2;
            }
            catch (KettleDatabaseException e) {
                this.log.logError(BaseMessages.getString(PKG, (String)"TransMeta.Log.DatabaseErrorOccuredReadingTransformation", (String[])new String[0]) + Const.CR + (Object)((Object)e));
                throw new KettleException(BaseMessages.getString(PKG, (String)"TransMeta.Exception.DatabaseErrorOccuredReadingTransformation", (String[])new String[0]), (Throwable)e);
            }
            catch (Exception e) {
                this.log.logError(BaseMessages.getString(PKG, (String)"TransMeta.Log.DatabaseErrorOccuredReadingTransformation", (String[])new String[0]) + Const.CR + e);
                throw new KettleException(BaseMessages.getString(PKG, (String)"TransMeta.Exception.DatabaseErrorOccuredReadingTransformation2", (String[])new String[0]), (Throwable)e);
            }
            finally {
                transMeta.initializeVariablesFrom(null);
                if (setInternalVariables) {
                    transMeta.setInternalKettleVariables();
                }
            }
        }
    }

    private void loadRepTrans(TransMeta transMeta) throws KettleException {
        try {
            RowMetaAndData r = this.getTransformation(transMeta.getObjectId());
            if (r != null) {
                long id_directory;
                DatabaseMeta logDb;
                transMeta.setName(r.getString("NAME", null));
                transMeta.setDescription(r.getString("DESCRIPTION", null));
                transMeta.setExtendedDescription(r.getString("EXTENDED_DESCRIPTION", null));
                transMeta.setTransversion(r.getString("TRANS_VERSION", null));
                transMeta.setTransstatus((int)r.getInteger("TRANS_STATUS", -1L));
                TransLogTable logTable = transMeta.getTransLogTable();
                logTable.findField(TransLogTable.ID.LINES_READ).setSubject((Object)StepMeta.findStep(transMeta.getSteps(), (ObjectId)new LongObjectId(r.getInteger("ID_STEP_READ", -1L))));
                logTable.findField(TransLogTable.ID.LINES_READ).setSubject((Object)StepMeta.findStep(transMeta.getSteps(), (ObjectId)new LongObjectId(r.getInteger("ID_STEP_WRITE", -1L))));
                logTable.findField(TransLogTable.ID.LINES_READ).setSubject((Object)StepMeta.findStep(transMeta.getSteps(), (ObjectId)new LongObjectId(r.getInteger("ID_STEP_INPUT", -1L))));
                logTable.findField(TransLogTable.ID.LINES_READ).setSubject((Object)StepMeta.findStep(transMeta.getSteps(), (ObjectId)new LongObjectId(r.getInteger("ID_STEP_OUTPUT", -1L))));
                logTable.findField(TransLogTable.ID.LINES_READ).setSubject((Object)StepMeta.findStep(transMeta.getSteps(), (ObjectId)new LongObjectId(r.getInteger("ID_STEP_UPDATE", -1L))));
                long id_rejected = this.getTransAttributeInteger(transMeta.getObjectId(), 0, "ID_STEP_REJECTED");
                if (id_rejected > 0L) {
                    logTable.findField(TransLogTable.ID.LINES_REJECTED).setSubject((Object)StepMeta.findStep(transMeta.getSteps(), (ObjectId)new LongObjectId(id_rejected)));
                }
                if ((logDb = DatabaseMeta.findDatabase(transMeta.getDatabases(), (ObjectId)new LongObjectId(r.getInteger("ID_DATABASE_LOG", -1L)))) != null) {
                    logTable.setConnectionName(logDb.getName());
                }
                logTable.setTableName(r.getString("TABLE_NAME_LOG", null));
                logTable.setBatchIdUsed(r.getBoolean("USE_BATCHID", false));
                logTable.setLogFieldUsed(r.getBoolean("USE_LOGFIELD", false));
                transMeta.setMaxDateConnection(DatabaseMeta.findDatabase(transMeta.getDatabases(), (ObjectId)new LongObjectId(r.getInteger("ID_DATABASE_MAXDATE", -1L))));
                transMeta.setMaxDateTable(r.getString("TABLE_NAME_MAXDATE", null));
                transMeta.setMaxDateField(r.getString("FIELD_NAME_MAXDATE", null));
                transMeta.setMaxDateOffset(r.getNumber("OFFSET_MAXDATE", 0.0));
                transMeta.setMaxDateDifference(r.getNumber("DIFF_MAXDATE", 0.0));
                transMeta.setCreatedUser(r.getString("CREATED_USER", null));
                transMeta.setCreatedDate(r.getDate("CREATED_DATE", null));
                transMeta.setModifiedUser(r.getString("MODIFIED_USER", null));
                transMeta.setModifiedDate(r.getDate("MODIFIED_DATE", null));
                transMeta.setSizeRowset(10000);
                Long val_size_rowset = r.getInteger("SIZE_ROWSET");
                if (val_size_rowset != null) {
                    transMeta.setSizeRowset(val_size_rowset.intValue());
                }
                if ((id_directory = r.getInteger("ID_DIRECTORY", -1L)) >= 0L) {
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("ID_DIRECTORY=" + id_directory);
                    }
                    transMeta.setRepositoryDirectory(this.repository.loadRepositoryDirectoryTree().findDirectory((ObjectId)new LongObjectId(id_directory)));
                }
                transMeta.setUsingUniqueConnections(this.getTransAttributeBoolean(transMeta.getObjectId(), 0, "UNIQUE_CONNECTIONS"));
                transMeta.setFeedbackShown(!"N".equalsIgnoreCase(this.getTransAttributeString(transMeta.getObjectId(), 0, "FEEDBACK_SHOWN")));
                transMeta.setFeedbackSize((int)this.getTransAttributeInteger(transMeta.getObjectId(), 0, "FEEDBACK_SIZE"));
                transMeta.setUsingThreadPriorityManagment(!"N".equalsIgnoreCase(this.getTransAttributeString(transMeta.getObjectId(), 0, "USING_THREAD_PRIORITIES")));
                transMeta.setCapturingStepPerformanceSnapShots(this.getTransAttributeBoolean(transMeta.getObjectId(), 0, "CAPTURE_STEP_PERFORMANCE"));
                transMeta.setStepPerformanceCapturingDelay(this.getTransAttributeInteger(transMeta.getObjectId(), 0, "STEP_PERFORMANCE_CAPTURING_DELAY"));
                transMeta.setStepPerformanceCapturingSizeLimit(this.getTransAttributeString(transMeta.getObjectId(), 0, "STEP_PERFORMANCE_CAPTURING_SIZE_LIMIT"));
                transMeta.getPerformanceLogTable().setTableName(this.getTransAttributeString(transMeta.getObjectId(), 0, "STEP_PERFORMANCE_LOG_TABLE"));
                transMeta.getTransLogTable().setLogSizeLimit(this.getTransAttributeString(transMeta.getObjectId(), 0, "LOG_SIZE_LIMIT"));
                transMeta.getTransLogTable().setLogInterval(this.getTransAttributeString(transMeta.getObjectId(), 0, "LOG_INTERVAL"));
                transMeta.setTransformationType(TransMeta.TransformationType.getTransformationTypeByCode(this.getTransAttributeString(transMeta.getObjectId(), 0, "TRANSFORMATION_TYPE")));
                transMeta.setSleepTimeEmpty((int)this.getTransAttributeInteger(transMeta.getObjectId(), 0, "SLEEP_TIME_EMPTY"));
                transMeta.setSleepTimeFull((int)this.getTransAttributeInteger(transMeta.getObjectId(), 0, "SLEEP_TIME_FULL"));
                this.loadRepParameters(transMeta);
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"TransMeta.Exception.UnableToLoadTransformationInfoFromRepository", (String[])new String[0]), (Throwable)dbe);
        }
        finally {
            transMeta.initializeVariablesFrom(null);
            transMeta.setInternalKettleVariables();
        }
    }

    private void loadRepParameters(TransMeta transMeta) throws KettleException {
        transMeta.eraseParameters();
        int count = this.countTransParameter(transMeta.getObjectId());
        for (int idx = 0; idx < count; ++idx) {
            String key = this.getTransParameterKey(transMeta.getObjectId(), idx);
            String def = this.getTransParameterDefault(transMeta.getObjectId(), idx);
            String desc = this.getTransParameterDescription(transMeta.getObjectId(), idx);
            transMeta.addParameterDefinition(key, def, desc);
        }
    }

    public int countTransParameter(ObjectId id_transformation) throws KettleException {
        return this.repository.connectionDelegate.countNrTransAttributes(id_transformation, "PARAM_KEY");
    }

    public String getTransParameterKey(ObjectId id_transformation, int nr) throws KettleException {
        return this.repository.connectionDelegate.getTransAttributeString(id_transformation, nr, "PARAM_KEY");
    }

    public String getTransParameterDefault(ObjectId id_transformation, int nr) throws KettleException {
        return this.repository.connectionDelegate.getTransAttributeString(id_transformation, nr, "PARAM_DEFAULT");
    }

    public String getTransParameterDescription(ObjectId id_transformation, int nr) throws KettleException {
        return this.repository.connectionDelegate.getTransAttributeString(id_transformation, nr, "PARAM_DESC");
    }

    public void insertTransParameter(ObjectId id_transformation, long nr, String key, String defValue, String description) throws KettleException {
        this.repository.connectionDelegate.insertTransAttribute(id_transformation, nr, "PARAM_KEY", 0L, key != null ? key : "");
        this.repository.connectionDelegate.insertTransAttribute(id_transformation, nr, "PARAM_DEFAULT", 0L, defValue != null ? defValue : "");
        this.repository.connectionDelegate.insertTransAttribute(id_transformation, nr, "PARAM_DESC", 0L, description != null ? description : "");
    }

    public void readDatabases(TransMeta transMeta, boolean overWriteShared) throws KettleException {
        try {
            ObjectId[] dbids = this.repository.getDatabaseIDs(false);
            for (int i = 0; i < dbids.length; ++i) {
                DatabaseMeta databaseMeta = this.repository.loadDatabaseMeta(dbids[i], null);
                databaseMeta.shareVariablesWith((VariableSpace)transMeta);
                DatabaseMeta check = transMeta.findDatabase(databaseMeta.getName());
                if (check != null && !overWriteShared || databaseMeta.getName() == null) continue;
                transMeta.addOrReplaceDatabase(databaseMeta);
                if (overWriteShared) continue;
                databaseMeta.setChanged(false);
            }
            transMeta.clearChangedDatabases();
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"TransMeta.Log.UnableToReadDatabaseIDSFromRepository", (String[])new String[0]), (Throwable)dbe);
        }
        catch (KettleException ke) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"TransMeta.Log.UnableToReadDatabasesFromRepository", (String[])new String[0]), (Throwable)ke);
        }
    }

    public void readClusters(TransMeta transMeta, boolean overWriteShared) throws KettleException {
        try {
            ObjectId[] dbids = this.repository.getClusterIDs(false);
            for (int i = 0; i < dbids.length; ++i) {
                ClusterSchema clusterSchema = this.repository.loadClusterSchema(dbids[i], transMeta.getSlaveServers(), null);
                clusterSchema.shareVariablesWith(transMeta);
                ClusterSchema check = transMeta.findClusterSchema(clusterSchema.getName());
                if (check != null && !overWriteShared || Const.isEmpty((String)clusterSchema.getName())) continue;
                transMeta.addOrReplaceClusterSchema(clusterSchema);
                if (overWriteShared) continue;
                clusterSchema.setChanged(false);
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"TransMeta.Log.UnableToReadClustersFromRepository", (String[])new String[0]), (Throwable)dbe);
        }
    }

    public void readPartitionSchemas(TransMeta transMeta, boolean overWriteShared) throws KettleException {
        try {
            ObjectId[] dbids = this.repository.getPartitionSchemaIDs(false);
            for (int i = 0; i < dbids.length; ++i) {
                PartitionSchema partitionSchema = this.repository.loadPartitionSchema(dbids[i], null);
                PartitionSchema check = transMeta.findPartitionSchema(partitionSchema.getName());
                if (check != null && !overWriteShared || Const.isEmpty((String)partitionSchema.getName())) continue;
                transMeta.addOrReplacePartitionSchema(partitionSchema);
                if (overWriteShared) continue;
                partitionSchema.setChanged(false);
            }
        }
        catch (KettleException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"TransMeta.Log.UnableToReadPartitionSchemaFromRepository", (String[])new String[0]), (Throwable)dbe);
        }
    }

    public void readSlaves(TransMeta transMeta, boolean overWriteShared) throws KettleException {
        try {
            ObjectId[] dbids = this.repository.getSlaveIDs(false);
            for (int i = 0; i < dbids.length; ++i) {
                SlaveServer slaveServer = this.repository.loadSlaveServer(dbids[i], null);
                slaveServer.shareVariablesWith(transMeta);
                SlaveServer check = transMeta.findSlaveServer(slaveServer.getName());
                if (check != null && !overWriteShared || Const.isEmpty((String)slaveServer.getName())) continue;
                transMeta.addOrReplaceSlaveServer(slaveServer);
                if (overWriteShared) continue;
                slaveServer.setChanged(false);
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"TransMeta.Log.UnableToReadSlaveServersFromRepository", (String[])new String[0]), (Throwable)dbe);
        }
    }

    public TransDependency loadTransDependency(ObjectId id_dependency, List<DatabaseMeta> databases) throws KettleException {
        TransDependency transDependency = new TransDependency();
        try {
            transDependency.setObjectId(id_dependency);
            RowMetaAndData r = this.getTransDependency(id_dependency);
            if (r != null) {
                long id_connection = r.getInteger("ID_DATABASE", 0L);
                transDependency.setDatabase(DatabaseMeta.findDatabase(databases, (ObjectId)new LongObjectId(id_connection)));
                transDependency.setTablename(r.getString("TABLE_NAME", null));
                transDependency.setFieldname(r.getString("FIELD_NAME", null));
            }
            return transDependency;
        }
        catch (KettleException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"TransDependency.Exception.UnableToLoadTransformationDependency", (String[])new String[0]) + id_dependency, (Throwable)dbe);
        }
    }

    public void saveTransDependency(TransDependency transDependency, ObjectId id_transformation) throws KettleException {
        try {
            ObjectId id_database = transDependency.getDatabase() == null ? null : transDependency.getDatabase().getObjectId();
            transDependency.setObjectId(this.insertDependency(id_transformation, id_database, transDependency.getTablename(), transDependency.getFieldname()));
        }
        catch (KettleException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"TransDependency.Exception.UnableToSaveTransformationDepency", (String[])new String[0]) + id_transformation, (Throwable)dbe);
        }
    }

    public void saveTransHopMeta(TransHopMeta transHopMeta, ObjectId id_transformation) throws KettleException {
        try {
            ObjectId id_step_from = transHopMeta.getFromStep() == null ? null : transHopMeta.getFromStep().getObjectId();
            ObjectId id_step_to = transHopMeta.getToStep() == null ? null : transHopMeta.getToStep().getObjectId();
            transHopMeta.setObjectId(this.insertTransHop(id_transformation, id_step_from, id_step_to, transHopMeta.isEnabled()));
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"TransHopMeta.Exception.UnableToSaveTransformationHopInfo", (String[])new String[0]) + id_transformation, (Throwable)dbe);
        }
    }

    public TransHopMeta loadTransHopMeta(ObjectId id_trans_hop, List<StepMeta> steps) throws KettleException {
        TransHopMeta hopTransMeta = new TransHopMeta();
        try {
            StepMeta stepMeta;
            hopTransMeta.setObjectId(id_trans_hop);
            RowMetaAndData r = this.getTransHop(id_trans_hop);
            hopTransMeta.setEnabled(r.getBoolean("ENABLED", false));
            long id_step_from = r.getInteger("ID_STEP_FROM", 0L);
            long id_step_to = r.getInteger("ID_STEP_TO", 0L);
            StepMeta fromStep = StepMeta.findStep(steps, (ObjectId)new LongObjectId(id_step_from));
            if (fromStep == null && id_step_from > 0L) {
                stepMeta = this.repository.stepDelegate.loadStepMeta((ObjectId)new LongObjectId(id_step_from), new ArrayList<DatabaseMeta>(), new ArrayList<PartitionSchema>());
                fromStep = StepMeta.findStep(steps, stepMeta.getName());
            }
            if (fromStep == null) {
                this.log.logError("Unable to determine source step of transformation hop with ID: " + id_trans_hop);
                return null;
            }
            hopTransMeta.setFromStep(fromStep);
            hopTransMeta.getFromStep().setDraw(true);
            hopTransMeta.setToStep(StepMeta.findStep(steps, (ObjectId)new LongObjectId(id_step_to)));
            if (hopTransMeta.getToStep() == null && id_step_to > 0L) {
                stepMeta = this.repository.stepDelegate.loadStepMeta((ObjectId)new LongObjectId(id_step_to), new ArrayList<DatabaseMeta>(), new ArrayList<PartitionSchema>());
                hopTransMeta.setToStep(StepMeta.findStep(steps, stepMeta.getName()));
            }
            if (hopTransMeta.getFromStep() == null || hopTransMeta.getFromStep() == null) {
                return null;
            }
            hopTransMeta.getToStep().setDraw(true);
            return hopTransMeta;
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"TransHopMeta.Exception.LoadTransformationHopInfo", (String[])new String[0]) + id_trans_hop, (Throwable)dbe);
        }
    }

    public synchronized int getNrTransformations(ObjectId id_directory) throws KettleException {
        int retval = 0;
        RowMetaAndData par = this.repository.connectionDelegate.getParameterMetaData(id_directory);
        String sql = "SELECT COUNT(*) FROM " + this.quoteTable("R_TRANSFORMATION") + " WHERE " + this.quote("ID_DIRECTORY") + " = ? ";
        RowMetaAndData r = this.repository.connectionDelegate.getOneRow(sql, par.getRowMeta(), par.getData());
        if (r != null) {
            retval = (int)r.getInteger(0, 0L);
        }
        return retval;
    }

    public synchronized int getNrTransHops(ObjectId id_transformation) throws KettleException {
        int retval = 0;
        RowMetaAndData par = this.repository.connectionDelegate.getParameterMetaData(id_transformation);
        String sql = "SELECT COUNT(*) FROM " + this.quoteTable("R_TRANS_HOP") + " WHERE " + this.quote("ID_TRANSFORMATION") + " = ? ";
        RowMetaAndData r = this.repository.connectionDelegate.getOneRow(sql, par.getRowMeta(), par.getData());
        if (r != null) {
            retval = (int)r.getInteger(0, 0L);
        }
        return retval;
    }

    public synchronized int getNrTransDependencies(ObjectId id_transformation) throws KettleException {
        int retval = 0;
        RowMetaAndData par = this.repository.connectionDelegate.getParameterMetaData(id_transformation);
        String sql = "SELECT COUNT(*) FROM " + this.quoteTable("R_DEPENDENCY") + " WHERE " + this.quote("ID_TRANSFORMATION") + " = ? ";
        RowMetaAndData r = this.repository.connectionDelegate.getOneRow(sql, par.getRowMeta(), par.getData());
        if (r != null) {
            retval = (int)r.getInteger(0, 0L);
        }
        return retval;
    }

    public String[] getTransformationsWithIDList(List<Object[]> list, RowMetaInterface rowMeta) throws KettleException {
        String[] transList = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            RowMetaAndData transRow;
            long id_transformation = rowMeta.getInteger(list.get(i), this.quote("ID_TRANSFORMATION"), Long.valueOf(-1L));
            if (id_transformation <= 0L || (transRow = this.getTransformation((ObjectId)new LongObjectId(id_transformation))) == null) continue;
            String transName = transRow.getString("NAME", "<name not found>");
            long id_directory = transRow.getInteger("ID_DIRECTORY", -1L);
            RepositoryDirectoryInterface dir = this.repository.loadRepositoryDirectoryTree().findDirectory((ObjectId)new LongObjectId(id_directory));
            transList[i] = dir.getPathObjectCombination(transName);
        }
        return transList;
    }

    public String[] getTransformationsWithIDList(ObjectId[] ids) throws KettleException {
        String[] transList = new String[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            RowMetaAndData transRow;
            ObjectId id_transformation = ids[i];
            if (id_transformation == null || (transRow = this.getTransformation(id_transformation)) == null) continue;
            String transName = transRow.getString("NAME", "<name not found>");
            long id_directory = transRow.getInteger("ID_DIRECTORY", -1L);
            RepositoryDirectoryInterface dir = this.repository.loadRepositoryDirectoryTree().findDirectory((ObjectId)new LongObjectId(id_directory));
            transList[i] = dir.getPathObjectCombination(transName);
        }
        return transList;
    }

    public boolean existsTransMeta(String transname, RepositoryDirectory directory) throws KettleException {
        return this.getTransformationID(transname, directory.getObjectId()) != null;
    }

    public ObjectId[] getTransHopIDs(ObjectId id_transformation) throws KettleException {
        return this.repository.connectionDelegate.getIDs("SELECT " + this.quote("ID_TRANS_HOP") + " FROM " + this.quoteTable("R_TRANS_HOP") + " WHERE " + this.quote("ID_TRANSFORMATION") + " = ? ", id_transformation);
    }

    private synchronized void insertTransformation(TransMeta transMeta) throws KettleException {
        RowMetaAndData table = new RowMetaAndData();
        table.addValue((ValueMetaInterface)new ValueMeta("ID_TRANSFORMATION", 5), (Object)new LongObjectId(transMeta.getObjectId()));
        table.addValue((ValueMetaInterface)new ValueMeta("NAME", 2), (Object)transMeta.getName());
        table.addValue((ValueMetaInterface)new ValueMeta("DESCRIPTION", 2), (Object)transMeta.getDescription());
        table.addValue((ValueMetaInterface)new ValueMeta("EXTENDED_DESCRIPTION", 2), (Object)transMeta.getExtendedDescription());
        table.addValue((ValueMetaInterface)new ValueMeta("TRANS_VERSION", 2), (Object)transMeta.getTransversion());
        table.addValue((ValueMetaInterface)new ValueMeta("TRANS_STATUS", 5), (Object)new Long(transMeta.getTransstatus() < 0 ? -1L : (long)transMeta.getTransstatus()));
        TransLogTable logTable = transMeta.getTransLogTable();
        StepMeta step = (StepMeta)logTable.getSubject(TransLogTable.ID.LINES_READ);
        table.addValue((ValueMetaInterface)new ValueMeta("ID_STEP_READ", 5), (Object)(step == null ? null : step.getObjectId()));
        step = (StepMeta)logTable.getSubject(TransLogTable.ID.LINES_WRITTEN);
        table.addValue((ValueMetaInterface)new ValueMeta("ID_STEP_WRITE", 5), (Object)(step == null ? null : step.getObjectId()));
        step = (StepMeta)logTable.getSubject(TransLogTable.ID.LINES_INPUT);
        table.addValue((ValueMetaInterface)new ValueMeta("ID_STEP_INPUT", 5), (Object)(step == null ? null : step.getObjectId()));
        step = (StepMeta)logTable.getSubject(TransLogTable.ID.LINES_OUTPUT);
        table.addValue((ValueMetaInterface)new ValueMeta("ID_STEP_OUTPUT", 5), (Object)(step == null ? null : step.getObjectId()));
        step = (StepMeta)logTable.getSubject(TransLogTable.ID.LINES_UPDATED);
        table.addValue((ValueMetaInterface)new ValueMeta("ID_STEP_UPDATE", 5), (Object)(step == null ? null : step.getObjectId()));
        table.addValue((ValueMetaInterface)new ValueMeta("ID_DATABASE_LOG", 5), (Object)(logTable.getDatabaseMeta() == null ? new LongObjectId(-1L).longValue() : new LongObjectId(logTable.getDatabaseMeta().getObjectId()).longValue()));
        table.addValue((ValueMetaInterface)new ValueMeta("TABLE_NAME_LOG", 2), (Object)logTable.getDatabaseMeta());
        table.addValue((ValueMetaInterface)new ValueMeta("USE_BATCHID", 4), (Object)logTable.isBatchIdUsed());
        table.addValue((ValueMetaInterface)new ValueMeta("USE_LOGFIELD", 4), (Object)logTable.isLogFieldUsed());
        table.addValue((ValueMetaInterface)new ValueMeta("ID_DATABASE_MAXDATE", 5), (Object)(transMeta.getMaxDateConnection() == null ? new LongObjectId(-1L).longValue() : new LongObjectId(transMeta.getMaxDateConnection().getObjectId()).longValue()));
        table.addValue((ValueMetaInterface)new ValueMeta("TABLE_NAME_MAXDATE", 2), (Object)transMeta.getMaxDateTable());
        table.addValue((ValueMetaInterface)new ValueMeta("FIELD_NAME_MAXDATE", 2), (Object)transMeta.getMaxDateField());
        table.addValue((ValueMetaInterface)new ValueMeta("OFFSET_MAXDATE", 1), (Object)new Double(transMeta.getMaxDateOffset()));
        table.addValue((ValueMetaInterface)new ValueMeta("DIFF_MAXDATE", 1), (Object)new Double(transMeta.getMaxDateDifference()));
        table.addValue((ValueMetaInterface)new ValueMeta("CREATED_USER", 2), (Object)transMeta.getCreatedUser());
        table.addValue((ValueMetaInterface)new ValueMeta("CREATED_DATE", 3), (Object)transMeta.getCreatedDate());
        table.addValue((ValueMetaInterface)new ValueMeta("MODIFIED_USER", 2), (Object)transMeta.getModifiedUser());
        table.addValue((ValueMetaInterface)new ValueMeta("MODIFIED_DATE", 3), (Object)transMeta.getModifiedDate());
        table.addValue((ValueMetaInterface)new ValueMeta("SIZE_ROWSET", 5), (Object)new Long(transMeta.getSizeRowset()));
        table.addValue((ValueMetaInterface)new ValueMeta("ID_DIRECTORY", 5), (Object)transMeta.getRepositoryDirectory().getObjectId());
        this.repository.connectionDelegate.getDatabase().prepareInsert(table.getRowMeta(), "R_TRANSFORMATION");
        this.repository.connectionDelegate.getDatabase().setValuesInsert(table);
        this.repository.connectionDelegate.getDatabase().insertRow();
        this.repository.connectionDelegate.getDatabase().closeInsert();
        step = (StepMeta)logTable.getSubject(TransLogTable.ID.LINES_REJECTED);
        if (step != null) {
            ObjectId rejectedId = step.getObjectId();
            this.repository.connectionDelegate.insertTransAttribute(transMeta.getObjectId(), 0L, "ID_STEP_REJECTED", rejectedId == null ? null : Long.valueOf(rejectedId.toString()), null);
        }
        this.repository.connectionDelegate.insertTransAttribute(transMeta.getObjectId(), 0L, "UNIQUE_CONNECTIONS", 0L, transMeta.isUsingUniqueConnections() ? "Y" : "N");
        this.repository.connectionDelegate.insertTransAttribute(transMeta.getObjectId(), 0L, "FEEDBACK_SHOWN", 0L, transMeta.isFeedbackShown() ? "Y" : "N");
        this.repository.connectionDelegate.insertTransAttribute(transMeta.getObjectId(), 0L, "FEEDBACK_SIZE", transMeta.getFeedbackSize(), "");
        this.repository.connectionDelegate.insertTransAttribute(transMeta.getObjectId(), 0L, "USING_THREAD_PRIORITIES", 0L, transMeta.isUsingThreadPriorityManagment() ? "Y" : "N");
        this.repository.connectionDelegate.insertTransAttribute(transMeta.getObjectId(), 0L, "SHARED_FILE", 0L, transMeta.getSharedObjectsFile());
        this.repository.connectionDelegate.insertTransAttribute(transMeta.getObjectId(), 0L, "CAPTURE_STEP_PERFORMANCE", 0L, transMeta.isCapturingStepPerformanceSnapShots() ? "Y" : "N");
        this.repository.connectionDelegate.insertTransAttribute(transMeta.getObjectId(), 0L, "STEP_PERFORMANCE_CAPTURING_DELAY", transMeta.getStepPerformanceCapturingDelay(), "");
        this.repository.connectionDelegate.insertTransAttribute(transMeta.getObjectId(), 0L, "STEP_PERFORMANCE_CAPTURING_SIZE_LIMIT", 0L, transMeta.getStepPerformanceCapturingSizeLimit());
        this.repository.connectionDelegate.insertTransAttribute(transMeta.getObjectId(), 0L, "STEP_PERFORMANCE_LOG_TABLE", 0L, transMeta.getPerformanceLogTable().getTableName());
        this.repository.connectionDelegate.insertTransAttribute(transMeta.getObjectId(), 0L, "LOG_SIZE_LIMIT", 0L, transMeta.getTransLogTable().getLogSizeLimit());
        this.repository.connectionDelegate.insertTransAttribute(transMeta.getObjectId(), 0L, "LOG_INTERVAL", 0L, transMeta.getTransLogTable().getLogInterval());
        this.repository.connectionDelegate.insertTransAttribute(transMeta.getObjectId(), 0L, "TRANSFORMATION_TYPE", 0L, transMeta.getTransformationType().getCode());
        this.repository.connectionDelegate.insertTransAttribute(transMeta.getObjectId(), 0L, "SLEEP_TIME_EMPTY", transMeta.getSleepTimeEmpty(), null);
        this.repository.connectionDelegate.insertTransAttribute(transMeta.getObjectId(), 0L, "SLEEP_TIME_FULL", transMeta.getSleepTimeFull(), null);
        if (logTable.getDatabaseMeta() != null) {
            this.repository.insertStepDatabase(transMeta.getObjectId(), null, logTable.getDatabaseMeta().getObjectId());
        }
        if (transMeta.getMaxDateConnection() != null) {
            this.repository.insertStepDatabase(transMeta.getObjectId(), null, transMeta.getMaxDateConnection().getObjectId());
        }
        KettleDatabaseRepositoryTransAttribute attributeInterface = new KettleDatabaseRepositoryTransAttribute(this.repository.connectionDelegate, transMeta.getObjectId());
        transMeta.getTransLogTable().saveToRepository(attributeInterface);
        transMeta.getStepLogTable().saveToRepository(attributeInterface);
        transMeta.getPerformanceLogTable().saveToRepository(attributeInterface);
        transMeta.getChannelLogTable().saveToRepository(attributeInterface);
    }

    private synchronized ObjectId insertTransHop(ObjectId id_transformation, ObjectId id_step_from, ObjectId id_step_to, boolean enabled) throws KettleException {
        ObjectId id = this.repository.connectionDelegate.getNextTransHopID();
        RowMetaAndData table = new RowMetaAndData();
        table.addValue((ValueMetaInterface)new ValueMeta("ID_TRANS_HOP", 5), (Object)id);
        table.addValue((ValueMetaInterface)new ValueMeta("ID_TRANSFORMATION", 5), (Object)id_transformation);
        table.addValue((ValueMetaInterface)new ValueMeta("ID_STEP_FROM", 5), (Object)id_step_from);
        table.addValue((ValueMetaInterface)new ValueMeta("ID_STEP_TO", 5), (Object)id_step_to);
        table.addValue((ValueMetaInterface)new ValueMeta("ENABLED", 4), (Object)enabled);
        this.repository.connectionDelegate.getDatabase().prepareInsert(table.getRowMeta(), "R_TRANS_HOP");
        this.repository.connectionDelegate.getDatabase().setValuesInsert(table);
        this.repository.connectionDelegate.getDatabase().insertRow();
        this.repository.connectionDelegate.getDatabase().closeInsert();
        return id;
    }

    private synchronized ObjectId insertDependency(ObjectId id_transformation, ObjectId id_database, String tablename, String fieldname) throws KettleException {
        ObjectId id = this.repository.connectionDelegate.getNextDepencencyID();
        RowMetaAndData table = new RowMetaAndData();
        table.addValue((ValueMetaInterface)new ValueMeta("ID_DEPENDENCY", 5), (Object)id);
        table.addValue((ValueMetaInterface)new ValueMeta("ID_TRANSFORMATION", 5), (Object)id_transformation);
        table.addValue((ValueMetaInterface)new ValueMeta("ID_DATABASE", 5), (Object)id_database);
        table.addValue((ValueMetaInterface)new ValueMeta("TABLE_NAME", 2), (Object)tablename);
        table.addValue((ValueMetaInterface)new ValueMeta("FIELD_NAME", 2), (Object)fieldname);
        this.repository.connectionDelegate.getDatabase().prepareInsert(table.getRowMeta(), "R_DEPENDENCY");
        this.repository.connectionDelegate.getDatabase().setValuesInsert(table);
        this.repository.connectionDelegate.getDatabase().insertRow();
        this.repository.connectionDelegate.getDatabase().closeInsert();
        return id;
    }

    public boolean getTransAttributeBoolean(ObjectId id_transformation, int nr, String code) throws KettleException {
        return this.repository.connectionDelegate.getTransAttributeBoolean(id_transformation, nr, code);
    }

    public String getTransAttributeString(ObjectId id_transformation, int nr, String code) throws KettleException {
        return this.repository.connectionDelegate.getTransAttributeString(id_transformation, nr, code);
    }

    public long getTransAttributeInteger(ObjectId id_transformation, int nr, String code) throws KettleException {
        return this.repository.connectionDelegate.getTransAttributeInteger(id_transformation, nr, code);
    }

    public SharedObjects readTransSharedObjects(TransMeta transMeta) throws KettleException {
        transMeta.setSharedObjectsFile(this.getTransAttributeString(transMeta.getObjectId(), 0, "SHARED_FILE"));
        transMeta.setSharedObjects(transMeta.readSharedObjects());
        this.readDatabases(transMeta, true);
        this.readPartitionSchemas(transMeta, true);
        this.readSlaves(transMeta, true);
        this.readClusters(transMeta, true);
        return transMeta.getSharedObjects();
    }

    public synchronized void moveTransformation(String transname, ObjectId id_directory_from, ObjectId id_directory_to) throws KettleException {
        String nameField = this.quote("NAME");
        String sql = "UPDATE " + this.quoteTable("R_TRANSFORMATION") + " SET " + this.quote("ID_DIRECTORY") + " = ? WHERE " + nameField + " = ? AND " + this.quote("ID_DIRECTORY") + " = ?";
        RowMetaAndData par = new RowMetaAndData();
        par.addValue((ValueMetaInterface)new ValueMeta("ID_DIRECTORY", 5), (Object)id_directory_to);
        par.addValue((ValueMetaInterface)new ValueMeta("NAME", 2), (Object)transname);
        par.addValue((ValueMetaInterface)new ValueMeta("ID_DIRECTORY", 5), (Object)id_directory_from);
        this.repository.connectionDelegate.getDatabase().execStatement(sql, par.getRowMeta(), par.getData());
    }

    public synchronized void renameTransformation(ObjectId id_transformation, RepositoryDirectoryInterface newParentDir, String newname) throws KettleException {
        if (newParentDir != null || newname != null) {
            RowMetaAndData table = new RowMetaAndData();
            String sql = "UPDATE " + this.quoteTable("R_TRANSFORMATION") + " SET ";
            boolean additionalParameter = false;
            if (newname != null) {
                additionalParameter = true;
                sql = sql + this.quote("NAME") + " = ? ";
                table.addValue((ValueMetaInterface)new ValueMeta("NAME", 2), (Object)newname);
            }
            if (newParentDir != null) {
                if (additionalParameter) {
                    sql = sql + ", ";
                }
                sql = sql + this.quote("ID_DIRECTORY") + " = ? ";
                table.addValue((ValueMetaInterface)new ValueMeta("ID_DIRECTORY", 5), (Object)newParentDir.getObjectId());
            }
            sql = sql + "WHERE " + this.quote("ID_TRANSFORMATION") + " = ?";
            table.addValue((ValueMetaInterface)new ValueMeta("ID_TRANSFORMATION", 5), (Object)id_transformation);
            this.log.logBasic("sql = [" + sql + "]");
            this.log.logBasic("row = [" + table + "]");
            this.repository.connectionDelegate.getDatabase().execStatement(sql, table.getRowMeta(), table.getData());
            this.repository.connectionDelegate.getDatabase().commit();
        }
    }

    private void saveTransAttributesMap(ObjectId transformationId, Map<String, Map<String, String>> attributesMap) throws KettleException {
        for (String groupName : attributesMap.keySet()) {
            Map<String, String> attributes = attributesMap.get(groupName);
            for (String key : attributes.keySet()) {
                String value = attributes.get(key);
                if (key == null || value == null) continue;
                this.repository.connectionDelegate.insertTransAttribute(transformationId, 0L, TRANS_ATTRIBUTE_PREFIX + groupName + TRANS_ATTRIBUTE_PREFIX_DELIMITER + key, 0L, value);
            }
        }
    }

    private Map<String, Map<String, String>> loadTransAttributesMap(ObjectId transformationId) throws KettleException {
        HashMap<String, Map<String, String>> attributesMap = new HashMap<String, Map<String, String>>();
        List<Object[]> attributeRows = this.repository.connectionDelegate.getTransAttributesWithPrefix(transformationId, TRANS_ATTRIBUTE_PREFIX);
        RowMetaInterface rowMeta = this.repository.connectionDelegate.getReturnRowMeta();
        for (Object[] attributeRow : attributeRows) {
            int tabIndex;
            String code = rowMeta.getString(attributeRow, "CODE", null);
            String value = rowMeta.getString(attributeRow, "VALUE_STR", null);
            if (code == null || value == null || (tabIndex = (code = code.substring(TRANS_ATTRIBUTE_PREFIX.length())).indexOf(TRANS_ATTRIBUTE_PREFIX_DELIMITER)) <= 0) continue;
            String groupName = code.substring(0, tabIndex);
            String key = code.substring(tabIndex + 1);
            HashMap<String, String> attributes = (HashMap<String, String>)attributesMap.get(groupName);
            if (attributes == null) {
                attributes = new HashMap<String, String>();
                attributesMap.put(groupName, attributes);
            }
            attributes.put(key, value);
        }
        return attributesMap;
    }
}

