/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.xslt;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryXSLT
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryXSLT.class;
    public static String FACTORY_JAXP = "JAXP";
    public static String FACTORY_SAXON = "SAXON";
    private String xmlfilename = null;
    private String xslfilename = null;
    private String outputfilename = null;
    public int iffileexists = 1;
    private boolean addfiletoresult = false;
    private String xsltfactory = FACTORY_JAXP;
    private boolean filenamesfromprevious = false;
    private String[] outputPropertyName;
    private String[] outputPropertyValue;
    private String[] parameterName;
    private String[] parameterField;
    private int nrParams;
    private String[] nameOfParams;
    private String[] valueOfParams;
    private boolean useParameters;
    private Properties outputProperties;
    private boolean setOutputProperties;

    public JobEntryXSLT(String n) {
        super(n, "");
        int i;
        int nrparams = 0;
        int nroutputproperties = 0;
        this.allocate(nrparams, nroutputproperties);
        for (i = 0; i < nrparams; ++i) {
            this.parameterField[i] = "param" + i;
            this.parameterName[i] = "param";
        }
        for (i = 0; i < nroutputproperties; ++i) {
            this.outputPropertyName[i] = "outputprop" + i;
            this.outputPropertyValue[i] = "outputprop";
        }
    }

    public void allocate(int nrParameters, int outputProps) {
        this.parameterName = new String[nrParameters];
        this.parameterField = new String[nrParameters];
        this.outputPropertyName = new String[outputProps];
        this.outputPropertyValue = new String[outputProps];
    }

    public JobEntryXSLT() {
        this("");
    }

    @Override
    public Object clone() {
        int i;
        JobEntryXSLT je = (JobEntryXSLT)super.clone();
        int nrparams = this.parameterName.length;
        int nroutputprops = this.outputPropertyName.length;
        je.allocate(nrparams, nroutputprops);
        for (i = 0; i < nrparams; ++i) {
            je.parameterName[i] = this.parameterName[i];
            je.parameterField[i] = this.parameterField[i];
        }
        for (i = 0; i < nroutputprops; ++i) {
            je.outputPropertyName[i] = this.outputPropertyName[i];
            je.outputPropertyValue[i] = this.outputPropertyValue[i];
        }
        return je;
    }

    @Override
    public String getXML() {
        int i;
        StringBuffer retval = new StringBuffer(50);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"xmlfilename", (String)this.xmlfilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"xslfilename", (String)this.xslfilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"outputfilename", (String)this.outputfilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"iffileexists", (int)this.iffileexists));
        retval.append("      ").append(XMLHandler.addTagValue((String)"addfiletoresult", (boolean)this.addfiletoresult));
        retval.append("      ").append(XMLHandler.addTagValue((String)"filenamesfromprevious", (boolean)this.filenamesfromprevious));
        retval.append("      ").append(XMLHandler.addTagValue((String)"xsltfactory", (String)this.xsltfactory));
        retval.append("    <parameters>").append(Const.CR);
        for (i = 0; i < this.parameterName.length; ++i) {
            retval.append("      <parameter>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"field", (String)this.parameterField[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.parameterName[i]));
            retval.append("      </parameter>").append(Const.CR);
        }
        retval.append("    </parameters>").append(Const.CR);
        retval.append("    <outputproperties>").append(Const.CR);
        for (i = 0; i < this.outputPropertyName.length; ++i) {
            retval.append("      <outputproperty>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.outputPropertyName[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"value", (String)this.outputPropertyValue[i]));
            retval.append("      </outputproperty>").append(Const.CR);
        }
        retval.append("    </outputproperties>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            Node anode;
            int i;
            super.loadXML(entrynode, databases, slaveServers);
            this.xmlfilename = XMLHandler.getTagValue((Node)entrynode, (String)"xmlfilename");
            this.xslfilename = XMLHandler.getTagValue((Node)entrynode, (String)"xslfilename");
            this.outputfilename = XMLHandler.getTagValue((Node)entrynode, (String)"outputfilename");
            this.iffileexists = Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"iffileexists"), (int)-1);
            this.addfiletoresult = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"addfiletoresult"));
            this.filenamesfromprevious = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"filenamesfromprevious"));
            this.xsltfactory = XMLHandler.getTagValue((Node)entrynode, (String)"xsltfactory");
            if (this.xsltfactory == null) {
                this.xsltfactory = FACTORY_JAXP;
            }
            Node parametersNode = XMLHandler.getSubNode((Node)entrynode, (String)"parameters");
            int nrparams = XMLHandler.countNodes((Node)parametersNode, (String)"parameter");
            Node parametersOutputProps = XMLHandler.getSubNode((Node)entrynode, (String)"outputproperties");
            int nroutputprops = XMLHandler.countNodes((Node)parametersOutputProps, (String)"outputproperty");
            this.allocate(nrparams, nroutputprops);
            for (i = 0; i < nrparams; ++i) {
                anode = XMLHandler.getSubNodeByNr((Node)parametersNode, (String)"parameter", (int)i);
                this.parameterField[i] = XMLHandler.getTagValue((Node)anode, (String)"field");
                this.parameterName[i] = XMLHandler.getTagValue((Node)anode, (String)"name");
            }
            for (i = 0; i < nroutputprops; ++i) {
                anode = XMLHandler.getSubNodeByNr((Node)parametersOutputProps, (String)"outputproperty", (int)i);
                this.outputPropertyName[i] = XMLHandler.getTagValue((Node)anode, (String)"name");
                this.outputPropertyValue[i] = XMLHandler.getTagValue((Node)anode, (String)"value");
            }
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException("Unable to load job entry of type 'xslt' from XML node", (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            int i;
            this.xmlfilename = rep.getJobEntryAttributeString(id_jobentry, "xmlfilename");
            this.xslfilename = rep.getJobEntryAttributeString(id_jobentry, "xslfilename");
            this.outputfilename = rep.getJobEntryAttributeString(id_jobentry, "outputfilename");
            this.iffileexists = (int)rep.getJobEntryAttributeInteger(id_jobentry, "iffileexists");
            this.addfiletoresult = rep.getJobEntryAttributeBoolean(id_jobentry, "addfiletoresult");
            this.filenamesfromprevious = rep.getJobEntryAttributeBoolean(id_jobentry, "filenamesfromprevious");
            this.xsltfactory = rep.getJobEntryAttributeString(id_jobentry, "xsltfactory");
            if (this.xsltfactory == null) {
                this.xsltfactory = FACTORY_JAXP;
            }
            int nrparams = rep.countNrJobEntryAttributes(id_jobentry, "param_name");
            int nroutputprops = rep.countNrJobEntryAttributes(id_jobentry, "output_property_name");
            this.allocate(nrparams, nroutputprops);
            for (i = 0; i < nrparams; ++i) {
                this.parameterField[i] = rep.getJobEntryAttributeString(id_jobentry, i, "param_field");
                this.parameterName[i] = rep.getJobEntryAttributeString(id_jobentry, i, "param_name");
            }
            for (i = 0; i < nroutputprops; ++i) {
                this.outputPropertyName[i] = rep.getJobEntryAttributeString(id_jobentry, i, "output_property_name");
                this.outputPropertyValue[i] = rep.getJobEntryAttributeString(id_jobentry, i, "output_property_value");
            }
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to load job entry of type 'xslt' from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            int i;
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "xmlfilename", this.xmlfilename);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "xslfilename", this.xslfilename);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "outputfilename", this.outputfilename);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "iffileexists", this.iffileexists);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "addfiletoresult", this.addfiletoresult);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "filenamesfromprevious", this.filenamesfromprevious);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "xsltfactory", this.xsltfactory);
            for (i = 0; i < this.parameterName.length; ++i) {
                rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "param_field", this.parameterField[i]);
                rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "param_name", this.parameterName[i]);
            }
            for (i = 0; i < this.outputPropertyName.length; ++i) {
                rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "output_property_name", this.outputPropertyName[i]);
                rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "output_property_value", this.outputPropertyValue[i]);
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'xslt' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    public String getXSLTFactory() {
        return this.xsltfactory;
    }

    public void setXSLTFactory(String xsltfactoryin) {
        this.xsltfactory = xsltfactoryin;
    }

    public String getRealxmlfilename() {
        return this.environmentSubstitute(this.getxmlFilename());
    }

    public String getoutputfilename() {
        return this.environmentSubstitute(this.getoutputFilename());
    }

    public boolean isFilenamesFromPrevious() {
        return this.filenamesfromprevious;
    }

    public void setFilenamesFromPrevious(boolean filenamesfromprevious) {
        this.filenamesfromprevious = filenamesfromprevious;
    }

    public String getRealxslfilename() {
        return this.environmentSubstitute(this.getxslFilename());
    }

    @Override
    public Result execute(Result previousResult, int nr) throws KettleException {
        int i;
        int nrOutputProps;
        Result result = previousResult;
        int NrErrors = 0;
        int NrSuccess = 0;
        int n = nrOutputProps = this.getOutputPropertyName() == null ? 0 : this.getOutputPropertyName().length;
        if (nrOutputProps > 0) {
            this.outputProperties = new Properties();
            for (i = 0; i < nrOutputProps; ++i) {
                this.outputProperties.put(this.getOutputPropertyName()[i], this.environmentSubstitute(this.getOutputPropertyValue()[i]));
            }
            this.setOutputProperties = true;
        }
        int n2 = this.nrParams = this.getParameterField() == null ? 0 : this.getParameterField().length;
        if (this.nrParams > 0) {
            this.nameOfParams = new String[this.nrParams];
            this.valueOfParams = new String[this.nrParams];
            for (i = 0; i < this.nrParams; ++i) {
                String name = this.environmentSubstitute(this.getParameterName()[i]);
                String value = this.environmentSubstitute(this.getParameterField()[i]);
                if (Const.isEmpty((String)value)) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"Xslt.Exception.ParameterFieldMissing", (Object[])new Object[]{name, i}));
                }
                this.nameOfParams[i] = name;
                this.valueOfParams[i] = value;
            }
            this.useParameters = true;
        }
        List rows = result.getRows();
        if (this.isFilenamesFromPrevious() && this.log.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryXSLT.Log.ArgFromPrevious.Found", (String[])new String[]{(rows != null ? rows.size() : 0) + ""}));
        }
        if (this.isFilenamesFromPrevious() && rows != null) {
            RowMetaAndData resultRow = null;
            for (int iteration = 0; iteration < rows.size() && !this.parentJob.isStopped(); ++iteration) {
                resultRow = (RowMetaAndData)rows.get(iteration);
                String xmlfilename_previous = resultRow.getString(0, null);
                String xslfilename_previous = resultRow.getString(1, null);
                String ouputfilename_previous = resultRow.getString(2, null);
                if (!(Const.isEmpty((String)xmlfilename_previous) || Const.isEmpty((String)xslfilename_previous) || Const.isEmpty((String)ouputfilename_previous))) {
                    if (this.processOneXMLFile(xmlfilename_previous, xslfilename_previous, ouputfilename_previous, result, this.parentJob)) {
                        ++NrSuccess;
                        continue;
                    }
                    ++NrErrors;
                    continue;
                }
                this.logError(BaseMessages.getString(PKG, (String)"JobEntryXSLT.AllFilesNotNull.Label", (String[])new String[0]));
                ++NrErrors;
            }
        } else {
            String realxmlfilename = this.getRealxmlfilename();
            String realxslfilename = this.getRealxslfilename();
            String realoutputfilename = this.getoutputfilename();
            if (!(Const.isEmpty((String)realxmlfilename) || Const.isEmpty((String)realxslfilename) || Const.isEmpty((String)realoutputfilename))) {
                if (this.processOneXMLFile(realxmlfilename, realxslfilename, realoutputfilename, result, this.parentJob)) {
                    ++NrSuccess;
                } else {
                    ++NrErrors;
                }
            } else {
                this.logError(BaseMessages.getString(PKG, (String)"JobEntryXSLT.AllFilesNotNull.Label", (String[])new String[0]));
                ++NrErrors;
            }
        }
        result.setResult(NrErrors == 0);
        result.setNrErrors((long)NrErrors);
        result.setNrLinesWritten((long)NrSuccess);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processOneXMLFile(String xmlfilename, String xslfilename, String outputfilename, Result result, Job parentJob) {
        boolean retval;
        block51: {
            retval = false;
            FileObject xmlfile = null;
            FileObject xslfile = null;
            FileObject outputfile = null;
            try {
                xmlfile = KettleVFS.getFileObject((String)xmlfilename, (VariableSpace)this);
                xslfile = KettleVFS.getFileObject((String)xslfilename, (VariableSpace)this);
                outputfile = KettleVFS.getFileObject((String)outputfilename, (VariableSpace)this);
                if (xmlfile.exists() && xslfile.exists()) {
                    if (outputfile.exists() && this.iffileexists == 2) {
                        this.logError(BaseMessages.getString(PKG, (String)"JobEntryXSLT.OuputFileExists1.Label", (String[])new String[0]) + outputfilename + BaseMessages.getString(PKG, (String)"JobEntryXSLT.OuputFileExists2.Label", (String[])new String[0]));
                        boolean bl = retval;
                        return bl;
                    }
                    if (outputfile.exists() && this.iffileexists == 1) {
                        if (this.log.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"JobEntryXSLT.OuputFileExists1.Label", (String[])new String[0]) + outputfilename + BaseMessages.getString(PKG, (String)"JobEntryXSLT.OuputFileExists2.Label", (String[])new String[0]));
                        }
                        boolean bl = retval = true;
                        return bl;
                    }
                    if (outputfile.exists() && this.iffileexists == 0) {
                        String wildcard = outputfilename.substring(outputfilename.length() - 4, outputfilename.length());
                        outputfilename = wildcard.substring(0, 1).equals(".") ? outputfilename.substring(0, outputfilename.length() - 4) + "_" + StringUtil.getFormattedDateTimeNow((boolean)true) + wildcard : outputfilename + "_" + StringUtil.getFormattedDateTimeNow((boolean)true);
                        if (this.log.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"JobEntryXSLT.OuputFileExists1.Label", (String[])new String[0]) + outputfilename + BaseMessages.getString(PKG, (String)"JobEntryXSLT.OuputFileExists2.Label", (String[])new String[0]));
                            this.logDebug(BaseMessages.getString(PKG, (String)"JobEntryXSLT.OuputFileNameChange1.Label", (String[])new String[0]) + outputfilename + BaseMessages.getString(PKG, (String)"JobEntryXSLT.OuputFileNameChange2.Label", (String[])new String[0]));
                        }
                    }
                    TransformerFactory factory = TransformerFactory.newInstance();
                    if (this.xsltfactory.equals(FACTORY_SAXON)) {
                        factory = new TransformerFactoryImpl();
                    }
                    if (this.log.isDetailed()) {
                        this.log.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryXSL.Log.TransformerFactoryInfos", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"JobEntryXSL.Log.TransformerFactory", (String[])new String[]{factory.getClass().getName()})});
                    }
                    InputStream xslInputStream = KettleVFS.getInputStream((FileObject)xslfile);
                    InputStream xmlInputStream = KettleVFS.getInputStream((FileObject)xmlfile);
                    OutputStream os = null;
                    try {
                        Templates template = factory.newTemplates(new StreamSource(xslInputStream));
                        Transformer xformer = template.newTransformer();
                        if (this.log.isDetailed()) {
                            this.log.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryXSL.Log.TransformerClassInfos", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"JobEntryXSL.Log.TransformerClass", (String[])new String[]{xformer.getClass().getName()})});
                        }
                        if (this.setOutputProperties) {
                            xformer.setOutputProperties(this.outputProperties);
                        }
                        if (this.useParameters) {
                            for (int i = 0; i < this.nrParams; ++i) {
                                xformer.setParameter(this.nameOfParams[i], this.valueOfParams[i]);
                            }
                        }
                        StreamSource source = new StreamSource(xmlInputStream);
                        os = KettleVFS.getOutputStream((FileObject)outputfile, (boolean)false);
                        StreamResult resultat = new StreamResult(os);
                        xformer.transform(source, resultat);
                        if (this.isAddFileToResult()) {
                            ResultFile resultFile = new ResultFile(0, KettleVFS.getFileObject((String)outputfilename, (VariableSpace)this), parentJob.getJobname(), this.toString());
                            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                        }
                        retval = true;
                        break block51;
                    }
                    finally {
                        try {
                            xslInputStream.close();
                        }
                        catch (IOException ignored) {}
                        try {
                            xmlInputStream.close();
                        }
                        catch (IOException ignored) {}
                        try {
                            if (os != null) {
                                os.close();
                            }
                        }
                        catch (IOException ignored) {}
                    }
                }
                if (!xmlfile.exists()) {
                    this.logError(BaseMessages.getString(PKG, (String)"JobEntryXSLT.FileDoesNotExist1.Label", (String[])new String[0]) + xmlfilename + BaseMessages.getString(PKG, (String)"JobEntryXSLT.FileDoesNotExist2.Label", (String[])new String[0]));
                }
                if (!xslfile.exists()) {
                    this.logError(BaseMessages.getString(PKG, (String)"JobEntryXSLT.FileDoesNotExist1.Label", (String[])new String[0]) + xmlfilename + BaseMessages.getString(PKG, (String)"JobEntryXSLT.FileDoesNotExist2.Label", (String[])new String[0]));
                }
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"JobEntryXSLT.ErrorXLST.Label", (String[])new String[0]) + BaseMessages.getString(PKG, (String)"JobEntryXSLT.ErrorXLSTXML1.Label", (String[])new String[0]) + xmlfilename + BaseMessages.getString(PKG, (String)"JobEntryXSLT.ErrorXLSTXML2.Label", (String[])new String[0]) + BaseMessages.getString(PKG, (String)"JobEntryXSLT.ErrorXLSTXSL1.Label", (String[])new String[0]) + xslfilename + BaseMessages.getString(PKG, (String)"JobEntryXSLT.ErrorXLSTXSL2.Label", (String[])new String[0]) + e.getMessage());
            }
            finally {
                try {
                    if (xmlfile != null) {
                        xmlfile.close();
                    }
                    if (xslfile != null) {
                        xslfile.close();
                    }
                    if (outputfile != null) {
                        outputfile.close();
                    }
                }
                catch (IOException e) {
                    this.logError("Unable to close file", e);
                }
            }
        }
        return retval;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    public void setxmlFilename(String filename) {
        this.xmlfilename = filename;
    }

    public String getxmlFilename() {
        return this.xmlfilename;
    }

    public String getoutputFilename() {
        return this.outputfilename;
    }

    public void setoutputFilename(String outputfilename) {
        this.outputfilename = outputfilename;
    }

    public void setxslFilename(String filename) {
        this.xslfilename = filename;
    }

    public String getxslFilename() {
        return this.xslfilename;
    }

    public void setAddFileToResult(boolean addfiletoresultin) {
        this.addfiletoresult = addfiletoresultin;
    }

    public boolean isAddFileToResult() {
        return this.addfiletoresult;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (!Const.isEmpty((String)this.xslfilename) && !Const.isEmpty((String)this.xmlfilename)) {
            String realXmlFileName = jobMeta.environmentSubstitute(this.xmlfilename);
            String realXslFileName = jobMeta.environmentSubstitute(this.xslfilename);
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(realXmlFileName, ResourceEntry.ResourceType.FILE));
            reference.getEntries().add(new ResourceEntry(realXslFileName, ResourceEntry.ResourceType.FILE));
            references.add(reference);
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notBlankValidator(), JobEntryValidatorUtils.fileExistsValidator());
        JobEntryValidatorUtils.andValidator().validate(this, "xmlFilename", remarks, ctx);
        JobEntryValidatorUtils.andValidator().validate(this, "xslFilename", remarks, ctx);
        JobEntryValidatorUtils.andValidator().validate(this, "outputFilename", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
    }

    public String[] getOutputPropertyName() {
        return this.outputPropertyName;
    }

    public void setOutputPropertyName(String[] argumentDirection) {
        this.outputPropertyName = argumentDirection;
    }

    public String[] getOutputPropertyValue() {
        return this.outputPropertyValue;
    }

    public void setOutputPropertyValue(String[] argumentDirection) {
        this.outputPropertyValue = argumentDirection;
    }

    public String[] getParameterName() {
        return this.parameterName;
    }

    public void setParameterName(String[] argumentDirection) {
        this.parameterName = argumentDirection;
    }

    public String[] getParameterField() {
        return this.parameterField;
    }
}

