/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core;

import org.pentaho.di.core.Const;

public class LastUsedFile {
    public static final String FILE_TYPE_TRANSFORMATION = "Trans";
    public static final String FILE_TYPE_JOB = "Job";
    public static final String FILE_TYPE_SCHEMA = "Schema";
    public static final String FILE_TYPE_CUSTOM = "Custom";
    public static final int OPENED_ITEM_TYPE_MASK_NONE = 0;
    public static final int OPENED_ITEM_TYPE_MASK_GRAPH = 1;
    public static final int OPENED_ITEM_TYPE_MASK_LOG = 2;
    public static final int OPENED_ITEM_TYPE_MASK_HISTORY = 4;
    private String fileType;
    private String filename;
    private String directory;
    private boolean sourceRepository;
    private String repositoryName;
    private boolean opened;
    private int openItemTypes;

    public LastUsedFile(String fileType, String filename, String directory, boolean sourceRepository, String repositoryName, boolean opened, int openItemTypes) {
        this.fileType = fileType;
        this.filename = filename;
        this.directory = directory;
        this.sourceRepository = sourceRepository;
        this.repositoryName = repositoryName;
        this.opened = opened;
        this.openItemTypes = openItemTypes;
    }

    public String toString() {
        String string = "";
        if (this.sourceRepository && !Const.isEmpty((String)this.directory) && !Const.isEmpty((String)this.repositoryName)) {
            string = string + "[" + this.repositoryName + "] ";
            string = this.directory.endsWith("/") ? string + ": " + this.directory + this.filename : string + ": /" + this.filename;
        } else {
            string = string + this.filename;
        }
        return string;
    }

    public int hashCode() {
        return (this.getFileType() + this.toString()).hashCode();
    }

    public boolean equals(Object obj) {
        LastUsedFile file = (LastUsedFile)obj;
        return this.getFileType().equals(file.getFileType()) && this.toString().equals(file.toString());
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public boolean isSourceRepository() {
        return this.sourceRepository;
    }

    public void setSourceRepository(boolean sourceRepository) {
        this.sourceRepository = sourceRepository;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public boolean isTransformation() {
        return FILE_TYPE_TRANSFORMATION.equalsIgnoreCase(this.fileType);
    }

    public boolean isJob() {
        return FILE_TYPE_JOB.equalsIgnoreCase(this.fileType);
    }

    public boolean isSchema() {
        return FILE_TYPE_SCHEMA.equalsIgnoreCase(this.fileType);
    }

    public boolean isOpened() {
        return this.opened;
    }

    public void setOpened(boolean opened) {
        this.opened = opened;
    }

    public int getOpenItemTypes() {
        return this.openItemTypes;
    }

    public void setOpenItemTypes(int openItemTypes) {
        this.openItemTypes = openItemTypes;
    }
}

