/*
 * Decompiled with CFR 0.152.
 */
package org.jfor.jfor.rtflib.rtfdoc;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.jfor.jfor.rtflib.rtfdoc.RtfAttributes;
import org.jfor.jfor.rtflib.rtfdoc.RtfHeader;
import org.jfor.jfor.rtflib.rtfdoc.RtfText;

public class RtfStyleSheetTable {
    private static int startIndex = 15;
    public static int STATUS_OK = 0;
    public static int STATUS_DEFAULT = 1;
    private static String STANDARD_STYLE = "Standard";
    private static RtfStyleSheetTable instance = null;
    private Hashtable styles = null;
    private Hashtable attrTable = null;
    private Vector nameTable = null;
    private String defaultStyleName = STANDARD_STYLE;

    private RtfStyleSheetTable() {
        this.styles = new Hashtable();
        this.attrTable = new Hashtable();
        this.nameTable = new Vector();
    }

    public static RtfStyleSheetTable getInstance() {
        if (instance == null) {
            instance = new RtfStyleSheetTable();
        }
        return instance;
    }

    public void setDefaultStyle(String string) {
        this.defaultStyleName = string;
    }

    public String getDefaultStyleName() {
        if (this.attrTable.get(this.defaultStyleName) != null) {
            return this.defaultStyleName;
        }
        if (this.attrTable.get(STANDARD_STYLE) != null) {
            this.defaultStyleName = STANDARD_STYLE;
            return this.defaultStyleName;
        }
        return null;
    }

    public void addStyle(String string, RtfAttributes rtfAttributes) {
        this.nameTable.addElement(string);
        if (rtfAttributes != null) {
            this.attrTable.put(string, rtfAttributes);
        }
        this.styles.put(string, new Integer(this.nameTable.size() - 1 + startIndex));
    }

    public int addStyleToAttributes(String string, RtfAttributes rtfAttributes) {
        int n = STATUS_OK;
        Integer n2 = (Integer)this.styles.get(string);
        if (n2 == null && !string.equals(this.defaultStyleName)) {
            string = this.defaultStyleName;
            n2 = (Integer)this.styles.get(string);
            n = STATUS_DEFAULT;
        }
        if (n2 == null) {
            return n;
        }
        rtfAttributes.set("cs", n2);
        Object v = this.attrTable.get(string);
        if (v != null) {
            RtfAttributes rtfAttributes2 = (RtfAttributes)v;
            Iterator iterator = rtfAttributes2.nameIterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (rtfAttributes.isSet(string2)) continue;
                Integer n3 = (Integer)rtfAttributes2.getValue(string2);
                if (n3 == null) {
                    rtfAttributes.set(string2);
                    continue;
                }
                rtfAttributes.set(string2, n3);
            }
        }
        return n;
    }

    public void writeStyleSheet(RtfHeader rtfHeader) throws IOException {
        if (this.styles == null || this.styles.size() == 0) {
            return;
        }
        rtfHeader.writeGroupMark(true);
        rtfHeader.writeControlWord("stylesheet");
        int n = this.nameTable.size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)this.nameTable.elementAt(n2);
            rtfHeader.writeGroupMark(true);
            rtfHeader.writeControlWord("*\\" + this.getRtfStyleReference(string));
            Object v = this.attrTable.get(string);
            if (v != null) {
                rtfHeader.writeAttributes((RtfAttributes)v, RtfText.ATTR_NAMES);
                rtfHeader.writeAttributes((RtfAttributes)v, RtfText.ALIGNMENT);
            }
            rtfHeader.write(string + ";");
            rtfHeader.writeGroupMark(false);
            ++n2;
        }
        rtfHeader.writeGroupMark(false);
    }

    private String getRtfStyleReference(String string) {
        return "cs" + this.styles.get(string).toString();
    }
}

