/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.text.Collator;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import net.sf.jasperreports.engine.fill.DatasetSortInfo;
import net.sf.jasperreports.engine.fill.SortedDataSource;

class DataSourceComparator
implements Comparator<Integer> {
    private final Collator collator;
    private final List<DatasetSortInfo.SortFieldInfo> sortFields;
    private final List<SortedDataSource.SortRecord> records;

    public DataSourceComparator(DatasetSortInfo sortFieldInfo, Locale locale, List<SortedDataSource.SortRecord> records) {
        this.collator = Collator.getInstance(locale);
        this.sortFields = sortFieldInfo.getSortFields();
        this.records = records;
    }

    @Override
    public int compare(Integer idx1, Integer idx2) {
        Object[] record1 = this.records.get(idx1).getValues();
        Object[] record2 = this.records.get(idx2).getValues();
        int ret = 0;
        for (DatasetSortInfo.SortFieldInfo info : this.sortFields) {
            Comparable field1 = (Comparable)record1[info.getRecordIndex()];
            Comparable field2 = (Comparable)record2[info.getRecordIndex()];
            ret = field1 == null ? (field2 == null ? 0 : -1) : (field2 == null ? 1 : (info.useCollator() ? this.collator.compare(field1, field2) : field1.compareTo(field2)));
            if (ret == 0) continue;
            if (info.isDescending()) {
                ret = -ret;
            }
            return ret;
        }
        return ret;
    }
}

