/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.inspector;

import de.destatis.core.connect.util.Contract;

public class ProblemPosition {
    private int line;
    private int column;
    private String xpath;
    private int msgid;
    private int declid;
    private int recno;
    private String varname;

    public ProblemPosition(int line, int column, String xpath, int msgid, int declid, int recno, String varname) {
        Contract.verify((line > 0 || line == -1 ? 1 : 0) != 0, (String)"Zeilennummer muss gr\u00f6\u00dfer 0 oder -1 sein.");
        Contract.verify((column > 0 || column == -1 ? 1 : 0) != 0, (String)"Spaltennummer muss gr\u00f6\u00dfer 0 oder -1 sein.");
        Contract.verify((xpath != null ? 1 : 0) != 0, (String)"XPath-Ausdruck muss ungleich null sein.");
        Contract.verify((msgid >= 0 ? 1 : 0) != 0, (String)"Nachrichtennummer muss eine positive Zahl sein.");
        Contract.verify((declid >= 0 ? 1 : 0) != 0, (String)"Meldungsnummer muss eine positive Zahl sein.");
        Contract.verify((recno >= 0 ? 1 : 0) != 0, (String)"Satznummer muss eine positive Zahl sein.");
        Contract.verify((msgid > 0 || declid == 0 ? 1 : 0) != 0, (String)"Nachrichtennummer muss ungleich 0 sein.");
        Contract.verify((msgid > 0 || varname == null || varname.length() == 0 ? 1 : 0) != 0, (String)"Nachrichtennummer muss ungleich 0 sein.");
        Contract.verify((declid > 0 || recno == 0 ? 1 : 0) != 0, (String)"Meldungsnummer muss ungleich 0 sein.");
        this.line = line;
        this.column = column;
        this.xpath = xpath;
        this.msgid = msgid;
        this.declid = declid;
        this.recno = recno;
        this.varname = varname;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String getXPath() {
        return this.xpath;
    }

    public int getMessageID() {
        return this.msgid;
    }

    public int getDeclarationID() {
        return this.declid;
    }

    public int getRecordNo() {
        return this.recno;
    }

    public String getVariableName() {
        return this.varname;
    }

    public String toString() {
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        if (this.line != -1) {
            buffer.append("Zeile:             ");
            buffer.append(this.line);
            buffer.append(lineSeparator);
        }
        if (this.column != -1) {
            buffer.append("Spalte:            ");
            buffer.append(this.column);
            buffer.append(lineSeparator);
        }
        buffer.append("XPath:             ");
        buffer.append(this.xpath);
        if (this.msgid > 0) {
            buffer.append(lineSeparator);
            buffer.append("Nachrichtennummer: ");
            buffer.append(this.msgid);
        }
        if (this.declid > 0) {
            buffer.append(lineSeparator);
            buffer.append("Meldungsnummer:    ");
            buffer.append(this.declid);
        }
        if (this.recno > 0) {
            buffer.append(lineSeparator);
            buffer.append("Satznummer:        ");
            buffer.append(this.recno);
        }
        if (this.varname != null && this.varname.length() > 0) {
            buffer.append(lineSeparator);
            buffer.append("Variablenname:     ");
            buffer.append(this.varname);
        }
        return buffer.toString();
    }
}

