/*
 * Decompiled with CFR 0.152.
 */
package de.his.net;

import de.his.net.TCPConnectionTester;
import de.his.tools.ParseSQL;
import de.his.tools.StringUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.Binding;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import org.apache.log4j.Logger;

public class LDAPClient {
    private static Logger logger = Logger.getLogger(LDAPClient.class);
    private static final String[] SECURITY_METHODS = new String[]{"none", "ssl", "tls"};
    private static final int SECURITY_SSL = 1;
    private static final int SECURITY_TLS = 2;
    private static final String[] SEARCH_SCOPE_NAME = new String[]{"base", "one", "sub"};
    private static final int[] SEARCH_SCOPE_INT = new int[]{0, 1, 2};
    private Properties connectionProperties = null;
    private LdapContext context = null;
    private boolean connected = false;
    private StartTlsResponse tls = null;
    private String lastError = null;
    private boolean logErrors = true;

    public LDAPClient(Properties prop) {
        this.connectionProperties = prop;
        if (prop.getProperty("IGNORE_ERRORS", "n").equalsIgnoreCase("y")) {
            this.logErrors = false;
        }
        try {
            this.context = this.connectLDAPContext();
            this.connected = true;
        }
        catch (NamingException e) {
            this.error(e);
            this.connected = false;
        }
        catch (IOException e) {
            this.error(e);
            this.connected = false;
        }
    }

    private LdapContext connectLDAPContext() throws NamingException, IOException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        int security = StringUtil.indexOf(this.connectionProperties.getProperty("security", "none").toLowerCase(), SECURITY_METHODS);
        if (security < 0) {
            logger.warn((Object)("Konfigurationseigenschaft security=" + this.connectionProperties.getProperty("security") + " ist ungueltig. Erwartet: " + StringUtil.arrayToString(SECURITY_METHODS, ", ")));
        }
        String protocol = "ldap";
        int port = Integer.parseInt(this.connectionProperties.getProperty("port", "389").trim());
        if (security == 1) {
            env.put("java.naming.security.protocol", "ssl");
            protocol = "ldaps";
            port = Integer.parseInt(this.connectionProperties.getProperty("port", "636").trim());
        }
        String server = this.findReachableServer(port);
        env.put("java.naming.provider.url", protocol + "://" + server + ":" + port + "/" + this.connectionProperties.getProperty("binddn", ""));
        env.put("java.naming.security.authentication", "none");
        if (this.connectionProperties.getProperty("pre-username") != null && this.connectionProperties.getProperty("pre-password") != null) {
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", this.connectionProperties.getProperty("pre-username"));
            env.put("java.naming.security.credentials", this.connectionProperties.getProperty("pre-password"));
        }
        if (this.connectionProperties.getProperty("referrals") != null) {
            env.put("java.naming.referral", this.connectionProperties.getProperty("referrals"));
        }
        if (this.connectionProperties.getProperty("derefAliases") != null) {
            env.put("java.naming.ldap.derefAliases", this.connectionProperties.getProperty("derefAliases"));
        }
        if (this.connectionProperties.getProperty("timeout") != null) {
            env.put("com.sun.jndi.ldap.connect.timeout", Integer.toString(Integer.parseInt(this.connectionProperties.getProperty("timeout")) * 1000));
        }
        if (this.connectionProperties.getProperty("version") != null) {
            env.put("java.naming.ldap.version", this.connectionProperties.getProperty("version"));
        }
        InitialLdapContext ctx = new InitialLdapContext(env, null);
        if (security == 2) {
            this.tls = (StartTlsResponse)ctx.extendedOperation(new StartTlsRequest());
            this.tls.negotiate();
        }
        if (this.connectionProperties.getProperty("username") != null && this.connectionProperties.getProperty("password") != null) {
            ctx.addToEnvironment("java.naming.security.authentication", "simple");
            ctx.addToEnvironment("java.naming.security.principal", this.connectionProperties.getProperty("username"));
            String charset = this.connectionProperties.getProperty("charset", "UTF-8");
            ctx.addToEnvironment("java.naming.security.credentials", this.connectionProperties.getProperty("password").getBytes(charset));
        }
        return ctx;
    }

    private String findReachableServer(int port) {
        String[] names;
        if (this.connectionProperties.getProperty("reachability-check", "n").trim().equalsIgnoreCase("n")) {
            return this.connectionProperties.getProperty("server", "").trim();
        }
        String servers = this.connectionProperties.getProperty("server", "").trim();
        for (String server : names = servers.split(",")) {
            try {
                InetAddress[] addresses;
                for (InetAddress address : addresses = InetAddress.getAllByName(server.trim())) {
                    TCPConnectionTester tester = new TCPConnectionTester(address.getHostAddress(), port, 3000);
                    tester.close();
                    if (tester.getError() == null) {
                        return address.getHostAddress();
                    }
                    logger.warn((Object)("LDAP-Reachability-Test failed for server " + address.getHostAddress() + ": " + tester.getError()));
                }
            }
            catch (UnknownHostException e) {
                logger.warn((Object)("LDAP-Reachability-Test failed because \"" + server + "\" has no DNS entry."));
            }
        }
        return names[0];
    }

    public void close() {
        try {
            if (this.tls != null) {
                this.tls.close();
            }
            if (this.context != null) {
                this.context.close();
            }
            this.connected = false;
        }
        catch (NamingException e) {
            this.error(e);
        }
        catch (IOException e) {
            this.error(e);
        }
    }

    public NamingEnumeration<SearchResult> search(String base, String filter, Map<?, ?> args, String attributes, String scope) {
        SearchControls searchControls = new SearchControls();
        NamingEnumeration<SearchResult> namingEnumeration = null;
        if (attributes != null && !attributes.trim().equals("") && !attributes.trim().equals("*")) {
            searchControls.setReturningAttributes(StringUtil.vectorToArray(StringUtil.stringToVector(attributes, ",")));
        }
        if (scope != null && !scope.trim().equals("")) {
            int scopeIdx = StringUtil.indexOf(scope, SEARCH_SCOPE_NAME);
            searchControls.setSearchScope(SEARCH_SCOPE_INT[scopeIdx]);
        }
        String[] keys = StringUtil.getParsFromString(filter);
        Object[] argArray = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            argArray[i] = args.get(key);
            filter = filter.replaceFirst("\\[" + key + "\\]", "{" + i + "}");
        }
        try {
            namingEnumeration = this.context.search(base, filter, argArray, searchControls);
        }
        catch (NamingException e) {
            logger.error((Object)e, (Throwable)e);
            this.lastError = e.toString();
        }
        return namingEnumeration;
    }

    public String find(String base, String filter, Map<?, ?> args, String attributes, String scope) {
        String res;
        block6: {
            res = null;
            NamingEnumeration<SearchResult> results = this.search(base, filter, args, attributes, scope);
            try {
                if (results == null || !results.hasMore()) break block6;
                SearchResult result = results.next();
                res = StringUtil.unquoteDoubles(result.getName());
                if (base != null && !base.trim().equals("")) {
                    res = res + "," + base;
                }
                logger.debug((Object)("dn: " + res));
                try {
                    if (results.hasMore()) {
                        res = null;
                        logger.info((Object)"Mehr als ein Treffer bei LDAP-Suche.");
                    }
                }
                catch (Exception e2) {
                    logger.debug((Object)"Fehler beim Aufruf von results.hasMore():", (Throwable)e2);
                }
            }
            catch (NamingException e) {
                this.error(e);
            }
        }
        return res;
    }

    public Properties getAttributes(String dn) {
        return this.getAttributes(dn, null);
    }

    public Properties getAttributes(String dn, String attributes) {
        Attributes attrs = null;
        try {
            attrs = this.context.getAttributes(dn.replace("/", "\\/"));
        }
        catch (NamingException e) {
            this.error(e);
        }
        return LDAPClient.attributesToProperties(attrs, attributes);
    }

    public String getLastError() {
        return this.lastError;
    }

    public void setLastError(String error) {
        this.lastError = error;
    }

    static Properties attributesToProperties(Attributes attrs, String attributes) {
        Properties res = new Properties();
        String[] wantedAttrs = null;
        String[] aliasAttrs = null;
        if (attributes != null) {
            wantedAttrs = ParseSQL.getDBColNames("SELECT " + attributes.toLowerCase());
            aliasAttrs = ParseSQL.getDBColNameAliases("SELECT " + attributes.toLowerCase());
        }
        if (attrs != null) {
            NamingEnumeration<? extends Attribute> enm = attrs.getAll();
            while (enm.hasMoreElements()) {
                Attribute key = (Attribute)enm.nextElement();
                try {
                    String keyString = key.getID();
                    if (wantedAttrs == null || aliasAttrs == null) {
                        res.put(keyString, key.get().toString());
                        continue;
                    }
                    int idx = StringUtil.indexOf(keyString.toLowerCase(), wantedAttrs);
                    if (idx <= -1) continue;
                    res.put(aliasAttrs[idx], key.get().toString());
                }
                catch (NamingException e) {
                    logger.warn((Object)e, (Throwable)e);
                }
            }
        }
        return res;
    }

    public void addEntry(String dn, Object obj) {
        try {
            this.context.bind(dn, obj);
        }
        catch (NamingException e) {
            this.error(e);
        }
        catch (RuntimeException e) {
            this.error(e);
        }
    }

    public void overWriteEntry(String dn, Object obj) {
        try {
            this.context.rebind(dn, obj);
        }
        catch (NamingException e) {
            this.error(e);
        }
        catch (RuntimeException e) {
            this.error(e);
        }
    }

    public void removeEntry(String dn) {
        try {
            this.context.destroySubcontext(dn);
        }
        catch (NamingException e) {
            this.error(e);
        }
        catch (RuntimeException e) {
            this.error(e);
        }
    }

    public void removeAllEntriesOf(String name) {
        try {
            NamingEnumeration<Binding> namingEnum = this.context.listBindings(name);
            Binding bind = null;
            while (namingEnum.hasMoreElements()) {
                bind = (Binding)namingEnum.nextElement();
                this.context.unbind(bind.getNameInNamespace());
            }
        }
        catch (NamingException e) {
            this.error(e);
        }
        catch (RuntimeException e) {
            this.error(e);
        }
    }

    public static String extractLDAPErrorMessage(String message) {
        String res = message;
        if (message == null) {
            return null;
        }
        int start = message.indexOf(91);
        int end = message.indexOf(93);
        if (start > -1 && end > -1 && end > start) {
            res = message.substring(start + 1, end);
        }
        return res;
    }

    public boolean isConnected() {
        return this.connected;
    }

    void error(Exception e) {
        if (this.logErrors) {
            logger.error((Object)e, (Throwable)e);
        } else {
            logger.info((Object)e);
            logger.debug((Object)"", (Throwable)e);
        }
        this.lastError = e.toString();
    }
}

