/*
 * Decompiled with CFR 0.152.
 */
package de.his.net;

import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class IPRange {
    private static Logger logger = Logger.getLogger(IPRange.class);
    private InetAddress ipBase = null;
    private BigInteger ipBaseInt = null;
    private BigInteger ipBoundInt = null;
    private int mask = -1;
    private int byteCount = 4;

    private BigInteger byteArrayToUnsignedBigInteger(byte[] bytes) {
        byte[] temp = new byte[bytes.length + 1];
        System.arraycopy(bytes, 0, temp, 1, bytes.length);
        return new BigInteger(temp);
    }

    public IPRange(String iprange) throws UnknownHostException {
        int pos = iprange.indexOf(47);
        if (pos > -1) {
            this.ipBase = InetAddress.getByName(iprange.substring(0, pos));
            this.mask = Integer.parseInt(iprange.substring(pos + 1));
        } else {
            this.ipBase = InetAddress.getByName(iprange);
            this.mask = this.ipBase.getAddress().length * 8;
        }
        this.byteCount = this.ipBase.getAddress().length;
        this.ipBaseInt = this.byteArrayToUnsignedBigInteger(this.ipBase.getAddress());
        BigInteger ipMaskInt = BigInteger.ZERO;
        for (int i = 0; i < this.mask; ++i) {
            ipMaskInt = ipMaskInt.shiftLeft(1);
            ipMaskInt = ipMaskInt.add(BigInteger.ONE);
        }
        int size = this.ipBase.getAddress().length * 8;
        ipMaskInt = ipMaskInt.shiftLeft(size - this.mask);
        this.ipBaseInt = this.ipBaseInt.and(ipMaskInt);
        this.ipBoundInt = this.ipBaseInt.add(ipMaskInt.xor(BigInteger.valueOf(2L).pow(size).subtract(BigInteger.ONE)));
    }

    public boolean inRange(InetAddress ip) {
        BigInteger ipInt = this.byteArrayToUnsignedBigInteger(ip.getAddress());
        return this.ipBaseInt.compareTo(ipInt) <= 0 && this.ipBoundInt.compareTo(ipInt) >= 0;
    }

    public String toString() {
        String ip = this.ipBaseInt.toString();
        try {
            byte[] temp;
            byte[] bytes = temp = this.ipBaseInt.toByteArray();
            if (temp.length % 2 == 1 && temp[0] == 0) {
                bytes = new byte[temp.length - 1];
                System.arraycopy(temp, 1, bytes, 0, temp.length - 1);
            }
            if (bytes.length < this.byteCount) {
                temp = bytes;
                bytes = new byte[this.byteCount];
                System.arraycopy(temp, 0, bytes, this.byteCount - temp.length, temp.length);
            }
            ip = InetAddress.getByAddress(bytes).getHostAddress();
        }
        catch (UnknownHostException e) {
            logger.error((Object)e, (Throwable)e);
        }
        return ip + "/" + this.mask;
    }

    public static List<IPRange> parseIPRanges(String ipranges) {
        ArrayList<IPRange> res = new ArrayList<IPRange>();
        StringTokenizer st = new StringTokenizer(ipranges, ",\t\n\r\f|");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            try {
                res.add(new IPRange(token));
            }
            catch (UnknownHostException e) {
                logger.error((Object)("Fehler beim Parsen des IPRanges \"" + token + "\": " + e));
            }
        }
        return res;
    }

    public static boolean ipAddressInRanges(InetAddress ipAddress, List<IPRange> ranges) {
        if (ranges == null) {
            return true;
        }
        for (IPRange iprange : ranges) {
            if (!iprange.inRange(ipAddress)) continue;
            return true;
        }
        return false;
    }
}

