/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.validation;

import java.io.Serializable;
import java.util.Locale;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.GenericValidator;
import org.apache.commons.validator.ValidatorAction;
import org.dbforms.config.DbFormsErrors;
import org.dbforms.config.FieldValue;
import org.dbforms.config.FieldValues;
import org.dbforms.config.ValidationException;
import org.dbforms.util.Util;
import org.dbforms.validation.DbFormsValidatorUtil;

public class DbFormsValidator
implements Serializable {
    private static Log logCat = LogFactory.getLog((String)(class$org$dbforms$validation$DbFormsValidator == null ? (class$org$dbforms$validation$DbFormsValidator = DbFormsValidator.class$("org.dbforms.validation.DbFormsValidator")) : class$org$dbforms$validation$DbFormsValidator).getName());
    private static final String REQUIRED = "required";
    private static final String MASK = "mask";
    private static final String RANGE = "range";
    private static final String MINLENGTH = "minlength";
    private static final String MAXLENGTH = "maxlength";
    private static final String BYTE = "byte";
    private static final String SHORT = "short";
    private static final String LONG = "long";
    private static final String INTEGER = "integer";
    private static final String FLOAT = "float";
    private static final String DOUBLE = "double";
    private static final String DATE = "date";
    private static final String CREDITCARD = "creditcard";
    private static final String EMAIL = "email";
    static /* synthetic */ Class class$org$dbforms$validation$DbFormsValidator;

    public static boolean validateByte(Object bean, ValidatorAction va, Field field, Vector errors, Locale locale, DbFormsErrors dbFormsErrors) {
        String value = DbFormsValidator.getValue(bean, field);
        if (!Util.isNull(value)) {
            if (!GenericValidator.isByte((String)value)) {
                errors.add(new ValidationException(DbFormsValidator.dbFormsErrorMessage(BYTE, va, field, locale, dbFormsErrors)));
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean validateCreditCard(Object bean, ValidatorAction va, Field field, Vector errors, Locale locale, DbFormsErrors dbFormsErrors) {
        String value = DbFormsValidator.getValue(bean, field);
        if (!Util.isNull(value) && !GenericValidator.isCreditCard((String)value)) {
            errors.add(new ValidationException(DbFormsValidator.dbFormsErrorMessage(CREDITCARD, va, field, locale, dbFormsErrors)));
            return false;
        }
        return true;
    }

    public static boolean validateDate(Object bean, ValidatorAction va, Field field, Vector errors, Locale locale, DbFormsErrors dbFormsErrors) {
        boolean bValid = true;
        String value = DbFormsValidator.getValue(bean, field);
        if (!Util.isNull(value)) {
            value = ((FieldValues)bean).get(field.getProperty()).getFieldValue();
            String datePattern = field.getVarValue("datePattern");
            String datePatternStrict = field.getVarValue("datePatternStrict");
            if (!GenericValidator.isBlankOrNull((String)value)) {
                try {
                    bValid = datePattern != null && datePattern.length() > 0 ? GenericValidator.isDate((String)value, (String)datePattern, (boolean)false) : (!Util.isNull(datePatternStrict) ? GenericValidator.isDate((String)value, (String)datePatternStrict, (boolean)true) : DbFormsValidator.getValue(bean, field) != null);
                }
                catch (Exception e) {
                    errors.add(new ValidationException(DbFormsValidator.dbFormsErrorMessage(DATE, va, field, locale, dbFormsErrors)));
                    bValid = false;
                }
            }
        }
        if (!bValid) {
            errors.add(new ValidationException(DbFormsValidator.dbFormsErrorMessage(DATE, va, field, locale, dbFormsErrors)));
        }
        return bValid;
    }

    public static boolean validateDouble(Object bean, ValidatorAction va, Field field, Vector errors, Locale locale, DbFormsErrors dbFormsErrors) {
        String value = DbFormsValidator.getValue(bean, field);
        if (!Util.isNull(value)) {
            if (!GenericValidator.isDouble((String)value)) {
                errors.add(new ValidationException(DbFormsValidator.dbFormsErrorMessage(DOUBLE, va, field, locale, dbFormsErrors)));
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean validateEmail(Object bean, ValidatorAction va, Field field, Vector errors, Locale locale, DbFormsErrors dbFormsErrors) {
        String value = DbFormsValidator.getValue(bean, field);
        if (!Util.isNull(value) && !GenericValidator.isEmail((String)value)) {
            errors.add(new ValidationException(DbFormsValidator.dbFormsErrorMessage(EMAIL, va, field, locale, dbFormsErrors)));
            return false;
        }
        return true;
    }

    public static boolean validateFloat(Object bean, ValidatorAction va, Field field, Vector errors, Locale locale, DbFormsErrors dbFormsErrors) {
        String value = DbFormsValidator.getValue(bean, field);
        if (!Util.isNull(value)) {
            if (!GenericValidator.isFloat((String)value)) {
                errors.add(new ValidationException(DbFormsValidator.dbFormsErrorMessage(FLOAT, va, field, locale, dbFormsErrors)));
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean validateInteger(Object bean, ValidatorAction va, Field field, Vector errors, Locale locale, DbFormsErrors dbFormsErrors) {
        String value = DbFormsValidator.getValue(bean, field);
        if (!Util.isNull(value)) {
            if (!GenericValidator.isInt((String)value)) {
                errors.add(new ValidationException(DbFormsValidator.dbFormsErrorMessage(INTEGER, va, field, locale, dbFormsErrors)));
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean validateLong(Object bean, ValidatorAction va, Field field, Vector errors, Locale locale, DbFormsErrors dbFormsErrors) {
        String value = DbFormsValidator.getValue(bean, field);
        if (!Util.isNull(value)) {
            if (!GenericValidator.isLong((String)value)) {
                errors.add(new ValidationException(DbFormsValidator.dbFormsErrorMessage(LONG, va, field, locale, dbFormsErrors)));
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean validateMask(Object bean, ValidatorAction va, Field field, Vector errors, Locale locale, DbFormsErrors dbFormsErrors) {
        String value = DbFormsValidator.getValue(bean, field);
        if (!Util.isNull(value)) {
            String mask = field.getVarValue(MASK);
            if (!GenericValidator.isBlankOrNull((String)value) && !GenericValidator.matchRegexp((String)value, (String)mask)) {
                errors.add(new ValidationException(DbFormsValidator.dbFormsErrorMessage(MASK, va, field, locale, dbFormsErrors)));
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean validateMaxLength(Object bean, ValidatorAction va, Field field, Vector errors, Locale locale, DbFormsErrors dbFormsErrors) {
        String sMaxLength;
        int max;
        String value = DbFormsValidator.getValue(bean, field);
        if (!Util.isNull(value) && !GenericValidator.maxLength((String)value, (int)(max = Integer.parseInt(sMaxLength = field.getVarValue(MAXLENGTH))))) {
            errors.add(new ValidationException(DbFormsValidator.dbFormsErrorMessage(MAXLENGTH, va, field, locale, dbFormsErrors)));
            return false;
        }
        return true;
    }

    public static boolean validateMinLength(Object bean, ValidatorAction va, Field field, Vector errors, Locale locale, DbFormsErrors dbFormsErrors) {
        String sMinLength;
        int min;
        String value = DbFormsValidator.getValue(bean, field);
        if (!Util.isNull(value) && !GenericValidator.minLength((String)value, (int)(min = Integer.parseInt(sMinLength = field.getVarValue(MINLENGTH))))) {
            errors.add(new ValidationException(DbFormsValidator.dbFormsErrorMessage(MINLENGTH, va, field, locale, dbFormsErrors)));
            return false;
        }
        return true;
    }

    public static boolean validateRange(Object bean, ValidatorAction va, Field field, Vector errors, Locale locale, DbFormsErrors dbFormsErrors) {
        String value = DbFormsValidator.getValue(bean, field);
        if (!Util.isNull(value)) {
            double max;
            double min;
            String sMin = field.getVarValue("min");
            String sMax = field.getVarValue("max");
            double iValue = Double.parseDouble(value);
            if (!GenericValidator.isInRange((double)iValue, (double)(min = Double.parseDouble(sMin)), (double)(max = Double.parseDouble(sMax)))) {
                errors.add(new ValidationException(DbFormsValidator.dbFormsErrorMessage(RANGE, va, field, locale, dbFormsErrors)));
                return false;
            }
        }
        return true;
    }

    public static boolean validateRequired(Object bean, ValidatorAction va, Field field, Vector errors, Locale locale, DbFormsErrors dbFormsErrors) {
        FieldValues hash = (FieldValues)bean;
        if (Util.isNull(field.getProperty())) {
            return true;
        }
        FieldValue f = hash.get(field.getProperty());
        if (f == null) {
            return true;
        }
        if (f.getFieldValue().equals(f.getOldValue()) && !Util.isNull(f.getFieldValue())) {
            return true;
        }
        String value = null;
        Object obj = f.getFieldValueAsObject();
        if (obj != null) {
            value = obj.toString();
        }
        if (GenericValidator.isBlankOrNull(value)) {
            errors.add(new ValidationException(DbFormsValidator.dbFormsErrorMessage(REQUIRED, va, field, locale, dbFormsErrors)));
            return false;
        }
        return true;
    }

    public static boolean validateShort(Object bean, ValidatorAction va, Field field, Vector errors, Locale locale, DbFormsErrors dbFormsErrors) {
        String value = DbFormsValidator.getValue(bean, field);
        if (!Util.isNull(value)) {
            if (!GenericValidator.isShort((String)value)) {
                errors.add(new ValidationException(DbFormsValidator.dbFormsErrorMessage(SHORT, va, field, locale, dbFormsErrors)));
                return false;
            }
            return true;
        }
        return true;
    }

    private static String getValue(Object bean, Field field) {
        try {
            FieldValues hash = (FieldValues)bean;
            if (Util.isNull(field.getProperty())) {
                return null;
            }
            FieldValue f = hash.get(field.getProperty());
            if (f == null) {
                return null;
            }
            if (f.getFieldValue().equals(f.getOldValue())) {
                return null;
            }
            String value = null;
            Object obj = f.getFieldValueAsObject();
            value = obj != null ? obj.toString() : f.getFieldValue();
            return value;
        }
        catch (Exception e) {
            logCat.error((Object)e);
            return null;
        }
    }

    private static String dbFormsErrorMessage(String type, ValidatorAction va, Field field, Locale locale, DbFormsErrors dbFormsErrors) {
        String message = DbFormsValidatorUtil.getMessage(type, va, locale, field, dbFormsErrors);
        return message;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

