/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map;

import de.destatis.core.map.Binding;
import de.destatis.core.map.BindingGroup;
import de.destatis.core.map.FieldBinding;
import de.destatis.core.map.FieldGroupBinding;
import de.destatis.core.map.FieldSetBinding;
import de.destatis.core.map.Mapping;
import de.destatis.core.map.MappingCheckResult;
import de.destatis.core.map.MappingProblem;
import de.destatis.core.map.model.BindingHelper;
import de.destatis.core.map.model.HelpFeatureBinding;
import de.destatis.core.map.model.HelpFeatureConfigValue;
import de.destatis.core.map.model.SelectorBinding;
import de.statspez.pleditor.generator.interpreter.InterpreterContext;
import de.statspez.pleditor.generator.interpreter.ProgramInterpreter;
import de.statspez.pleditor.generator.interpreter.SimpleDataset;
import de.statspez.pleditor.generator.runtime.ClassificationGroup;
import de.statspez.pleditor.generator.runtime.plausi.SatzInterface;
import de.statspez.sdf.generator.interpreter.SDFFieldDescriptorFactory;
import de.statspez.sdf.generator.meta.MetaCustomSDFFeldReferenz;
import de.statspez.sdf.generator.meta.MetaCustomSDFMerkmal;
import de.statspez.sdf.generator.meta.generated.MetaErhebungsbeschreibung;
import de.statspez.sdf.generator.meta.generated.MetaSDFAusgabegruppe;
import de.statspez.sdf.generator.meta.generated.MetaSDFAusgabesatz;
import de.statspez.sdf.generator.meta.generated.MetaSDFFeldReferenz;
import de.statspez.sdf.generator.meta.generated.MetaSDFMerkmal;
import de.statspez.sdf.generator.meta.generated.MetaSDFMerkmalsgruppe;
import de.statspez.sdf.generator.meta.util.SDFStructureHelper;
import de.statspez.sdf.generator.util.SDFUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MappingCheck {
    private Map bindingGroupOffsetCache;
    private static final int MAX_ALLOWED_FIELDS = 10000;

    public MappingCheckResult check(Mapping mapping, MetaErhebungsbeschreibung surveyDefinition) {
        this.bindingGroupOffsetCache = new HashMap();
        MappingCheckResult result = new MappingCheckResult();
        try {
            this.doCheck(mapping, surveyDefinition, result);
        }
        catch (Throwable e) {
            e.printStackTrace();
            result.addProblem(new MappingProblem(1, mapping, "Laufzeitfehler: " + e.toString(), e));
        }
        this.bindingGroupOffsetCache.clear();
        this.bindingGroupOffsetCache = null;
        return result;
    }

    private MappingCheckResult doCheck(Mapping mapping, MetaErhebungsbeschreibung surveyDefinition, MappingCheckResult result) {
        InterpreterContext context;
        if (surveyDefinition == null) {
            result.addProblem(new MappingProblem(2, mapping, "Es wurde keine Erhebungsbeschreibung zugeordnet."));
        } else {
            String mappingResourceId = mapping.getId();
            String surveyResourceId = "1" + surveyDefinition.getProzedurCode();
            String mappingResourceIdWithoutVersion = mappingResourceId.substring(0, 17);
            String surveyResourceIdWithoutVersion = surveyResourceId.substring(0, 17);
            if (!surveyResourceIdWithoutVersion.equals(mappingResourceIdWithoutVersion)) {
                result.addProblem(new MappingProblem(2, mapping, "Das Mapping passt nicht zur zugeordneten Erhebungsbeschreibung. Das Mapping wurde f\u00fcr die Erhebungsbeschreibung '" + mappingResourceId + "' erstellt, f\u00fcr die Pr\u00fcfung des Mappings wurde aber die Erhebungsbeschreibung '" + surveyResourceId + "' \u00fcbergeben. Nur die Version der Erhebungsbeschreibung darf unterschiedlich sein."));
            } else {
                int compare = mappingResourceId.compareTo(surveyResourceId);
                if (compare > 0) {
                    result.addProblem(new MappingProblem(3, mapping, "Das Mapping wurde f\u00fcr eine neuere Version der Erhebungsbeschreibung erstellt."));
                } else if (compare < 0) {
                    result.addProblem(new MappingProblem(3, mapping, "Das Mapping wurde f\u00fcr eine \u00e4ltere Version der Erhebungsbeschreibung erstellt."));
                }
            }
        }
        if (surveyDefinition != null) {
            this.checkSDFErhebungsbeschreibung(result, surveyDefinition, mapping);
        }
        if (surveyDefinition != null) {
            context = new InterpreterContext();
            SDFFieldDescriptorFactory fieldDescriptorFactory = new SDFFieldDescriptorFactory(surveyDefinition);
            Iterator iter = fieldDescriptorFactory.getClassificationGroups();
            while (iter != null && iter.hasNext()) {
                ClassificationGroup classGroup = (ClassificationGroup)iter.next();
                context.registerClassificationGroup(classGroup.value().asString(), classGroup);
            }
        } else {
            context = null;
        }
        HelpFeatureConfigValue helpfeatureConfig = mapping.getHelpFeatureConfig();
        HashMap helpFeaturePositions = new HashMap();
        HashMap selectorPositions = new HashMap();
        HashMap positions = new HashMap();
        MetaSDFAusgabegruppe defaultAusgabeGruppe = surveyDefinition != null ? SDFStructureHelper.getDeafaultDataGroup((MetaSDFAusgabesatz)surveyDefinition.getAusgabesatz()) : null;
        Iterator iter = mapping.getBindings();
        while (iter.hasNext()) {
            Binding binding = (Binding)iter.next();
            if (binding instanceof HelpFeatureBinding) {
                MetaCustomSDFFeldReferenz reference = SDFStructureHelper.findHelpFeature((MetaErhebungsbeschreibung)surveyDefinition, (String)binding.getId());
                if (reference == null) {
                    result.addProblem(new MappingProblem(3, binding, "Es existiert kein entsprechendes Hilfsmerkmal in der Erhebungsbeschreibung."));
                }
                this.checkHelpFeatureBinding(result, (HelpFeatureBinding)binding, (MetaSDFFeldReferenz)reference, helpFeaturePositions, context);
                continue;
            }
            if (binding instanceof SelectorBinding) {
                MetaCustomSDFFeldReferenz reference;
                MetaCustomSDFFeldReferenz metaCustomSDFFeldReferenz = reference = defaultAusgabeGruppe == null ? null : SDFStructureHelper.findFeature((MetaSDFAusgabegruppe)defaultAusgabeGruppe, (String)binding.getId());
                if (reference == null) {
                    result.addProblem(new MappingProblem(3, binding, "Es existiert kein entsprechender Selektor in der Erhebungsbeschreibung."));
                }
                this.checkSelectorBinding(result, helpfeatureConfig, (SelectorBinding)binding, (MetaSDFFeldReferenz)reference, helpFeaturePositions, selectorPositions, context);
                continue;
            }
            if (binding instanceof FieldSetBinding) {
                positions.clear();
                positions.putAll(selectorPositions);
                if (helpfeatureConfig.isEachRecord()) {
                    positions.putAll(helpFeaturePositions);
                }
                int fieldSetBindingFieldCount = this.getFieldSetBindingFieldCount((FieldSetBinding)binding);
                fieldSetBindingFieldCount = MappingCheck.safeAddUp(fieldSetBindingFieldCount, positions.size());
                boolean checkPositions = true;
                if (fieldSetBindingFieldCount > 10000) {
                    result.addProblem(new MappingProblem(1, binding, "F\u00fcr die Satzart wurden " + fieldSetBindingFieldCount + " Felder definiert. Es werden maximal " + 10000 + " Felder unterst\u00fctzt. Bitte \u00fcberpr\u00fcfen und reduzieren Sie die Anzahl der Wiederholungen innerhalb dieser Satzart."));
                    checkPositions = false;
                }
                MetaSDFAusgabegruppe fieldSet = null;
                if (surveyDefinition != null) {
                    Iterator fieldSets = surveyDefinition.getAusgabesatz().getAusgabegruppen();
                    while (fieldSets.hasNext()) {
                        MetaSDFAusgabegruppe tmpFieldSet = (MetaSDFAusgabegruppe)fieldSets.next();
                        if (tmpFieldSet.getAttributDaten() != 1 || !tmpFieldSet.getName().equals(binding.getId())) continue;
                        fieldSet = tmpFieldSet;
                        break;
                    }
                    if (fieldSet == null) {
                        result.addProblem(new MappingProblem(3, binding, "Es existiert keine entsprechende Ausgabegruppe in der Erhebungsbeschreibung."));
                    }
                }
                this.checkFieldSetBinding(result, (FieldSetBinding)binding, fieldSet, checkPositions ? positions : null, context);
                continue;
            }
            result.addProblem(new MappingProblem(1, binding, "Ung\u00fcltiges Binding: '" + (binding == null ? "null" : binding.getClass().getName()) + "'."));
        }
        return result;
    }

    private void checkFieldSetBinding(MappingCheckResult result, FieldSetBinding fieldSetBinding, MetaSDFAusgabegruppe fieldSet, Map positions, InterpreterContext context) {
        Iterator iter = fieldSetBinding.getBindings();
        while (iter.hasNext()) {
            Binding binding = (Binding)iter.next();
            MetaSDFFeldReferenz reference = null;
            if (fieldSet != null) {
                Iterator references = fieldSet.getSDFFeldReferenzen();
                while (references.hasNext()) {
                    MetaSDFFeldReferenz tmpReference = (MetaSDFFeldReferenz)references.next();
                    if (!tmpReference.getKlasse().getName().equals(binding.getId())) continue;
                    reference = tmpReference;
                    break;
                }
                if (reference == null) {
                    result.addProblem(new MappingProblem(3, binding, "Es existiert kein entsprechendes Feld in der Erhebungsbeschreibung."));
                }
            }
            if (binding instanceof FieldBinding) {
                FieldBinding fieldBinding = (FieldBinding)binding;
                this.checkFieldBinding(result, fieldBinding, reference, positions, 0, context);
                continue;
            }
            if (binding instanceof FieldGroupBinding) {
                this.checkFieldGroupBinding(result, (FieldGroupBinding)binding, reference, positions, 0, context);
                continue;
            }
            result.addProblem(new MappingProblem(1, binding, "Ung\u00fcltiges Binding: '" + (binding == null ? "null" : binding.getClass().getName()) + "'."));
        }
    }

    private void checkFieldGroupBinding(MappingCheckResult result, FieldGroupBinding fieldGroupBinding, MetaSDFFeldReferenz fieldGroupReference, Map positions, int offset, InterpreterContext context) {
        int len;
        Integer bindingGroupOffset;
        Integer quantity = fieldGroupBinding.getSize();
        if (offset == 0 && quantity != null) {
            if (quantity < 0) {
                result.addProblem(new MappingProblem(2, fieldGroupBinding, "Die Anzahl der Instanzen der Merkmalsgruppe ist ung\u00fcltig."));
            } else if (fieldGroupReference != null) {
                int minOccurs = SDFUtil.getMinOccurs((String)fieldGroupReference.getMinimaleAnzahl());
                int maxOccurs = SDFUtil.getMaxOccurs((String)fieldGroupReference.getMaximaleAnzahl());
                if (quantity < minOccurs) {
                    if (minOccurs == maxOccurs) {
                        result.addProblem(new MappingProblem(3, fieldGroupBinding, "Von der Merkmalsgruppe m\u00fcssen genau " + minOccurs + " Instanzen angegeben werden."));
                    } else {
                        result.addProblem(new MappingProblem(3, fieldGroupBinding, "Von der Merkmalsgruppe m\u00fcssen mindestens " + minOccurs + " Instanzen angegeben werden."));
                    }
                }
                if (maxOccurs != -1 && quantity > maxOccurs) {
                    if (minOccurs == maxOccurs) {
                        result.addProblem(new MappingProblem(3, fieldGroupBinding, "Von der Merkmalsgruppe m\u00fcssen genau " + minOccurs + " Instanzen angegeben werden."));
                    } else {
                        result.addProblem(new MappingProblem(3, fieldGroupBinding, "Von der Merkmalsgruppe d\u00fcrfen h\u00f6chstens " + maxOccurs + " Instanzen angegeben werden."));
                    }
                }
            }
        }
        if (positions == null) {
            bindingGroupOffset = 0;
            len = 1;
        } else {
            bindingGroupOffset = (Integer)this.bindingGroupOffsetCache.get(fieldGroupBinding);
            if (bindingGroupOffset == null) {
                bindingGroupOffset = BindingHelper.getOffset(fieldGroupBinding);
                this.bindingGroupOffsetCache.put(fieldGroupBinding, bindingGroupOffset);
            }
            if (bindingGroupOffset == 0) {
                positions = null;
                len = 1;
            } else {
                len = quantity;
            }
        }
        for (int i = 0; i < len; ++i) {
            Iterator iter = fieldGroupBinding.getBindings();
            while (iter.hasNext()) {
                Binding binding = (Binding)iter.next();
                MetaSDFFeldReferenz reference = null;
                if (offset == 0 && fieldGroupReference != null) {
                    MetaSDFMerkmalsgruppe fieldGroup = (MetaSDFMerkmalsgruppe)fieldGroupReference.getKlasse();
                    Iterator references = fieldGroup.getSDFFeldReferenzen();
                    while (references.hasNext()) {
                        MetaSDFFeldReferenz tmpReference = (MetaSDFFeldReferenz)references.next();
                        if (!tmpReference.getKlasse().getName().equals(binding.getId())) continue;
                        reference = tmpReference;
                        break;
                    }
                    if (reference == null) {
                        result.addProblem(new MappingProblem(3, binding, "Es existiert kein entsprechendes Feld in der Erhebungsbeschreibung."));
                    }
                }
                if (binding instanceof FieldBinding) {
                    this.checkFieldBinding(result, (FieldBinding)binding, reference, positions, offset, context);
                    continue;
                }
                if (binding instanceof FieldGroupBinding) {
                    this.checkFieldGroupBinding(result, (FieldGroupBinding)binding, reference, positions, offset, context);
                    continue;
                }
                if (offset != 0) continue;
                result.addProblem(new MappingProblem(1, binding, "Ung\u00fcltiges Binding: '" + (binding == null ? "null" : binding.getClass().getName()) + "'."));
            }
            offset += bindingGroupOffset.intValue();
        }
    }

    private void checkHelpFeatureBinding(MappingCheckResult result, HelpFeatureBinding fieldBinding, MetaSDFFeldReferenz fieldReference, Map helpFeaturePositions, InterpreterContext context) {
        Integer position = fieldBinding.getPosition();
        if (position != null) {
            if (position < 1) {
                result.addProblem(new MappingProblem(2, fieldBinding, "Die Position des Hilfsmerkmals ist ung\u00fcltig. Die Position muss > 0 oder leer sein."));
            }
            if (helpFeaturePositions.containsKey(position)) {
                result.addProblem(new MappingProblem(3, fieldBinding, "Die Positionsnummer wird mehrfach verwendet."));
            } else {
                helpFeaturePositions.put(position, fieldBinding);
            }
        }
        this.checkDefaultValue(result, fieldBinding, fieldReference, context);
    }

    private void checkSelectorBinding(MappingCheckResult result, HelpFeatureConfigValue helpFeatureConfig, SelectorBinding fieldBinding, MetaSDFFeldReferenz fieldReference, Map helpFeaturePositions, Map selectorPositions, InterpreterContext context) {
        Integer position = fieldBinding.getPosition();
        if (position != null) {
            if (position < 1) {
                result.addProblem(new MappingProblem(2, fieldBinding, "Die Position des Selektors ist ung\u00fcltig. Die Position muss > 0 oder leer sein."));
            }
            if (selectorPositions.containsKey(position) || helpFeatureConfig.isEachRecord() && helpFeaturePositions.containsKey(position)) {
                result.addProblem(new MappingProblem(3, fieldBinding, "Die Positionsnummer wird mehrfach verwendet."));
            } else {
                selectorPositions.put(position, fieldBinding);
            }
        }
        this.checkDefaultValue(result, fieldBinding, fieldReference, context);
    }

    private void checkFieldBinding(MappingCheckResult result, FieldBinding fieldBinding, MetaSDFFeldReferenz fieldReference, Map positions, int offset, InterpreterContext context) {
        Integer position = fieldBinding.getPosition();
        if (position != null) {
            if (offset == 0 && position < 1) {
                result.addProblem(new MappingProblem(2, fieldBinding, "Die Position des Merkmals ist ung\u00fcltig. Die Position muss > 0 oder leer sein."));
            }
            if (positions != null) {
                if (offset != 0) {
                    position = new Integer(position + offset);
                }
                if (positions.containsKey(position)) {
                    result.addProblem(new MappingProblem(3, fieldBinding, "Die Positionsnummer wird mehrfach verwendet."));
                } else {
                    positions.put(position, fieldBinding);
                }
            }
        }
        if (offset == 0) {
            this.checkDefaultValue(result, fieldBinding, fieldReference, context);
        }
    }

    private void checkDefaultValue(MappingCheckResult result, FieldBinding fieldBinding, MetaSDFFeldReferenz fieldReference, InterpreterContext context) {
        MetaCustomSDFMerkmal merkmal;
        if (fieldReference != null && context != null && fieldBinding.getDefaultValue() != null && (merkmal = (MetaCustomSDFMerkmal)fieldReference.getKlasse()).getSpecification() != null) {
            HashMap<String, String> values = new HashMap<String, String>();
            values.put(fieldBinding.getId(), fieldBinding.getDefaultValue());
            SimpleDataset dataset = new SimpleDataset(values);
            context.setSatz((SatzInterface)dataset);
            ProgramInterpreter interpreter = new ProgramInterpreter();
            try {
                context.setCurrentField(SDFFieldDescriptorFactory.createSimpleFieldDescriptor((MetaSDFMerkmal)merkmal));
                if (!interpreter.execute(merkmal.getSpecification(), context).asBoolean()) {
                    result.addProblem(new MappingProblem(3, fieldBinding, "Der Wert des " + (fieldBinding instanceof HelpFeatureBinding ? "Hilfsmerkmals" : (fieldBinding instanceof SelectorBinding ? "Selektors" : "Merkmals")) + " liegt nicht im definierten Wertebereich."));
                }
            }
            catch (Exception e) {
                result.addProblem(new MappingProblem(1, fieldBinding, "Die Merkmalspr\u00fcfung konnte nicht ausgef\u00fchrt werden.", e));
            }
        }
    }

    private void checkSDFErhebungsbeschreibung(MappingCheckResult result, MetaErhebungsbeschreibung surveyDefinition, Mapping mapping) {
        this.checkSDFHelpFeatures(result, surveyDefinition, mapping);
        this.checkSDFSelectors(result, surveyDefinition, mapping);
        Iterator ausgabegruppen = surveyDefinition.getAusgabesatz().getAusgabegruppen();
        while (ausgabegruppen.hasNext()) {
            MetaSDFAusgabegruppe ausgabegruppe = (MetaSDFAusgabegruppe)ausgabegruppen.next();
            if (1 != ausgabegruppe.getAttributDaten()) continue;
            String name = ausgabegruppe.getName();
            Binding binding = BindingHelper.getBindingById(mapping, name);
            if (!(binding instanceof FieldSetBinding)) {
                result.addProblem(new MappingProblem(2, mapping, "Nicht gemappte Ausgabegruppe '" + name + "'."));
                continue;
            }
            this.checkSDFAusgabegruppe(result, ausgabegruppe, (FieldSetBinding)binding);
        }
    }

    private void checkSDFHelpFeatures(MappingCheckResult result, MetaErhebungsbeschreibung surveyDefinition, Mapping mapping) {
        Iterator ausgabegruppen = surveyDefinition.getAusgabesatz().getAusgabegruppen();
        while (ausgabegruppen.hasNext()) {
            MetaSDFAusgabegruppe ausgabegruppe = (MetaSDFAusgabegruppe)ausgabegruppen.next();
            if (2 != ausgabegruppe.getAttributDaten()) continue;
            Iterator merkmale = ausgabegruppe.getSDFFeldReferenzen();
            while (merkmale.hasNext()) {
                MetaSDFFeldReferenz reference = (MetaSDFFeldReferenz)merkmale.next();
                MetaSDFMerkmal hilfsmerkmal = (MetaSDFMerkmal)reference.getKlasse();
                String name = hilfsmerkmal.getName();
                Binding binding = BindingHelper.getBindingById(mapping, name);
                if (binding instanceof HelpFeatureBinding) continue;
                result.addProblem(new MappingProblem(2, mapping, "Nicht gemapptes Hilfsmerkmal '" + name + "'."));
            }
        }
    }

    private void checkSDFSelectors(MappingCheckResult result, MetaErhebungsbeschreibung surveyDefinition, Mapping mapping) {
        Iterator ausgabegruppen = surveyDefinition.getAusgabesatz().getAusgabegruppen();
        while (ausgabegruppen.hasNext()) {
            MetaSDFAusgabegruppe ausgabegruppe = (MetaSDFAusgabegruppe)ausgabegruppen.next();
            if (1 != ausgabegruppe.getAttributDaten()) continue;
            Iterator references = ausgabegruppe.getSDFFeldReferenzen();
            while (references.hasNext()) {
                MetaSDFMerkmal selektor;
                String name;
                Binding binding;
                MetaSDFFeldReferenz merkmal = (MetaSDFFeldReferenz)references.next();
                if (!merkmal.isIstSelektor() || (binding = BindingHelper.getBindingById(mapping, name = (selektor = (MetaSDFMerkmal)merkmal.getKlasse()).getName())) instanceof SelectorBinding) continue;
                result.addProblem(new MappingProblem(2, mapping, "Nicht gemappter Selektor '" + name + "'."));
            }
            break block0;
        }
    }

    private void checkSDFAusgabegruppe(MappingCheckResult result, MetaSDFAusgabegruppe ausgabegruppe, FieldSetBinding fieldSetBinding) {
        Iterator references = ausgabegruppe.getSDFFeldReferenzen();
        while (references.hasNext()) {
            MetaSDFFeldReferenz reference = (MetaSDFFeldReferenz)references.next();
            if (reference.isIstSelektor()) continue;
            this.checkSDFFeldReferenz(result, reference, fieldSetBinding);
        }
    }

    private void checkSDFFeldReferenz(MappingCheckResult result, MetaSDFFeldReferenz reference, BindingGroup parentBinding) {
        if (reference.getArt() == 1) {
            MetaSDFMerkmal merkmal = (MetaSDFMerkmal)reference.getKlasse();
            String name = merkmal.getName();
            Binding binding = BindingHelper.getBindingById(parentBinding, name);
            if (!(binding instanceof FieldBinding)) {
                result.addProblem(new MappingProblem(2, parentBinding, "Nicht gemapptes Merkmal '" + name + "'."));
            }
        } else {
            MetaSDFMerkmalsgruppe merkmalsgruppe = (MetaSDFMerkmalsgruppe)reference.getKlasse();
            String name = merkmalsgruppe.getName();
            Binding binding = BindingHelper.getBindingById(parentBinding, name);
            if (!(binding instanceof FieldGroupBinding)) {
                result.addProblem(new MappingProblem(2, parentBinding, "Nicht gemappte Merkmalsgruppe '" + name + "'."));
            } else {
                Iterator references = merkmalsgruppe.getSDFFeldReferenzen();
                while (references.hasNext()) {
                    MetaSDFFeldReferenz subReference = (MetaSDFFeldReferenz)references.next();
                    this.checkSDFFeldReferenz(result, subReference, (FieldGroupBinding)binding);
                }
            }
        }
    }

    private int getFieldSetBindingFieldCount(FieldSetBinding fieldSetBinding) {
        int count = 0;
        Iterator iter = fieldSetBinding.getBindings();
        while (iter.hasNext()) {
            Binding binding = (Binding)iter.next();
            if (binding instanceof FieldBinding) {
                Integer position = ((FieldBinding)binding).getPosition();
                if (position != null) {
                    count = MappingCheck.safeAddUp(count, 1);
                }
            } else if (binding instanceof FieldGroupBinding) {
                int filedGroupCount = this.getFieldGroupBindingCount((FieldGroupBinding)binding);
                count = MappingCheck.safeAddUp(count, filedGroupCount);
            }
            if (count != Integer.MAX_VALUE) continue;
            break;
        }
        return count;
    }

    private int getFieldGroupBindingCount(FieldGroupBinding fieldGroupBinding) {
        int quantityValue;
        int count = 0;
        Integer quantity = fieldGroupBinding.getSize();
        if (quantity != null && (quantityValue = quantity.intValue()) > 0) {
            int subCount = 0;
            Iterator iter = fieldGroupBinding.getBindings();
            while (iter.hasNext()) {
                Binding binding = (Binding)iter.next();
                if (binding instanceof FieldBinding) {
                    Integer position = ((FieldBinding)binding).getPosition();
                    if (position != null) {
                        subCount = MappingCheck.safeAddUp(subCount, 1);
                    }
                } else if (binding instanceof FieldGroupBinding) {
                    int subGroupCount = this.getFieldGroupBindingCount((FieldGroupBinding)binding);
                    subCount = MappingCheck.safeAddUp(subCount, subGroupCount);
                }
                if (subCount != Integer.MAX_VALUE) continue;
                break;
            }
            count = MappingCheck.safeMultiply(subCount, quantityValue);
        }
        return count;
    }

    private static int safeAddUp(int a, int b) {
        long sum = (long)a + (long)b;
        int result = sum > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)sum;
        return result;
    }

    private static int safeMultiply(int a, int b) {
        long product = (long)a * (long)b;
        int result = product > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)product;
        return result;
    }
}

