/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.generator;

import de.destatis.core.connect.util.Contract;
import de.destatis.core.generator.AbstractDescriptor;
import de.destatis.core.generator.DataProvider;
import de.destatis.core.generator.Descriptor;
import de.destatis.core.generator.FieldDescriptor;
import de.destatis.core.generator.StructureDescriptor;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MapDataProvider
implements DataProvider {
    private Map values;
    private Set structures;

    public MapDataProvider(Map values) {
        Contract.verify(values != null, "values ist erforderlich");
        this.values = values;
        this.initStructureNodes();
    }

    @Override
    public String getFieldValue(FieldDescriptor field) {
        String path = this.getPathString(field);
        Object value = this.values.get(path);
        return value != null ? value.toString() : null;
    }

    @Override
    public DataProvider getDataProvider(StructureDescriptor structure) {
        MapDataProvider dataProvider = null;
        String path = this.getPathString(structure);
        if (this.structures.contains(path)) {
            dataProvider = this;
        }
        return dataProvider;
    }

    protected String getPathString(Descriptor descriptor) {
        String path = AbstractDescriptor.getCustomNamesPathString(descriptor);
        return path;
    }

    private void initStructureNodes() {
        this.structures = new HashSet();
        for (String key : this.values.keySet()) {
            String structure;
            int lastPathSepIndex = key.lastIndexOf(".");
            if (lastPathSepIndex == -1 || this.structures.contains(structure = key.substring(0, lastPathSepIndex))) continue;
            this.structures.add(structure);
            do {
                if ((lastPathSepIndex = structure.lastIndexOf(".")) == -1) continue;
                String parentStructure = structure.substring(0, lastPathSepIndex);
                this.structures.add(parentStructure);
                structure = parentStructure;
            } while (lastPathSepIndex != -1);
        }
    }

    @Override
    public void close() {
    }
}

