/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.connect.transfer.https;

import de.destatis.core.connect.CheckDeliveryRequest;
import de.destatis.core.connect.ClientAuthenticator;
import de.destatis.core.connect.ClientStatusEvent;
import de.destatis.core.connect.DataDelivery;
import de.destatis.core.connect.GetCommonResourceRequest;
import de.destatis.core.connect.GetSurveyResourceRequest;
import de.destatis.core.connect.GetSurveysRequest;
import de.destatis.core.connect.PingRequest;
import de.destatis.core.connect.ProtocolRequest;
import de.destatis.core.connect.Response;
import de.destatis.core.connect.ResponseStatus;
import de.destatis.core.connect.ResponseToCheckDeliveryRequest;
import de.destatis.core.connect.ResponseToDataDelivery;
import de.destatis.core.connect.ResponseToGetCommonResourceRequest;
import de.destatis.core.connect.ResponseToGetResourceRequest;
import de.destatis.core.connect.ResponseToGetSurveysRequest;
import de.destatis.core.connect.ResponseToPingRequest;
import de.destatis.core.connect.ResponseToProtocolRequest;
import de.destatis.core.connect.ServerAddress;
import de.destatis.core.connect.TransferProtocol;
import de.destatis.core.connect.TransferProtocolException;
import de.destatis.core.connect.UnsupportedProtocolException;
import de.destatis.core.connect.transfer.ProtocolHandlerBase;
import de.destatis.core.connect.transfer.https.HttpsCheckDeliveryRequestHandler;
import de.destatis.core.connect.transfer.https.HttpsDataDeliveryHandler;
import de.destatis.core.connect.transfer.https.HttpsGetCommonResourceRequestHandler;
import de.destatis.core.connect.transfer.https.HttpsGetResourceRequestHandler;
import de.destatis.core.connect.transfer.https.HttpsGetSurveysRequestHandler;
import de.destatis.core.connect.transfer.https.HttpsPingRequestHandler;
import de.destatis.core.connect.transfer.https.HttpsProtocolRequestHandler;
import de.destatis.core.connect.transfer.https.HttpsRequestHandler;
import de.destatis.core.connect.util.ClientConfig;
import de.destatis.core.connect.util.ClientLogger;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;

public class HttpsProtocolHandler
extends ProtocolHandlerBase {
    private static final String CERTIFICATE_EXT_PEM = "pem";
    private static final String CERTIFICATE_EXT_DER = "der";
    private static final String CUSTOM_CERTIFICATE_PREFIX = "CUSTOM";
    private static final ClientLogger LOG = ClientLogger.getLogger(HttpsProtocolHandler.class);

    public HttpsProtocolHandler(ClientConfig config) {
        super(config, TransferProtocol.HTTPS);
    }

    @Override
    public ResponseToDataDelivery send(ClientAuthenticator authenticator, DataDelivery req, ServerAddress to) throws TransferProtocolException {
        Response result = this.sendRequest(authenticator, new HttpsDataDeliveryHandler(req, this.getConfig()), to);
        return (ResponseToDataDelivery)result;
    }

    @Override
    public ResponseToProtocolRequest send(ClientAuthenticator authenticator, ProtocolRequest req, ServerAddress to) throws TransferProtocolException {
        Response result = this.sendRequest(authenticator, new HttpsProtocolRequestHandler(req, this.getConfig()), to);
        return (ResponseToProtocolRequest)result;
    }

    @Override
    public ResponseToGetSurveysRequest send(ClientAuthenticator authenticator, GetSurveysRequest req, ServerAddress to) throws TransferProtocolException {
        Response result = this.sendRequest(authenticator, new HttpsGetSurveysRequestHandler(req, this.getConfig()), to);
        return (ResponseToGetSurveysRequest)result;
    }

    @Override
    public ResponseToGetResourceRequest send(ClientAuthenticator authenticator, GetSurveyResourceRequest req, ServerAddress to) throws TransferProtocolException {
        Response result = this.sendRequest(authenticator, new HttpsGetResourceRequestHandler(req, this.getConfig()), to);
        return (ResponseToGetResourceRequest)result;
    }

    @Override
    public ResponseToCheckDeliveryRequest send(ClientAuthenticator authenticator, CheckDeliveryRequest req, ServerAddress to) throws TransferProtocolException {
        Response result = this.sendRequest(authenticator, new HttpsCheckDeliveryRequestHandler(req, this.getConfig()), to);
        return (ResponseToCheckDeliveryRequest)result;
    }

    @Override
    public ResponseToGetCommonResourceRequest send(ClientAuthenticator authenticator, GetCommonResourceRequest req, ServerAddress to) throws TransferProtocolException {
        Response result = this.sendRequest(authenticator, new HttpsGetCommonResourceRequestHandler(req, this.getConfig()), to);
        return (ResponseToGetCommonResourceRequest)result;
    }

    @Override
    public ResponseToPingRequest send(PingRequest req, ServerAddress to) throws TransferProtocolException {
        Response result = this.sendRequest(null, new HttpsPingRequestHandler(req, this.getConfig()), to);
        return (ResponseToPingRequest)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response sendRequest(ClientAuthenticator authenticator, HttpsRequestHandler requestHandler, ServerAddress to) throws TransferProtocolException {
        DefaultHttpClient client;
        Response result;
        block51: {
            LOG.debug("enter sendRequest()");
            assert (requestHandler != null);
            boolean authenticatorRequired = requestHandler.clientAuthenticatorRequired();
            if (authenticatorRequired) assert (authenticator != null);
            result = null;
            client = new DefaultHttpClient();
            MultipartEntity entity = null;
            try {
                HttpResponse httpResponse;
                String uri;
                int responseStatus;
                block50: {
                    responseStatus = 200;
                    this.notifyListeners(new ClientStatusEvent(this, 2, "Vorbereiten und Aufbauen der Verbindung"));
                    uri = null;
                    if (to != ServerAddress.CORE1) {
                        LOG.info("Achtung: Die Anfrage wird nicht an den zentralen Dateneingang von eSTATISTIK.core gesendet!");
                    }
                    try {
                        uri = this.getConfig().getAddressUseURI() ? to.getURI(this.getTransferProtocol()).toASCIIString() : to.getTransferURI(this.getTransferProtocol()).toASCIIString();
                    }
                    catch (UnsupportedProtocolException exc) {
                        exc.printStackTrace();
                        if ($assertionsDisabled) break block50;
                        throw new AssertionError();
                    }
                }
                LOG.info("Senden der Anfrage an folgende URL: " + uri);
                HttpPost method = new HttpPost(uri);
                if (this.getConfig().getProxyHost() != null && this.getConfig().getProxyHost().length() > 0) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Proxy fuer HTTPS-Verbindung: " + this.getConfig().getProxyHost() + ":" + this.getConfig().getProxyPort());
                    }
                    HttpHost proxy = new HttpHost(this.getConfig().getProxyHost(), this.getConfig().getProxyPort());
                    client.getParams().setParameter("http.route.default-proxy", (Object)proxy);
                    if (this.getConfig().getProxyUser() != null && this.getConfig().getProxyUser().length() > 0) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Authentifizierung am Proxy-Server als Benutzer '" + this.getConfig().getProxyUser() + "'");
                        }
                        String proxyPassword = "";
                        char[] proxyPasswordChars = this.getConfig().getProxyPassword();
                        if (proxyPasswordChars != null) {
                            proxyPassword = new String(proxyPasswordChars);
                        }
                        Object credentials = this.getConfig().getProxyDomain() != null && this.getConfig().getProxyDomain().length() > 0 ? new NTCredentials(this.getConfig().getProxyUser(), proxyPassword, this.getConfig().getProxyWorkstation(), this.getConfig().getProxyDomain()) : new UsernamePasswordCredentials(this.getConfig().getProxyUser(), proxyPassword);
                        client.getCredentialsProvider().setCredentials(new AuthScope(this.getConfig().getProxyHost(), this.getConfig().getProxyPort()), (Credentials)credentials);
                        if (!this.getConfig().isProxyAuthMethodAuto()) {
                            ArrayList<String> authPrefs = new ArrayList<String>(1);
                            if (this.getConfig().isProxyAuthMethodBasic()) {
                                authPrefs.add("Basic");
                            } else if (this.getConfig().isProxyAuthMethodDigest()) {
                                authPrefs.add("Digest");
                            } else if (this.getConfig().isProxyAuthMethodNTLM()) {
                                authPrefs.add("NTLM");
                            }
                            client.getParams().setParameter("http.auth.proxy-scheme-pref", authPrefs);
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("Authentifizierungsmethode auf " + this.getConfig().getProxyAuthMethod() + " gesetzt");
                            }
                        }
                    }
                }
                LOG.trace("Request-Parameter:");
                if (LOG.isTraceEnabled() && authenticatorRequired) {
                    LOG.trace("user=" + authenticator.getUserName());
                }
                LinkedHashMap<String, ContentBody> partList = new LinkedHashMap<String, ContentBody>();
                if (authenticatorRequired) {
                    try {
                        partList.put("user", (ContentBody)new StringBody(authenticator.getUserName()));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                    LOG.trace("password=********");
                    try {
                        partList.put("password", (ContentBody)new StringBody(new String(authenticator.getPassword()), Charset.forName("UTF-8")));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                }
                LOG.trace("action=" + requestHandler.getActionValue());
                try {
                    partList.put("action", (ContentBody)new StringBody(requestHandler.getActionValue()));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                requestHandler.addParts(partList);
                entity = new MultipartEntity();
                for (Map.Entry part : partList.entrySet()) {
                    entity.addPart((String)part.getKey(), (ContentBody)part.getValue());
                }
                method.setEntity((HttpEntity)entity);
                this.notifyListeners(new ClientStatusEvent(this, 3, "Senden der Anfrage an den Server"));
                client.getParams().setIntParameter("http.connection.timeout", 120000);
                client.getParams().setLongParameter("http.conn-manager.timeout", 120000L);
                try {
                    if (uri.startsWith("https")) {
                        Scheme scheme = this.getSslScheme(to);
                        client.getConnectionManager().getSchemeRegistry().register(scheme);
                    }
                    httpResponse = client.execute((HttpUriRequest)method);
                    responseStatus = httpResponse.getStatusLine().getStatusCode();
                }
                catch (HttpResponseException exc) {
                    LOG.error("Allgemeiner HTTPS-Fehler beim Senden des Requests!", exc);
                    throw new TransferProtocolException(to, this.getTransferProtocol(), exc.getStatusCode(), exc.getMessage());
                }
                catch (ClientProtocolException exc) {
                    LOG.error("Allgemeiner HTTPS-Fehler beim Senden des Requests!", exc);
                    throw new TransferProtocolException(to, this.getTransferProtocol(), 0, exc.getMessage());
                }
                catch (ConnectTimeoutException exc) {
                    LOG.error("Zeitueberschreibung beim Aufbau der Verbindung!", exc);
                    throw new TransferProtocolException(to, this.getTransferProtocol(), 0, "Zeitueberschreibung beim Aufbau der Verbindung!");
                }
                catch (ConnectException exc) {
                    LOG.error("Fehler beim Aufbau der Verbindung!", exc);
                    throw new TransferProtocolException(to, this.getTransferProtocol(), 0, exc.getMessage());
                }
                catch (Exception exc) {
                    LOG.error(exc.getMessage(), exc);
                    throw new TransferProtocolException(to, this.getTransferProtocol(), 0, exc.getMessage());
                }
                if (responseStatus == 200) {
                    LOG.info("Anfrage wurde erfolgreich an den Server gesendet.");
                    result = requestHandler.getResponse(httpResponse);
                    if (result != null) {
                        if (result.getStatus() == ResponseStatus.OK) {
                            LOG.info("Verarbeitung der Anfrage auf dem Server erfolgreich");
                        } else {
                            LOG.error("Bei der Verarbeitung der Anfrage auf dem Server ist ein Fehler aufgetreten!");
                            LOG.error("Statuscode: " + result.getStatus());
                            LOG.error("Fehlermeldung: " + result.getErrorText());
                        }
                    }
                } else {
                    if (responseStatus == 407) {
                        LOG.error("Authentifizierung am Proxy-Server fehlgeschlagen!");
                        LOG.error("Statuscode: " + responseStatus);
                        throw new TransferProtocolException(to, this.getTransferProtocol(), responseStatus, "Authentifizierung am Proxy-Server fehlgeschlagen!");
                    }
                    LOG.error("Beim Senden einer Anfrage an den CORE-Server ist ein Fehler aufgetreten!");
                    LOG.error("Statuscode: " + responseStatus);
                    String statusLine = httpResponse.getStatusLine().getReasonPhrase();
                    throw new TransferProtocolException(to, this.getTransferProtocol(), responseStatus, "Beim Senden einer Anfrage an den CORE-Server ist ein Fehler aufgetreten" + (statusLine == null ? "!" : ": " + statusLine));
                }
                this.notifyListeners(new ClientStatusEvent(this, 4, "Abbauen der Verbindung"));
                method.releaseConnection();
                if (entity == null) break block51;
            }
            catch (Throwable throwable) {
                if (entity != null) {
                    try {
                        EntityUtils.consume(entity);
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                }
                try {
                    client.getConnectionManager().shutdown();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                EntityUtils.consume((HttpEntity)entity);
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        try {
            client.getConnectionManager().shutdown();
        }
        catch (Throwable ignore) {}
        return result;
    }

    private Scheme getSslScheme(ServerAddress to) {
        X509HostnameVerifier hostNameVerifier;
        SSLContext context;
        try {
            context = SSLContext.getInstance("TLSv1.2");
            if ("TEST".equals(to.getName())) {
                context.init(null, new TrustManager[]{new SimpleX509TrustManager()}, null);
                hostNameVerifier = SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
            } else {
                String certificateDir = ClientConfig.getCertificateDir();
                if (certificateDir != null) {
                    TrustManager[] customCertsTrustManagers = this.getCustomCertificatesTrustManagers();
                    context.init(null, customCertsTrustManagers, null);
                } else {
                    context.init(null, null, null);
                }
                hostNameVerifier = SSLSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER;
            }
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        CoreSSLSocketFactory socketFactory = new CoreSSLSocketFactory(context, hostNameVerifier);
        Scheme scheme = new Scheme("https", 443, (SchemeSocketFactory)socketFactory);
        return scheme;
    }

    private TrustManager[] getCustomCertificatesTrustManagers() {
        TrustManager[] trustManagers;
        try {
            KeyStore trustedKeyStore = KeyStore.getInstance("JKS");
            trustedKeyStore.load(null, null);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            this.loadCustomCertificates(cf, trustedKeyStore);
            TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustFactory.init(trustedKeyStore);
            trustManagers = trustFactory.getTrustManagers();
        }
        catch (Exception e) {
            LOG.error("Fehler beim Einlesen der Server-Zertifikate:", e);
            throw new RuntimeException(e.toString());
        }
        return trustManagers;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadCustomCertificates(CertificateFactory certificateFactory, KeyStore trustedKeyStore) {
        LOG.debug("enter loadCustomCertificates()");
        String certificateDir = ClientConfig.getCertificateDir();
        if (certificateDir == null) return;
        LOG.trace("Suche nach benutzerspezifischen Zertifikaten");
        LOG.trace("Verzeichnis: " + certificateDir);
        File dir = new File(certificateDir);
        File[] files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                String fileExt;
                boolean result = false;
                LOG.debug("Pruefe Datei " + file.getName());
                String fileName = file.getName();
                int dotIdx = fileName.lastIndexOf(46);
                if (dotIdx > 0 && fileName.length() > dotIdx + 1 && ((fileExt = fileName.substring(dotIdx + 1)).equalsIgnoreCase(HttpsProtocolHandler.CERTIFICATE_EXT_PEM) || fileExt.equalsIgnoreCase(HttpsProtocolHandler.CERTIFICATE_EXT_DER))) {
                    LOG.debug("Zertifikat gefunden");
                    result = true;
                }
                return result;
            }
        });
        if (files == null) return;
        for (int idx = 0; idx < files.length; ++idx) {
            try {
                LOG.trace("Lese Zertifikat " + files[idx]);
                FileInputStream stream = new FileInputStream(files[idx]);
                X509Certificate certificate = (X509Certificate)certificateFactory.generateCertificate(stream);
                try {
                    ((InputStream)stream).close();
                }
                catch (Exception exc) {
                    LOG.error("Fehler beim Schliessen der Datei " + files[idx] + ":", exc);
                }
                LOG.debug("Fuege Zertifikat zum KeyStore hinzu.");
                trustedKeyStore.setCertificateEntry(CUSTOM_CERTIFICATE_PREFIX + idx, certificate);
                LOG.debug("Zertifikat hinzugefuegt.");
                continue;
            }
            catch (CertificateException exc) {
                LOG.error("Fehler beim Lesen des Zertifikats " + files[idx], exc);
                continue;
            }
            catch (FileNotFoundException exc) {
                LOG.error("Fehler beim Lesen der Datei " + files[idx], exc);
                continue;
            }
            catch (KeyStoreException exc) {
                LOG.error("Das Zertifikat " + files[idx] + " konnte nicht zum KeyStore hinzugefuegt werden", exc);
            }
        }
    }

    public static class SimpleX509TrustManager
    implements X509TrustManager {
        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }
    }

    private static class CoreSSLSocketFactory
    extends SSLSocketFactory {
        public CoreSSLSocketFactory(SSLContext sslContext, X509HostnameVerifier hostNameVerifier) {
            super(sslContext, hostNameVerifier);
        }
    }
}

