/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.objects;

import clover.it.unimi.dsi.fastutil.objects.ObjectCollection;
import clover.it.unimi.dsi.fastutil.objects.ObjectIterator;
import clover.it.unimi.dsi.fastutil.objects.ObjectIterators;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

public class ObjectCollections {
    private ObjectCollections() {
    }

    public static ObjectCollection synchronize(ObjectCollection c) {
        return new SynchronizedCollection(c);
    }

    public static ObjectCollection synchronize(ObjectCollection c, Object sync) {
        return new SynchronizedCollection(c, sync);
    }

    public static ObjectCollection unmodifiable(ObjectCollection c) {
        return new UnmodifiableCollection(c);
    }

    public static class UnmodifiableCollection
    implements ObjectCollection,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final ObjectCollection collection;

        protected UnmodifiableCollection(ObjectCollection c) {
            if (c == null) {
                throw new NullPointerException();
            }
            this.collection = c;
        }

        public int size() {
            return this.collection.size();
        }

        public boolean isEmpty() {
            return this.collection.isEmpty();
        }

        public boolean contains(Object o) {
            return this.collection.contains(o);
        }

        public Object[] toArray() {
            return this.collection.toArray();
        }

        public Object[] toArray(Object[] a) {
            return this.collection.toArray(a);
        }

        public Iterator iterator() {
            return ObjectIterators.unmodifiable((ObjectIterator)this.collection.iterator());
        }

        public ObjectIterator objectIterator() {
            return ObjectIterators.unmodifiable(this.collection.objectIterator());
        }

        public boolean add(Object k) {
            throw new UnsupportedOperationException();
        }

        public boolean rem(Object k) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object ok) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean containsAll(Collection c) {
            return this.collection.containsAll(c);
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(ObjectCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean containsAll(ObjectCollection c) {
            return this.collection.containsAll(c);
        }

        public boolean removeAll(ObjectCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(ObjectCollection c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.collection.toString();
        }
    }

    public static class SynchronizedCollection
    implements ObjectCollection,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final ObjectCollection collection;
        protected final Object sync;

        protected SynchronizedCollection(ObjectCollection c, Object sync) {
            if (c == null) {
                throw new NullPointerException();
            }
            this.collection = c;
            this.sync = sync;
        }

        protected SynchronizedCollection(ObjectCollection c) {
            if (c == null) {
                throw new NullPointerException();
            }
            this.collection = c;
            this.sync = this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(Object o) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.contains(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray() {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray(Object[] a) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.toArray(a);
            }
        }

        public Iterator iterator() {
            return this.collection.iterator();
        }

        public ObjectIterator objectIterator() {
            return this.collection.objectIterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(Object k) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.add(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean rem(Object k) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.remove(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object ok) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.remove(ok);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(Collection c) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.addAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsAll(Collection c) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.containsAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeAll(Collection c) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.removeAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean retainAll(Collection c) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.retainAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(ObjectCollection c) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.addAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsAll(ObjectCollection c) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.containsAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeAll(ObjectCollection c) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.removeAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean retainAll(ObjectCollection c) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.retainAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.sync;
            synchronized (object) {
                this.collection.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.toString();
            }
        }
    }
}

