/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.tags.code;

import info.bliki.wiki.tags.code.AbstractCodeFormatter;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ABAPCodeFilter
extends AbstractCodeFormatter {
    private static HashMap<String, String> KEYWORD_SET = new HashMap();
    private static final String[] KEYWORDS = new String[]{"ADD", "ALL", "AND", "ANY", "ADD-CORRESPONDING", "APPEND", "APPENDING", "ASSIGN", "ASSIGNED", "ASSIGNING", "AT", "AUTHORITY-CHECK", "BACK", "BEGIN", "BETWEEN", "BINARY", "BREAK-POINT", "BY", "CALL", "CASE", "CHANGING", "CHECK", "CLEAR", "CLOSE", "CA", "CN", "CO", "CP", "CS", "CNT", "COLLECT", "COMMIT", "COMMUNICATION", "COMPUTE", "CONCATENATE", "CONDENSE", "CONSTANTS", "CONTINUE", "CONTROLS", "CONVERT", "CORRESPONDING", "COUNT", "CUSTOMER-FUNCTION", "CREATE", "CURRENCY", "CURSOR", "DATA", "DEFINE", "DELETE", "DESCRIBE", "DETAIL", "DIVIDE", "DIVIDE-CORRESPONDING", "DO", "EDIT", "EDITOR-CALL", "ELSE", "ELSEIF", "END", "END-OF-DEFINITION", "END-OF-PAGE", "END-OF-SELECTION", "ENDAT", "ENDCASE", "ENDDO", "ENDEXEC", "ENDFORM", "ENDFUNCTION", "ENDIF", "ENDIFEND", "ENDLOOP", "ENDMODULE", "ENDON", "ENDPROVIDE", "ENDSELECT", "ENDWHILE", "ENTRIES", "EQ", "EXCEPTIONS", "EXEC", "EXIT", "EXIT FROM STEP LOOP", "EXPORT", "EXPORTING", "EXTRACT", "FETCH", "FIELD", "FIELD-GROUPS", "FIELD-SYMBOLS", "FIELDS", "FOR", "FORM", "FORMAT", "FREE", "FROM", "FUNCTION", "FUNCTION-POOL", "GENERATE", "GET", "GE", "GT", "HIDE", "ID", "INITIAL", "IF", "IS", "IMPORT", "IMPORTING", "INCLUDE", "INFOTYPES", "INPUT", "IN", "INITIALIZATION", "INPUT", "INSERT", "INTO", "KEY", "LE", "LEAVE", "LIKE", "LINE", "LOAD", "LOCAL", "LOOP", "LT", "M", "MASK", "MEMORY", "METHOD", "MESSAGE", "MODIFY", "MODULE", "MOVE", "MOVE-CORRESPONDING", "MULTIPLY", "MULTIPLY-CORRESPONDING", "NA", "NP", "NS", "NE", "NEW-LINE", "NEW-PAGE", "NEW-SECTION", "NO", "NOT", "O", "OF", "ON", "OR", "OUTPUT", "OVERLAY", "PACK", "PARAMETER", "PARAMETERS", "PERFORM", "POSITION", "PRINT-CONTROL", "PROGRAM", "PROVIDE", "PUT", "RAISE", "RANGES", "READ", "RECEIVE", "REF", "REFRESH", "REJECT", "REPLACE", "REPORT", "REQUESTED", "RESERVE", "RESTORE", "ROLLBACK", "ROWS", "SCAN", "SCREEN", "SCROLL", "SEARCH", "SELECT", "SELECT-OPTIONS", "SELECTION-SCREEN", "SEPARATED", "SET", "SHIFT", "SINGLE", "SKIP", "SORT", "SPACE", "SPLIT", "START-OF-SELECTION", "STATICS", "STOP", "STRUCTURE", "SUBMIT", "SUBTRACT", "SUBTRACT-CORRESPONDING", "SUM", "SUMMARY", "SUPPRESS", "SYNTAX-CHECK", "SYNTAX-TRACE", "TABLE", "TABLES", "TIMES", "TO", "TOP-OF-PAGE", "TRANSACTION", "TRANSFER", "TRANSLATE", "TRANSPORTING", "TYPE", "TYPE-POOL", "TYPE-POOLS", "TYPES", "ULINE", "USING", "UNPACK", "UP", "UPDATE", "VALUE", "WHEN", "WHILE", "WINDOW", "WAIT", "WHERE", "WITH", "WORK", "WRITE", "Z"};
    private static HashMap<String, String> OBJECT_SET = new HashMap();

    @Override
    public HashMap<String, String> getKeywordSet() {
        return KEYWORD_SET;
    }

    @Override
    public HashMap<String, String> getObjectSet() {
        return OBJECT_SET;
    }

    private int appendIdentifier(String input, int identStart, int currentPosition, HashMap<String, String> keywords, HashMap<String, String> objectWords, StringBuilder result) {
        String keywordValue;
        String originalIdent;
        String keywordIdent = originalIdent = input.substring(identStart, --currentPosition);
        if (!this.isKeywordLowerCase()) {
            keywordIdent = keywordIdent.toLowerCase();
        }
        if ((keywordValue = keywords.get(keywordIdent)) != null) {
            result.append(keywordValue);
        } else {
            result.append(originalIdent);
        }
        return currentPosition;
    }

    @Override
    public String filter(String input) {
        char[] source = input.toCharArray();
        int currentPosition = 0;
        int identStart = 0;
        char currentChar = ' ';
        HashMap<String, String> keywordsSet = this.getKeywordSet();
        HashMap<String, String> objectsSet = this.getObjectSet();
        StringBuilder result = new StringBuilder(input.length() + input.length() / 4);
        boolean identFound = false;
        try {
            while (true) {
                if ((currentChar = source[currentPosition++]) >= 'A' && currentChar <= 'Z' || currentChar >= 'a' && currentChar <= 'z') {
                    identStart = currentPosition - 1;
                    identFound = true;
                    while (currentChar >= 'a' && currentChar <= 'z' || currentChar >= 'A' && currentChar <= 'Z' || currentChar == '-' || currentChar == '_') {
                        currentChar = source[currentPosition++];
                    }
                    currentPosition = this.appendIdentifier(input, identStart, currentPosition, keywordsSet, objectsSet, result);
                    identFound = false;
                    continue;
                }
                if (currentChar == '\'') {
                    result.append("<span style=\"color:#2A00FF; \">");
                    ABAPCodeFilter.appendChar(result, currentChar);
                    while (currentPosition < input.length()) {
                        currentChar = source[currentPosition++];
                        ABAPCodeFilter.appendChar(result, currentChar);
                        if (currentChar == '\'') {
                            if (currentPosition < input.length() && source[currentPosition] != '\'') break;
                            ABAPCodeFilter.appendChar(result, currentChar);
                            ++currentPosition;
                        }
                        if (currentChar != 10) continue;
                    }
                    result.append("</span>");
                    continue;
                }
                if (currentChar == '\n' && currentPosition < input.length() && source[currentPosition] == '*') {
                    result.append("<span style=\"color:#3F7F5F; \">");
                    ABAPCodeFilter.appendChar(result, currentChar);
                    ABAPCodeFilter.appendChar(result, source[currentPosition++]);
                    while (currentPosition < input.length()) {
                        currentChar = source[currentPosition++];
                        ABAPCodeFilter.appendChar(result, currentChar);
                        if (currentChar != 10) continue;
                        --currentPosition;
                        break;
                    }
                    result.append("</span>");
                    continue;
                }
                if (currentChar == '\"' && currentPosition < input.length()) {
                    result.append("<span style=\"color:#3F7F5F; \">");
                    ABAPCodeFilter.appendChar(result, currentChar);
                    ABAPCodeFilter.appendChar(result, source[currentPosition++]);
                    while (currentPosition < input.length()) {
                        currentChar = source[currentPosition++];
                        ABAPCodeFilter.appendChar(result, currentChar);
                        if (currentChar != 10) continue;
                    }
                    result.append("</span>");
                    continue;
                }
                ABAPCodeFilter.appendChar(result, currentChar);
            }
        }
        catch (IndexOutOfBoundsException e) {
            if (identFound) {
                currentPosition = this.appendIdentifier(input, identStart, currentPosition, keywordsSet, null, result);
            }
            return result.toString();
        }
    }

    public boolean isKeywordLowerCase() {
        return true;
    }

    public boolean isPHPTag() {
        return false;
    }

    static {
        for (int i = 0; i < KEYWORDS.length; ++i) {
            ABAPCodeFilter.createHashMap(KEYWORD_SET, KEYWORDS[i]);
        }
    }
}

